/*
 * Decompiled with CFR 0.152.
 */
package com.github.sarxos.webcam;

import com.github.sarxos.webcam.Webcam;
import com.github.sarxos.webcam.WebcamSignalHandler;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintStream;

final class WebcamDeallocator {
    private static final WebcamSignalHandler HANDLER = new WebcamSignalHandler();
    private final Webcam[] webcams;

    private WebcamDeallocator(Webcam[] devices) {
        this.webcams = devices;
    }

    protected static void store(Webcam[] webcams) {
        if (HANDLER.get() != null) {
            throw new IllegalStateException("Deallocator is already set!");
        }
        HANDLER.set(new WebcamDeallocator(webcams));
    }

    protected static void unstore() {
        HANDLER.reset();
    }

    protected void deallocate() {
        for (Webcam w : this.webcams) {
            try {
                w.dispose();
            }
            catch (Throwable t) {
                this.caugh(t);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void caugh(Throwable t) {
        File f = new File(String.format("webcam-capture-hs-%s", System.currentTimeMillis()));
        PrintStream ps = null;
        try {
            ps = new PrintStream(f);
            t.printStackTrace(ps);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
    }
}

