/*
 * Decompiled with CFR 0.152.
 */
package com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d;

import com.sun.j3d.utils.scenegraph.io.retained.Controller;
import com.sun.j3d.utils.scenegraph.io.retained.SymbolTableData;
import com.sun.j3d.utils.scenegraph.io.state.javax.media.j3d.SceneGraphObjectState;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import javax.media.j3d.BoundingLeaf;
import javax.media.j3d.Fog;
import javax.media.j3d.Group;
import javax.media.j3d.SceneGraphObject;
import javax.vecmath.Color3f;

public abstract class FogState
extends SceneGraphObjectState {
    protected int[] scopes;
    protected int boundingLeaf;

    public FogState(SymbolTableData symbolTableData, Controller controller) {
        super(symbolTableData, controller);
    }

    public void writeObject(DataOutput dataOutput) throws IOException {
        super.writeObject(dataOutput);
        this.control.writeBounds(dataOutput, ((Fog)this.node).getInfluencingBounds());
        dataOutput.writeInt(((Fog)this.node).numScopes());
        for (int i = 0; i < ((Fog)this.node).numScopes(); ++i) {
            dataOutput.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Fog)this.node).getScope(i)));
        }
        dataOutput.writeInt(this.control.getSymbolTable().addReference((SceneGraphObject)((Fog)this.node).getInfluencingBoundingLeaf()));
        Color3f color3f = new Color3f();
        ((Fog)this.node).getColor(color3f);
        this.control.writeColor3f(dataOutput, color3f);
    }

    public void readObject(DataInput dataInput) throws IOException {
        super.readObject(dataInput);
        ((Fog)this.node).setInfluencingBounds(this.control.readBounds(dataInput));
        this.scopes = new int[dataInput.readInt()];
        for (int i = 0; i < this.scopes.length; ++i) {
            this.scopes[i] = dataInput.readInt();
        }
        this.boundingLeaf = dataInput.readInt();
        ((Fog)this.node).setColor(this.control.readColor3f(dataInput));
    }

    public void buildGraph() {
        for (int i = 0; i < this.scopes.length; ++i) {
            ((Fog)this.node).addScope((Group)this.control.getSymbolTable().getJ3dNode(this.scopes[i]));
        }
        ((Fog)this.node).setInfluencingBoundingLeaf((BoundingLeaf)this.control.getSymbolTable().getJ3dNode(this.boundingLeaf));
        super.buildGraph();
    }
}

