/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.windows.forms;

import java.awt.Graphics;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import org.kbinani.BEvent;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.windows.forms.BKeyEventArgs;
import org.kbinani.windows.forms.BKeyEventHandler;
import org.kbinani.windows.forms.BKeyPressEventArgs;
import org.kbinani.windows.forms.BKeyPressEventHandler;
import org.kbinani.windows.forms.BMouseButtons;
import org.kbinani.windows.forms.BMouseEventArgs;
import org.kbinani.windows.forms.BMouseEventHandler;
import org.kbinani.windows.forms.BPaintEventArgs;
import org.kbinani.windows.forms.BPaintEventHandler;
import org.kbinani.windows.forms.BPreviewKeyDownEventArgs;
import org.kbinani.windows.forms.BPreviewKeyDownEventHandler;

public class BPanel
extends JPanel
implements MouseListener,
MouseMotionListener,
KeyListener,
MouseWheelListener,
FocusListener {
    private static final long serialVersionUID = -1767993910090796469L;
    public BEvent<BMouseEventHandler> mouseWheelEvent = new BEvent();
    public BEvent<BPaintEventHandler> paintEvent = new BEvent();
    public BEvent<BPreviewKeyDownEventHandler> previewKeyDownEvent = new BEvent();
    public BEvent<BKeyEventHandler> keyDownEvent = new BEvent();
    public BEvent<BKeyEventHandler> keyUpEvent = new BEvent();
    public BEvent<BKeyPressEventHandler> keyPressEvent = new BEvent();
    public BEvent<BMouseEventHandler> mouseMoveEvent = new BEvent();
    public BEvent<BMouseEventHandler> mouseClickEvent = new BEvent();
    public BEvent<BMouseEventHandler> mouseDoubleClickEvent = new BEvent();
    public BEvent<BMouseEventHandler> mouseDownEvent = new BEvent();
    public BEvent<BMouseEventHandler> mouseUpEvent = new BEvent();
    public BEvent<BEventHandler> mouseEnterEvent = new BEvent();
    public BEvent<BEventHandler> mouseLeaveEvent = new BEvent();
    public BEvent<BEventHandler> enterEvent = new BEvent();
    public BEvent<BEventHandler> leaveEvent = new BEvent();

    public BPanel() {
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        this.addKeyListener(this);
        this.addMouseWheelListener(this);
        this.addFocusListener(this);
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        BMouseButtons bMouseButtons = BMouseButtons.Middle;
        switch (mouseWheelEvent.getButton()) {
            case 1: {
                bMouseButtons = BMouseButtons.Left;
                break;
            }
            case 2: {
                bMouseButtons = BMouseButtons.Middle;
                break;
            }
            case 3: {
                bMouseButtons = BMouseButtons.Right;
            }
        }
        BMouseEventArgs bMouseEventArgs = new BMouseEventArgs(bMouseButtons, mouseWheelEvent.getClickCount(), mouseWheelEvent.getX(), mouseWheelEvent.getY(), mouseWheelEvent.getWheelRotation() * mouseWheelEvent.getUnitsToScroll());
        try {
            this.mouseWheelEvent.raise(this, bMouseEventArgs);
        }
        catch (Exception exception) {
            System.err.println("BButton#mouseWheelMoved; ex=" + exception);
        }
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        BPaintEventArgs bPaintEventArgs = new BPaintEventArgs(graphics);
        try {
            this.paintEvent.raise(this, bPaintEventArgs);
        }
        catch (Exception exception) {
            System.err.println("BButton#paint; ex=" + exception);
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            this.previewKeyDownEvent.raise(this, new BPreviewKeyDownEventArgs(keyEvent));
            this.keyDownEvent.raise(this, new BKeyEventArgs(keyEvent));
        }
        catch (Exception exception) {
            System.err.println("BButton#keyPressed; ex=" + exception);
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        try {
            this.keyUpEvent.raise(this, new BKeyEventArgs(keyEvent));
        }
        catch (Exception exception) {
            System.err.println("BButton#keyReleased; ex=" + exception);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        try {
            this.previewKeyDownEvent.raise(this, new BPreviewKeyDownEventArgs(keyEvent));
            this.keyPressEvent.raise(this, new BKeyPressEventArgs(keyEvent));
        }
        catch (Exception exception) {
            System.err.println("BButton#keyType; ex=" + exception);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            this.mouseMoveEvent.raise(this, BMouseEventArgs.fromMouseEvent(mouseEvent));
        }
        catch (Exception exception) {
            System.err.println("BButton#mouseDragged; ex=" + exception);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            this.mouseMoveEvent.raise(this, BMouseEventArgs.fromMouseEvent(mouseEvent));
        }
        catch (Exception exception) {
            System.err.println("BButton#mouseMoved; ex=" + exception);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        try {
            this.mouseClickEvent.raise(this, BMouseEventArgs.fromMouseEvent(mouseEvent));
            if (mouseEvent.getClickCount() >= 2) {
                this.mouseDoubleClickEvent.raise(this, BMouseEventArgs.fromMouseEvent(mouseEvent));
            }
        }
        catch (Exception exception) {
            System.err.println("BButton#mouseClicked; ex=" + exception);
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            this.mouseEnterEvent.raise(this, new BEventArgs());
        }
        catch (Exception exception) {
            System.err.println("BButton#mouseEntered; ex=" + exception);
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        try {
            this.mouseLeaveEvent.raise(this, new BEventArgs());
        }
        catch (Exception exception) {
            System.err.println("BButton#mouseExited; ex=" + exception);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            this.mouseDownEvent.raise(this, BMouseEventArgs.fromMouseEvent(mouseEvent));
        }
        catch (Exception exception) {
            System.err.println("BButton#mousePressed; ex=" + exception);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            this.mouseUpEvent.raise(this, BMouseEventArgs.fromMouseEvent(mouseEvent));
        }
        catch (Exception exception) {
            System.err.println("BButton#mouseReleased; ex=" + exception);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        try {
            this.enterEvent.raise(this, new BEventArgs());
        }
        catch (Exception exception) {
            System.err.println("BButton#focusGained; ex=" + exception);
        }
    }

    public void focusLost(FocusEvent focusEvent) {
        try {
            this.leaveEvent.raise(this, new BEventArgs());
        }
        catch (Exception exception) {
            System.err.println("BButton#focusLost; ex=" + exception);
        }
    }
}

