/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.windows.forms;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.kbinani.BEvent;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;

public class BNumericUpDown
extends JPanel {
    private static final long serialVersionUID = -8499996379673462967L;
    private JTextField txtValue = null;
    private JButton btnUp = null;
    private JButton btnDown = null;
    private float value = 0.0f;
    private float maximum = 100.0f;
    private float minimum = 0.0f;
    private float increment = 1.0f;
    private int decimalPlaces = 0;
    private float minimumStep = 1.0f;
    public BEvent<BEventHandler> valueChangedEvent = new BEvent();

    public int getDecimalPlaces() {
        return this.decimalPlaces;
    }

    public void setDecimalPlaces(int n) {
        this.decimalPlaces = n;
        this.minimumStep = (float)Math.pow(0.1, n);
        if (this.increment < this.minimumStep) {
            this.increment = this.minimumStep;
        }
    }

    public float getIncrement() {
        return this.increment;
    }

    public void setIncrement(float f) {
        this.increment = f;
    }

    private void update() {
        this.getTxtValue().setText(this.value + "");
        try {
            this.valueChangedEvent.raise(this, new BEventArgs());
        }
        catch (Exception exception) {
            System.err.println("BNumericUpDown#update; ex=" + exception);
        }
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float f) {
        if (this.minimum <= f && f <= this.maximum) {
            this.value = f;
            this.update();
        }
    }

    public float getMaximum() {
        return this.maximum;
    }

    public void setMaximum(float f) {
        if (f < this.value) {
            this.value = f;
            this.update();
        }
        this.maximum = f;
    }

    public float getMinimum() {
        return this.minimum;
    }

    public void setMinimum(float f) {
        if (this.value < f) {
            this.value = f;
            this.update();
        }
        this.minimum = f;
    }

    public BNumericUpDown() {
        this.initialize();
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.gridy = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 1;
        gridBagConstraints2.weighty = 1.0;
        gridBagConstraints2.anchor = 15;
        gridBagConstraints2.gridy = 0;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.gridy = 0;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridheight = 2;
        gridBagConstraints3.weighty = 1.0;
        gridBagConstraints3.gridx = 0;
        this.setSize(127, 23);
        this.setLayout(new GridBagLayout());
        this.add((Component)this.getTxtValue(), gridBagConstraints3);
        this.add((Component)this.getBtnUp(), gridBagConstraints2);
        this.add((Component)this.getBtnDown(), gridBagConstraints);
    }

    private JTextField getTxtValue() {
        if (this.txtValue == null) {
            this.txtValue = new JTextField();
            this.txtValue.setText("0");
            this.txtValue.setHorizontalAlignment(4);
            this.txtValue.addKeyListener(new KeyAdapter(){

                public void keyTyped(KeyEvent keyEvent) {
                    try {
                        float f = Float.parseFloat(BNumericUpDown.this.txtValue.getText());
                        BNumericUpDown.this.value = f;
                        BNumericUpDown.this.update();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            });
        }
        return this.txtValue;
    }

    private JButton getBtnUp() {
        if (this.btnUp == null) {
            this.btnUp = new JButton();
            this.btnUp.setText("");
            this.btnUp.setPreferredSize(new Dimension(20, 10));
            this.btnUp.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (BNumericUpDown.this.value + BNumericUpDown.this.increment <= BNumericUpDown.this.maximum) {
                        BNumericUpDown.this.value += BNumericUpDown.this.increment;
                        BNumericUpDown.this.update();
                    }
                }
            });
        }
        return this.btnUp;
    }

    private JButton getBtnDown() {
        if (this.btnDown == null) {
            this.btnDown = new JButton();
            this.btnDown.setText("");
            this.btnDown.setPreferredSize(new Dimension(20, 10));
            this.btnDown.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    if (BNumericUpDown.this.value - BNumericUpDown.this.increment >= BNumericUpDown.this.minimum) {
                        BNumericUpDown.this.value -= BNumericUpDown.this.increment;
                        BNumericUpDown.this.update();
                    }
                }
            });
        }
        return this.btnDown;
    }
}

