/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.IOException;
import java.io.Serializable;
import java.util.Vector;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.vsq.ITextWriter;
import org.kbinani.vsq.TextStream;
import org.kbinani.vsq.VsqMixerEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqMixer
implements Cloneable,
Serializable {
    public int MasterFeder;
    public int MasterPanpot;
    public int MasterMute;
    public int OutputMode;
    public Vector<VsqMixerEntry> Slave = new Vector();

    public Object clone() {
        VsqMixer vsqMixer = new VsqMixer(this.MasterFeder, this.MasterPanpot, this.MasterMute, this.OutputMode);
        vsqMixer.Slave = new Vector();
        for (VsqMixerEntry vsqMixerEntry : this.Slave) {
            vsqMixer.Slave.add((VsqMixerEntry)vsqMixerEntry.clone());
        }
        return vsqMixer;
    }

    public VsqMixer(int n, int n2, int n3, int n4) {
        this.MasterFeder = n;
        this.MasterMute = n3;
        this.MasterPanpot = n2;
        this.OutputMode = n4;
        this.Slave = new Vector();
    }

    public VsqMixer() {
        this(0, 0, 0, 0);
    }

    public VsqMixer(TextStream textStream, ByRef<String> byRef) {
        String[] stringArray;
        this.MasterFeder = 0;
        this.MasterPanpot = 0;
        this.MasterMute = 0;
        this.OutputMode = 0;
        int n = 0;
        String string = "";
        byRef.value = textStream.readLine();
        while (!((String)byRef.value).startsWith("[")) {
            stringArray = PortUtil.splitString((String)byRef.value, '=');
            if (stringArray[0].equals("MasterFeder")) {
                this.MasterFeder = PortUtil.parseInt(stringArray[1]);
            } else if (stringArray[0].equals("MasterPanpot")) {
                this.MasterPanpot = PortUtil.parseInt(stringArray[1]);
            } else if (stringArray[0].equals("MasterMute")) {
                this.MasterMute = PortUtil.parseInt(stringArray[1]);
            } else if (stringArray[0].equals("OutputMode")) {
                this.OutputMode = PortUtil.parseInt(stringArray[1]);
            } else if (stringArray[0].equals("Tracks")) {
                n = PortUtil.parseInt(stringArray[1]);
            } else if (stringArray[0].startsWith("Feder") || stringArray[0].startsWith("Panpot") || stringArray[0].startsWith("Mute") || stringArray[0].startsWith("Solo")) {
                string = string + stringArray[0] + "=" + stringArray[1] + "\n";
            }
            if (!textStream.ready()) break;
            byRef.value = textStream.readLine().toString();
        }
        this.Slave = new Vector();
        for (int i = 0; i < n; ++i) {
            this.Slave.add(new VsqMixerEntry(0, 0, 0, 0));
        }
        stringArray = PortUtil.splitString(string, new String[]{"\n"}, true);
        for (int i = 0; i < stringArray.length; ++i) {
            int n2;
            String string2 = "";
            String[] stringArray2 = PortUtil.splitString(stringArray[i], '=');
            if (stringArray2[0].startsWith("Feder")) {
                string2 = stringArray2[0].replace("Feder", "");
                n2 = PortUtil.parseInt(string2);
                this.Slave.get((int)n2).Feder = PortUtil.parseInt(stringArray2[1]);
                continue;
            }
            if (stringArray2[0].startsWith("Panpot")) {
                string2 = stringArray2[0].replace("Panpot", "");
                n2 = PortUtil.parseInt(string2);
                this.Slave.get((int)n2).Panpot = PortUtil.parseInt(stringArray2[1]);
                continue;
            }
            if (stringArray2[0].startsWith("Mute")) {
                string2 = stringArray2[0].replace("Mute", "");
                n2 = PortUtil.parseInt(string2);
                this.Slave.get((int)n2).Mute = PortUtil.parseInt(stringArray2[1]);
                continue;
            }
            if (!stringArray2[0].startsWith("Solo")) continue;
            string2 = stringArray2[0].replace("Solo", "");
            n2 = PortUtil.parseInt(string2);
            this.Slave.get((int)n2).Solo = PortUtil.parseInt(stringArray2[1]);
        }
    }

    public void write(ITextWriter iTextWriter) throws IOException {
        iTextWriter.writeLine("[Mixer]");
        iTextWriter.writeLine("MasterFeder=" + this.MasterFeder);
        iTextWriter.writeLine("MasterPanpot=" + this.MasterPanpot);
        iTextWriter.writeLine("MasterMute=" + this.MasterMute);
        iTextWriter.writeLine("OutputMode=" + this.OutputMode);
        int n = this.Slave.size();
        iTextWriter.writeLine("Tracks=" + n);
        for (int i = 0; i < n; ++i) {
            VsqMixerEntry vsqMixerEntry = this.Slave.get(i);
            iTextWriter.writeLine("Feder" + i + "=" + vsqMixerEntry.Feder);
            iTextWriter.writeLine("Panpot" + i + "=" + vsqMixerEntry.Panpot);
            iTextWriter.writeLine("Mute" + i + "=" + vsqMixerEntry.Mute);
            iTextWriter.writeLine("Solo" + i + "=" + vsqMixerEntry.Solo);
        }
    }
}

