/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.Serializable;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.vsq.IconDynamicsHandle;
import org.kbinani.vsq.IconHandle;
import org.kbinani.vsq.LyricHandle;
import org.kbinani.vsq.NoteHeadHandle;
import org.kbinani.vsq.TextStream;
import org.kbinani.vsq.VibratoHandle;
import org.kbinani.vsq.VsqHandle;
import org.kbinani.vsq.VsqIDType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqID
implements Cloneable,
Serializable {
    public static final int MAX_NOTE_MILLISEC_LENGTH = 16383;
    public int value;
    public int IconHandle_index;
    public int LyricHandle_index;
    public int VibratoHandle_index;
    public int NoteHeadHandle_index;
    public VsqIDType type;
    public IconHandle IconHandle;
    private int length;
    public int Note;
    public int Dynamics;
    public int PMBendDepth;
    public int PMBendLength;
    public int PMbPortamentoUse;
    public int DEMdecGainRate;
    public int DEMaccent;
    public LyricHandle LyricHandle;
    public VibratoHandle VibratoHandle;
    public int VibratoDelay;
    public NoteHeadHandle NoteHeadHandle;
    public int pMeanOnsetFirstNote = 10;
    public int vMeanNoteTransition = 12;
    public int d4mean = 24;
    public int pMeanEndingNote = 12;
    public IconDynamicsHandle IconDynamicsHandle;
    public static VsqID EOS = new VsqID(-1);

    public int getLength() {
        return this.length;
    }

    public void setLength(int n) {
        this.length = n;
    }

    public static boolean isXmlIgnored(String string) {
        if (string.equals("IconHandle_index")) {
            return true;
        }
        if (string.equals("value")) {
            return true;
        }
        if (string.equals("LyricHandle_index")) {
            return true;
        }
        if (string.equals("NoteHeadHandle_index")) {
            return true;
        }
        return string.equals("VibratoHandle_index");
    }

    public static String getXmlElementName(String string) {
        return string;
    }

    public Object clone() {
        VsqID vsqID = new VsqID(this.value);
        vsqID.type = this.type;
        if (this.IconHandle != null) {
            vsqID.IconHandle = (IconHandle)this.IconHandle.clone();
        }
        vsqID.setLength(this.getLength());
        vsqID.Note = this.Note;
        vsqID.Dynamics = this.Dynamics;
        vsqID.PMBendDepth = this.PMBendDepth;
        vsqID.PMBendLength = this.PMBendLength;
        vsqID.PMbPortamentoUse = this.PMbPortamentoUse;
        vsqID.DEMdecGainRate = this.DEMdecGainRate;
        vsqID.DEMaccent = this.DEMaccent;
        vsqID.d4mean = this.d4mean;
        vsqID.pMeanOnsetFirstNote = this.pMeanOnsetFirstNote;
        vsqID.vMeanNoteTransition = this.vMeanNoteTransition;
        vsqID.pMeanEndingNote = this.pMeanEndingNote;
        if (this.LyricHandle != null) {
            vsqID.LyricHandle = (LyricHandle)this.LyricHandle.clone();
        }
        if (this.VibratoHandle != null) {
            vsqID.VibratoHandle = (VibratoHandle)this.VibratoHandle.clone();
        }
        vsqID.VibratoDelay = this.VibratoDelay;
        if (this.NoteHeadHandle != null) {
            vsqID.NoteHeadHandle = (NoteHeadHandle)this.NoteHeadHandle.clone();
        }
        if (this.IconDynamicsHandle != null) {
            vsqID.IconDynamicsHandle = (IconDynamicsHandle)this.IconDynamicsHandle.clone();
        }
        return vsqID;
    }

    public VsqID(int n) {
        this.value = n;
    }

    public VsqID() {
        this(0);
    }

    public VsqID(TextStream textStream, int n, ByRef<String> byRef) {
        this.value = n;
        this.type = VsqIDType.Unknown;
        this.IconHandle_index = -2;
        this.LyricHandle_index = -1;
        this.VibratoHandle_index = -1;
        this.NoteHeadHandle_index = -1;
        this.setLength(0);
        this.Note = 0;
        this.Dynamics = 64;
        this.PMBendDepth = 8;
        this.PMBendLength = 0;
        this.PMbPortamentoUse = 0;
        this.DEMdecGainRate = 50;
        this.DEMaccent = 50;
        this.VibratoDelay = 0;
        byRef.value = textStream.readLine();
        while (!((String)byRef.value).startsWith("[")) {
            String[] stringArray = PortUtil.splitString((String)byRef.value, '=');
            String string = stringArray[0];
            if (string.equals("Type")) {
                this.type = stringArray[1].equals("Anote") ? VsqIDType.Anote : (stringArray[1].equals("Singer") ? VsqIDType.Singer : (stringArray[1].equals("Aicon") ? VsqIDType.Aicon : VsqIDType.Unknown));
            } else if (string.equals("Length")) {
                this.setLength(PortUtil.parseInt(stringArray[1]));
            } else if (string.equals("Note#")) {
                this.Note = PortUtil.parseInt(stringArray[1]);
            } else if (string.equals("Dynamics")) {
                this.Dynamics = PortUtil.parseInt(stringArray[1]);
            } else if (string.equals("PMBendDepth")) {
                this.PMBendDepth = PortUtil.parseInt(stringArray[1]);
            } else if (string.equals("PMBendLength")) {
                this.PMBendLength = PortUtil.parseInt(stringArray[1]);
            } else if (string.equals("DEMdecGainRate")) {
                this.DEMdecGainRate = PortUtil.parseInt(stringArray[1]);
            } else if (string.equals("DEMaccent")) {
                this.DEMaccent = PortUtil.parseInt(stringArray[1]);
            } else if (string.equals("LyricHandle")) {
                this.LyricHandle_index = VsqHandle.HandleIndexFromString(stringArray[1]);
            } else if (string.equals("IconHandle")) {
                this.IconHandle_index = VsqHandle.HandleIndexFromString(stringArray[1]);
            } else if (string.equals("VibratoHandle")) {
                this.VibratoHandle_index = VsqHandle.HandleIndexFromString(stringArray[1]);
            } else if (string.equals("VibratoDelay")) {
                this.VibratoDelay = PortUtil.parseInt(stringArray[1]);
            } else if (string.equals("PMbPortamentoUse")) {
                this.PMbPortamentoUse = PortUtil.parseInt(stringArray[1]);
            } else if (string.equals("NoteHeadHandle")) {
                this.NoteHeadHandle_index = VsqHandle.HandleIndexFromString(stringArray[1]);
            }
            if (!textStream.ready()) break;
            byRef.value = textStream.readLine();
        }
    }

    public String ToString() {
        String string = "{Type=" + (Object)((Object)this.type);
        if (this.type == VsqIDType.Anote) {
            string = string + ", Length=" + this.getLength();
            string = string + ", Note#=" + this.Note;
            string = string + ", Dynamics=" + this.Dynamics;
            string = string + ", PMBendDepth=" + this.PMBendDepth;
            string = string + ", PMBendLength=" + this.PMBendLength;
            string = string + ", PMbPortamentoUse=" + this.PMbPortamentoUse;
            string = string + ", DEMdecGainRate=" + this.DEMdecGainRate;
            string = string + ", DEMaccent=" + this.DEMaccent;
            if (this.LyricHandle != null) {
                string = string + ", LyricHandle=h#" + PortUtil.formatDecimal("0000", this.LyricHandle_index);
            }
            if (this.VibratoHandle != null) {
                string = string + ", VibratoHandle=h#" + PortUtil.formatDecimal("0000", this.VibratoHandle_index);
                string = string + ", VibratoDelay=" + this.VibratoDelay;
            }
        } else if (this.type == VsqIDType.Singer) {
            string = string + ", IconHandle=h#" + PortUtil.formatDecimal("0000", this.IconHandle_index);
        }
        string = string + "}";
        return string;
    }
}

