/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.BufferedWriter;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.ByRef;
import org.kbinani.PortUtil;
import org.kbinani.ValuePair;
import org.kbinani.vsq.BPPair;
import org.kbinani.vsq.IconHandle;
import org.kbinani.vsq.LyricHandle;
import org.kbinani.vsq.MidiEvent;
import org.kbinani.vsq.MidiFile;
import org.kbinani.vsq.NRPN;
import org.kbinani.vsq.NrpnData;
import org.kbinani.vsq.SymbolTable;
import org.kbinani.vsq.TempoTableEntry;
import org.kbinani.vsq.TempoVector;
import org.kbinani.vsq.TextStream;
import org.kbinani.vsq.TimeSigTableEntry;
import org.kbinani.vsq.Timesig;
import org.kbinani.vsq.UstEnvelope;
import org.kbinani.vsq.UstEvent;
import org.kbinani.vsq.UstFile;
import org.kbinani.vsq.VibratoBPList;
import org.kbinani.vsq.VibratoBPPair;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqBPPair;
import org.kbinani.vsq.VsqBPPairSearchContext;
import org.kbinani.vsq.VsqBarLineType;
import org.kbinani.vsq.VsqCommand;
import org.kbinani.vsq.VsqCommandType;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.VsqMaster;
import org.kbinani.vsq.VsqMixer;
import org.kbinani.vsq.VsqMixerEntry;
import org.kbinani.vsq.VsqNote;
import org.kbinani.vsq.VsqNrpn;
import org.kbinani.vsq.VsqTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqFile
implements Cloneable,
Serializable {
    public Vector<VsqTrack> Track;
    public TempoVector TempoTable;
    public Vector<TimeSigTableEntry> TimesigTable;
    protected static final int m_tpq = 480;
    public int TotalClocks = 0;
    protected static final int superTempo = 500000;
    public VsqMaster Master;
    public VsqMixer Mixer;
    public Object Tag;
    static final byte[] _MTRK = new byte[]{77, 84, 114, 107};
    static final byte[] _MTHD = new byte[]{77, 84, 104, 100};
    static final byte[] _MASTER_TRACK = new byte[]{77, 97, 115, 116, 101, 114, 32, 84, 114, 97, 99, 107};
    static final String[] _CURVES = new String[]{"VEL", "DYN", "BRE", "BRI", "CLE", "OPE", "GEN", "POR", "PIT", "PBS"};

    public VsqFile(UstFile ustFile) {
        this("Miku", 1, 4, 4, ustFile.getBaseTempo());
        int n = 1920;
        VsqBPList vsqBPList = new VsqBPList("", 0, -2400, 2400);
        Iterator<UstEvent> iterator = ustFile.getTrack(0).getNoteEventIterator();
        while (iterator.hasNext()) {
            UstEvent ustEvent = iterator.next();
            if (ustEvent.Lyric != "R") {
                VsqID vsqID = new VsqID(0);
                vsqID.setLength(ustEvent.getLength());
                ByRef<String> byRef = new ByRef<String>("a");
                if (!SymbolTable.attatch(ustEvent.Lyric, byRef)) {
                    byRef.value = "a";
                }
                vsqID.LyricHandle = new LyricHandle(ustEvent.Lyric, (String)byRef.value);
                vsqID.Note = ustEvent.Note;
                vsqID.type = VsqIDType.Anote;
                VsqEvent vsqEvent = new VsqEvent(n, vsqID);
                vsqEvent.UstEvent = (UstEvent)ustEvent.clone();
                this.Track.get(1).addEvent(vsqEvent);
                if (ustEvent.Pitches != null) {
                    int n2 = n - ustEvent.PBType;
                    for (int i = 0; i < ustEvent.Pitches.length; ++i) {
                        vsqBPList.add(n2 += ustEvent.PBType, (int)ustEvent.Pitches[i]);
                    }
                }
            }
            if (ustEvent.Tempo > 0.0f) {
                this.TempoTable.add(new TempoTableEntry(n, (int)(6.0E7 / (double)ustEvent.Tempo), 0.0));
            }
            n += ustEvent.getLength();
        }
        this.updateTempoInfo();
        this.updateTotalClocks();
        this.updateTimesigInfo();
        VsqFile.reflectPitch(this, 1, vsqBPList);
    }

    public void adjustClockToMatchWith(double d) {
        int n = this.Track.size();
        for (int i = 1; i < n; ++i) {
            int n2;
            Object object;
            VsqTrack vsqTrack = this.Track.get(i);
            Iterator<VsqEvent> iterator = vsqTrack.getEventIterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (((VsqEvent)object).ID.type == VsqIDType.Singer && ((VsqEvent)object).Clock == 0) continue;
                int n3 = ((VsqEvent)object).Clock;
                double d2 = this.getSecFromClock(n3);
                double d3 = this.getSecFromClock(n3 + ((VsqEvent)object).ID.getLength());
                n2 = (int)(d2 * 8.0 * d);
                int n4 = (int)(d3 * 8.0 * d);
                ((VsqEvent)object).Clock = n2;
                ((VsqEvent)object).ID.setLength(n4 - n2);
                if (((VsqEvent)object).ID.VibratoHandle == null) continue;
                double d4 = this.getSecFromClock(n3 + ((VsqEvent)object).ID.VibratoDelay);
                int n5 = (int)(d4 * 8.0 * d);
                ((VsqEvent)object).ID.VibratoDelay = n5 - n2;
                ((VsqEvent)object).ID.VibratoHandle.setLength(n4 - n5);
            }
            for (int j = 0; j < _CURVES.length; ++j) {
                object = _CURVES[j];
                VsqBPList vsqBPList = vsqTrack.getCurve((String)object);
                if (vsqBPList == null) continue;
                VsqBPList vsqBPList2 = new VsqBPList(vsqBPList.getName(), vsqBPList.getDefault(), vsqBPList.getMinimum(), vsqBPList.getMaximum());
                int n6 = vsqBPList.size();
                for (int k = 0; k < n6; ++k) {
                    int n7 = vsqBPList.getKeyClock(k);
                    n2 = vsqBPList.getElement(k);
                    double d5 = this.getSecFromClock(n7);
                    if (!(d5 >= 0.0)) continue;
                    int n8 = (int)(d5 * 8.0 * d);
                    vsqBPList2.add(n8, n2);
                }
                vsqTrack.setCurve((String)object, vsqBPList2);
            }
        }
        this.TempoTable.clear();
        this.TempoTable.add(new TempoTableEntry(0, (int)(6.0E7 / d), 0.0));
        this.updateTempoInfo();
        this.updateTimesigInfo();
        this.updateTotalClocks();
    }

    public void adjustClockToMatchWith(TempoVector tempoVector) {
        double d = 0.0;
        int n = this.Track.size();
        for (int i = 1; i < n; ++i) {
            int n2;
            Object object;
            VsqTrack vsqTrack = this.Track.get(i);
            Iterator<VsqEvent> iterator = vsqTrack.getEventIterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (((VsqEvent)object).ID.type == VsqIDType.Singer && ((VsqEvent)object).Clock == 0) continue;
                int n3 = ((VsqEvent)object).Clock;
                double d2 = this.getSecFromClock(n3);
                double d3 = this.getSecFromClock(n3 + ((VsqEvent)object).ID.getLength());
                n2 = (int)tempoVector.getClockFromSec(d2);
                int n4 = (int)tempoVector.getClockFromSec(d3);
                ((VsqEvent)object).Clock = n2;
                ((VsqEvent)object).ID.setLength(n4 - n2);
                if (((VsqEvent)object).ID.VibratoHandle == null) continue;
                double d4 = this.getSecFromClock(n3 + ((VsqEvent)object).ID.VibratoDelay);
                int n5 = (int)tempoVector.getClockFromSec(d4);
                ((VsqEvent)object).ID.VibratoDelay = n5 - n2;
                ((VsqEvent)object).ID.VibratoHandle.setLength(n4 - n5);
            }
            for (int j = 0; j < _CURVES.length; ++j) {
                object = _CURVES[j];
                VsqBPList vsqBPList = vsqTrack.getCurve((String)object);
                if (vsqBPList == null) continue;
                VsqBPList vsqBPList2 = new VsqBPList(vsqBPList.getName(), vsqBPList.getDefault(), vsqBPList.getMinimum(), vsqBPList.getMaximum());
                int n6 = vsqBPList.size();
                for (int k = 0; k < n6; ++k) {
                    int n7 = vsqBPList.getKeyClock(k);
                    n2 = vsqBPList.getElement(k);
                    double d5 = this.getSecFromClock(n7);
                    if (!(d5 >= d)) continue;
                    int n8 = (int)tempoVector.getClockFromSec(d5);
                    vsqBPList2.add(n8, n2);
                }
                vsqTrack.setCurve((String)object, vsqBPList2);
            }
        }
    }

    public void printAsMusicXml(String string, String string2) {
        this.printAsMusicXmlCore(string, string2, "", (int)(6.0E7 / (double)this.getTempoAt(0)), false);
    }

    public void printAsMusicXml(String string, String string2, int n) {
        this.printAsMusicXmlCore(string, string2, "", n, true);
    }

    public void printAsMusicXml(String string, String string2, String string3) {
        this.printAsMusicXmlCore(string, string2, string3, (int)(6.0E7 / (double)this.getTempoAt(0)), false);
    }

    public void printAsMusicXml(String string, String string2, String string3, int n) {
        this.printAsMusicXmlCore(string, string2, string3, n, true);
    }

    private static void printStyledNoteCor(BufferedWriter bufferedWriter, int n, int n2, String string, TreeMap<String, Boolean> treeMap, boolean bl, boolean bl2, String string2) throws IOException {
        bufferedWriter.write("      <note>");
        bufferedWriter.newLine();
        if (n2 < 0) {
            bufferedWriter.write("        <rest/>");
            bufferedWriter.newLine();
        } else {
            String string3 = VsqNote.getNoteStringBase(n2);
            int n3 = VsqNote.getNoteOctave(n2);
            bufferedWriter.write("        <pitch>");
            bufferedWriter.newLine();
            bufferedWriter.write("          <step>" + string3 + "</step>");
            bufferedWriter.newLine();
            int n4 = VsqNote.getNoteAlter(n2);
            if (n4 != 0) {
                bufferedWriter.write("          <alter>" + n4 + "</alter>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("          <octave>" + (n3 + 1) + "</octave>");
            bufferedWriter.newLine();
            bufferedWriter.write("        </pitch>");
            bufferedWriter.newLine();
            String string4 = n2 >= 70 ? "down" : "up";
            bufferedWriter.write("        <stem>" + string4 + "</stem>");
            bufferedWriter.newLine();
            String string5 = "";
            String string6 = string3;
            if (!bl2 && treeMap.containsKey(string6)) {
                if (n4 == 0) {
                    if (treeMap.get(string6).booleanValue()) {
                        string5 = "natural";
                        treeMap.put(string6, false);
                    }
                } else if (!treeMap.get(string6).booleanValue()) {
                    string5 = n4 == 1 ? "sharp" : "flat";
                    treeMap.put(string6, true);
                }
            }
            if (PortUtil.getStringLength(string5) > 0) {
                bufferedWriter.write("        <accidental>" + string5 + "</accidental>");
                bufferedWriter.newLine();
            }
            if (bl) {
                bufferedWriter.write("        <tie type=\"start\"/>");
                bufferedWriter.newLine();
                bufferedWriter.write("        <notations>");
                bufferedWriter.newLine();
                bufferedWriter.write("          <tied type=\"start\"/>");
                bufferedWriter.newLine();
                bufferedWriter.write("        </notations>");
                bufferedWriter.newLine();
            }
            if (bl2) {
                bufferedWriter.write("        <tie type=\"stop\"/>");
                bufferedWriter.newLine();
                bufferedWriter.write("        <notations>");
                bufferedWriter.newLine();
                bufferedWriter.write("          <tied type=\"stop\"/>");
                bufferedWriter.newLine();
                bufferedWriter.write("        </notations>");
                bufferedWriter.newLine();
            }
            if (!bl2) {
                bufferedWriter.write("        <lyric>");
                bufferedWriter.newLine();
                bufferedWriter.write("          <text>" + string + "</text>");
                bufferedWriter.newLine();
                bufferedWriter.write("        </lyric>");
                bufferedWriter.newLine();
            }
        }
        bufferedWriter.write("        <voice>1</voice>");
        bufferedWriter.newLine();
        bufferedWriter.write("        <duration>" + n + "</duration>");
        bufferedWriter.newLine();
        if (PortUtil.getStringLength(string2) > 0) {
            bufferedWriter.write("        <type>" + string2 + "</type>");
            bufferedWriter.newLine();
        }
        bufferedWriter.write("      </note>");
        bufferedWriter.newLine();
    }

    private static void printStyledNote(BufferedWriter bufferedWriter, int n, int n2, int n3, Vector<TempoTableEntry> vector, String string, TreeMap<String, Boolean> treeMap, boolean bl, boolean bl2) throws IOException {
        int n4;
        int n5;
        Object object;
        int n6 = vector.size();
        for (int i = 0; i < n6; ++i) {
            object = vector.get(i);
            int n7 = (int)(6.0E7 / (double)((TempoTableEntry)object).Tempo);
            bufferedWriter.write("      <direction placement=\"above\">");
            bufferedWriter.newLine();
            bufferedWriter.write("        <direction-type>");
            bufferedWriter.newLine();
            bufferedWriter.write("          <metronome>");
            bufferedWriter.newLine();
            bufferedWriter.write("            <beat-unit>quarter</beat-unit>");
            bufferedWriter.newLine();
            bufferedWriter.write("            <per-minute>" + n7 + "</per-minute>");
            bufferedWriter.newLine();
            bufferedWriter.write("          </metronome>");
            bufferedWriter.newLine();
            bufferedWriter.write("          <words>Tempo " + n7 + "</words>");
            bufferedWriter.newLine();
            bufferedWriter.write("        </direction-type>");
            bufferedWriter.newLine();
            bufferedWriter.write("        <sound tempo=\"" + n7 + "\"/>");
            bufferedWriter.newLine();
            bufferedWriter.write("        <offset>" + (((TempoTableEntry)object).Clock - n) + "</offset>");
            bufferedWriter.newLine();
            bufferedWriter.write("      </direction>");
            bufferedWriter.newLine();
        }
        int[] nArray = new int[9];
        object = new int[]{1920, 960, 480, 240, 120, 60, 30, 15};
        String[] stringArray = new String[]{"whole", "half", "quarter", "eighth", "16th", "32nd", "64th", "128th", ""};
        int n8 = n2;
        for (n5 = 0; n5 < 8; ++n5) {
            nArray[n5] = n8 / object[n5];
            if (nArray[n5] <= 0) continue;
            n8 -= object[n5] * nArray[n5];
        }
        nArray[8] = n8;
        n5 = -1;
        int n9 = -1;
        int n10 = 0;
        for (n4 = 0; n4 < 8; ++n4) {
            if (nArray[n4] <= 0) continue;
            if (n5 < 0) {
                n5 = n4;
            }
            n9 = n4;
            n10 += nArray[n4];
        }
        for (n4 = 0; n4 < 8; ++n4) {
            int n11 = nArray[n4];
            if (n11 <= 0) continue;
            for (int i = 0; i < n11; ++i) {
                boolean bl3;
                boolean bl4 = n10 > 0;
                boolean bl5 = bl3 = n10 > 0;
                if (n4 == n5 && i == 0) {
                    bl3 = bl2;
                }
                if (n4 == n9 && i == n11 - 1) {
                    bl4 = bl;
                }
                VsqFile.printStyledNoteCor(bufferedWriter, (int)object[n4], n3, string, treeMap, bl4, bl3, stringArray[n4]);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void printAsMusicXmlCore(String string, String string2, String string3, int n, boolean bl) {
        BufferedWriter bufferedWriter = null;
        VsqFile vsqFile = (VsqFile)this.clone();
        int n2 = (int)(6.0E7 / (double)n);
        if (!bl) {
            n2 = vsqFile.getTempoAt(0);
        }
        if (bl) {
            vsqFile.adjustClockToMatchWith(n);
        }
        Timesig timesig = vsqFile.getTimesigAt(0);
        int n3 = timesig.numerator * 480 * 4 / timesig.denominator;
        try {
            int n4;
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), string2));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"" + string2 + "\"?>");
            bufferedWriter.newLine();
            bufferedWriter.write("<!DOCTYPE score-partwise PUBLIC \"-//Recordare//DTD MusicXML 2.0 Partwise//EN\"");
            bufferedWriter.newLine();
            bufferedWriter.write("                                \"http://www.musicxml.org/dtds/partwise.dtd\">");
            bufferedWriter.newLine();
            bufferedWriter.write("<score-partwise version=\"2.0\">");
            bufferedWriter.newLine();
            bufferedWriter.write("  <identification>");
            bufferedWriter.newLine();
            bufferedWriter.write("    <encoding>");
            bufferedWriter.newLine();
            if (PortUtil.getStringLength(string3) > 0) {
                bufferedWriter.write("      <software>" + string3 + "</software>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("      <software>org.kbinani.vsq</software>");
            bufferedWriter.newLine();
            bufferedWriter.write("    </encoding>");
            bufferedWriter.newLine();
            bufferedWriter.write("  </identification>");
            bufferedWriter.newLine();
            bufferedWriter.write("  <part-list>");
            bufferedWriter.newLine();
            int n5 = vsqFile.Track.size();
            Timesig timesig2 = vsqFile.getTimesigAt(0);
            int n6 = timesig2.numerator * 480 * 4 / timesig2.denominator;
            for (n4 = 1; n4 < n5; ++n4) {
                VsqTrack vsqTrack = vsqFile.Track.get(n4);
                bufferedWriter.write("    <score-part id=\"P" + n4 + "\">");
                bufferedWriter.newLine();
                bufferedWriter.write("      <part-name>" + vsqTrack.getName() + "</part-name>");
                bufferedWriter.newLine();
                bufferedWriter.write("    </score-part>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("  </part-list>");
            bufferedWriter.newLine();
            n4 = 0;
            for (int i = 1; i < n5; ++i) {
                VsqTrack vsqTrack = vsqFile.Track.get(i);
                int n7 = vsqTrack.getEventCount();
                bufferedWriter.write("  <part id=\"P" + i + "\">");
                bufferedWriter.newLine();
                int n8 = vsqFile.TimesigTable.size();
                int n9 = n4;
                int n10 = n4 * n6;
                int n11 = 0;
                for (int j = 0; j < n8; ++j) {
                    int n12;
                    TimeSigTableEntry timeSigTableEntry = vsqFile.TimesigTable.get(j);
                    n6 = timeSigTableEntry.Numerator * 480 * 4 / timeSigTableEntry.Denominator;
                    int n13 = 0;
                    if (j + 1 < n8) {
                        TimeSigTableEntry timeSigTableEntry2 = vsqFile.TimesigTable.get(j + 1);
                        n13 = timeSigTableEntry2.BarCount - timeSigTableEntry.BarCount;
                    } else {
                        n12 = vsqFile.TotalClocks - n10;
                        n13 = n12 / n6;
                        if (n12 % n6 != 0) {
                            ++n13;
                        }
                    }
                    for (n12 = n9; n12 < n9 + n13; ++n12) {
                        int n14;
                        String[] stringArray;
                        int n15 = n10 + (n12 - n9) * n6;
                        int n16 = n15 + n6;
                        int n17 = this.TempoTable.size();
                        Vector<TempoTableEntry> vector = new Vector<TempoTableEntry>();
                        for (int k = 0; k < n17; ++k) {
                            stringArray = (String[])this.TempoTable.get(k);
                            if (n15 > stringArray.Clock || stringArray.Clock >= n16) continue;
                            vector.add((TempoTableEntry)stringArray.clone());
                        }
                        bufferedWriter.write("    <measure number=\"" + (n12 + 1 - n4) + "\">");
                        bufferedWriter.newLine();
                        if (n12 == n9) {
                            bufferedWriter.write("      <attributes>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        <divisions>480</divisions>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        <time symbol=\"common\">");
                            bufferedWriter.newLine();
                            bufferedWriter.write("          <beats>" + timeSigTableEntry.Numerator + "</beats>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("          <beat-type>" + timeSigTableEntry.Denominator + "</beat-type>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        </time>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("      </attributes>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("      <direction placement=\"above\">");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        <direction-type>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("          <metronome>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("            <beat-unit>quarter</beat-unit>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("            <per-minute>" + n + "</per-minute>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("          </metronome>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        </direction-type>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        <sound tempo=\"" + n + "\"/>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("      </direction>");
                            bufferedWriter.newLine();
                        }
                        TreeMap<String, Boolean> treeMap = new TreeMap<String, Boolean>();
                        stringArray = new String[]{"C", "D", "E", "F", "G", "A", "B"};
                        for (n14 = 0; n14 < stringArray.length; ++n14) {
                            treeMap.put(stringArray[n14], false);
                        }
                        n14 = n15;
                        for (int k = n11; k < n7; ++k) {
                            int n18;
                            VsqEvent vsqEvent = vsqTrack.getEvent(k);
                            if (vsqEvent.ID.type != VsqIDType.Anote) {
                                if (n16 > vsqEvent.Clock) continue;
                                n11 = k;
                                break;
                            }
                            if (!(n15 <= vsqEvent.Clock && vsqEvent.Clock < n16 || n15 <= vsqEvent.Clock + vsqEvent.ID.getLength() && vsqEvent.Clock + vsqEvent.ID.getLength() < n16) && (vsqEvent.Clock > n15 || n16 > vsqEvent.Clock + vsqEvent.ID.getLength())) continue;
                            if (n14 < vsqEvent.Clock) {
                                Vector<TempoTableEntry> vector2 = new Vector<TempoTableEntry>();
                                if (!bl) {
                                    for (n18 = 0; n18 < vector.size(); ++n18) {
                                        TempoTableEntry tempoTableEntry = (TempoTableEntry)vector.get(n18);
                                        if (n14 > tempoTableEntry.Clock || tempoTableEntry.Clock >= vsqEvent.Clock) continue;
                                        vector2.add(tempoTableEntry);
                                    }
                                }
                                VsqFile.printStyledNote(bufferedWriter, n14, vsqEvent.Clock - n14, -1, vector2, "", treeMap, false, false);
                                n14 = vsqEvent.Clock;
                            }
                            boolean bl2 = false;
                            n18 = vsqEvent.Clock;
                            if (n18 < n15) {
                                n18 = n15;
                                bl2 = true;
                            }
                            int n19 = vsqEvent.Clock + vsqEvent.ID.getLength();
                            boolean bl3 = false;
                            if (n16 < n19) {
                                n19 = n16;
                                bl3 = true;
                            }
                            int n20 = n19 - n18;
                            Vector<TempoTableEntry> vector3 = new Vector<TempoTableEntry>();
                            if (!bl) {
                                for (int i2 = 0; i2 < vector.size(); ++i2) {
                                    TempoTableEntry tempoTableEntry = (TempoTableEntry)vector.get(i2);
                                    if (n18 > tempoTableEntry.Clock || tempoTableEntry.Clock >= n19) continue;
                                    vector3.add(tempoTableEntry);
                                }
                            }
                            VsqFile.printStyledNote(bufferedWriter, n18, n20, vsqEvent.ID.Note, vector3, vsqEvent.ID.LyricHandle.L0.Phrase, treeMap, bl3, bl2);
                            n14 = n19;
                            n11 = bl3 ? k : k + 1;
                        }
                        if (n14 < n16) {
                            Vector<TempoTableEntry> vector4 = new Vector<TempoTableEntry>();
                            if (!bl) {
                                for (int k = 0; k < vector.size(); ++k) {
                                    TempoTableEntry tempoTableEntry = (TempoTableEntry)vector.get(k);
                                    if (n16 > tempoTableEntry.Clock || tempoTableEntry.Clock >= n14) continue;
                                    vector4.add(tempoTableEntry);
                                }
                            }
                            VsqFile.printStyledNote(bufferedWriter, n14, n16 - n14, -1, vector4, "", treeMap, false, false);
                            n14 = n16;
                        }
                        bufferedWriter.write("    </measure>");
                        bufferedWriter.newLine();
                    }
                    n10 += n13 * n6;
                    n9 += n13;
                }
                bufferedWriter.write("  </part>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("</score-partwise>");
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VsqFile#printAsMusicXml; ex=" + exception);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("VsqFile#printAsMusicXml; ex2=" + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printAsMusicXml_OLD(String string) {
        BufferedWriter bufferedWriter = null;
        try {
            int n;
            bufferedWriter = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string), "UTF-8"));
            bufferedWriter.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
            bufferedWriter.newLine();
            bufferedWriter.write("<!DOCTYPE score-partwise PUBLIC \"-//Recordare//DTD MusicXML 2.0 Partwise//EN\"");
            bufferedWriter.newLine();
            bufferedWriter.write("                                \"http://www.musicxml.org/dtds/partwise.dtd\">");
            bufferedWriter.newLine();
            bufferedWriter.write("<score-partwise version=\"2.0\">");
            bufferedWriter.newLine();
            bufferedWriter.write("  <part-list>");
            bufferedWriter.newLine();
            int n2 = this.Track.size();
            for (n = 1; n < n2; ++n) {
                VsqTrack vsqTrack = this.Track.get(n);
                bufferedWriter.write("    <score-part id=\"P" + n + "\">");
                bufferedWriter.newLine();
                bufferedWriter.write("      <part-name>" + vsqTrack.getName() + "</part-name>");
                bufferedWriter.newLine();
                bufferedWriter.write("    </score-part>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("  </part-list>");
            bufferedWriter.newLine();
            n = 1920;
            for (int i = 1; i < n2; ++i) {
                VsqTrack vsqTrack = this.Track.get(i);
                bufferedWriter.write("  <part id=\"P" + i + "\">");
                bufferedWriter.newLine();
                int n3 = this.TotalClocks / n + 1;
                int n4 = 0;
                int n5 = vsqTrack.getEventCount();
                for (int j = 0; j < n3; ++j) {
                    bufferedWriter.write("    <measure number=\"" + (j + 1) + "\">");
                    bufferedWriter.newLine();
                    if (j == 0) {
                        bufferedWriter.write("      <attributes>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        <divisions>480</divisions>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        <time symbol=\"common\">");
                        bufferedWriter.newLine();
                        bufferedWriter.write("          <beats>4</beats>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("          <beat-type>4</beat-type>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        </time>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("      </attributes>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("      <sound tempo=\"" + this.getBaseTempo() + "\"/>");
                        bufferedWriter.newLine();
                    }
                    int n6 = j * n;
                    int n7 = n6 + n;
                    int n8 = n6;
                    for (int k = n4; k < n5; ++k) {
                        VsqEvent vsqEvent = vsqTrack.getEvent(k);
                        if (vsqEvent.ID.type != VsqIDType.Anote) {
                            if (n7 > vsqEvent.Clock) continue;
                            n4 = k;
                            break;
                        }
                        if (!(n6 <= vsqEvent.Clock && vsqEvent.Clock < n7 || n6 <= vsqEvent.Clock + vsqEvent.ID.getLength() && vsqEvent.Clock + vsqEvent.ID.getLength() < n7) && (vsqEvent.Clock > n6 || n7 > vsqEvent.Clock + vsqEvent.ID.getLength())) continue;
                        if (n8 < vsqEvent.Clock) {
                            bufferedWriter.write("      <note>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        <rest/>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        <duration>" + (vsqEvent.Clock - n8) + "</duration>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        <voice>1</voice>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("      </note>");
                            bufferedWriter.newLine();
                            n8 = vsqEvent.Clock;
                        }
                        boolean bl = false;
                        int n9 = vsqEvent.Clock;
                        if (n9 < n6) {
                            n9 = n6;
                            bl = true;
                        }
                        int n10 = vsqEvent.Clock + vsqEvent.ID.getLength();
                        boolean bl2 = false;
                        if (n7 < n10) {
                            n10 = n7;
                            bl2 = true;
                        }
                        int n11 = n10 - n9;
                        bufferedWriter.write("      <note>");
                        bufferedWriter.newLine();
                        int n12 = vsqEvent.ID.Note;
                        bufferedWriter.write("        <pitch>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("          <step>" + VsqNote.getNoteStringBase(n12) + "</step>");
                        bufferedWriter.newLine();
                        int n13 = VsqNote.getNoteAlter(n12);
                        if (n13 != 0) {
                            bufferedWriter.write("          <alter>" + n13 + "</alter>");
                            bufferedWriter.newLine();
                        }
                        bufferedWriter.write("          <octave>" + (VsqNote.getNoteOctave(n12) + 1) + "</octave>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        </pitch>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        <duration>" + n11 + "</duration>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        <voice>1</voice>");
                        bufferedWriter.newLine();
                        if (bl2) {
                            bufferedWriter.write("        <tie type=\"start\"/>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        <notations>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("          <tied type=\"start\"/>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        </notations>");
                            bufferedWriter.newLine();
                        }
                        if (bl) {
                            bufferedWriter.write("        <tie type=\"stop\"/>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        <notations>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("          <tied type=\"stop\"/>");
                            bufferedWriter.newLine();
                            bufferedWriter.write("        </notations>");
                            bufferedWriter.newLine();
                        }
                        bufferedWriter.write("        <lyric>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("          <text>" + vsqEvent.ID.LyricHandle.L0.Phrase + "</text>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        </lyric>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("      </note>");
                        bufferedWriter.newLine();
                        n8 = n10;
                        n4 = bl2 ? k : k + 1;
                    }
                    if (n8 < n7) {
                        bufferedWriter.write("      <note>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        <rest/>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        <duration>" + (n7 - n8) + "</duration>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("        <voice>1</voice>");
                        bufferedWriter.newLine();
                        bufferedWriter.write("      </note>");
                        bufferedWriter.newLine();
                        n8 = n7;
                    }
                    bufferedWriter.write("    </measure>");
                    bufferedWriter.newLine();
                }
                bufferedWriter.write("  </part>");
                bufferedWriter.newLine();
            }
            bufferedWriter.write("</score-partwise>");
            bufferedWriter.newLine();
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VsqFile#printAsMusicXml; ex=" + exception);
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("VsqFile#printAsMusicXml; ex2=" + exception);
                }
            }
        }
    }

    private static void reflectPitch(VsqFile vsqFile, int n, VsqBPList vsqBPList) {
        int n2 = vsqBPList.size();
        VsqBPList vsqBPList2 = new VsqBPList("pit", 0, -8192, 8191);
        VsqBPList vsqBPList3 = new VsqBPList("pbs", 2, 0, 24);
        int n3 = vsqFile.getPreMeasureClocks();
        int n4 = vsqBPList2.getDefault();
        int n5 = vsqBPList3.getDefault();
        int n6 = 24;
        int n7 = 0;
        Vector<Integer> vector = new Vector<Integer>();
        vector.add(n3);
        int n8 = n3;
        Iterator<VsqEvent> iterator = vsqFile.Track.get(n).getNoteEventIterator();
        while (iterator.hasNext()) {
            VsqEvent vsqEvent = iterator.next();
            if (vsqEvent.Clock <= n8) {
                n8 = Math.max(n8, vsqEvent.Clock + vsqEvent.ID.getLength());
                continue;
            }
            vector.add(vsqEvent.Clock);
            n8 = vsqEvent.Clock + vsqEvent.ID.getLength();
        }
        int n9 = vector.size();
        block1: for (int i = 0; i < n9; ++i) {
            int n10 = (Integer)vector.get(i);
            int n11 = Integer.MAX_VALUE;
            if (i + 1 < vector.size()) {
                n11 = (Integer)vector.get(i + 1);
            }
            double d = 0.0;
            for (int j = 0; j < n2; ++j) {
                int n12 = vsqBPList.getKeyClock(j);
                if (n12 < n10) continue;
                if (n11 <= n12) break;
                d = Math.max(d, Math.abs((double)vsqBPList.getValue(n12) / 100.0));
            }
            if ((n6 = (int)(Math.ceil(d * 8192.0 / 8191.0) + 0.1)) <= 0) {
                n6 = 1;
            }
            double d2 = (double)vsqBPList.getValue(n10) / 100.0;
            if (n5 != n6) {
                vsqBPList3.add(n10, n6);
                n5 = n6;
            }
            if (n4 != (n7 = (int)(d2 * 8192.0 / (double)n6))) {
                vsqBPList2.add(n10, n7);
                n4 = n7;
            }
            for (int j = 0; j < n2; ++j) {
                int n13 = vsqBPList.getKeyClock(j);
                if (n13 < n10) continue;
                if (n11 <= n13) continue block1;
                if (n13 == n10 || n4 == (n7 = (int)((d2 = (double)vsqBPList.getElement(j) / 100.0) * 8192.0 / (double)n6))) continue;
                vsqBPList2.add(n13, n7);
                n4 = n7;
            }
        }
        vsqFile.Track.get(n).setCurve("pit", vsqBPList2);
        vsqFile.Track.get(n).setCurve("pbs", vsqBPList3);
    }

    public boolean checkPreSendTimeValidity(int n) {
        int n2 = this.Track.size();
        for (int i = 1; i < n2; ++i) {
            VsqTrack vsqTrack = this.Track.get(i);
            Iterator<VsqEvent> iterator = vsqTrack.getNoteEventIterator();
            if (!iterator.hasNext()) continue;
            VsqEvent vsqEvent = iterator.next();
            int n3 = this.getPresendClockAt(vsqEvent.Clock, n);
            if (vsqEvent.Clock - n3 >= 0) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void speedingUp(double d) {
        TempoVector tempoVector = this.TempoTable;
        synchronized (tempoVector) {
            int n = this.TempoTable.size();
            for (int i = 0; i < n; ++i) {
                ((TempoTableEntry)this.TempoTable.get((int)i)).Tempo = (int)((double)((TempoTableEntry)this.TempoTable.get((int)i)).Tempo / d);
            }
        }
        this.updateTempoInfo();
    }

    public VsqCommand executeCommand(VsqCommand vsqCommand) {
        VsqCommandType vsqCommandType = vsqCommand.Type;
        if (vsqCommandType == VsqCommandType.CHANGE_PRE_MEASURE) {
            int n;
            VsqCommand vsqCommand2 = VsqCommand.generateCommandChangePreMeasure(this.Master.PreMeasure);
            this.Master.PreMeasure = n = ((Integer)vsqCommand.Args[0]).intValue();
            this.updateTimesigInfo();
            return vsqCommand2;
        }
        if (vsqCommandType == VsqCommandType.TRACK_ADD) {
            VsqTrack vsqTrack = (VsqTrack)vsqCommand.Args[0];
            VsqMixerEntry vsqMixerEntry = (VsqMixerEntry)vsqCommand.Args[1];
            int n = (Integer)vsqCommand.Args[2];
            VsqCommand vsqCommand3 = VsqCommand.generateCommandDeleteTrack(n);
            if (this.Track.size() <= 17) {
                this.Track.insertElementAt((VsqTrack)vsqTrack.clone(), n);
                this.Mixer.Slave.add((VsqMixerEntry)vsqMixerEntry.clone());
                return vsqCommand3;
            }
            return null;
        }
        if (vsqCommandType == VsqCommandType.TRACK_DELETE) {
            int n = (Integer)vsqCommand.Args[0];
            VsqCommand vsqCommand4 = VsqCommand.generateCommandAddTrack(this.Track.get(n), this.Mixer.Slave.get(n - 1), n);
            this.Track.removeElementAt(n);
            this.Mixer.Slave.removeElementAt(n - 1);
            this.updateTotalClocks();
            return vsqCommand4;
        }
        if (vsqCommandType == VsqCommandType.UPDATE_TEMPO) {
            int n = (Integer)vsqCommand.Args[0];
            int n2 = (Integer)vsqCommand.Args[1];
            int n3 = (Integer)vsqCommand.Args[2];
            int n4 = -1;
            int n5 = this.TempoTable.size();
            for (int i = 0; i < n5; ++i) {
                if (((TempoTableEntry)this.TempoTable.get((int)i)).Clock != n) continue;
                n4 = i;
                break;
            }
            VsqCommand vsqCommand5 = null;
            if (n4 >= 0) {
                if (n2 <= 0) {
                    vsqCommand5 = VsqCommand.generateCommandUpdateTempo(n, n, ((TempoTableEntry)this.TempoTable.get((int)n4)).Tempo);
                    this.TempoTable.removeElementAt(n4);
                } else {
                    vsqCommand5 = VsqCommand.generateCommandUpdateTempo(n3, n, ((TempoTableEntry)this.TempoTable.get((int)n4)).Tempo);
                    ((TempoTableEntry)this.TempoTable.get((int)n4)).Tempo = n2;
                    ((TempoTableEntry)this.TempoTable.get((int)n4)).Clock = n3;
                }
            } else {
                vsqCommand5 = VsqCommand.generateCommandUpdateTempo(n, n, -1);
                this.TempoTable.add(new TempoTableEntry(n3, n2, 0.0));
            }
            this.updateTempoInfo();
            this.updateTotalClocks();
            return vsqCommand5;
        }
        if (vsqCommandType == VsqCommandType.UPDATE_TEMPO_RANGE) {
            int[] nArray = (int[])vsqCommand.Args[0];
            int[] nArray2 = (int[])vsqCommand.Args[1];
            int[] nArray3 = (int[])vsqCommand.Args[2];
            int[] nArray4 = new int[nArray2.length];
            int n = Integer.MAX_VALUE;
            for (int i = 0; i < nArray.length; ++i) {
                int n6 = -1;
                n = Math.min(n, nArray[i]);
                n = Math.min(n, nArray3[i]);
                int n7 = this.TempoTable.size();
                for (int j = 0; j < n7; ++j) {
                    if (((TempoTableEntry)this.TempoTable.get((int)j)).Clock != nArray[i]) continue;
                    n6 = j;
                    break;
                }
                if (n6 >= 0) {
                    nArray4[i] = ((TempoTableEntry)this.TempoTable.get((int)n6)).Tempo;
                    if (nArray2[i] <= 0) {
                        this.TempoTable.removeElementAt(n6);
                        continue;
                    }
                    ((TempoTableEntry)this.TempoTable.get((int)n6)).Tempo = nArray2[i];
                    ((TempoTableEntry)this.TempoTable.get((int)n6)).Clock = nArray3[i];
                    continue;
                }
                nArray4[i] = -1;
                this.TempoTable.add(new TempoTableEntry(nArray3[i], nArray2[i], 0.0));
            }
            this.updateTempoInfo();
            this.updateTotalClocks();
            return VsqCommand.generateCommandUpdateTempoRange(nArray3, nArray, nArray4);
        }
        if (vsqCommandType == VsqCommandType.UPDATE_TIMESIG) {
            int n = (Integer)vsqCommand.Args[0];
            int n8 = (Integer)vsqCommand.Args[1];
            int n9 = (Integer)vsqCommand.Args[2];
            int n10 = (Integer)vsqCommand.Args[3];
            int n11 = -1;
            int n12 = this.TimesigTable.size();
            for (int i = 0; i < n12; ++i) {
                if (n != this.TimesigTable.get((int)i).BarCount) continue;
                n11 = i;
                break;
            }
            VsqCommand vsqCommand6 = null;
            if (n11 >= 0) {
                if (n8 <= 0) {
                    vsqCommand6 = VsqCommand.generateCommandUpdateTimesig(n, n, this.TimesigTable.get((int)n11).Numerator, this.TimesigTable.get((int)n11).Denominator);
                    this.TimesigTable.removeElementAt(n11);
                } else {
                    vsqCommand6 = VsqCommand.generateCommandUpdateTimesig(n10, n, this.TimesigTable.get((int)n11).Numerator, this.TimesigTable.get((int)n11).Denominator);
                    this.TimesigTable.get((int)n11).BarCount = n10;
                    this.TimesigTable.get((int)n11).Numerator = n8;
                    this.TimesigTable.get((int)n11).Denominator = n9;
                }
            } else {
                vsqCommand6 = VsqCommand.generateCommandUpdateTimesig(n10, n10, -1, -1);
                this.TimesigTable.add(new TimeSigTableEntry(0, n8, n9, n10));
            }
            this.updateTimesigInfo();
            this.updateTotalClocks();
            return vsqCommand6;
        }
        if (vsqCommandType == VsqCommandType.UPDATE_TIMESIG_RANGE) {
            int[] nArray = (int[])vsqCommand.Args[0];
            int[] nArray5 = (int[])vsqCommand.Args[1];
            int[] nArray6 = (int[])vsqCommand.Args[2];
            int[] nArray7 = (int[])vsqCommand.Args[3];
            int[] nArray8 = new int[nArray5.length];
            int[] nArray9 = new int[nArray6.length];
            for (int i = 0; i < nArray.length; ++i) {
                int n = -1;
                int n13 = this.TimesigTable.size();
                for (int j = 0; j < n13; ++j) {
                    if (this.TimesigTable.get((int)j).BarCount != nArray[i]) continue;
                    n = j;
                    break;
                }
                if (n >= 0) {
                    nArray8[i] = this.TimesigTable.get((int)n).Numerator;
                    nArray9[i] = this.TimesigTable.get((int)n).Denominator;
                    if (nArray5[i] <= 0) {
                        this.TimesigTable.removeElementAt(n);
                        continue;
                    }
                    this.TimesigTable.get((int)n).BarCount = nArray7[i];
                    this.TimesigTable.get((int)n).Numerator = nArray5[i];
                    this.TimesigTable.get((int)n).Denominator = nArray6[i];
                    continue;
                }
                nArray8[i] = -1;
                nArray9[i] = -1;
                this.TimesigTable.add(new TimeSigTableEntry(0, nArray5[i], nArray6[i], nArray7[i]));
            }
            this.updateTimesigInfo();
            this.updateTotalClocks();
            return VsqCommand.generateCommandUpdateTimesigRange(nArray7, nArray, nArray8, nArray9);
        }
        if (vsqCommandType == VsqCommandType.REPLACE) {
            int n;
            int n14;
            VsqFile vsqFile = (VsqFile)vsqCommand.Args[0];
            VsqFile vsqFile2 = (VsqFile)this.clone();
            this.Track.clear();
            int n15 = vsqFile.Track.size();
            for (n14 = 0; n14 < n15; ++n14) {
                this.Track.add((VsqTrack)vsqFile.Track.get(n14).clone());
            }
            this.TempoTable.clear();
            n14 = vsqFile.TempoTable.size();
            for (n = 0; n < n14; ++n) {
                this.TempoTable.add((TempoTableEntry)((TempoTableEntry)vsqFile.TempoTable.get(n)).clone());
            }
            this.TimesigTable.clear();
            n = vsqFile.TimesigTable.size();
            for (int i = 0; i < n; ++i) {
                this.TimesigTable.add((TimeSigTableEntry)vsqFile.TimesigTable.get(i).clone());
            }
            this.TotalClocks = vsqFile.TotalClocks;
            this.Master = (VsqMaster)vsqFile.Master.clone();
            this.Mixer = (VsqMixer)vsqFile.Mixer.clone();
            this.updateTotalClocks();
            return VsqCommand.generateCommandReplace(vsqFile2);
        }
        if (vsqCommandType == VsqCommandType.EVENT_ADD) {
            int n = (Integer)vsqCommand.Args[0];
            VsqEvent vsqEvent = (VsqEvent)vsqCommand.Args[1];
            this.Track.get(n).addEvent(vsqEvent);
            VsqCommand vsqCommand7 = VsqCommand.generateCommandEventDelete(n, vsqEvent.InternalID);
            this.updateTotalClocks();
            this.Track.get(n).sortEvent();
            return vsqCommand7;
        }
        if (vsqCommandType == VsqCommandType.EVENT_ADD_RANGE) {
            int n = (Integer)vsqCommand.Args[0];
            VsqEvent[] vsqEventArray = (VsqEvent[])vsqCommand.Args[1];
            Vector<Integer> vector = new Vector<Integer>();
            int n16 = this.TotalClocks;
            int n17 = 0;
            VsqTrack vsqTrack = this.Track.get(n);
            for (int i = 0; i < vsqEventArray.length; ++i) {
                VsqEvent vsqEvent = (VsqEvent)vsqEventArray[i].clone();
                n16 = Math.min(n16, vsqEvent.Clock);
                n17 = Math.max(n17, vsqEvent.Clock + vsqEvent.ID.getLength());
                vsqTrack.addEvent(vsqEvent);
                vector.add(vsqEvent.InternalID);
            }
            this.updateTotalClocks();
            vsqTrack.sortEvent();
            return VsqCommand.generateCommandEventDeleteRange(n, vector);
        }
        if (vsqCommandType == VsqCommandType.EVENT_DELETE) {
            int n = (Integer)vsqCommand.Args[0];
            int n18 = (Integer)vsqCommand.Args[1];
            VsqEvent[] vsqEventArray = new VsqEvent[1];
            VsqTrack vsqTrack = this.Track.get(n);
            Object object = vsqTrack.getEventIterator();
            while (object.hasNext()) {
                VsqEvent vsqEvent = object.next();
                if (vsqEvent.InternalID != n18) continue;
                vsqEventArray[0] = (VsqEvent)vsqEvent.clone();
                break;
            }
            object = VsqCommand.generateCommandEventAddRange(n, vsqEventArray);
            int n19 = vsqTrack.getEventCount();
            for (int i = 0; i < n19; ++i) {
                if (vsqTrack.getEvent((int)i).InternalID != n18) continue;
                vsqTrack.removeEvent(i);
                break;
            }
            this.updateTotalClocks();
            return object;
        }
        if (vsqCommandType == VsqCommandType.EVENT_DELETE_RANGE) {
            Vector vector = (Vector)vsqCommand.Args[1];
            int n = (Integer)vsqCommand.Args[0];
            Vector<VsqEvent> vector2 = new Vector<VsqEvent>();
            int n20 = Integer.MAX_VALUE;
            int n21 = Integer.MIN_VALUE;
            VsqTrack vsqTrack = this.Track.get(n);
            int n22 = vector.size();
            block12: for (int i = 0; i < n22; ++i) {
                for (int j = 0; j < vsqTrack.getEventCount(); ++j) {
                    VsqEvent vsqEvent = vsqTrack.getEvent(j);
                    if ((Integer)vector.get(i) != vsqEvent.InternalID) continue;
                    vector2.add((VsqEvent)vsqEvent.clone());
                    n20 = Math.min(n20, vsqEvent.Clock);
                    n21 = Math.max(n21, vsqEvent.Clock + vsqEvent.ID.getLength());
                    vsqTrack.removeEvent(j);
                    continue block12;
                }
            }
            this.updateTotalClocks();
            return VsqCommand.generateCommandEventAddRange(n, vector2.toArray(new VsqEvent[0]));
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK) {
            int n = (Integer)vsqCommand.Args[0];
            int n23 = (Integer)vsqCommand.Args[1];
            int n24 = (Integer)vsqCommand.Args[2];
            VsqTrack vsqTrack = this.Track.get(n);
            Iterator<VsqEvent> iterator = vsqTrack.getEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (vsqEvent.InternalID != n23) continue;
                VsqCommand vsqCommand8 = VsqCommand.generateCommandEventChangeClock(n, n23, vsqEvent.Clock);
                int n25 = Math.min(vsqEvent.Clock, n24);
                int n26 = Math.max(vsqEvent.Clock + vsqEvent.ID.getLength(), n24 + vsqEvent.ID.getLength());
                vsqEvent.Clock = n24;
                this.updateTotalClocks();
                vsqTrack.sortEvent();
                return vsqCommand8;
            }
            return null;
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_LYRIC) {
            int n = (Integer)vsqCommand.Args[0];
            int n27 = (Integer)vsqCommand.Args[1];
            String string = (String)vsqCommand.Args[2];
            String string2 = (String)vsqCommand.Args[3];
            boolean bl = (Boolean)vsqCommand.Args[4];
            VsqTrack vsqTrack = this.Track.get(n);
            Iterator<VsqEvent> iterator = vsqTrack.getEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (vsqEvent.InternalID != n27 || vsqEvent.ID.type != VsqIDType.Anote) continue;
                VsqCommand vsqCommand9 = VsqCommand.generateCommandEventChangeLyric(n, n27, vsqEvent.ID.LyricHandle.L0.Phrase, vsqEvent.ID.LyricHandle.L0.getPhoneticSymbol(), vsqEvent.ID.LyricHandle.L0.PhoneticSymbolProtected);
                vsqEvent.ID.LyricHandle.L0.Phrase = string;
                vsqEvent.ID.LyricHandle.L0.setPhoneticSymbol(string2);
                vsqEvent.ID.LyricHandle.L0.PhoneticSymbolProtected = bl;
                this.updateTotalClocks();
                return vsqCommand9;
            }
            return null;
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_NOTE) {
            int n = (Integer)vsqCommand.Args[0];
            int n28 = (Integer)vsqCommand.Args[1];
            int n29 = (Integer)vsqCommand.Args[2];
            VsqTrack vsqTrack = this.Track.get(n);
            Iterator<VsqEvent> iterator = vsqTrack.getEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (vsqEvent.InternalID != n28) continue;
                VsqCommand vsqCommand10 = VsqCommand.generateCommandEventChangeNote(n, n28, vsqEvent.ID.Note);
                vsqEvent.ID.Note = n29;
                this.updateTotalClocks();
                return vsqCommand10;
            }
            return null;
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK_AND_NOTE) {
            int n = (Integer)vsqCommand.Args[0];
            int n30 = (Integer)vsqCommand.Args[1];
            int n31 = (Integer)vsqCommand.Args[2];
            int n32 = (Integer)vsqCommand.Args[3];
            VsqTrack vsqTrack = this.Track.get(n);
            Iterator<VsqEvent> iterator = vsqTrack.getEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (vsqEvent.InternalID != n30) continue;
                VsqCommand vsqCommand11 = VsqCommand.generateCommandEventChangeClockAndNote(n, n30, vsqEvent.Clock, vsqEvent.ID.Note);
                int n33 = Math.min(vsqEvent.Clock, n31);
                int n34 = Math.max(vsqEvent.Clock + vsqEvent.ID.getLength(), n31 + vsqEvent.ID.getLength());
                vsqEvent.Clock = n31;
                vsqEvent.ID.Note = n32;
                vsqTrack.sortEvent();
                this.updateTotalClocks();
                return vsqCommand11;
            }
            return null;
        }
        if (vsqCommandType == VsqCommandType.TRACK_CURVE_EDIT) {
            int n;
            int n35;
            int n36;
            int n37;
            int n38 = (Integer)vsqCommand.Args[0];
            String string = (String)vsqCommand.Args[1];
            Vector vector = (Vector)vsqCommand.Args[2];
            VsqCommand vsqCommand12 = null;
            Vector<BPPair> vector3 = new Vector<BPPair>();
            VsqBPList vsqBPList = this.Track.get(n38).getCurve(string);
            if (vector != null) {
                if (vector.size() > 0) {
                    int n39;
                    n37 = ((BPPair)vector.get((int)0)).Clock;
                    n36 = ((BPPair)vector.get((int)0)).Clock;
                    for (BPPair bPPair : vector) {
                        n37 = Math.min(n37, bPPair.Clock);
                        n36 = Math.max(n36, bPPair.Clock);
                    }
                    n35 = vsqBPList.getValue(n37);
                    int n40 = vsqBPList.getValue(n36);
                    Iterator<Integer> iterator = vsqBPList.keyClockIterator();
                    while (iterator.hasNext()) {
                        n39 = iterator.next();
                        if (n37 > n39 || n39 > n36) continue;
                        vector3.add(new BPPair(n39, vsqBPList.getValue(n39)));
                    }
                    n = 0;
                    n39 = 0;
                    int n41 = vector3.size();
                    for (int i = 0; i < n41; ++i) {
                        if (((BPPair)vector3.get((int)i)).Clock == n37) {
                            n = 1;
                            vector3.get((int)i).Value = n35;
                            if (n != 0 && n39 != 0) break;
                        }
                        if (((BPPair)vector3.get((int)i)).Clock != n36) continue;
                        n39 = 1;
                        vector3.get((int)i).Value = n40;
                        if (n != 0 && n39 != 0) break;
                    }
                    if (n == 0) {
                        vector3.add(new BPPair(n37, n35));
                    }
                    if (n39 == 0) {
                        vector3.add(new BPPair(n36, n40));
                    }
                    Collections.sort(vector3);
                    vsqCommand12 = VsqCommand.generateCommandTrackCurveEdit(n38, string, vector3);
                } else if (vector.size() == 0) {
                    vsqCommand12 = VsqCommand.generateCommandTrackCurveEdit(n38, string, new Vector<BPPair>());
                }
            }
            this.updateTotalClocks();
            if (vector.size() == 0) {
                return vsqCommand12;
            }
            if (vector.size() == 1) {
                n37 = 0;
                Iterator<Integer> iterator = vsqBPList.keyClockIterator();
                while (iterator.hasNext()) {
                    n35 = iterator.next();
                    if (n35 != ((BPPair)vector.get((int)0)).Clock) continue;
                    n37 = 1;
                    vsqBPList.add(n35, ((BPPair)vector.get((int)0)).Value);
                    break;
                }
                if (n37 == 0) {
                    vsqBPList.add(((BPPair)vector.get((int)0)).Clock, ((BPPair)vector.get((int)0)).Value);
                }
            } else {
                n37 = ((BPPair)vector.get((int)0)).Clock;
                n36 = ((BPPair)vector.get((int)(vector.size() - 1))).Clock;
                n35 = 1;
                block22: while (n35 != 0) {
                    n35 = 0;
                    Iterator<Integer> iterator = vsqBPList.keyClockIterator();
                    while (iterator.hasNext()) {
                        n = iterator.next();
                        if (n37 > n || n > n36) continue;
                        vsqBPList.remove(n);
                        n35 = 1;
                        continue block22;
                    }
                }
                for (BPPair bPPair : vector) {
                    vsqBPList.add(bPPair.Clock, bPPair.Value);
                }
            }
            return vsqCommand12;
        }
        if (vsqCommandType == VsqCommandType.TRACK_CURVE_EDIT2) {
            int n = (Integer)vsqCommand.Args[0];
            String string = (String)vsqCommand.Args[1];
            Vector vector = (Vector)vsqCommand.Args[2];
            TreeMap treeMap = (TreeMap)vsqCommand.Args[3];
            Vector<Long> vector4 = new Vector<Long>();
            TreeMap<Integer, VsqBPPair> treeMap2 = new TreeMap<Integer, VsqBPPair>();
            this.processTrackCurveEdit(n, string, vector, treeMap, vector4, treeMap2);
            this.updateTotalClocks();
            return VsqCommand.generateCommandTrackCurveEdit2(n, string, vector4, treeMap2);
        }
        if (vsqCommandType == VsqCommandType.TRACK_CURVE_EDIT2_ALL) {
            int n = (Integer)vsqCommand.Args[0];
            Vector vector = (Vector)vsqCommand.Args[1];
            Vector vector5 = (Vector)vsqCommand.Args[2];
            Vector vector6 = (Vector)vsqCommand.Args[3];
            int n42 = vector.size();
            Vector<Vector<Long>> vector7 = new Vector<Vector<Long>>();
            Vector<TreeMap<Integer, VsqBPPair>> vector8 = new Vector<TreeMap<Integer, VsqBPPair>>();
            for (int i = 0; i < n42; ++i) {
                Vector<Long> vector9 = new Vector<Long>();
                TreeMap<Integer, VsqBPPair> treeMap = new TreeMap<Integer, VsqBPPair>();
                this.processTrackCurveEdit(n, (String)vector.get(i), (Vector)vector5.get(i), (TreeMap)vector6.get(i), vector9, treeMap);
                vector7.add(vector9);
                vector8.add(treeMap);
            }
            this.updateTotalClocks();
            return VsqCommand.generateCommandTrackCurveEdit2All(n, vector, vector7, vector8);
        }
        if (vsqCommandType == VsqCommandType.TRACK_CURVE_REPLACE) {
            int n = (Integer)vsqCommand.Args[0];
            String string = (String)vsqCommand.Args[1];
            VsqBPList vsqBPList = (VsqBPList)vsqCommand.Args[2];
            VsqCommand vsqCommand13 = VsqCommand.generateCommandTrackCurveReplace(n, string, this.Track.get(n).getCurve(string));
            this.Track.get(n).setCurve(string, vsqBPList);
            return vsqCommand13;
        }
        if (vsqCommandType == VsqCommandType.TRACK_CURVE_REPLACE_RANGE) {
            int n = (Integer)vsqCommand.Args[0];
            String[] stringArray = (String[])vsqCommand.Args[1];
            VsqBPList[] vsqBPListArray = (VsqBPList[])vsqCommand.Args[2];
            VsqBPList[] vsqBPListArray2 = new VsqBPList[vsqBPListArray.length];
            VsqTrack vsqTrack = this.Track.get(n);
            for (int i = 0; i < stringArray.length; ++i) {
                vsqBPListArray2[i] = vsqTrack.getCurve(stringArray[i]);
            }
            VsqCommand vsqCommand14 = VsqCommand.generateCommandTrackCurveReplaceRange(n, stringArray, vsqBPListArray2);
            for (int i = 0; i < stringArray.length; ++i) {
                vsqTrack.setCurve(stringArray[i], vsqBPListArray[i]);
            }
            return vsqCommand14;
        }
        if (vsqCommandType == VsqCommandType.TRACK_CURVE_EDIT_RANGE) {
            int n = (Integer)vsqCommand.Args[0];
            Vector vector = (Vector)vsqCommand.Args[1];
            Vector vector10 = (Vector)vsqCommand.Args[2];
            Vector<Vector<BPPair>> vector11 = new Vector<Vector<BPPair>>();
            VsqCommand vsqCommand15 = null;
            int n43 = vector.size();
            for (int i = 0; i < n43; ++i) {
                int n44;
                int n45;
                String string = (String)vector.get(i);
                Vector vector12 = (Vector)vector10.get(i);
                Vector<BPPair> vector13 = new Vector<BPPair>();
                if (vector12 != null) {
                    if (vector12.size() > 0) {
                        int n46;
                        n45 = ((BPPair)vector12.get((int)0)).Clock;
                        int n47 = ((BPPair)vector12.get((int)0)).Clock;
                        for (BPPair bPPair : vector12) {
                            n45 = Math.min(n45, bPPair.Clock);
                            n47 = Math.max(n47, bPPair.Clock);
                        }
                        n44 = this.Track.get(n).getCurve(string).getValue(n45);
                        int n48 = this.Track.get(n).getCurve(string).getValue(n47);
                        Iterator<Integer> iterator = this.Track.get(n).getCurve(string).keyClockIterator();
                        while (iterator.hasNext()) {
                            n46 = iterator.next();
                            if (n45 > n46 || n46 > n47) continue;
                            vector13.add(new BPPair(n46, this.Track.get(n).getCurve(string).getValue(n46)));
                        }
                        boolean bl = false;
                        n46 = 0;
                        for (int j = 0; j < vector13.size(); ++j) {
                            if (((BPPair)vector13.get((int)j)).Clock == n45) {
                                bl = true;
                                ((BPPair)vector13.get((int)j)).Value = n44;
                                if (bl && n46 != 0) break;
                            }
                            if (((BPPair)vector13.get((int)j)).Clock != n47) continue;
                            n46 = 1;
                            ((BPPair)vector13.get((int)j)).Value = n48;
                            if (bl && n46 != 0) break;
                        }
                        if (!bl) {
                            vector13.add(new BPPair(n45, n44));
                        }
                        if (n46 == 0) {
                            vector13.add(new BPPair(n47, n48));
                        }
                        Collections.sort(vector13);
                        vector11.add(vector13);
                    } else if (vector12.size() == 0) {
                        vector11.add(new Vector());
                    }
                }
                this.updateTotalClocks();
                if (vector12.size() == 0) {
                    return vsqCommand15;
                }
                if (vector12.size() == 1) {
                    n45 = 0;
                    Iterator<Integer> iterator = this.Track.get(n).getCurve(string).keyClockIterator();
                    while (iterator.hasNext()) {
                        n44 = iterator.next();
                        if (n44 != ((BPPair)vector12.get((int)0)).Clock) continue;
                        n45 = 1;
                        this.Track.get(n).getCurve(string).add(n44, ((BPPair)vector12.get((int)0)).Value);
                        break;
                    }
                    if (n45 != 0) continue;
                    this.Track.get(n).getCurve(string).add(((BPPair)vector12.get((int)0)).Clock, ((BPPair)vector12.get((int)0)).Value);
                    continue;
                }
                n45 = ((BPPair)vector12.get((int)0)).Clock;
                int n49 = ((BPPair)vector12.get((int)(vector12.size() - 1))).Clock;
                n44 = 1;
                block33: while (n44 != 0) {
                    n44 = 0;
                    Iterator<Integer> iterator = this.Track.get(n).getCurve(string).keyClockIterator();
                    while (iterator.hasNext()) {
                        int n50 = iterator.next();
                        if (n45 > n50 || n50 > n49) continue;
                        this.Track.get(n).getCurve(string).remove(n50);
                        n44 = 1;
                        continue block33;
                    }
                }
                for (BPPair bPPair : vector12) {
                    this.Track.get(n).getCurve(string).add(bPPair.Clock, bPPair.Value);
                }
            }
            return VsqCommand.generateCommandTrackCurveEditRange(n, vector, vector11);
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_VELOCITY) {
            int n = (Integer)vsqCommand.Args[0];
            Vector vector = (Vector)vsqCommand.Args[1];
            Vector<ValuePair<Integer, Integer>> vector14 = new Vector<ValuePair<Integer, Integer>>();
            Iterator<VsqEvent> iterator = this.Track.get(n).getEventIterator();
            block36: while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                for (ValuePair valuePair : vector) {
                    if (vsqEvent.InternalID != (Integer)valuePair.getKey()) continue;
                    vector14.add(new ValuePair<Integer, Integer>(vsqEvent.InternalID, vsqEvent.ID.Dynamics));
                    vsqEvent.ID.Dynamics = (Integer)valuePair.getValue();
                    continue block36;
                }
            }
            return VsqCommand.generateCommandEventChangeVelocity(n, vector14);
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_ACCENT) {
            int n = (Integer)vsqCommand.Args[0];
            Vector vector = (Vector)vsqCommand.Args[1];
            Vector<ValuePair<Integer, Integer>> vector15 = new Vector<ValuePair<Integer, Integer>>();
            Iterator<VsqEvent> iterator = this.Track.get(n).getEventIterator();
            block38: while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                for (ValuePair valuePair : vector) {
                    if (vsqEvent.InternalID != (Integer)valuePair.getKey()) continue;
                    vector15.add(new ValuePair<Integer, Integer>(vsqEvent.InternalID, vsqEvent.ID.DEMaccent));
                    vsqEvent.ID.DEMaccent = (Integer)valuePair.getValue();
                    continue block38;
                }
            }
            return VsqCommand.generateCommandEventChangeAccent(n, vector15);
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_DECAY) {
            int n = (Integer)vsqCommand.Args[0];
            Vector vector = (Vector)vsqCommand.Args[1];
            Vector<ValuePair<Integer, Integer>> vector16 = new Vector<ValuePair<Integer, Integer>>();
            Iterator<VsqEvent> iterator = this.Track.get(n).getEventIterator();
            block40: while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                for (ValuePair valuePair : vector) {
                    if (vsqEvent.InternalID != (Integer)valuePair.getKey()) continue;
                    vector16.add(new ValuePair<Integer, Integer>(vsqEvent.InternalID, vsqEvent.ID.DEMdecGainRate));
                    vsqEvent.ID.DEMdecGainRate = (Integer)valuePair.getValue();
                    continue block40;
                }
            }
            return VsqCommand.generateCommandEventChangeDecay(n, vector16);
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_LENGTH) {
            int n = (Integer)vsqCommand.Args[0];
            int n51 = (Integer)vsqCommand.Args[1];
            int n52 = (Integer)vsqCommand.Args[2];
            Iterator<VsqEvent> iterator = this.Track.get(n).getEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (vsqEvent.InternalID != n51) continue;
                VsqCommand vsqCommand16 = VsqCommand.generateCommandEventChangeLength(n, n51, vsqEvent.ID.getLength());
                vsqEvent.ID.setLength(n52);
                this.updateTotalClocks();
                return vsqCommand16;
            }
            return null;
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK_AND_LENGTH) {
            int n = (Integer)vsqCommand.Args[0];
            int n53 = (Integer)vsqCommand.Args[1];
            int n54 = (Integer)vsqCommand.Args[2];
            int n55 = (Integer)vsqCommand.Args[3];
            Iterator<VsqEvent> iterator = this.Track.get(n).getEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (vsqEvent.InternalID != n53) continue;
                VsqCommand vsqCommand17 = VsqCommand.generateCommandEventChangeClockAndLength(n, n53, vsqEvent.Clock, vsqEvent.ID.getLength());
                int n56 = Math.min(vsqEvent.Clock, n54);
                int n57 = Math.max(vsqEvent.ID.getLength(), n55);
                int n58 = Math.max(vsqEvent.Clock + n57, n54 + n57);
                vsqEvent.ID.setLength(n55);
                vsqEvent.Clock = n54;
                this.Track.get(n).sortEvent();
                this.updateTotalClocks();
                return vsqCommand17;
            }
            return null;
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_ID_CONTAINTS) {
            int n = (Integer)vsqCommand.Args[0];
            int n59 = (Integer)vsqCommand.Args[1];
            VsqID vsqID = (VsqID)vsqCommand.Args[2];
            Iterator<VsqEvent> iterator = this.Track.get(n).getEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (vsqEvent.InternalID != n59) continue;
                VsqCommand vsqCommand18 = VsqCommand.generateCommandEventChangeIDContaints(n, n59, vsqEvent.ID);
                int n60 = Math.max(vsqEvent.ID.getLength(), vsqID.getLength());
                vsqEvent.ID = (VsqID)vsqID.clone();
                this.updateTotalClocks();
                return vsqCommand18;
            }
            return null;
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_ID_CONTAINTS_RANGE) {
            int n = (Integer)vsqCommand.Args[0];
            int[] nArray = (int[])vsqCommand.Args[1];
            VsqID[] vsqIDArray = (VsqID[])vsqCommand.Args[2];
            VsqID[] vsqIDArray2 = new VsqID[vsqIDArray.length];
            block45: for (int i = 0; i < nArray.length; ++i) {
                Iterator<VsqEvent> iterator = this.Track.get(n).getEventIterator();
                while (iterator.hasNext()) {
                    VsqEvent vsqEvent = iterator.next();
                    if (vsqEvent.InternalID != nArray[i]) continue;
                    vsqIDArray2[i] = (VsqID)vsqEvent.ID.clone();
                    int n61 = Math.max(vsqEvent.ID.getLength(), vsqIDArray[i].getLength());
                    vsqEvent.ID = (VsqID)vsqIDArray[i].clone();
                    continue block45;
                }
            }
            this.updateTotalClocks();
            return VsqCommand.generateCommandEventChangeIDContaintsRange(n, nArray, vsqIDArray2);
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK_AND_ID_CONTAINTS) {
            int n = (Integer)vsqCommand.Args[0];
            int n62 = (Integer)vsqCommand.Args[1];
            int n63 = (Integer)vsqCommand.Args[2];
            VsqID vsqID = (VsqID)vsqCommand.Args[3];
            VsqTrack vsqTrack = this.Track.get(n);
            Iterator<VsqEvent> iterator = vsqTrack.getEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (vsqEvent.InternalID != n62) continue;
                VsqCommand vsqCommand19 = VsqCommand.generateCommandEventChangeClockAndIDContaints(n, n62, vsqEvent.Clock, vsqEvent.ID);
                int n64 = Math.max(vsqEvent.ID.getLength(), vsqID.getLength());
                int n65 = Math.min(vsqEvent.Clock, n63);
                int n66 = Math.max(vsqEvent.Clock + n64, n63 + n64);
                vsqEvent.ID = (VsqID)vsqID.clone();
                vsqEvent.Clock = n63;
                vsqTrack.sortEvent();
                this.updateTotalClocks();
                return vsqCommand19;
            }
            return null;
        }
        if (vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK_AND_ID_CONTAINTS_RANGE) {
            int n = (Integer)vsqCommand.Args[0];
            int[] nArray = (int[])vsqCommand.Args[1];
            int[] nArray10 = (int[])vsqCommand.Args[2];
            VsqID[] vsqIDArray = (VsqID[])vsqCommand.Args[3];
            Vector<VsqID> vector = new Vector<VsqID>();
            Vector<Integer> vector17 = new Vector<Integer>();
            block48: for (int i = 0; i < nArray.length; ++i) {
                Iterator<VsqEvent> iterator = this.Track.get(n).getEventIterator();
                while (iterator.hasNext()) {
                    VsqEvent vsqEvent = iterator.next();
                    if (vsqEvent.InternalID != nArray[i]) continue;
                    vector.add((VsqID)vsqEvent.ID.clone());
                    vector17.add(vsqEvent.Clock);
                    int n67 = Math.max(vsqEvent.ID.getLength(), vsqIDArray[i].getLength());
                    int n68 = Math.min(vsqEvent.Clock, nArray10[i]);
                    int n69 = Math.max(vsqEvent.Clock + n67, nArray10[i] + n67);
                    vsqEvent.ID = (VsqID)vsqIDArray[i].clone();
                    vsqEvent.Clock = nArray10[i];
                    continue block48;
                }
            }
            this.Track.get(n).sortEvent();
            this.updateTotalClocks();
            return VsqCommand.generateCommandEventChangeClockAndIDContaintsRange(n, nArray, PortUtil.convertIntArray(vector17.toArray(new Integer[0])), vector.toArray(new VsqID[0]));
        }
        if (vsqCommandType == VsqCommandType.TRACK_CHANGE_NAME) {
            int n = (Integer)vsqCommand.Args[0];
            String string = (String)vsqCommand.Args[1];
            VsqCommand vsqCommand20 = VsqCommand.generateCommandTrackChangeName(n, this.Track.get(n).getName());
            this.Track.get(n).setName(string);
            return vsqCommand20;
        }
        if (vsqCommandType == VsqCommandType.TRACK_REPLACE) {
            int n = (Integer)vsqCommand.Args[0];
            VsqTrack vsqTrack = (VsqTrack)vsqCommand.Args[1];
            VsqCommand vsqCommand21 = VsqCommand.generateCommandTrackReplace(n, this.Track.get(n));
            this.Track.set(n, vsqTrack);
            this.updateTotalClocks();
            return vsqCommand21;
        }
        if (vsqCommandType == VsqCommandType.TRACK_CHANGE_PLAY_MODE) {
            int n = (Integer)vsqCommand.Args[0];
            int n70 = (Integer)vsqCommand.Args[1];
            int n71 = (Integer)vsqCommand.Args[2];
            VsqTrack vsqTrack = this.Track.get(n);
            VsqCommand vsqCommand22 = VsqCommand.generateCommandTrackChangePlayMode(n, vsqTrack.getCommon().PlayMode, vsqTrack.getCommon().LastPlayMode);
            vsqTrack.getCommon().PlayMode = n70;
            vsqTrack.getCommon().LastPlayMode = n71;
            return vsqCommand22;
        }
        if (vsqCommandType == VsqCommandType.EVENT_REPLACE) {
            int n = (Integer)vsqCommand.Args[0];
            VsqEvent vsqEvent = (VsqEvent)vsqCommand.Args[1];
            VsqCommand vsqCommand23 = null;
            for (int i = 0; i < this.Track.get(n).getEventCount(); ++i) {
                VsqEvent vsqEvent2 = this.Track.get(n).getEvent(i);
                if (vsqEvent2.InternalID != vsqEvent.InternalID) continue;
                vsqCommand23 = VsqCommand.generateCommandEventReplace(n, vsqEvent2);
                this.Track.get(n).setEvent(i, vsqEvent);
                break;
            }
            this.Track.get(n).sortEvent();
            this.updateTotalClocks();
            return vsqCommand23;
        }
        if (vsqCommandType == VsqCommandType.EVENT_REPLACE_RANGE) {
            int n = (Integer)vsqCommand.Args[0];
            VsqEvent[] vsqEventArray = (VsqEvent[])vsqCommand.Args[1];
            VsqCommand vsqCommand24 = null;
            VsqEvent[] vsqEventArray2 = new VsqEvent[vsqEventArray.length];
            block51: for (int i = 0; i < vsqEventArray.length; ++i) {
                VsqEvent vsqEvent = vsqEventArray[i];
                for (int j = 0; j < this.Track.get(n).getEventCount(); ++j) {
                    VsqEvent vsqEvent3 = this.Track.get(n).getEvent(j);
                    if (vsqEvent3.InternalID != vsqEvent.InternalID) continue;
                    vsqEventArray2[i] = (VsqEvent)vsqEvent3.clone();
                    this.Track.get(n).setEvent(j, vsqEventArray[i]);
                    continue block51;
                }
            }
            this.Track.get(n).sortEvent();
            this.updateTotalClocks();
            vsqCommand24 = VsqCommand.generateCommandEventReplaceRange(n, vsqEventArray2);
            return vsqCommand24;
        }
        return null;
    }

    private void processTrackCurveEdit(int n, String string, Vector<Long> vector, TreeMap<Integer, VsqBPPair> treeMap, Vector<Long> vector2, TreeMap<Integer, VsqBPPair> treeMap2) {
        VsqBPList vsqBPList = this.Track.get(n).getCurve(string);
        vector2.clear();
        treeMap2.clear();
        Iterator<Number> iterator = vector.iterator();
        while (iterator.hasNext()) {
            long l = iterator.next();
            VsqBPPairSearchContext vsqBPPairSearchContext = vsqBPList.findElement(l);
            if (vsqBPPairSearchContext.index < 0) continue;
            int n2 = vsqBPPairSearchContext.clock;
            vsqBPList.removeElementAt(vsqBPPairSearchContext.index);
            treeMap2.put(n2, new VsqBPPair(vsqBPPairSearchContext.point.value, vsqBPPairSearchContext.point.id));
        }
        iterator = treeMap.keySet().iterator();
        while (iterator.hasNext()) {
            int n3 = (Integer)iterator.next();
            VsqBPPair vsqBPPair = treeMap.get(n3);
            vsqBPList.addWithID(n3, vsqBPPair.value, vsqBPPair.id);
            vector2.add(vsqBPPair.id);
        }
    }

    public void removePart(int n, int n2) {
        int n3;
        int n4 = n2 - n;
        int n5 = this.getTempoAt(n2);
        boolean bl = true;
        int n6 = 0;
        while (n6 < this.TempoTable.size()) {
            TempoTableEntry tempoTableEntry = (TempoTableEntry)this.TempoTable.get(n6);
            if (n <= tempoTableEntry.Clock && tempoTableEntry.Clock < n2) {
                this.TempoTable.removeElementAt(n6);
                continue;
            }
            if (n2 < tempoTableEntry.Clock) {
                tempoTableEntry.Clock -= n4;
            }
            ++n6;
        }
        n6 = this.TempoTable.size();
        boolean bl2 = false;
        for (n3 = 0; n3 < n6; ++n3) {
            TempoTableEntry tempoTableEntry = (TempoTableEntry)this.TempoTable.get(n3);
            if (tempoTableEntry.Clock != n) continue;
            tempoTableEntry.Tempo = n5;
            bl2 = true;
            break;
        }
        if (!bl2) {
            this.TempoTable.add(new TempoTableEntry(n, n5, 0.0));
        }
        this.updateTempoInfo();
        n3 = this.Track.size();
        for (int i = 1; i < n3; ++i) {
            Object object;
            int n7;
            VsqTrack vsqTrack = this.Track.get(i);
            VsqEvent vsqEvent = null;
            Object object2 = vsqTrack.getSingerEventIterator();
            while (object2.hasNext()) {
                VsqEvent vsqEvent2 = object2.next();
                if (n <= vsqEvent2.Clock && vsqEvent2.Clock < n2) {
                    vsqEvent = vsqEvent2;
                }
                if (vsqEvent2.Clock != n2) continue;
                vsqEvent = null;
            }
            object2 = null;
            if (vsqEvent != null) {
                object2 = (VsqEvent)vsqEvent.clone();
                ((VsqEvent)object2).Clock = n2;
            }
            bl = true;
            block4: while (bl) {
                bl = false;
                int n8 = vsqTrack.getEventCount();
                for (n7 = 0; n7 < n8; ++n7) {
                    object = vsqTrack.getEvent(n7);
                    if (n > ((VsqEvent)object).Clock || ((VsqEvent)object).Clock >= n2) continue;
                    vsqTrack.removeEvent(n7);
                    bl = true;
                    continue block4;
                }
            }
            if (object2 != null) {
                vsqTrack.addEvent((VsqEvent)object2);
            }
            int n9 = vsqTrack.getEventCount();
            for (n7 = 0; n7 < n9; ++n7) {
                object = vsqTrack.getEvent(n7);
                if (n2 > ((VsqEvent)object).Clock) continue;
                ((VsqEvent)object).Clock -= n4;
            }
            for (n7 = 0; n7 < _CURVES.length; ++n7) {
                object = _CURVES[n7];
                VsqBPList vsqBPList = vsqTrack.getCurve((String)object);
                if (vsqBPList == null) continue;
                VsqBPList vsqBPList2 = (VsqBPList)vsqBPList.clone();
                vsqBPList.clear();
                int n10 = vsqBPList2.getValue(n2);
                boolean bl3 = false;
                Iterator<Integer> iterator = vsqBPList2.keyClockIterator();
                while (iterator.hasNext()) {
                    int n11 = iterator.next();
                    if (n11 < n) {
                        vsqBPList.add(n11, vsqBPList2.getValue(n11));
                        continue;
                    }
                    if (n2 > n11) continue;
                    if (n11 == n2) {
                        bl3 = true;
                    }
                    vsqBPList.add(n11 - n4, vsqBPList2.getValue(n11));
                }
                if (bl3) continue;
                vsqBPList.add(n2 - n4, n10);
            }
        }
    }

    public static void shift(VsqFile vsqFile, int n) {
        int n2;
        if (n == 0) {
            return;
        }
        int n3 = n;
        for (n2 = 0; n2 < vsqFile.TempoTable.size(); ++n2) {
            if (((TempoTableEntry)vsqFile.TempoTable.get((int)n2)).Clock <= 0) continue;
            ((TempoTableEntry)vsqFile.TempoTable.get((int)n2)).Clock += n3;
        }
        vsqFile.updateTempoInfo();
        n2 = vsqFile.Track.size();
        for (int i = 1; i < n2; ++i) {
            Object object;
            int n4;
            VsqTrack vsqTrack = vsqFile.Track.get(i);
            int n5 = vsqTrack.getEventCount();
            for (n4 = 0; n4 < n5; ++n4) {
                object = vsqTrack.getEvent(n4);
                if (((VsqEvent)object).Clock <= 0) continue;
                ((VsqEvent)object).Clock += n3;
            }
            for (n4 = 0; n4 < _CURVES.length; ++n4) {
                object = _CURVES[n4];
                VsqBPList vsqBPList = vsqTrack.getCurve((String)object);
                if (vsqBPList == null) continue;
                VsqBPList vsqBPList2 = new VsqBPList(vsqBPList.getName(), vsqBPList.getDefault(), vsqBPList.getMinimum(), vsqBPList.getMaximum());
                Iterator<Integer> iterator = vsqBPList.keyClockIterator();
                while (iterator.hasNext()) {
                    int n6 = iterator.next();
                    vsqBPList2.add(n6 + n3, vsqBPList.getValue(n6));
                }
                vsqTrack.setCurve((String)object, vsqBPList2);
            }
        }
        vsqFile.updateTotalClocks();
    }

    public Object clone() {
        int n;
        VsqFile vsqFile = new VsqFile();
        vsqFile.Track = new Vector();
        for (n = 0; n < this.Track.size(); ++n) {
            vsqFile.Track.add((VsqTrack)this.Track.get(n).clone());
        }
        vsqFile.TempoTable = new TempoVector();
        for (n = 0; n < this.TempoTable.size(); ++n) {
            vsqFile.TempoTable.add((TempoTableEntry)((TempoTableEntry)this.TempoTable.get(n)).clone());
        }
        vsqFile.TimesigTable = new Vector();
        for (n = 0; n < this.TimesigTable.size(); ++n) {
            vsqFile.TimesigTable.add((TimeSigTableEntry)this.TimesigTable.get(n).clone());
        }
        vsqFile.TotalClocks = this.TotalClocks;
        vsqFile.Master = (VsqMaster)this.Master.clone();
        vsqFile.Mixer = (VsqMixer)this.Mixer.clone();
        return vsqFile;
    }

    private VsqFile() {
    }

    public Iterator<VsqBarLineType> getBarLineIterator(int n) {
        return new BarLineIterator(this.TimesigTable, n);
    }

    public int getBaseTempo() {
        return 500000;
    }

    public int getPreMeasure() {
        return this.Master.PreMeasure;
    }

    public int getPreMeasureClocks() {
        return this.calculatePreMeasureInClock();
    }

    private int calculatePreMeasureInClock() {
        int n;
        int n2 = this.Master.PreMeasure;
        int n3 = this.TimesigTable.get((int)0).BarCount;
        int n4 = this.TimesigTable.get((int)0).Clock;
        int n5 = this.TimesigTable.get((int)0).Denominator;
        int n6 = this.TimesigTable.get((int)0).Numerator;
        for (n = 1; n < this.TimesigTable.size() && this.TimesigTable.get((int)n).BarCount < n2; ++n) {
            n3 = this.TimesigTable.get((int)n).BarCount;
            n4 = this.TimesigTable.get((int)n).Clock;
            n5 = this.TimesigTable.get((int)n).Denominator;
            n6 = this.TimesigTable.get((int)n).Numerator;
        }
        n = n2 - n3;
        return n4 + n * n6 * 480 * 4 / n5;
    }

    public double getSecFromClock(double d) {
        return this.TempoTable.getSecFromClock(d);
    }

    public double getClockFromSec(double d) {
        return this.TempoTable.getClockFromSec(d);
    }

    public Timesig getTimesigAt(int n) {
        Timesig timesig = new Timesig();
        timesig.numerator = 4;
        timesig.denominator = 4;
        int n2 = 0;
        int n3 = this.TimesigTable.size();
        for (int i = n3 - 1; i >= 0; --i) {
            n2 = i;
            if (this.TimesigTable.get((int)i).Clock <= n) break;
        }
        timesig.numerator = this.TimesigTable.get((int)n2).Numerator;
        timesig.denominator = this.TimesigTable.get((int)n2).Denominator;
        return timesig;
    }

    public Timesig getTimesigAt(int n, ByRef<Integer> byRef) {
        int n2 = 0;
        int n3 = this.TimesigTable.size();
        for (int i = n3 - 1; i >= 0; --i) {
            n2 = i;
            if (this.TimesigTable.get((int)i).Clock <= n) break;
        }
        TimeSigTableEntry timeSigTableEntry = this.TimesigTable.get(n2);
        Timesig timesig = new Timesig();
        timesig.numerator = timeSigTableEntry.Numerator;
        timesig.denominator = timeSigTableEntry.Denominator;
        int n4 = n - timeSigTableEntry.Clock;
        int n5 = 1920 / timesig.denominator * timesig.numerator;
        byRef.value = timeSigTableEntry.BarCount + n4 / n5;
        return timesig;
    }

    public int getTempoAt(int n) {
        int n2 = 0;
        int n3 = this.TempoTable.size();
        for (int i = n3 - 1; i >= 0; --i) {
            n2 = i;
            if (((TempoTableEntry)this.TempoTable.get((int)i)).Clock <= n) break;
        }
        return ((TempoTableEntry)this.TempoTable.get((int)n2)).Tempo;
    }

    public int getClockFromBarCount(int n) {
        int n2 = 0;
        int n3 = this.TimesigTable.size();
        for (int i = n3 - 1; i >= 0; --i) {
            n2 = i;
            if (this.TimesigTable.get((int)i).BarCount <= n) break;
        }
        TimeSigTableEntry timeSigTableEntry = this.TimesigTable.get(n2);
        int n4 = timeSigTableEntry.Numerator;
        int n5 = timeSigTableEntry.Denominator;
        int n6 = timeSigTableEntry.Clock;
        int n7 = timeSigTableEntry.BarCount;
        int n8 = n4 * 480 * 4 / n5;
        return n6 + (n - n7) * n8;
    }

    public int getBarCountFromClock(int n) {
        int n2;
        int n3 = 0;
        int n4 = this.TimesigTable.size();
        for (n2 = n4 - 1; n2 >= 0; --n2) {
            n3 = n2;
            if (this.TimesigTable.get((int)n2).Clock <= n) break;
        }
        n2 = 0;
        if (n3 >= 0) {
            int n5 = this.TimesigTable.get((int)n3).Clock;
            int n6 = this.TimesigTable.get((int)n3).BarCount;
            int n7 = this.TimesigTable.get((int)n3).Numerator;
            int n8 = this.TimesigTable.get((int)n3).Denominator;
            int n9 = n7 * 480 * 4 / n8;
            n2 = n6 + (n - n5) / n9;
        }
        return n2;
    }

    public int getTickPerQuarter() {
        return 480;
    }

    public VsqFile(String string, int n, int n2, int n3, int n4) {
        this.TotalClocks = n * 480 * 4 / n3 * n2;
        this.Track = new Vector();
        this.Track.add(new VsqTrack(n4, n2, n3));
        this.Track.add(new VsqTrack("Voice1", string));
        this.Master = new VsqMaster(n);
        this.Mixer = new VsqMixer(0, 0, 0, 0);
        this.Mixer.Slave.add(new VsqMixerEntry(0, 0, 0, 0));
        this.TimesigTable = new Vector();
        this.TimesigTable.add(new TimeSigTableEntry(0, n2, n3, 0));
        this.TempoTable = new TempoVector();
        this.TempoTable.add(new TempoTableEntry(0, n4, 0.0));
    }

    public VsqFile(String string, String string2) throws FileNotFoundException {
        int n;
        int n2;
        this.TempoTable = new TempoVector();
        this.TimesigTable = new Vector();
        MidiFile midiFile = new MidiFile(string);
        this.Track = new Vector();
        int n3 = midiFile.getTrackCount();
        for (int i = 0; i < n3; ++i) {
            this.Track.add(new VsqTrack(midiFile.getMidiEventList(i), string2));
        }
        VsqMaster vsqMaster = this.Track.get(1).getMaster();
        this.Master = vsqMaster == null ? new VsqMaster(4) : (VsqMaster)vsqMaster.clone();
        VsqMixer vsqMixer = this.Track.get(1).getMixer();
        if (vsqMixer == null) {
            this.Mixer = new VsqMixer(0, 0, 0, 0);
            this.Mixer.Slave = new Vector();
            for (n2 = 1; n2 < this.Track.size(); ++n2) {
                this.Mixer.Slave.add(new VsqMixerEntry());
            }
        } else {
            this.Mixer = (VsqMixer)vsqMixer.clone();
        }
        this.Track.get(1).setMaster(null);
        this.Track.get(1).setMixer(null);
        n2 = -1;
        for (n = 0; n < this.Track.size(); ++n) {
            if (!this.Track.get(n).getName().equals("Master Track")) continue;
            n2 = n;
            break;
        }
        if (n2 >= 0) {
            byte by;
            int n4;
            int n5;
            Vector<MidiEvent> vector = midiFile.getMidiEventList(n2);
            n = 500000;
            byte by2 = 0;
            double d = 0.0;
            int n6 = -1;
            int n7 = vector.size();
            for (n5 = 0; n5 < n7; ++n5) {
                MidiEvent midiEvent = vector.get(n5);
                if (midiEvent.firstByte != -1 || midiEvent.data.length < 4 || midiEvent.data[0] != 81) continue;
                if (++n6 == 0 && midiEvent.clock != 0L) {
                    this.TempoTable.add(new TempoTableEntry(0, 500000, 0.0));
                    n = 500000;
                }
                n4 = midiEvent.data[1] << 16 | midiEvent.data[2] << 8 | midiEvent.data[3];
                by = (byte)vector.get((int)n5).clock;
                double d2 = d + (double)n * (double)(by - by2) / 4.8E8;
                this.TempoTable.add(new TempoTableEntry(by, n4, d2));
                n = n4;
                by2 = by;
                d = d2;
            }
            Collections.sort(this.TempoTable);
            n5 = 4;
            int n8 = 4;
            n6 = -1;
            for (n4 = 0; n4 < vector.size(); ++n4) {
                int n9;
                int n10;
                int n11;
                if (vector.get((int)n4).firstByte != -1 || vector.get((int)n4).data.length < 5 || vector.get((int)n4).data[0] != 88) continue;
                ++n6;
                n8 = vector.get((int)n4).data[1];
                n5 = 1;
                for (by = 0; by < vector.get((int)n4).data[2]; ++by) {
                    n5 *= 2;
                }
                if (n6 == 0) {
                    by = 4;
                    n11 = 4;
                    n10 = 0;
                    n9 = 0;
                    if (vector.get((int)n4).clock == 0L) {
                        this.TimesigTable.add(new TimeSigTableEntry(0, n8, n5, 0));
                        continue;
                    }
                    this.TimesigTable.add(new TimeSigTableEntry(0, 4, 4, 0));
                    this.TimesigTable.add(new TimeSigTableEntry(0, n8, n5, (int)vector.get((int)n4).clock / 1920));
                    ++n6;
                    continue;
                }
                by = this.TimesigTable.get((int)(n6 - 1)).Numerator;
                n11 = this.TimesigTable.get((int)(n6 - 1)).Denominator;
                n10 = this.TimesigTable.get((int)(n6 - 1)).Clock;
                n9 = this.TimesigTable.get((int)(n6 - 1)).BarCount;
                int n12 = 1920 / n11 * by;
                this.TimesigTable.add(new TimeSigTableEntry((int)vector.get((int)n4).clock, n8, n5, n9 += ((int)vector.get((int)n4).clock - n10) / n12));
            }
        }
        this.TempoTable.updateTempoInfo();
        this.updateTimesigInfo();
        this.updateTotalClocks();
    }

    public void updateTimesigInfo() {
        if (this.TimesigTable.get((int)0).Clock != 0) {
            return;
        }
        this.TimesigTable.get((int)0).Clock = 0;
        Collections.sort(this.TimesigTable);
        int n = this.TimesigTable.size();
        for (int i = 1; i < n; ++i) {
            TimeSigTableEntry timeSigTableEntry = this.TimesigTable.get(i - 1);
            int n2 = timeSigTableEntry.Numerator;
            int n3 = timeSigTableEntry.Denominator;
            int n4 = timeSigTableEntry.Clock;
            int n5 = timeSigTableEntry.BarCount;
            int n6 = 1920 / n3 * n2;
            this.TimesigTable.get((int)i).Clock = n4 += (this.TimesigTable.get((int)i).BarCount - n5) * n6;
        }
    }

    public void updateTempoInfo() {
        this.TempoTable.updateTempoInfo();
    }

    public void updateTotalClocks() {
        int n = this.getPreMeasureClocks();
        for (int i = 1; i < this.Track.size(); ++i) {
            VsqTrack vsqTrack = this.Track.get(i);
            int n2 = vsqTrack.getEventCount();
            if (n2 > 0) {
                VsqEvent vsqEvent = vsqTrack.getEvent(n2 - 1);
                n = Math.max(n, vsqEvent.Clock + vsqEvent.ID.getLength());
            }
            for (int j = 0; j < _CURVES.length; ++j) {
                int n3;
                String string = _CURVES[j];
                VsqBPList vsqBPList = vsqTrack.getCurve(string);
                if (vsqBPList == null || (n3 = vsqBPList.size()) <= 0) continue;
                int n4 = vsqBPList.getKeyClock(n3 - 1);
                n = Math.max(n, n4);
            }
        }
        this.TotalClocks = n;
    }

    public double getTotalSec() {
        return this.getSecFromClock(this.TotalClocks);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printLyricTable(int n, String string) {
        BufferedWriter bufferedWriter = null;
        try {
            bufferedWriter = new BufferedWriter(new FileWriter(string));
            for (int i = 0; i < this.Track.get(n).getEventCount(); ++i) {
                int n2;
                int n3 = this.Track.get((int)n).getEvent((int)i).Clock;
                if (this.Track.get((int)n).getEvent((int)i).ID.type != VsqIDType.Anote) continue;
                int n4 = this.Track.get((int)n).getEvent((int)i).ID.getLength();
                int n5 = this.TempoTable.size() - 1;
                int n6 = ((TempoTableEntry)this.TempoTable.get((int)n5)).Tempo;
                int n7 = ((TempoTableEntry)this.TempoTable.get((int)n5)).Clock;
                double d = ((TempoTableEntry)this.TempoTable.get((int)n5)).Time;
                for (n2 = 1; n2 < this.TempoTable.size(); ++n2) {
                    if (((TempoTableEntry)this.TempoTable.get((int)n2)).Clock <= n3) continue;
                    n6 = ((TempoTableEntry)this.TempoTable.get((int)(n2 - 1))).Tempo;
                    n7 = ((TempoTableEntry)this.TempoTable.get((int)(n2 - 1))).Clock;
                    d = ((TempoTableEntry)this.TempoTable.get((int)(n2 - 1))).Time;
                    break;
                }
                n2 = this.Track.get((int)n).getEvent((int)i).Clock;
                double d2 = d + (double)(n2 - n7) * (double)n6 / 4.8E8;
                double d3 = d2 + (double)n4 * (double)n6 / 4.8E8;
                bufferedWriter.write(this.Track.get((int)n).getEvent((int)i).Clock + "," + PortUtil.formatDecimal("0.000000", d2) + "," + PortUtil.formatDecimal("0.000000", d3) + "," + this.Track.get((int)n).getEvent((int)i).ID.LyricHandle.L0.Phrase + "," + this.Track.get((int)n).getEvent((int)i).ID.LyricHandle.L0.getPhoneticSymbol());
                bufferedWriter.newLine();
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (bufferedWriter != null) {
                try {
                    bufferedWriter.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Vector<MidiEvent> generateMetaTextEvent(int n, String string) {
        String string2 = "\n";
        Vector<MidiEvent> vector = new Vector<MidiEvent>();
        TextStream textStream = null;
        try {
            textStream = new TextStream();
            this.Track.get(n).printMetaText(textStream, this.TotalClocks + 120, this.calculatePreMeasureInClock());
            textStream.setPointer(-1);
            int n2 = -1;
            String string3 = "";
            if (textStream.ready()) {
                int n3;
                Object object;
                Object[] objectArray;
                Vector<Byte> vector2 = new Vector<Byte>();
                boolean bl = true;
                while (textStream.ready()) {
                    if (bl) {
                        string3 = textStream.readLine();
                        bl = false;
                    } else {
                        string3 = string2 + textStream.readLine();
                    }
                    objectArray = PortUtil.convertByteArray(PortUtil.getEncodedByte(string, string3));
                    vector2.addAll(Arrays.asList(objectArray));
                    while (VsqFile.getLinePrefixBytes(n2 + 1).length + vector2.size() >= 127) {
                        int n4;
                        object = VsqFile.getLinePrefixBytes(++n2);
                        MidiEvent midiEvent = new MidiEvent();
                        midiEvent.clock = 0L;
                        midiEvent.firstByte = (byte)-1;
                        midiEvent.data = new byte[128];
                        midiEvent.data[0] = 1;
                        n3 = 127;
                        for (n4 = 0; n4 < ((Object)object).length; ++n4) {
                            midiEvent.data[n4 + 1] = (byte)object[n4];
                        }
                        for (n4 = ((Object)object).length; n4 < n3; ++n4) {
                            byte by;
                            midiEvent.data[n4 + 1] = by = ((Byte)vector2.get(0)).byteValue();
                            vector2.removeElementAt(0);
                        }
                        vector.add(midiEvent);
                    }
                }
                if (vector2.size() > 0) {
                    while (VsqFile.getLinePrefixBytes(n2 + 1).length + vector2.size() >= 127) {
                        objectArray = VsqFile.getLinePrefixBytes(++n2);
                        object = new MidiEvent();
                        ((MidiEvent)object).clock = 0L;
                        ((MidiEvent)object).firstByte = (byte)-1;
                        ((MidiEvent)object).data = new byte[128];
                        ((MidiEvent)object).data[0] = 1;
                        int n5 = 127;
                        for (n3 = 0; n3 < objectArray.length; ++n3) {
                            ((MidiEvent)object).data[n3 + 1] = objectArray[n3];
                        }
                        for (n3 = objectArray.length; n3 < n5; ++n3) {
                            ((MidiEvent)object).data[n3 + 1] = (Byte)vector2.get(0);
                            vector2.removeElementAt(0);
                        }
                        vector.add((MidiEvent)object);
                    }
                    if (vector2.size() > 0) {
                        objectArray = VsqFile.getLinePrefixBytes(++n2);
                        object = new MidiEvent();
                        ((MidiEvent)object).clock = 0L;
                        ((MidiEvent)object).firstByte = (byte)-1;
                        int n6 = objectArray.length + vector2.size();
                        ((MidiEvent)object).data = new byte[n6 + 1];
                        ((MidiEvent)object).data[0] = 1;
                        for (n3 = 0; n3 < objectArray.length; ++n3) {
                            ((MidiEvent)object).data[n3 + 1] = objectArray[n3];
                        }
                        for (n3 = objectArray.length; n3 < n6; ++n3) {
                            ((MidiEvent)object).data[n3 + 1] = (Byte)vector2.get(0);
                            vector2.removeElementAt(0);
                        }
                        vector.add((MidiEvent)object);
                    }
                }
            }
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VsqFile#generateMetaTextEvent; ex=" + exception);
        }
        finally {
            if (textStream != null) {
                try {
                    textStream.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("VsqFile#generateMetaTextEvent; ex2=" + exception);
                }
            }
        }
        return vector;
    }

    private static String substring127Bytes(String string, String string2) {
        int n;
        int n2 = Math.min(127, PortUtil.getStringLength(string));
        int n3 = PortUtil.getEncodedByteCount(string2, string.substring(0, n2));
        if (n3 == 127) {
            return string.substring(0, n2);
        }
        int n4 = n = n3 > 127 ? -1 : 1;
        while ((n == -1 && n3 > 127 || n == 1 && n3 < 127) && (n != -1 || (n2 += n) != 0) && (n != 1 || n2 != PortUtil.getStringLength(string))) {
            n3 = PortUtil.getEncodedByteCount(string2, string.substring(0, n2));
        }
        return string.substring(0, n2);
    }

    private static void printTrack(VsqFile vsqFile, int n, RandomAccessFile randomAccessFile, int n2, String string) throws IOException {
        int n3;
        String string2 = "\n";
        randomAccessFile.write(_MTRK, 0, 4);
        randomAccessFile.write(new byte[]{0, 0, 0, 0}, 0, 4);
        long l = randomAccessFile.getFilePointer();
        VsqFile.writeFlexibleLengthUnsignedLong(randomAccessFile, 0L);
        randomAccessFile.write(-1);
        randomAccessFile.write(3);
        byte[] byArray = PortUtil.getEncodedByte(string, vsqFile.Track.get(n).getName());
        VsqFile.writeFlexibleLengthUnsignedLong(randomAccessFile, byArray.length);
        randomAccessFile.write(byArray, 0, byArray.length);
        Vector<MidiEvent> vector = vsqFile.generateMetaTextEvent(n, string);
        long l2 = 0L;
        for (n3 = 0; n3 < vector.size(); ++n3) {
            VsqFile.writeFlexibleLengthUnsignedLong(randomAccessFile, vector.get((int)n3).clock - l2);
            vector.get(n3).writeData(randomAccessFile);
            l2 = vector.get((int)n3).clock;
        }
        n3 = 0;
        VsqNrpn[] vsqNrpnArray = VsqFile.generateNRPN(vsqFile, n, n2);
        NrpnData[] nrpnDataArray = VsqNrpn.convert(vsqNrpnArray);
        for (int i = 0; i < nrpnDataArray.length; ++i) {
            VsqFile.writeFlexibleLengthUnsignedLong(randomAccessFile, nrpnDataArray[i].getClock() - n3);
            randomAccessFile.write(-80);
            randomAccessFile.write(nrpnDataArray[i].getParameter());
            randomAccessFile.write(nrpnDataArray[i].Value);
            n3 = nrpnDataArray[i].getClock();
        }
        VsqEvent vsqEvent = vsqFile.Track.get(n).getEvent(vsqFile.Track.get(n).getEventCount() - 1);
        int n4 = vsqEvent.Clock + vsqEvent.ID.getLength();
        VsqFile.writeFlexibleLengthUnsignedLong(randomAccessFile, n4);
        randomAccessFile.write(-1);
        randomAccessFile.write(47);
        randomAccessFile.write(0);
        long l3 = randomAccessFile.getFilePointer();
        randomAccessFile.seek(l - 4L);
        VsqFile.writeUnsignedInt(randomAccessFile, l3 - l);
        randomAccessFile.seek(l3);
    }

    public int getPresendClockAt(int n, int n2) {
        double d = this.getSecFromClock(n) * 1000.0;
        float f = (float)(d - (double)n2) / 1000.0f;
        int n3 = (int)Math.floor(this.getClockFromSec(f));
        return n - n3;
    }

    public int getMaximumNoteLengthAt(int n) {
        double d = this.getSecFromClock(n);
        double d2 = d + 16.383;
        int n2 = (int)this.getClockFromSec(d2) - 1;
        d2 = this.getSecFromClock(n2);
        while ((int)(d2 * 1000.0) - (int)(d * 1000.0) <= 16383) {
            d2 = this.getSecFromClock(++n2);
        }
        return --n2 - n;
    }

    public static VsqNrpn[] generateExpressionNRPN(VsqFile vsqFile, int n, int n2) {
        Vector<VsqNrpn> vector = new Vector<VsqNrpn>();
        VsqBPList vsqBPList = vsqFile.Track.get(n).getCurve("DYN");
        int n3 = vsqBPList.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = vsqBPList.getKeyClock(i);
            int n5 = n4 - vsqFile.getPresendClockAt(n4, n2);
            if (n5 < 0) continue;
            VsqNrpn vsqNrpn = new VsqNrpn(n5, 25346, (byte)vsqBPList.getElement(i));
            vector.add(vsqNrpn);
        }
        return vector.toArray(new VsqNrpn[0]);
    }

    public static VsqNrpn[] generateFx2DepthNRPN(VsqFile vsqFile, int n, int n2) {
        Vector<VsqNrpn> vector = new Vector<VsqNrpn>();
        VsqBPList vsqBPList = vsqFile.Track.get(n).getCurve("fx2depth");
        int n3 = vsqBPList.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = vsqBPList.getKeyClock(i);
            int n5 = n4 - vsqFile.getPresendClockAt(n4, n2);
            if (n5 < 0) continue;
            VsqNrpn vsqNrpn = new VsqNrpn(n5, 26114, (byte)vsqBPList.getElement(i));
            vector.add(vsqNrpn);
        }
        return vector.toArray(new VsqNrpn[0]);
    }

    public static VsqNrpn generateHeaderNRPN() {
        VsqNrpn vsqNrpn = new VsqNrpn(0, 24576, 0, 0);
        vsqNrpn.append(24577, (byte)0, (byte)0);
        vsqNrpn.append(24578, (byte)0);
        return vsqNrpn;
    }

    public static VsqNrpn[] generateSingerNRPN(VsqFile vsqFile, VsqEvent vsqEvent, int n) {
        int n2 = vsqEvent.Clock;
        IconHandle iconHandle = null;
        if (vsqEvent.ID.IconHandle != null && vsqEvent.ID.IconHandle instanceof IconHandle) {
            iconHandle = vsqEvent.ID.IconHandle;
        }
        if (iconHandle == null) {
            return new VsqNrpn[0];
        }
        double d = vsqFile.getSecFromClock(n2) * 1000.0;
        int n3 = vsqFile.getTempoAt(n2);
        double d2 = 6.0E7 / (double)n3;
        double d3 = vsqFile.getSecFromClock(vsqEvent.Clock + vsqEvent.ID.getLength()) * 1000.0;
        int n4 = (int)Math.ceil(d3 - d);
        ValuePair<Byte, Byte> valuePair = VsqFile.getMsbAndLsb(n4);
        byte by = valuePair.getKey();
        byte by2 = valuePair.getValue();
        ValuePair<Byte, Byte> valuePair2 = VsqFile.getMsbAndLsb(n);
        byte by3 = valuePair2.getKey();
        byte by4 = valuePair2.getValue();
        Vector vector = new Vector();
        int n5 = n2 - vsqFile.getPresendClockAt(n2, n);
        VsqNrpn vsqNrpn = new VsqNrpn(n5, 24576, 0, 0);
        vsqNrpn.append(24577, by3, by4, true);
        vsqNrpn.append(24578, (byte)iconHandle.Language, true);
        vsqNrpn.append(21250, (byte)iconHandle.Program);
        return new VsqNrpn[]{vsqNrpn};
    }

    public static VsqNrpn generateNoteNRPN(VsqFile vsqFile, int n, VsqEvent vsqEvent, int n2, byte by, boolean bl) {
        byte by2;
        byte by3;
        int n3;
        int n4;
        byte by4;
        int n5;
        VsqNrpn vsqNrpn;
        int n6;
        Object object;
        int n7 = vsqEvent.Clock;
        String string = vsqFile.Track.get((int)n).getCommon().Version;
        double d = vsqFile.getSecFromClock(n7) * 1000.0;
        int n8 = vsqFile.getTempoAt(n7);
        double d2 = 6.0E7 / (double)n8;
        double d3 = vsqFile.getSecFromClock(vsqEvent.Clock + vsqEvent.ID.getLength()) * 1000.0;
        int n9 = (int)(d3 - d);
        ValuePair<Byte, Byte> valuePair = VsqFile.getMsbAndLsb(n9);
        byte by5 = valuePair.getKey();
        byte by6 = valuePair.getValue();
        if (bl) {
            object = VsqFile.getMsbAndLsb(n2);
            byte by7 = ((ValuePair)object).getKey();
            n6 = ((ValuePair)object).getValue().byteValue();
            vsqNrpn = new VsqNrpn(n7 - vsqFile.getPresendClockAt(n7, n2), 20480, 0, 0);
            vsqNrpn.append(20481, by7, (byte)n6, true);
            vsqNrpn.append(20482, (byte)vsqEvent.ID.Note, true);
        } else {
            vsqNrpn = new VsqNrpn(n7 - vsqFile.getPresendClockAt(n7, n2), 20482, (byte)vsqEvent.ID.Note);
        }
        vsqNrpn.append(20483, (byte)vsqEvent.ID.Dynamics, true);
        vsqNrpn.append(20484, by5, by6, true);
        vsqNrpn.append(20485, by, true);
        if (vsqEvent.ID.VibratoHandle != null) {
            vsqNrpn.append(20492, (byte)0, (byte)0, true);
            object = vsqEvent.ID.VibratoHandle.IconID;
            String string2 = ((String)object).substring(PortUtil.getStringLength((String)object) - 4);
            n6 = (int)PortUtil.fromHexString(string2);
            n5 = vsqEvent.ID.getLength();
            int n10 = vsqEvent.ID.VibratoDelay;
            by4 = (byte)((float)(n5 - n10) / (float)n5 * 127.0f);
            n4 = 127 - by4;
            vsqNrpn.append(20493, (byte)n6, by4, true);
            vsqNrpn.append(20494, (byte)n4, true);
        }
        object = vsqEvent.ID.LyricHandle.L0.getPhoneticSymbolList();
        String string3 = "";
        for (n6 = 0; n6 < ((String[])object).length; ++n6) {
            string3 = string3 + (String)object[n6];
        }
        char[] cArray = string3.toCharArray();
        if (string.startsWith("DSB2")) {
            vsqNrpn.append(20497, (byte)1, true);
        }
        vsqNrpn.append(20498, (byte)cArray.length, true);
        n5 = -1;
        int[] nArray = vsqEvent.ID.LyricHandle.L0.getConsonantAdjustmentList();
        for (by4 = 0; by4 < ((Object)object).length; by4 = (byte)(by4 + 1)) {
            char[] cArray2 = ((String)object[by4]).toCharArray();
            for (n3 = 0; n3 < cArray2.length; ++n3) {
                ++n5;
                if (n3 == 0) {
                    vsqNrpn.append(0x5000 | 19 + n5, (byte)cArray2[n3], (byte)nArray[by4], true);
                    continue;
                }
                vsqNrpn.append(0x5000 | 19 + n5, (byte)cArray2[n3], true);
            }
        }
        if (!string.startsWith("DSB2")) {
            vsqNrpn.append(20559, (byte)127, true);
        }
        if (string.startsWith("DSB3")) {
            by4 = (byte)(vsqEvent.ID.PMBendDepth * 60 / 100);
            if (by4 < 0) {
                by4 = 0;
            }
            if (60 < by4) {
                by4 = (byte)60;
            }
            n4 = (int)(0.3196 * (double)vsqEvent.ID.PMBendLength + 8.0);
            n3 = (int)(0.92 * (double)vsqEvent.ID.PMBendLength + 28.0);
            vsqNrpn.append(20560, by4, true);
            vsqNrpn.append(20561, (byte)n4, true);
            vsqNrpn.append(20562, (byte)20, true);
            vsqNrpn.append(20563, (byte)n3, true);
            vsqNrpn.append(20564, (byte)vsqEvent.ID.d4mean, true);
            vsqNrpn.append(20565, (byte)vsqEvent.ID.pMeanOnsetFirstNote, true);
            vsqNrpn.append(20566, (byte)vsqEvent.ID.vMeanNoteTransition, true);
            vsqNrpn.append(20567, (byte)vsqEvent.ID.pMeanEndingNote, true);
            vsqNrpn.append(20568, (byte)vsqEvent.ID.PMbPortamentoUse, true);
            by3 = (byte)((double)vsqEvent.ID.DEMdecGainRate / 100.0 * 100.0);
            vsqNrpn.append(20569, by3, true);
            by2 = (byte)((double)(100 * vsqEvent.ID.DEMaccent) / 100.0);
            vsqNrpn.append(20570, by2, true);
        }
        if (string.startsWith("UTU0") && vsqEvent.UstEvent != null) {
            byte by8;
            UstEnvelope ustEnvelope = null;
            ustEnvelope = vsqEvent.UstEvent.Envelope != null ? vsqEvent.UstEvent.Envelope : new UstEnvelope();
            int[] nArray2 = null;
            nArray2 = new int[]{ustEnvelope.p1, ustEnvelope.p2, ustEnvelope.p3, ustEnvelope.v1, ustEnvelope.v2, ustEnvelope.v3, ustEnvelope.v4, ustEnvelope.p4, ustEnvelope.p5, ustEnvelope.v5};
            for (n3 = 0; n3 < nArray2.length; ++n3) {
                by8 = nArray2[n3];
                by2 = (byte)(by8 & 0x7F);
                by3 = (byte)((by8 >>= 7) & 0x7F);
                vsqNrpn.append(20606, by3, by2);
                by2 = (byte)((by8 >>= 7) & 0x7F);
                by3 = (byte)((by8 >>= 7) & 0x7F);
                vsqNrpn.append(20605, by3, by2);
                by3 = (byte)((by8 >>= 7) & 0xF);
                vsqNrpn.append(20604, by3);
                vsqNrpn.append(20603, (byte)0);
            }
            vsqNrpn.append(20603, (byte)127);
            if (-100 <= vsqEvent.UstEvent.Moduration && vsqEvent.UstEvent.Moduration <= 100) {
                ValuePair<Byte, Byte> valuePair2 = VsqFile.getMsbAndLsb(vsqEvent.UstEvent.Moduration + 100);
                vsqNrpn.append(20601, (byte)valuePair2.getKey(), valuePair2.getValue());
            }
            if (vsqEvent.UstEvent.PreUtterance != 0.0f) {
                ValuePair<Byte, Byte> valuePair3 = VsqFile.getMsbAndLsb((int)(vsqEvent.UstEvent.PreUtterance + 8192.0f));
                vsqNrpn.append(20602, (byte)valuePair3.getKey(), valuePair3.getValue());
            }
            if (vsqEvent.UstEvent.Flags != "") {
                char[] cArray3 = vsqEvent.UstEvent.Flags.toCharArray();
                vsqNrpn.append(20598, (byte)cArray3.length);
                for (by2 = 0; by2 < cArray3.length; ++by2) {
                    by8 = (byte)cArray3[by2];
                    vsqNrpn.append(20599, by8);
                }
                vsqNrpn.append(20600, (byte)127);
            }
            if (vsqEvent.UstEvent.VoiceOverlap != 0.0f) {
                ValuePair<Byte, Byte> valuePair4 = VsqFile.getMsbAndLsb((int)(vsqEvent.UstEvent.VoiceOverlap + 8192.0f));
                vsqNrpn.append(20597, (byte)valuePair4.getKey(), valuePair4.getValue());
            }
        }
        vsqNrpn.append(20607, (byte)127, true);
        return vsqNrpn;
    }

    public static VsqNrpn[] generateNRPN(VsqFile vsqFile, int n, int n2, int n3, int n4) {
        VsqFile vsqFile2 = (VsqFile)vsqFile.clone();
        vsqFile2.removePart(n4, vsqFile.TotalClocks);
        if (0 < n3) {
            vsqFile2.removePart(0, n3);
        }
        vsqFile2.Master.PreMeasure = 1;
        VsqNrpn[] vsqNrpnArray = VsqFile.generateNRPN(vsqFile2, n, n2);
        vsqFile2 = null;
        return vsqNrpnArray;
    }

    public static VsqNrpn[] generateNRPN(VsqFile vsqFile, int n, int n2) {
        Cloneable cloneable;
        VsqBPList vsqBPList;
        Cloneable cloneable2;
        Vector<VsqNrpn> vector;
        int n3;
        Vector<VsqNrpn> vector2 = new Vector<VsqNrpn>();
        VsqTrack vsqTrack = vsqFile.Track.get(n);
        String string = vsqTrack.getCommon().Version;
        int n4 = vsqTrack.getEventCount();
        int n5 = 0;
        int n6 = vsqTrack.getEventCount() - 1;
        int n7 = 0;
        while (n7 < n4) {
            if (0 <= vsqTrack.getEvent((int)n7).Clock) {
                n5 = n7;
                break;
            }
            n5 = n7++;
        }
        for (n7 = vsqTrack.getEventCount() - 1; n7 >= 0; --n7) {
            if (vsqTrack.getEvent((int)n7).Clock > vsqFile.TotalClocks) continue;
            n6 = n7;
            break;
        }
        n7 = -1;
        for (n3 = n5; n3 >= 0; --n3) {
            if (vsqTrack.getEvent((int)n3).ID.type != VsqIDType.Singer) continue;
            n7 = n3;
            break;
        }
        if (n7 >= 0) {
            vector2.addAll(Arrays.asList(VsqFile.generateSingerNRPN(vsqFile, vsqTrack.getEvent(n7), 0)));
        } else {
            vector2.add(new VsqNrpn(0, 24578, 0));
            vector2.add(new VsqNrpn(0, 21250, 0));
        }
        vector2.addAll(Arrays.asList(VsqFile.generateVoiceChangeParameterNRPN(vsqFile, n, n2)));
        if (string.startsWith("DSB2")) {
            vector2.addAll(Arrays.asList(VsqFile.generateFx2DepthNRPN(vsqFile, n, n2)));
        }
        n3 = n2;
        if (string.startsWith("UTU0")) {
            double d = 0.0;
            vector = vsqTrack.getNoteEventIterator();
            while (vector.hasNext()) {
                cloneable2 = vector.next();
                double d2 = vsqFile.getSecFromClock(((VsqEvent)cloneable2).Clock + ((VsqEvent)cloneable2).ID.getLength()) - vsqFile.getSecFromClock(((VsqEvent)cloneable2).Clock);
                d = Math.max(d, d2);
            }
            n3 += (int)(d * 1000.0);
        }
        if ((vsqBPList = vsqTrack.getCurve("dyn")).size() > 0 && ((Vector)(cloneable = new Vector<VsqNrpn>(Arrays.asList(VsqFile.generateExpressionNRPN(vsqFile, n, n3))))).size() > 0) {
            vector2.addAll((Collection<VsqNrpn>)((Object)cloneable));
        }
        if (((VsqBPList)(cloneable = vsqTrack.getCurve("pbs"))).size() > 0 && (vector = new Vector<VsqNrpn>(Arrays.asList(VsqFile.generatePitchBendSensitivityNRPN(vsqFile, n, n3)))).size() > 0) {
            vector2.addAll(vector);
        }
        if (((VsqBPList)((Object)(vector = vsqTrack.getCurve("pit")))).size() > 0 && ((Vector)(cloneable2 = new Vector<VsqNrpn>(Arrays.asList(VsqFile.generatePitchBendNRPN(vsqFile, n, n3))))).size() > 0) {
            vector2.addAll((Collection<VsqNrpn>)((Object)cloneable2));
        }
        boolean bl = true;
        int n8 = 0;
        for (int i = n5; i <= n6; ++i) {
            VsqEvent vsqEvent = vsqTrack.getEvent(i);
            if (vsqEvent.ID.type == VsqIDType.Anote) {
                byte by = 3;
                if (vsqEvent.Clock == n8) {
                    by = (byte)(by - 2);
                }
                int n9 = vsqEvent.Clock + vsqEvent.ID.getLength() + 1;
                int n10 = vsqTrack.getEventCount();
                for (int j = i + 1; j < n10; ++j) {
                    VsqEvent vsqEvent2 = vsqTrack.getEvent(j);
                    if (vsqEvent2.ID.type != VsqIDType.Anote) continue;
                    n9 = vsqEvent2.Clock;
                    break;
                }
                if (vsqEvent.Clock + vsqEvent.ID.getLength() == n9) {
                    by = (byte)(by - 1);
                }
                vector2.add(VsqFile.generateNoteNRPN(vsqFile, n, vsqEvent, n2, by, bl));
                bl = false;
                vector2.addAll(Arrays.asList(VsqFile.generateVibratoNRPN(vsqFile, vsqEvent, n2)));
                n8 = vsqEvent.Clock + vsqEvent.ID.getLength();
                continue;
            }
            if (vsqEvent.ID.type != VsqIDType.Singer || i <= n5 || i == n7) continue;
            vector2.addAll(Arrays.asList(VsqFile.generateSingerNRPN(vsqFile, vsqEvent, n2)));
        }
        vector2 = VsqNrpn.sort(vector2);
        Vector<VsqNrpn> vector3 = new Vector<VsqNrpn>();
        for (int i = 0; i < vector2.size(); ++i) {
            vector3.addAll(Arrays.asList(vector2.get(i).expand()));
        }
        return vector3.toArray(new VsqNrpn[0]);
    }

    public static VsqNrpn[] generatePitchBendNRPN(VsqFile vsqFile, int n, int n2) {
        Vector<VsqNrpn> vector = new Vector<VsqNrpn>();
        VsqBPList vsqBPList = vsqFile.Track.get(n).getCurve("PIT");
        int n3 = vsqBPList.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = vsqBPList.getKeyClock(i);
            int n5 = vsqBPList.getElement(i) + 8192;
            ValuePair<Byte, Byte> valuePair = VsqFile.getMsbAndLsb(n5);
            int n6 = n4 - vsqFile.getPresendClockAt(n4, n2);
            if (n6 < 0) continue;
            VsqNrpn vsqNrpn = new VsqNrpn(n6, 21506, valuePair.getKey(), valuePair.getValue());
            vector.add(vsqNrpn);
        }
        return vector.toArray(new VsqNrpn[0]);
    }

    public static VsqNrpn[] generatePitchBendSensitivityNRPN(VsqFile vsqFile, int n, int n2) {
        Vector<VsqNrpn> vector = new Vector<VsqNrpn>();
        VsqBPList vsqBPList = vsqFile.Track.get(n).getCurve("PBS");
        int n3 = vsqBPList.size();
        for (int i = 0; i < n3; ++i) {
            int n4 = vsqBPList.getKeyClock(i);
            int n5 = n4 - vsqFile.getPresendClockAt(n4, n2);
            if (n5 < 0) continue;
            VsqNrpn vsqNrpn = new VsqNrpn(n5, 26370, (byte)vsqBPList.getElement(i), 0);
            vector.add(vsqNrpn);
        }
        return vector.toArray(new VsqNrpn[0]);
    }

    public static VsqNrpn[] generateVibratoNRPN(VsqFile vsqFile, VsqEvent vsqEvent, int n) {
        Vector<VsqNrpn> vector = new Vector<VsqNrpn>();
        if (vsqEvent.ID.VibratoHandle != null) {
            VibratoBPList vibratoBPList;
            int n2 = vsqEvent.Clock + vsqEvent.ID.VibratoDelay;
            ValuePair<Byte, Byte> valuePair = VsqFile.getMsbAndLsb(n);
            VsqNrpn vsqNrpn = new VsqNrpn(n2 - vsqFile.getPresendClockAt(n2, n), 25856, 0, 0);
            vsqNrpn.append(25857, valuePair.getKey(), valuePair.getValue(), true);
            vsqNrpn.append(25858, (byte)vsqEvent.ID.VibratoHandle.getStartDepth(), true);
            vsqNrpn.append(25602, (byte)vsqEvent.ID.VibratoHandle.getStartRate());
            vector.add(vsqNrpn);
            int n3 = vsqEvent.ID.getLength() - vsqEvent.ID.VibratoDelay;
            VibratoBPList vibratoBPList2 = vsqEvent.ID.VibratoHandle.getRateBP();
            int n4 = vibratoBPList2.getCount();
            if (n4 > 0) {
                for (int i = 0; i < n4; ++i) {
                    VibratoBPPair vibratoBPPair = vibratoBPList2.getElement(i);
                    float f = vibratoBPPair.X;
                    int n5 = n2 + (int)(f * (float)n3);
                    vector.add(new VsqNrpn(n5 - vsqFile.getPresendClockAt(n5, n), 25602, (byte)vibratoBPPair.Y));
                }
            }
            if ((n4 = (vibratoBPList = vsqEvent.ID.VibratoHandle.getDepthBP()).getCount()) > 0) {
                for (int i = 0; i < n4; ++i) {
                    VibratoBPPair vibratoBPPair = vibratoBPList.getElement(i);
                    float f = vibratoBPPair.X;
                    int n6 = n2 + (int)(f * (float)n3);
                    vector.add(new VsqNrpn(n6 - vsqFile.getPresendClockAt(n6, n), 25858, (byte)vibratoBPPair.Y));
                }
            }
        }
        Collections.sort(vector);
        return vector.toArray(new VsqNrpn[0]);
    }

    public static VsqNrpn[] generateVoiceChangeParameterNRPN(VsqFile vsqFile, int n, int n2) {
        int n3 = vsqFile.getPreMeasureClocks();
        String string = vsqFile.Track.get((int)n).getCommon().Version;
        Vector<VsqNrpn> vector = new Vector<VsqNrpn>();
        String[] stringArray = string.startsWith("DSB3") ? new String[]{"BRE", "BRI", "CLE", "POR", "OPE", "GEN"} : (string.startsWith("DSB2") ? new String[]{"BRE", "BRI", "CLE", "POR", "GEN", "harmonics", "reso1amp", "reso1bw", "reso1freq", "reso2amp", "reso2bw", "reso2freq", "reso3amp", "reso3bw", "reso3freq", "reso4amp", "reso4bw", "reso4freq"} : new String[]{"BRE", "BRI", "CLE", "POR", "GEN"});
        for (int i = 0; i < stringArray.length; ++i) {
            VsqBPList vsqBPList = vsqFile.Track.get(n).getCurve(stringArray[i]);
            if (vsqBPList.size() <= 0) continue;
            byte by = NRPN.getVoiceChangeParameterID(stringArray[i]);
            int n4 = vsqBPList.size();
            for (int j = 0; j < n4; ++j) {
                int n5 = vsqBPList.getKeyClock(j);
                int n6 = n5 - vsqFile.getPresendClockAt(n5, n2);
                if (n6 < 0) continue;
                VsqNrpn vsqNrpn = new VsqNrpn(n6, 21762, by);
                vsqNrpn.append(21763, (byte)vsqBPList.getElement(j), true);
                vector.add(vsqNrpn);
            }
        }
        Collections.sort(vector);
        return vector.toArray(new VsqNrpn[0]);
    }

    public static ValuePair<Byte, Byte> getMsbAndLsb(int n) {
        ValuePair<Byte, Byte> valuePair = new ValuePair<Byte, Byte>();
        if (16383 < n) {
            valuePair.setKey((byte)127);
            valuePair.setValue((byte)127);
        } else {
            byte by = (byte)(n >> 7);
            valuePair.setKey(by);
            valuePair.setValue((byte)(n - (by << 7)));
        }
        return valuePair;
    }

    public Vector<MidiEvent> generateTimeSig() {
        Vector<MidiEvent> vector = new Vector<MidiEvent>();
        for (TimeSigTableEntry timeSigTableEntry : this.TimesigTable) {
            vector.add(MidiEvent.generateTimeSigEvent(timeSigTableEntry.Clock, timeSigTableEntry.Numerator, timeSigTableEntry.Denominator));
        }
        return vector;
    }

    public Vector<MidiEvent> generateTempoChange() {
        Vector<MidiEvent> vector = new Vector<MidiEvent>();
        for (TempoTableEntry tempoTableEntry : this.TempoTable) {
            vector.add(MidiEvent.generateTempoChangeEvent(tempoTableEntry.Clock, tempoTableEntry.Tempo));
        }
        return vector;
    }

    public void write(String string) {
        this.write(string, 500, "Shift_JIS");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(String string, int n, String string2) {
        int n2 = 0;
        int n3 = this.Track.size();
        for (int i = 1; i < n3; ++i) {
            if (this.Track.get(i).getEventCount() <= 0) continue;
            int n4 = this.Track.get(i).getEventCount() - 1;
            VsqEvent vsqEvent = this.Track.get(i).getEvent(n4);
            n2 = Math.max(n2, vsqEvent.Clock + vsqEvent.ID.getLength());
        }
        if (PortUtil.isFileExists(string)) {
            try {
                PortUtil.deleteFile(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(string, "rw");
            randomAccessFile.write(_MTHD, 0, 4);
            randomAccessFile.write(0);
            randomAccessFile.write(0);
            randomAccessFile.write(0);
            randomAccessFile.write(6);
            randomAccessFile.write(0);
            randomAccessFile.write(1);
            VsqFile.writeUnsignedShort(randomAccessFile, this.Track.size());
            randomAccessFile.write(1);
            randomAccessFile.write(-32);
            randomAccessFile.write(_MTRK, 0, 4);
            randomAccessFile.write(new byte[]{0, 0, 0, 0}, 0, 4);
            long l = randomAccessFile.getFilePointer();
            VsqFile.writeFlexibleLengthUnsignedLong(randomAccessFile, 0L);
            randomAccessFile.write(-1);
            randomAccessFile.write(3);
            randomAccessFile.write((byte)_MASTER_TRACK.length);
            randomAccessFile.write(_MASTER_TRACK, 0, _MASTER_TRACK.length);
            Vector<MidiEvent> vector = new Vector<MidiEvent>();
            for (Comparable<TimeSigTableEntry> comparable : this.TimesigTable) {
                vector.add(MidiEvent.generateTimeSigEvent(comparable.Clock, comparable.Numerator, comparable.Denominator));
                n2 = Math.max(n2, comparable.Clock);
            }
            for (Comparable<TimeSigTableEntry> comparable : this.TempoTable) {
                vector.add(MidiEvent.generateTempoChangeEvent(((TempoTableEntry)comparable).Clock, ((TempoTableEntry)comparable).Tempo));
                n2 = Math.max(n2, ((TempoTableEntry)comparable).Clock);
            }
            Collections.sort(vector);
            long l2 = 0L;
            for (MidiEvent midiEvent : vector) {
                VsqFile.writeFlexibleLengthUnsignedLong(randomAccessFile, midiEvent.clock - l2);
                midiEvent.writeData(randomAccessFile);
                l2 = midiEvent.clock;
            }
            VsqFile.writeFlexibleLengthUnsignedLong(randomAccessFile, 0L);
            randomAccessFile.write(-1);
            randomAccessFile.write(47);
            randomAccessFile.write(0);
            long l3 = randomAccessFile.getFilePointer();
            randomAccessFile.seek(l - 4L);
            VsqFile.writeUnsignedInt(randomAccessFile, l3 - l);
            randomAccessFile.seek(l3);
            VsqFile vsqFile = (VsqFile)this.clone();
            vsqFile.Track.get(1).setMaster((VsqMaster)this.Master.clone());
            vsqFile.Track.get(1).setMixer((VsqMixer)this.Mixer.clone());
            VsqFile.printTrack(vsqFile, 1, randomAccessFile, n, string2);
            int n5 = this.Track.size();
            for (int i = 2; i < n5; ++i) {
                VsqFile.printTrack(this, i, randomAccessFile, n, string2);
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (randomAccessFile != null) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static String getLinePrefix(int n) {
        int n2 = VsqFile.getHowManyDigits(n);
        int n3 = (n2 - 1) / 4 + 1;
        String string = "";
        for (int i = 0; i < n3; ++i) {
            string = string + "0000";
        }
        return "DM:" + PortUtil.formatDecimal(string, n) + ":";
    }

    public static byte[] getLinePrefixBytes(int n) {
        int n2 = VsqFile.getHowManyDigits(n);
        int n3 = (n2 - 1) / 4 + 1;
        String string = "";
        for (int i = 0; i < n3; ++i) {
            string = string + "0000";
        }
        String string2 = "DM:" + PortUtil.formatDecimal(string, n) + ":";
        byte[] byArray = PortUtil.getEncodedByte("ASCII", string2);
        return byArray;
    }

    private static int getHowManyDigits(int n) {
        int n2 = n > 0 ? n : -n;
        int n3 = 1;
        int n4 = 1;
        do {
            ++n3;
        } while (n2 >= (n4 *= 10));
        return n3 - 1;
    }

    public static void writeCharArray(RandomAccessFile randomAccessFile, char[] cArray) throws IOException {
        for (int i = 0; i < cArray.length; ++i) {
            randomAccessFile.write((byte)cArray[i]);
        }
    }

    public static void writeUnsignedShort(RandomAccessFile randomAccessFile, int n) throws IOException {
        byte[] byArray = PortUtil.getbytes_uint16_be(n);
        randomAccessFile.write(byArray, 0, byArray.length);
    }

    public static void writeUnsignedInt(RandomAccessFile randomAccessFile, long l) throws IOException {
        byte[] byArray = PortUtil.getbytes_uint32_be(l);
        randomAccessFile.write(byArray, 0, byArray.length);
    }

    public static byte[] getBytesFlexibleLengthUnsignedLong(long l) {
        int n;
        int n2;
        boolean[] blArray = new boolean[64];
        long l2 = 1L;
        blArray[0] = (l & l2) == l2;
        for (n2 = 1; n2 < 64; ++n2) {
            blArray[n2] = (l & (l2 <<= 1)) == l2;
        }
        n2 = 0;
        for (n = 63; n >= 0; --n) {
            if (!blArray[n]) continue;
            n2 = n;
            break;
        }
        n = n2 / 7 + 1;
        byte[] byArray = new byte[n];
        for (int i = 1; i <= n; ++i) {
            int n3 = 0;
            int n4 = -128;
            for (int j = (n - i + 1) * 7 - 1; j >= (n - i + 1) * 7 - 6 - 1; --j) {
                n4 >>= 1;
                if (!blArray[j]) continue;
                n3 += n4;
            }
            if (i != n) {
                n3 -= 128;
            }
            byArray[i - 1] = (byte)n3;
        }
        return byArray;
    }

    public static void writeFlexibleLengthUnsignedLong(RandomAccessFile randomAccessFile, long l) throws IOException {
        byte[] byArray = VsqFile.getBytesFlexibleLengthUnsignedLong(l);
        randomAccessFile.write(byArray, 0, byArray.length);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class BarLineIterator
    implements Iterator {
        private Vector<TimeSigTableEntry> m_list;
        private int m_end_clock;
        private int i;
        private int clock;
        int local_denominator;
        int local_numerator;
        int clock_step;
        int t_end;
        int local_clock;
        int bar_counter;

        public BarLineIterator(Vector<TimeSigTableEntry> vector, int n) {
            this.m_list = vector;
            this.m_end_clock = n;
            this.i = 0;
            this.t_end = -1;
            this.clock = 0;
        }

        public VsqBarLineType next() {
            int n = this.clock_step * this.local_numerator;
            if (this.clock < this.t_end) {
                if ((this.clock - this.local_clock) % n == 0) {
                    ++this.bar_counter;
                    VsqBarLineType vsqBarLineType = new VsqBarLineType(this.clock, true, this.local_denominator, this.local_numerator, this.bar_counter);
                    this.clock += this.clock_step;
                    return vsqBarLineType;
                }
                VsqBarLineType vsqBarLineType = new VsqBarLineType(this.clock, false, this.local_denominator, this.local_numerator, this.bar_counter);
                this.clock += this.clock_step;
                return vsqBarLineType;
            }
            if (this.i < this.m_list.size()) {
                this.local_denominator = this.m_list.get((int)this.i).Denominator;
                this.local_numerator = this.m_list.get((int)this.i).Numerator;
                this.local_clock = this.m_list.get((int)this.i).Clock;
                int n2 = this.m_list.get((int)this.i).BarCount;
                this.clock_step = 1920 / this.local_denominator;
                n = this.clock_step * this.local_numerator;
                this.bar_counter = n2 - 1;
                this.t_end = this.m_end_clock;
                if (this.i + 1 < this.m_list.size()) {
                    this.t_end = this.m_list.get((int)(this.i + 1)).Clock;
                }
                ++this.i;
                this.clock = this.local_clock;
                if (this.clock < this.t_end) {
                    if ((this.clock - this.local_clock) % n == 0) {
                        ++this.bar_counter;
                        VsqBarLineType vsqBarLineType = new VsqBarLineType(this.clock, true, this.local_denominator, this.local_numerator, this.bar_counter);
                        this.clock += this.clock_step;
                        return vsqBarLineType;
                    }
                    VsqBarLineType vsqBarLineType = new VsqBarLineType(this.clock, false, this.local_denominator, this.local_numerator, this.bar_counter);
                    this.clock += this.clock_step;
                    return vsqBarLineType;
                }
            }
            return new VsqBarLineType();
        }

        @Override
        public void remove() {
        }

        @Override
        public boolean hasNext() {
            return this.clock < this.m_end_clock;
        }
    }
}

