/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.vsq;

import java.io.Serializable;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.ValuePair;
import org.kbinani.vsq.BPPair;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqBPPair;
import org.kbinani.vsq.VsqCommandType;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqFile;
import org.kbinani.vsq.VsqID;
import org.kbinani.vsq.VsqMixerEntry;
import org.kbinani.vsq.VsqTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqCommand
implements Serializable {
    public VsqCommandType Type;
    public Object[] Args;
    public Vector<VsqCommand> Children = new Vector();
    public VsqCommand Parent = null;

    public static VsqCommand generateCommandRoot() {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.ROOT;
        vsqCommand.Args = null;
        return vsqCommand;
    }

    public static VsqCommand generateCommandReplace(VsqFile vsqFile) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Args = new Object[1];
        vsqCommand.Type = VsqCommandType.REPLACE;
        vsqCommand.Args[0] = (VsqFile)vsqFile.clone();
        return vsqCommand;
    }

    public static VsqCommand generateCommandTrackReplace(int n, VsqTrack vsqTrack) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_REPLACE;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = (VsqTrack)vsqTrack.clone();
        return vsqCommand;
    }

    public static VsqCommand generateCommandUpdateTimesig(int n, int n2, int n3, int n4) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.UPDATE_TIMESIG;
        vsqCommand.Args = new Object[4];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n3;
        vsqCommand.Args[2] = n4;
        vsqCommand.Args[3] = n2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandUpdateTimesigRange(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.UPDATE_TIMESIG_RANGE;
        vsqCommand.Args = new Object[4];
        vsqCommand.Args[0] = VsqCommand.copyIntArray(nArray);
        vsqCommand.Args[1] = VsqCommand.copyIntArray(nArray3);
        vsqCommand.Args[2] = VsqCommand.copyIntArray(nArray4);
        vsqCommand.Args[3] = VsqCommand.copyIntArray(nArray2);
        return vsqCommand;
    }

    public static VsqCommand generateCommandUpdateTempoRange(int[] nArray, int[] nArray2, int[] nArray3) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.UPDATE_TEMPO_RANGE;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = VsqCommand.copyIntArray(nArray);
        vsqCommand.Args[1] = VsqCommand.copyIntArray(nArray3);
        vsqCommand.Args[2] = VsqCommand.copyIntArray(nArray2);
        return vsqCommand;
    }

    public static VsqCommand generateCommandUpdateTempo(int n, int n2, int n3) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.UPDATE_TEMPO;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n3;
        vsqCommand.Args[2] = n2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandChangePreMeasure(int n) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.CHANGE_PRE_MEASURE;
        vsqCommand.Args = new Object[1];
        vsqCommand.Args[0] = n;
        return vsqCommand;
    }

    public static VsqCommand generateCommandDeleteTrack(int n) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_DELETE;
        vsqCommand.Args = new Object[1];
        vsqCommand.Args[0] = n;
        return vsqCommand;
    }

    public static VsqCommand generateCommandAddTrack(VsqTrack vsqTrack, VsqMixerEntry vsqMixerEntry, int n) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_ADD;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = vsqTrack;
        vsqCommand.Args[1] = vsqMixerEntry;
        vsqCommand.Args[2] = n;
        return vsqCommand;
    }

    public static VsqCommand generateCommandTrackChangeName(int n, String string) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_CHANGE_NAME;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = string;
        return vsqCommand;
    }

    public static VsqCommand generateCommandTrackChangePlayMode(int n, int n2, int n3) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_CHANGE_PLAY_MODE;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        vsqCommand.Args[2] = n3;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeClockAndIDContaintsRange(int n, int[] nArray, int[] nArray2, VsqID[] vsqIDArray) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_CLOCK_AND_ID_CONTAINTS_RANGE;
        int n2 = nArray.length;
        vsqCommand.Args = new Object[4];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = VsqCommand.copyIntArray(nArray);
        vsqCommand.Args[2] = VsqCommand.copyIntArray(nArray2);
        VsqID[] vsqIDArray2 = new VsqID[vsqIDArray.length];
        for (int i = 0; i < vsqIDArray.length; ++i) {
            vsqIDArray2[i] = (VsqID)vsqIDArray[i].clone();
        }
        vsqCommand.Args[3] = vsqIDArray2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeClockAndIDContaints(int n, int n2, int n3, VsqID vsqID) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_CLOCK_AND_ID_CONTAINTS;
        vsqCommand.Args = new Object[4];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        vsqCommand.Args[2] = n3;
        vsqCommand.Args[3] = (VsqID)vsqID.clone();
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeIDContaintsRange(int n, int[] nArray, VsqID[] vsqIDArray) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_ID_CONTAINTS_RANGE;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = VsqCommand.copyIntArray(nArray);
        VsqID[] vsqIDArray2 = new VsqID[vsqIDArray.length];
        for (int i = 0; i < vsqIDArray.length; ++i) {
            vsqIDArray2[i] = (VsqID)vsqIDArray[i].clone();
        }
        vsqCommand.Args[2] = vsqIDArray2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeIDContaints(int n, int n2, VsqID vsqID) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_ID_CONTAINTS;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        vsqCommand.Args[2] = (VsqID)vsqID.clone();
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeClockAndLength(int n, int n2, int n3, int n4) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_CLOCK_AND_LENGTH;
        vsqCommand.Args = new Object[4];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        vsqCommand.Args[2] = n3;
        vsqCommand.Args[3] = n4;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeLength(int n, int n2, int n3) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_LENGTH;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        vsqCommand.Args[2] = n3;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeVelocity(int n, Vector<ValuePair<Integer, Integer>> vector) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_VELOCITY;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        Vector<ValuePair<Integer, Integer>> vector2 = new Vector<ValuePair<Integer, Integer>>();
        for (ValuePair<Integer, Integer> valuePair : vector) {
            vector2.add(new ValuePair<Integer, Integer>(valuePair.getKey(), valuePair.getValue()));
        }
        vsqCommand.Args[1] = vector2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventReplace(int n, VsqEvent vsqEvent) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_REPLACE;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = vsqEvent.clone();
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventReplaceRange(int n, VsqEvent[] vsqEventArray) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_REPLACE_RANGE;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        VsqEvent[] vsqEventArray2 = new VsqEvent[vsqEventArray.length];
        for (int i = 0; i < vsqEventArray.length; ++i) {
            vsqEventArray2[i] = (VsqEvent)vsqEventArray[i].clone();
        }
        vsqCommand.Args[1] = vsqEventArray2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeAccent(int n, Vector<ValuePair<Integer, Integer>> vector) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_ACCENT;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        Vector<ValuePair<Integer, Integer>> vector2 = new Vector<ValuePair<Integer, Integer>>();
        for (ValuePair<Integer, Integer> valuePair : vector) {
            vector2.add(new ValuePair<Integer, Integer>(valuePair.getKey(), valuePair.getValue()));
        }
        vsqCommand.Args[1] = vector2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeDecay(int n, Vector<ValuePair<Integer, Integer>> vector) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_DECAY;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        Vector<ValuePair<Integer, Integer>> vector2 = new Vector<ValuePair<Integer, Integer>>();
        for (ValuePair<Integer, Integer> valuePair : vector) {
            vector2.add(new ValuePair<Integer, Integer>(valuePair.getKey(), valuePair.getValue()));
        }
        vsqCommand.Args[1] = vector2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandTrackCurveReplaceRange(int n, String[] stringArray, VsqBPList[] vsqBPListArray) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_CURVE_REPLACE_RANGE;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        String[] stringArray2 = new String[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            stringArray2[i] = stringArray[i];
        }
        vsqCommand.Args[1] = stringArray2;
        VsqBPList[] vsqBPListArray2 = new VsqBPList[vsqBPListArray.length];
        for (int i = 0; i < vsqBPListArray.length; ++i) {
            vsqBPListArray2[i] = (VsqBPList)vsqBPListArray[i].clone();
        }
        vsqCommand.Args[2] = vsqBPListArray2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandTrackCurveReplace(int n, String string, VsqBPList vsqBPList) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_CURVE_REPLACE;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = string;
        vsqCommand.Args[2] = vsqBPList.clone();
        return vsqCommand;
    }

    public static VsqCommand generateCommandTrackCurveEdit(int n, String string, Vector<BPPair> vector) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_CURVE_EDIT;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = string;
        Vector<BPPair> vector2 = new Vector<BPPair>();
        for (BPPair bPPair : vector) {
            vector2.add(bPPair);
        }
        vsqCommand.Args[2] = vector2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandTrackCurveEdit2(int n, String string, Vector<Long> vector, TreeMap<Integer, VsqBPPair> treeMap) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_CURVE_EDIT2;
        vsqCommand.Args = new Object[4];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = string;
        Vector<Long> vector2 = new Vector<Long>();
        Object object = vector.iterator();
        while (object.hasNext()) {
            long l = object.next();
            vector2.add(l);
        }
        vsqCommand.Args[2] = vector2;
        object = new TreeMap();
        for (int n2 : treeMap.keySet()) {
            VsqBPPair vsqBPPair = treeMap.get(n2);
            ((TreeMap)object).put(n2, vsqBPPair);
        }
        vsqCommand.Args[3] = object;
        return vsqCommand;
    }

    public static VsqCommand generateCommandTrackCurveEditRange(int n, Vector<String> vector, Vector<Vector<BPPair>> vector2) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_CURVE_EDIT_RANGE;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        Vector<String> vector3 = new Vector<String>();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            vector3.add(vector.get(i));
        }
        vsqCommand.Args[1] = vector3;
        Vector vector4 = new Vector();
        n2 = vector2.size();
        for (int i = 0; i < n2; ++i) {
            Vector<BPPair> vector5 = new Vector<BPPair>();
            for (BPPair bPPair : vector2.get(i)) {
                vector5.add(new BPPair(bPPair.Clock, bPPair.Value));
            }
            vector4.add(vector5);
        }
        vsqCommand.Args[2] = vector4;
        return vsqCommand;
    }

    public static VsqCommand generateCommandTrackCurveEdit2All(int n, Vector<String> vector, Vector<Vector<Long>> vector2, Vector<TreeMap<Integer, VsqBPPair>> vector3) {
        Object object;
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.TRACK_CURVE_EDIT2_ALL;
        vsqCommand.Args = new Object[4];
        vsqCommand.Args[0] = n;
        Vector<String> vector4 = new Vector<String>();
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            vector4.add(vector.get(i));
        }
        vsqCommand.Args[1] = vector4;
        Vector vector5 = new Vector();
        n2 = vector2.size();
        for (int i = 0; i < n2; ++i) {
            Vector<Long> vector6 = new Vector<Long>();
            object = vector2.get(i).iterator();
            while (object.hasNext()) {
                long l = object.next();
                vector6.add(l);
            }
            vector5.add(vector6);
        }
        vsqCommand.Args[2] = vector5;
        Vector<Object> vector7 = new Vector<Object>();
        n2 = vector3.size();
        for (int i = 0; i < n2; ++i) {
            object = new TreeMap();
            TreeMap<Integer, VsqBPPair> treeMap = vector3.get(i);
            for (int n3 : treeMap.keySet()) {
                VsqBPPair vsqBPPair = treeMap.get(n3);
                ((TreeMap)object).put(n3, vsqBPPair);
            }
            vector7.add(object);
        }
        vsqCommand.Args[3] = vector7;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeLyric(int n, int n2, String string, String string2, boolean bl) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_LYRIC;
        vsqCommand.Args = new Object[5];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        vsqCommand.Args[2] = string;
        vsqCommand.Args[3] = string2;
        vsqCommand.Args[4] = bl;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeClock(int n, int n2, int n3) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_CLOCK;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        vsqCommand.Args[2] = n3;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventDeleteRange(int n, Vector<Integer> vector) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_DELETE_RANGE;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = VsqCommand.copyIntVector(vector);
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventDelete(int n, int n2) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_DELETE;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventAddRange(int n, VsqEvent[] vsqEventArray) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_ADD_RANGE;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        VsqEvent[] vsqEventArray2 = new VsqEvent[vsqEventArray.length];
        for (int i = 0; i < vsqEventArray.length; ++i) {
            vsqEventArray2[i] = (VsqEvent)vsqEventArray[i].clone();
        }
        vsqCommand.Args[1] = vsqEventArray2;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventAdd(int n, VsqEvent vsqEvent) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_ADD;
        vsqCommand.Args = new Object[2];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = (VsqEvent)vsqEvent.clone();
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeNote(int n, int n2, int n3) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_NOTE;
        vsqCommand.Args = new Object[3];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        vsqCommand.Args[2] = n3;
        return vsqCommand;
    }

    public static VsqCommand generateCommandEventChangeClockAndNote(int n, int n2, int n3, int n4) {
        VsqCommand vsqCommand = new VsqCommand();
        vsqCommand.Type = VsqCommandType.EVENT_CHANGE_CLOCK_AND_NOTE;
        vsqCommand.Args = new Object[4];
        vsqCommand.Args[0] = n;
        vsqCommand.Args[1] = n2;
        vsqCommand.Args[2] = n3;
        vsqCommand.Args[3] = n4;
        return vsqCommand;
    }

    private static int[] copyIntArray(int[] nArray) {
        int[] nArray2 = new int[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            nArray2[i] = nArray[i];
        }
        return nArray2;
    }

    private static Vector<Integer> copyIntVector(Vector<Integer> vector) {
        Vector<Integer> vector2 = new Vector<Integer>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector2.add(vector.get(i));
        }
        return vector2;
    }
}

