/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.componentmodel;

import org.kbinani.BEvent;
import org.kbinani.componentmodel.BDoWorkEventArgs;
import org.kbinani.componentmodel.BDoWorkEventHandler;
import org.kbinani.componentmodel.BProgressChangedEventArgs;
import org.kbinani.componentmodel.BProgressChangedEventHandler;
import org.kbinani.componentmodel.BRunWorkerCompletedEventArgs;
import org.kbinani.componentmodel.BRunWorkerCompletedEventHandler;

public class BBackgroundWorker {
    public BEvent<BDoWorkEventHandler> doWorkEvent = new BEvent();
    public BEvent<BProgressChangedEventHandler> progressChangedEvent = new BEvent();
    public BEvent<BRunWorkerCompletedEventHandler> runWorkerCompletedEvent = new BEvent();
    private WorkerRunner m_runner = null;
    private Thread thread = null;

    public boolean isBusy() {
        if (this.m_runner == null) {
            return false;
        }
        return this.m_runner.isBusy;
    }

    public void cancelAsync() {
        this.thread.interrupt();
        System.err.println("info; BBackgroundWorker#cancelAsync");
    }

    public void runWorkerAsync() {
        this.runWorkerAsync(null);
    }

    public void runWorkerAsync(Object object) {
        this.m_runner = new WorkerRunner(this.doWorkEvent, object);
        this.thread = new Thread(this.m_runner);
        this.thread.start();
    }

    public void reportProgress(int n) {
        this.reportProgress(n, null);
    }

    public void reportProgress(int n, Object object) {
        BProgressChangedEventArgs bProgressChangedEventArgs = new BProgressChangedEventArgs(n, object);
        try {
            this.progressChangedEvent.raise(this, bProgressChangedEventArgs);
        }
        catch (Exception exception) {
            System.err.println("BBackgroundWorker#reportProgress(int,Object); ex=" + exception);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class WorkerRunner
    implements Runnable {
        private BDoWorkEventArgs m_arg = null;
        private BEvent<BDoWorkEventHandler> m_delegate = null;
        private boolean isBusy = false;

        public WorkerRunner(BEvent<BDoWorkEventHandler> bEvent, Object object) {
            this.m_delegate = bEvent;
            this.m_arg = new BDoWorkEventArgs(object);
        }

        @Override
        public void run() {
            this.isBusy = true;
            try {
                this.m_delegate.raise(this.m_arg);
                BRunWorkerCompletedEventArgs bRunWorkerCompletedEventArgs = new BRunWorkerCompletedEventArgs(null, null, false);
                BBackgroundWorker.this.runWorkerCompletedEvent.raise(bRunWorkerCompletedEventArgs);
            }
            catch (Exception exception) {
                System.err.println("BBackgroundWorker#WorkerRunner#run(void); ex=" + exception);
            }
            this.isBusy = false;
        }
    }
}

