/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import org.kbinani.PortUtil;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.WaveDrawContext;
import org.kbinani.windows.forms.BPanel;

public class WaveView
extends BPanel {
    private WaveDrawContext[] drawer = new WaveDrawContext[16];

    private void paint(Graphics2D graphics2D) {
        int n = this.getWidth();
        Rectangle rectangle = new Rectangle(0, 0, n, this.getHeight());
        if (AppManager.skipDrawingWaveformWhenPlaying && AppManager.isPlaying()) {
            PortUtil.drawStringEx(graphics2D, "(hidden for performance)", AppManager.superFont10, rectangle, 0, 0);
            return;
        }
        int n2 = AppManager.getSelected();
        WaveDrawContext waveDrawContext = this.drawer[n2 - 1];
        if (waveDrawContext == null) {
            return;
        }
        waveDrawContext.draw(graphics2D, Color.black, rectangle, AppManager.clockFromXCoord(AppManager.keyWidth), AppManager.clockFromXCoord(AppManager.keyWidth + n), AppManager.getVsqFile().TempoTable, AppManager.scaleX);
    }

    public void unloadAll() {
        for (int i = 0; i < this.drawer.length; ++i) {
            WaveDrawContext waveDrawContext = this.drawer[i];
            if (waveDrawContext == null) continue;
            waveDrawContext.unload();
        }
    }

    public void reloadPartial(int n, String string, double d, double d2) {
        if (n < 0 || this.drawer.length <= n) {
            return;
        }
        if (this.drawer[n] == null) {
            this.drawer[n] = new WaveDrawContext();
            this.drawer[n].load(string);
        } else {
            this.drawer[n].reloadPartial(string, d, d2);
        }
    }

    public void load(int n, String string) {
        if (n < 0 || this.drawer.length <= n) {
            return;
        }
        if (this.drawer[n] == null) {
            this.drawer[n] = new WaveDrawContext();
        }
        this.drawer[n].load(string);
    }
}

