/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.PortUtil;
import org.kbinani.cadencii.AttachedCurve;
import org.kbinani.cadencii.BezierChain;
import org.kbinani.cadencii.BezierCurves;
import org.kbinani.cadencii.BezierPoint;
import org.kbinani.cadencii.BgmFile;
import org.kbinani.cadencii.CadenciiCommand;
import org.kbinani.cadencii.CadenciiCommandType;
import org.kbinani.cadencii.CurveType;
import org.kbinani.cadencii.EditorStatus;
import org.kbinani.cadencii.ICommand;
import org.kbinani.cadencii.ICommandRunnable;
import org.kbinani.cadencii.PointD;
import org.kbinani.cadencii.RendererKind;
import org.kbinani.cadencii.Utility;
import org.kbinani.vsq.TempoTableEntry;
import org.kbinani.vsq.TempoVector;
import org.kbinani.vsq.TimeSigTableEntry;
import org.kbinani.vsq.UstFile;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqBPPair;
import org.kbinani.vsq.VsqCommand;
import org.kbinani.vsq.VsqCommandType;
import org.kbinani.vsq.VsqCommon;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqFile;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.VsqMaster;
import org.kbinani.vsq.VsqMixer;
import org.kbinani.vsq.VsqMixerEntry;
import org.kbinani.vsq.VsqTrack;
import org.kbinani.xml.XmlSerializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VsqFileEx
extends VsqFile
implements Cloneable,
ICommandRunnable,
Serializable {
    public static final int NUM_TRACK = 17;
    static XmlSerializer s_vsq_serializer = new XmlSerializer(VsqFileEx.class);
    public AttachedCurve AttachedCurves;
    public Vector<BgmFile> BgmFiles = new Vector();
    public String cacheDir = "";
    public EditorStatus editorStatus = new EditorStatus();
    public boolean[] mute = new boolean[17];
    public boolean[] solo = new boolean[17];
    public static final String TAG_VSQEVENT_AQUESTONE_RELEASE = "org.kbinani.cadencii.AquesToneRelease";
    public static final String TAG_VSQTRACK_RENDERER_KIND = "org.kbinani.cadencii.RendererKind";

    public static RendererKind getTrackRendererKind(VsqTrack vsqTrack) {
        RendererKind[] rendererKindArray;
        String string = VsqFileEx.getTagCor(vsqTrack.Tag, TAG_VSQTRACK_RENDERER_KIND);
        if (string != null && !string.equals("")) {
            rendererKindArray = RendererKind.values();
            for (RendererKind rendererKind : rendererKindArray) {
                if (!string.equals(rendererKind + "")) continue;
                return rendererKind;
            }
        }
        if ((rendererKindArray = vsqTrack.getCommon()) == null) {
            return RendererKind.VOCALOID2;
        }
        String string2 = rendererKindArray.Version;
        if (string2 == null) {
            return RendererKind.VOCALOID2;
        }
        if (string2.startsWith("AQT0")) {
            return RendererKind.AQUES_TONE;
        }
        if (string2.startsWith("DSB3")) {
            return RendererKind.VOCALOID2;
        }
        if (string2.startsWith("STR0")) {
            return RendererKind.STRAIGHT_UTAU;
        }
        if (string2.startsWith("UTU0")) {
            return RendererKind.UTAU;
        }
        if (string2.startsWith("NUL0")) {
            return RendererKind.NULL;
        }
        int n = VocaloSysUtil.getDefaultDseVersion();
        if (n == 101) {
            return RendererKind.VOCALOID1_101;
        }
        return RendererKind.VOCALOID1_100;
    }

    public static void setTrackRendererKind(VsqTrack vsqTrack, RendererKind rendererKind) {
        vsqTrack.Tag = VsqFileEx.setTagCor(vsqTrack.Tag, TAG_VSQTRACK_RENDERER_KIND, (Object)((Object)rendererKind) + "");
        VsqCommon vsqCommon = vsqTrack.getCommon();
        if (vsqCommon != null) {
            if (rendererKind == RendererKind.AQUES_TONE) {
                vsqCommon.Version = "AQT0";
            } else if (rendererKind == RendererKind.STRAIGHT_UTAU) {
                vsqCommon.Version = "STR0";
            } else if (rendererKind == RendererKind.UTAU) {
                vsqCommon.Version = "UTU0";
            } else if (rendererKind == RendererKind.VOCALOID1_100 || rendererKind == RendererKind.VOCALOID1_101) {
                vsqCommon.Version = "DSB2";
            } else if (rendererKind == RendererKind.VOCALOID2) {
                vsqCommon.Version = "DSB3";
            } else if (rendererKind == RendererKind.NULL) {
                vsqCommon.Version = "NUL0";
            }
        }
    }

    private static String getTagCor(String string, String string2) {
        String[] stringArray;
        if (string2 == null) {
            return "";
        }
        if (string2.equals("")) {
            return "";
        }
        if (string == null) {
            return "";
        }
        if (string.equals("")) {
            return "";
        }
        for (String string3 : stringArray = PortUtil.splitString(string, ';')) {
            String[] stringArray2 = PortUtil.splitString(string3, ':');
            if (stringArray2.length != 2 || !string2.equals(stringArray2[0])) continue;
            return stringArray2[1];
        }
        return "";
    }

    private static String setTagCor(String string, String string2, String string3) {
        if (string2 == null) {
            return string;
        }
        if (string2.equals("")) {
            return string;
        }
        String string4 = string3.replace(":", "").replace(";", "");
        if (string == null) {
            return string2 + ":" + string3;
        }
        String string5 = "";
        String[] stringArray = PortUtil.splitString(string, ';');
        boolean bl = true;
        for (String string6 : stringArray) {
            String[] stringArray2 = PortUtil.splitString(string6, ':');
            if (stringArray2.length != 2) continue;
            String string7 = "";
            string7 = string2.equals(stringArray2[0]) ? string2 + ":" + string4 : stringArray2[0] + ":" + stringArray2[1];
            string5 = string5 + string7 + (bl ? "" : ";");
            bl = false;
        }
        if (bl) {
            string5 = string2 + ":" + string3;
        }
        return string5;
    }

    public static String getEventTag(VsqEvent vsqEvent, String string) {
        return VsqFileEx.getTagCor(vsqEvent.Tag, string);
    }

    public static void setEventTag(VsqEvent vsqEvent, String string, String string2) {
        vsqEvent.Tag = VsqFileEx.setTagCor(vsqEvent.Tag, string, string2);
    }

    public boolean getActualMuted(int n) {
        if (n < 1 || this.Track.size() <= n) {
            return true;
        }
        if (this.getMasterMute()) {
            return true;
        }
        if (this.getMute(n)) {
            return true;
        }
        if (!((VsqTrack)this.Track.get(n)).isTrackOn()) {
            return true;
        }
        boolean bl = false;
        for (int i = 1; i < this.Track.size(); ++i) {
            if (!this.getSolo(i)) continue;
            bl = true;
            break;
        }
        if (bl) {
            if (this.getSolo(n)) {
                return this.getMute(n);
            }
            return true;
        }
        return this.getMute(n);
    }

    public boolean getMasterMute() {
        if (this.Mixer == null) {
            return false;
        }
        return this.Mixer.MasterMute == 1;
    }

    public void setMasterMute(boolean bl) {
        if (this.Mixer == null) {
            return;
        }
        this.Mixer.MasterMute = bl ? 1 : 0;
    }

    public boolean getMute(int n) {
        if (this.Mixer == null) {
            return false;
        }
        if (this.Mixer.Slave == null) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        if (n == 0) {
            return this.Mixer.MasterMute == 1;
        }
        if (n - 1 < this.Mixer.Slave.size()) {
            return this.Mixer.Slave.get((int)(n - 1)).Mute == 1;
        }
        return false;
    }

    public void setMute(int n, boolean bl) {
        if (this.Mixer == null) {
            return;
        }
        if (this.Mixer.Slave == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (n == 0) {
            this.Mixer.MasterMute = bl ? 1 : 0;
        } else if (n - 1 < this.Mixer.Slave.size()) {
            this.Mixer.Slave.get((int)(n - 1)).Mute = bl ? 1 : 0;
        }
    }

    public boolean getSolo(int n) {
        if (this.Mixer == null) {
            return false;
        }
        if (this.Mixer.Slave == null) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        if (n == 0) {
            return false;
        }
        if (n - 1 < this.Mixer.Slave.size()) {
            return this.Mixer.Slave.get((int)(n - 1)).Solo == 1;
        }
        return false;
    }

    public void setSolo(int n, boolean bl) {
        if (this.Mixer == null) {
            return;
        }
        if (this.Mixer.Slave == null) {
            return;
        }
        if (n < 0) {
            return;
        }
        if (n == 0) {
            return;
        }
        if (n - 1 < this.Mixer.Slave.size()) {
            int n2 = this.Mixer.Slave.get((int)(n - 1)).Solo = bl ? 1 : 0;
            if (bl) {
                for (int i = 0; i < this.Mixer.Slave.size(); ++i) {
                    if (i + 1 == n || this.Mixer.Slave.get((int)i).Solo != 1) continue;
                    this.Mixer.Slave.get((int)i).Solo = 0;
                }
            }
        }
    }

    @Override
    public void adjustClockToMatchWith(TempoVector tempoVector) {
        double d;
        super.adjustClockToMatchWith(tempoVector);
        double d2 = d = this.getSecFromClock(this.getPreMeasureClocks());
        for (int i = 1; i < this.Track.size(); ++i) {
            for (int j = 0; j < Utility.CURVE_USAGE.length; ++j) {
                CurveType curveType = Utility.CURVE_USAGE[j];
                Vector<BezierChain> vector = this.AttachedCurves.get(i - 1).get(curveType);
                if (vector == null) continue;
                for (BezierChain bezierChain : vector) {
                    for (BezierPoint bezierPoint : bezierChain.points) {
                        PointD pointD = new PointD(tempoVector.getClockFromSec(this.getSecFromClock(bezierPoint.getBase().getX()) - d + d2), bezierPoint.getBase().getY());
                        double d3 = bezierPoint.getBase().getX() + bezierPoint.controlRight.getX();
                        double d4 = tempoVector.getClockFromSec(this.getSecFromClock(d3) - d + d2);
                        PointD pointD2 = new PointD(d4 - pointD.getX(), bezierPoint.controlRight.getY());
                        double d5 = bezierPoint.getBase().getX() + bezierPoint.controlLeft.getX();
                        double d6 = tempoVector.getClockFromSec(this.getSecFromClock(d5) - d + d2);
                        PointD pointD3 = new PointD(d6 - pointD.getX(), bezierPoint.controlLeft.getY());
                        bezierPoint.setBase(pointD);
                        bezierPoint.controlLeft = pointD3;
                        bezierPoint.controlRight = pointD2;
                    }
                }
            }
        }
    }

    public static void shift(VsqFileEx vsqFileEx, double d, int n) {
        int n2;
        TempoTableEntry tempoTableEntry;
        boolean bl = true;
        VsqFile vsqFile = new VsqFile("Miku", vsqFileEx.getPreMeasure(), 4, 4, 500000);
        vsqFile.TempoTable.clear();
        for (TempoTableEntry tempoTableEntry2 : vsqFileEx.TempoTable) {
            vsqFile.TempoTable.add(tempoTableEntry2);
        }
        vsqFile.updateTempoInfo();
        int n3 = vsqFile.TempoTable.size();
        if (d < 0.0) {
            bl = true;
            for (int i = n3 - 1; i >= 0; --i) {
                tempoTableEntry = (TempoTableEntry)vsqFile.TempoTable.get(i);
                if (!(tempoTableEntry.Time + d <= 0.0)) continue;
                if (!bl) break;
                n = tempoTableEntry.Tempo;
                bl = false;
            }
        }
        vsqFileEx.TempoTable.clear();
        vsqFileEx.TempoTable.add(new TempoTableEntry(0, n, 0.0));
        for (n2 = 0; n2 < n3; ++n2) {
            tempoTableEntry = (TempoTableEntry)vsqFile.TempoTable.get(n2);
            double d2 = tempoTableEntry.Time + d;
            int n4 = (int)vsqFileEx.getClockFromSec(d2);
            double d3 = vsqFileEx.getSecFromClock(n4);
            vsqFileEx.TempoTable.add(new TempoTableEntry(n4, tempoTableEntry.Tempo, d3));
        }
        vsqFileEx.updateTempoInfo();
        n2 = vsqFileEx.Track.size();
        int n5 = vsqFileEx.getPreMeasureClocks();
        for (int i = 1; i < n2; ++i) {
            Cloneable cloneable;
            int n6;
            double d4;
            int n7;
            int n8;
            int n9;
            VsqTrack vsqTrack = (VsqTrack)vsqFileEx.Track.get(i);
            Vector<Integer> vector = new Vector<Integer>();
            int n10 = vsqTrack.getEventCount();
            bl = true;
            for (n9 = n10 - 1; n9 >= 0; --n9) {
                VsqEvent vsqEvent = vsqTrack.getEvent(n9);
                double d5 = vsqFileEx.getSecFromClock(vsqEvent.Clock) + d;
                int n11 = (int)vsqFileEx.getClockFromSec(d5);
                if (vsqEvent.ID.type == VsqIDType.Anote) {
                    double d6 = vsqFileEx.getSecFromClock(vsqEvent.Clock + vsqEvent.ID.getLength()) + d;
                    n8 = (int)vsqFileEx.getClockFromSec(d6);
                    n7 = n8 - n11;
                    if (n11 < n5) {
                        if (n5 < n8) {
                            n11 = n5;
                            n7 = n8 - n5;
                            if (vsqEvent.ID.VibratoHandle != null) {
                                d4 = (double)vsqEvent.ID.VibratoHandle.getLength() / (double)vsqEvent.ID.getLength() * 100.0;
                                double d7 = vsqFileEx.getSecFromClock(n11);
                                double d8 = d6 - (d6 - d7) * d4 / 100.0;
                                int n12 = (int)vsqFileEx.getClockFromSec(d8);
                                vsqEvent.ID.VibratoHandle.setLength(n8 - n12);
                                vsqEvent.ID.VibratoDelay = n12 - n11;
                            }
                            vsqEvent.Clock = n11;
                            vsqEvent.ID.setLength(n7);
                            continue;
                        }
                        vector.add(n9);
                        continue;
                    }
                    if (vsqEvent.ID.VibratoHandle != null) {
                        d4 = vsqFileEx.getSecFromClock(vsqEvent.Clock + vsqEvent.ID.getLength() - vsqEvent.ID.VibratoHandle.getLength()) + d;
                        int n13 = (int)vsqFileEx.getClockFromSec(d4);
                        vsqEvent.ID.VibratoHandle.setLength(n13 - n11);
                        vsqEvent.ID.VibratoDelay = n13 - n11;
                    }
                    vsqEvent.Clock = n11;
                    vsqEvent.ID.setLength(n7);
                    continue;
                }
                if (vsqEvent.ID.type != VsqIDType.Singer) continue;
                if (vsqEvent.Clock <= 0) {
                    if (d >= 0.0) {
                        vsqEvent.Clock = n11 = 0;
                        continue;
                    }
                    if (bl) {
                        n11 = 0;
                        bl = false;
                        vsqEvent.Clock = n11;
                        continue;
                    }
                    vector.add(n9);
                    continue;
                }
                if (n11 < 0) {
                    if (bl) {
                        n11 = 0;
                        bl = false;
                    } else {
                        vector.add(n9);
                    }
                }
                vsqEvent.Clock = n11;
            }
            Collections.sort(vector);
            n9 = vector.size();
            for (n6 = n9 - 1; n6 >= 0; --n6) {
                int n14 = (Integer)vector.get(n6);
                vsqTrack.removeEvent(n14);
            }
            for (n6 = 0; n6 < Utility.CURVE_USAGE.length; ++n6) {
                CurveType curveType = Utility.CURVE_USAGE[n6];
                cloneable = vsqTrack.getCurve(curveType.getName());
                if (cloneable == null) continue;
                VsqBPList vsqBPList = new VsqBPList(((VsqBPList)cloneable).getName(), ((VsqBPList)cloneable).getDefault(), ((VsqBPList)cloneable).getMinimum(), ((VsqBPList)cloneable).getMaximum());
                int n15 = ((VsqBPList)cloneable).size();
                bl = true;
                for (int j = n15 - 1; j >= 0; --j) {
                    n8 = ((VsqBPList)cloneable).getKeyClock(j);
                    n7 = ((VsqBPList)cloneable).getElement(j);
                    d4 = vsqFileEx.getSecFromClock(n8) + d;
                    int n16 = (int)vsqFileEx.getClockFromSec(d4);
                    if (n16 < n5) {
                        if (!bl) break;
                        n16 = n5;
                        bl = false;
                    }
                    vsqBPList.add(n16, n7);
                }
                vsqTrack.setCurve(curveType.getName(), vsqBPList);
            }
            for (n6 = 0; n6 < Utility.CURVE_USAGE.length; ++n6) {
                int n17;
                CurveType curveType = Utility.CURVE_USAGE[n6];
                cloneable = vsqFileEx.AttachedCurves.get(i - 1).get(curveType);
                if (cloneable == null) continue;
                vector.clear();
                int n18 = ((Vector)cloneable).size();
                for (n17 = 0; n17 < n18; ++n17) {
                    BezierChain bezierChain = (BezierChain)((Vector)cloneable).get(n17);
                    for (BezierPoint bezierPoint : bezierChain.points) {
                        PointD pointD = new PointD(vsqFileEx.getClockFromSec(vsqFileEx.getSecFromClock(bezierPoint.getBase().getX()) + d), bezierPoint.getBase().getY());
                        double d9 = bezierPoint.getBase().getX() + bezierPoint.controlRight.getX();
                        double d10 = vsqFileEx.getClockFromSec(vsqFileEx.getSecFromClock(d9) + d);
                        PointD pointD2 = new PointD(d10 - pointD.getX(), bezierPoint.controlRight.getY());
                        double d11 = bezierPoint.getBase().getX() + bezierPoint.controlLeft.getX();
                        double d12 = vsqFileEx.getClockFromSec(vsqFileEx.getSecFromClock(d11) + d);
                        PointD pointD3 = new PointD(d12 - pointD.getX(), bezierPoint.controlLeft.getY());
                        bezierPoint.setBase(pointD);
                        bezierPoint.controlLeft = pointD3;
                        bezierPoint.controlRight = pointD2;
                    }
                    double d13 = bezierChain.getStart();
                    d4 = bezierChain.getEnd();
                    if (!(d13 < (double)n5)) continue;
                    if ((double)n5 < d4) {
                        BezierChain bezierChain2 = null;
                        try {
                            bezierChain2 = bezierChain.extractPartialBezier(n5, d4);
                            bezierChain2.id = bezierChain.id;
                            ((Vector)cloneable).set(n17, bezierChain2);
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("VsqFileEx#shift; ex=" + exception);
                        }
                        continue;
                    }
                    vector.add(bezierChain.id);
                }
                n9 = vector.size();
                block13: for (n17 = 0; n17 < n9; ++n17) {
                    int n19 = (Integer)vector.get(n17);
                    n18 = ((Vector)cloneable).size();
                    for (int j = 0; j < n18; ++j) {
                        if (n19 != ((BezierChain)((Vector)cloneable).get((int)j)).id) continue;
                        ((Vector)cloneable).removeElementAt(j);
                        continue block13;
                    }
                }
            }
        }
    }

    @Override
    public Object clone() {
        int n;
        VsqFileEx vsqFileEx = new VsqFileEx("Miku", 1, 4, 4, 500000);
        vsqFileEx.Track = new Vector();
        int n2 = this.Track.size();
        for (n = 0; n < n2; ++n) {
            vsqFileEx.Track.add((VsqTrack)((VsqTrack)this.Track.get(n)).clone());
        }
        vsqFileEx.TempoTable = new TempoVector();
        n2 = this.TempoTable.size();
        for (n = 0; n < n2; ++n) {
            vsqFileEx.TempoTable.add((TempoTableEntry)((TempoTableEntry)this.TempoTable.get(n)).clone());
        }
        vsqFileEx.TimesigTable = new Vector();
        n2 = this.TimesigTable.size();
        for (n = 0; n < n2; ++n) {
            vsqFileEx.TimesigTable.add((TimeSigTableEntry)((TimeSigTableEntry)this.TimesigTable.get(n)).clone());
        }
        vsqFileEx.TotalClocks = this.TotalClocks;
        vsqFileEx.Master = (VsqMaster)this.Master.clone();
        vsqFileEx.Mixer = (VsqMixer)this.Mixer.clone();
        vsqFileEx.AttachedCurves = (AttachedCurve)this.AttachedCurves.clone();
        n2 = this.BgmFiles.size();
        for (n = 0; n < n2; ++n) {
            vsqFileEx.BgmFiles.add((BgmFile)this.BgmFiles.get(n).clone());
        }
        vsqFileEx.cacheDir = this.cacheDir;
        return vsqFileEx;
    }

    public static CadenciiCommand generateCommandBgmUpdate(Vector<BgmFile> vector) {
        CadenciiCommand cadenciiCommand = new CadenciiCommand();
        cadenciiCommand.type = CadenciiCommandType.BGM_UPDATE;
        cadenciiCommand.args = new Object[1];
        Vector<BgmFile> vector2 = new Vector<BgmFile>();
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            vector2.add((BgmFile)vector.get(i).clone());
        }
        cadenciiCommand.args[0] = vector2;
        return cadenciiCommand;
    }

    public static CadenciiCommand generateCommandDeleteTrack(int n) {
        CadenciiCommand cadenciiCommand = new CadenciiCommand();
        cadenciiCommand.type = CadenciiCommandType.TRACK_DELETE;
        cadenciiCommand.args = new Object[1];
        cadenciiCommand.args[0] = n;
        return cadenciiCommand;
    }

    public static CadenciiCommand generateCommandTrackReplace(int n, VsqTrack vsqTrack, BezierCurves bezierCurves) {
        CadenciiCommand cadenciiCommand = new CadenciiCommand();
        cadenciiCommand.type = CadenciiCommandType.TRACK_REPLACE;
        cadenciiCommand.args = new Object[3];
        cadenciiCommand.args[0] = n;
        cadenciiCommand.args[1] = vsqTrack.clone();
        cadenciiCommand.args[2] = bezierCurves.clone();
        return cadenciiCommand;
    }

    public static CadenciiCommand generateCommandAddTrack(VsqTrack vsqTrack, VsqMixerEntry vsqMixerEntry, int n, BezierCurves bezierCurves) {
        CadenciiCommand cadenciiCommand = new CadenciiCommand();
        cadenciiCommand.type = CadenciiCommandType.TRACK_ADD;
        cadenciiCommand.args = new Object[4];
        cadenciiCommand.args[0] = vsqTrack.clone();
        cadenciiCommand.args[1] = vsqMixerEntry;
        cadenciiCommand.args[2] = n;
        cadenciiCommand.args[3] = bezierCurves.clone();
        return cadenciiCommand;
    }

    public static CadenciiCommand generateCommandAddBezierChain(int n, CurveType curveType, int n2, int n3, BezierChain bezierChain) {
        CadenciiCommand cadenciiCommand = new CadenciiCommand();
        cadenciiCommand.type = CadenciiCommandType.BEZIER_CHAIN_ADD;
        cadenciiCommand.args = new Object[5];
        cadenciiCommand.args[0] = n;
        cadenciiCommand.args[1] = curveType;
        cadenciiCommand.args[2] = (BezierChain)bezierChain.clone();
        cadenciiCommand.args[3] = n3;
        cadenciiCommand.args[4] = n2;
        return cadenciiCommand;
    }

    public static CadenciiCommand generateCommandDeleteBezierChain(int n, CurveType curveType, int n2, int n3) {
        CadenciiCommand cadenciiCommand = new CadenciiCommand();
        cadenciiCommand.type = CadenciiCommandType.BEZIER_CHAIN_DELETE;
        cadenciiCommand.args = new Object[4];
        cadenciiCommand.args[0] = n;
        cadenciiCommand.args[1] = curveType;
        cadenciiCommand.args[2] = n2;
        cadenciiCommand.args[3] = n3;
        return cadenciiCommand;
    }

    public static CadenciiCommand generateCommandReplaceBezierChain(int n, CurveType curveType, int n2, BezierChain bezierChain, int n3) {
        CadenciiCommand cadenciiCommand = new CadenciiCommand();
        cadenciiCommand.type = CadenciiCommandType.BEZIER_CHAIN_REPLACE;
        cadenciiCommand.args = new Object[5];
        cadenciiCommand.args[0] = n;
        cadenciiCommand.args[1] = curveType;
        cadenciiCommand.args[2] = n2;
        cadenciiCommand.args[3] = bezierChain;
        cadenciiCommand.args[4] = n3;
        return cadenciiCommand;
    }

    public static CadenciiCommand generateCommandReplace(VsqFileEx vsqFileEx) {
        CadenciiCommand cadenciiCommand = new CadenciiCommand();
        cadenciiCommand.type = CadenciiCommandType.REPLACE;
        cadenciiCommand.args = new Object[1];
        cadenciiCommand.args[0] = (VsqFileEx)vsqFileEx.clone();
        return cadenciiCommand;
    }

    public static CadenciiCommand generateCommandReplaceAttachedCurveRange(int n, TreeMap<CurveType, Vector<BezierChain>> treeMap) {
        CadenciiCommand cadenciiCommand = new CadenciiCommand();
        cadenciiCommand.type = CadenciiCommandType.ATTACHED_CURVE_REPLACE_RANGE;
        cadenciiCommand.args = new Object[2];
        cadenciiCommand.args[0] = n;
        TreeMap treeMap2 = new TreeMap();
        for (CurveType curveType : treeMap.keySet()) {
            Vector<BezierChain> vector = treeMap.get(curveType);
            Vector<BezierChain> vector2 = new Vector<BezierChain>();
            Iterator<BezierChain> iterator = vector.iterator();
            while (iterator.hasNext()) {
                vector2.add((BezierChain)iterator.next().clone());
            }
            treeMap2.put(curveType, vector2);
        }
        cadenciiCommand.args[1] = treeMap2;
        return cadenciiCommand;
    }

    @Override
    public ICommand executeCommand(ICommand iCommand) {
        CadenciiCommand cadenciiCommand = (CadenciiCommand)iCommand;
        CadenciiCommand cadenciiCommand2 = null;
        if (cadenciiCommand.type == CadenciiCommandType.VSQ_COMMAND) {
            cadenciiCommand2 = new CadenciiCommand();
            cadenciiCommand2.type = CadenciiCommandType.VSQ_COMMAND;
            cadenciiCommand2.vsqCommand = super.executeCommand(cadenciiCommand.vsqCommand);
            VsqCommandType vsqCommandType = cadenciiCommand.vsqCommand.Type;
            if (vsqCommandType == VsqCommandType.CHANGE_PRE_MEASURE || vsqCommandType == VsqCommandType.REPLACE || vsqCommandType == VsqCommandType.UPDATE_TEMPO || vsqCommandType == VsqCommandType.UPDATE_TEMPO_RANGE) {
                int n = this.Track.size();
                for (int i = 0; i < n - 1; ++i) {
                    this.editorStatus.renderRequired[i] = true;
                }
            } else if (vsqCommandType == VsqCommandType.EVENT_ADD || vsqCommandType == VsqCommandType.EVENT_ADD_RANGE || vsqCommandType == VsqCommandType.EVENT_CHANGE_ACCENT || vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK || vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK_AND_ID_CONTAINTS || vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK_AND_ID_CONTAINTS_RANGE || vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK_AND_LENGTH || vsqCommandType == VsqCommandType.EVENT_CHANGE_CLOCK_AND_NOTE || vsqCommandType == VsqCommandType.EVENT_CHANGE_DECAY || vsqCommandType == VsqCommandType.EVENT_CHANGE_ID_CONTAINTS || vsqCommandType == VsqCommandType.EVENT_CHANGE_ID_CONTAINTS_RANGE || vsqCommandType == VsqCommandType.EVENT_CHANGE_LENGTH || vsqCommandType == VsqCommandType.EVENT_CHANGE_LYRIC || vsqCommandType == VsqCommandType.EVENT_CHANGE_NOTE || vsqCommandType == VsqCommandType.EVENT_CHANGE_VELOCITY || vsqCommandType == VsqCommandType.EVENT_DELETE || vsqCommandType == VsqCommandType.EVENT_DELETE_RANGE || vsqCommandType == VsqCommandType.EVENT_REPLACE || vsqCommandType == VsqCommandType.EVENT_REPLACE_RANGE || vsqCommandType == VsqCommandType.TRACK_CURVE_EDIT || vsqCommandType == VsqCommandType.TRACK_CURVE_EDIT_RANGE || vsqCommandType == VsqCommandType.TRACK_CURVE_EDIT2 || vsqCommandType == VsqCommandType.TRACK_CURVE_REPLACE || vsqCommandType == VsqCommandType.TRACK_CURVE_REPLACE_RANGE || vsqCommandType == VsqCommandType.TRACK_REPLACE) {
                int n = (Integer)cadenciiCommand.vsqCommand.Args[0];
                this.editorStatus.renderRequired[n - 1] = true;
            } else if (vsqCommandType == VsqCommandType.TRACK_ADD) {
                int n = (Integer)cadenciiCommand.vsqCommand.Args[2];
                for (int i = 15; i >= n; --i) {
                    this.editorStatus.renderRequired[i] = this.editorStatus.renderRequired[i - 1];
                }
                this.editorStatus.renderRequired[n - 1] = true;
            } else if (vsqCommandType == VsqCommandType.TRACK_DELETE) {
                int n = (Integer)cadenciiCommand.vsqCommand.Args[0];
                for (int i = n - 1; i < 15; ++i) {
                    this.editorStatus.renderRequired[i] = this.editorStatus.renderRequired[i + 1];
                }
                this.editorStatus.renderRequired[15] = false;
            }
        } else {
            if (cadenciiCommand.type == CadenciiCommandType.BEZIER_CHAIN_ADD) {
                int n = (Integer)cadenciiCommand.args[0];
                CurveType curveType = (CurveType)cadenciiCommand.args[1];
                BezierChain bezierChain = (BezierChain)cadenciiCommand.args[2];
                int n2 = (Integer)cadenciiCommand.args[3];
                int n3 = (Integer)cadenciiCommand.args[4];
                this.AttachedCurves.get(n - 1).addBezierChain(curveType, bezierChain, n3);
                cadenciiCommand2 = VsqFileEx.generateCommandDeleteBezierChain(n, curveType, n3, n2);
                if (bezierChain.size() >= 1) {
                    int n4;
                    int n5;
                    int n6;
                    int n7 = n6 = (int)bezierChain.points.get(0).getBase().getX();
                    int n8 = bezierChain.points.size();
                    for (n5 = 1; n5 < n8; ++n5) {
                        n4 = (int)bezierChain.points.get(n5).getBase().getX();
                        n6 = Math.min(n6, n4);
                        n7 = Math.max(n7, n4);
                    }
                    n5 = curveType.getMaximum();
                    n4 = curveType.getMinimum();
                    VsqBPList vsqBPList = ((VsqTrack)this.Track.get(n)).getCurve(curveType.getName());
                    if (n6 <= n7 && vsqBPList != null) {
                        int n9;
                        Vector<Long> vector = new Vector<Long>();
                        int n10 = vsqBPList.size();
                        for (int i = 0; i < n10; ++i) {
                            n9 = vsqBPList.getKeyClock(i);
                            if (n6 > n9 || n9 > n7) continue;
                            VsqBPPair vsqBPPair = vsqBPList.getElementB(i);
                            vector.add(vsqBPPair.id);
                        }
                        TreeMap<Integer, VsqBPPair> treeMap = new TreeMap<Integer, VsqBPPair>();
                        if (bezierChain.points.size() == 1) {
                            BezierPoint bezierPoint = bezierChain.points.get(0);
                            treeMap.put((int)bezierPoint.getBase().getX(), new VsqBPPair((int)bezierPoint.getBase().getY(), vsqBPList.getMaxID() + 1L));
                        } else {
                            n9 = Integer.MAX_VALUE;
                            int n11 = 0;
                            for (int i = n6; i <= n7; i += n2) {
                                int n12 = (int)bezierChain.getValue(i);
                                if (n12 < n4) {
                                    n12 = n4;
                                } else if (n5 < n12) {
                                    n12 = n5;
                                }
                                if (n12 == n9) continue;
                                treeMap.put(i, new VsqBPPair(n12, vsqBPList.getMaxID() + (long)(++n11)));
                                n9 = n12;
                            }
                        }
                        cadenciiCommand.vsqCommand = VsqCommand.generateCommandTrackCurveEdit2(n, curveType.getName(), vector, treeMap);
                    }
                }
                this.editorStatus.renderRequired[n - 1] = true;
            } else if (cadenciiCommand.type == CadenciiCommandType.BEZIER_CHAIN_DELETE) {
                int n;
                int n13;
                int n14 = (Integer)cadenciiCommand.args[0];
                CurveType curveType = (CurveType)cadenciiCommand.args[1];
                int n15 = (Integer)cadenciiCommand.args[2];
                int n16 = (Integer)cadenciiCommand.args[3];
                BezierChain bezierChain = (BezierChain)this.AttachedCurves.get(n14 - 1).getBezierChain(curveType, n15).clone();
                this.AttachedCurves.get(n14 - 1).remove(curveType, n15);
                cadenciiCommand2 = VsqFileEx.generateCommandAddBezierChain(n14, curveType, n15, n16, bezierChain);
                int n17 = bezierChain.points.size();
                int n18 = n13 = (int)bezierChain.points.get(0).getBase().getX();
                for (int i = 1; i < n17; ++i) {
                    n = (int)bezierChain.points.get(i).getBase().getX();
                    n13 = Math.min(n13, n);
                    n18 = Math.max(n18, n);
                }
                VsqBPList vsqBPList = ((VsqTrack)this.Track.get(n14)).getCurve(curveType.getName());
                n = vsqBPList.size();
                Vector<Long> vector = new Vector<Long>();
                for (int i = 0; i < n; ++i) {
                    int n19 = vsqBPList.getKeyClock(i);
                    if (n13 <= n19 && n19 <= n18) {
                        vector.add(vsqBPList.getElementB((int)i).id);
                        continue;
                    }
                    if (n18 < n19) break;
                }
                cadenciiCommand.vsqCommand = VsqCommand.generateCommandTrackCurveEdit2(n14, curveType.getName(), vector, new TreeMap<Integer, VsqBPPair>());
                this.editorStatus.renderRequired[n14 - 1] = true;
            } else if (cadenciiCommand.type == CadenciiCommandType.BEZIER_CHAIN_REPLACE) {
                int n = (Integer)cadenciiCommand.args[0];
                CurveType curveType = (CurveType)cadenciiCommand.args[1];
                int n20 = (Integer)cadenciiCommand.args[2];
                BezierChain bezierChain = (BezierChain)cadenciiCommand.args[3];
                int n21 = (Integer)cadenciiCommand.args[4];
                BezierChain bezierChain2 = (BezierChain)this.AttachedCurves.get(n - 1).getBezierChain(curveType, n20).clone();
                this.AttachedCurves.get(n - 1).setBezierChain(curveType, n20, bezierChain);
                VsqBPList vsqBPList = ((VsqTrack)this.Track.get(n)).getCurve(curveType.getName());
                cadenciiCommand2 = VsqFileEx.generateCommandReplaceBezierChain(n, curveType, n20, bezierChain2, n21);
                if (bezierChain.size() == 1) {
                    int n22;
                    int n23 = n22 = (int)bezierChain.points.get(0).getBase().getX();
                    if (bezierChain2.points.size() > 1) {
                        int n24;
                        int n25 = bezierChain2.points.size();
                        for (int i = 1; i < n25; ++i) {
                            n24 = (int)bezierChain2.points.get(i).getBase().getX();
                            n22 = Math.min(n22, n24);
                            n23 = Math.max(n23, n24);
                        }
                        if (n22 < n23) {
                            Vector<Long> vector = new Vector<Long>();
                            n24 = vsqBPList.size();
                            for (int i = 0; i < n24; ++i) {
                                int n26 = vsqBPList.getKeyClock(i);
                                if (n22 <= n26 && n26 <= n23) {
                                    vector.add(vsqBPList.getElementB((int)i).id);
                                }
                                if (n23 < n26) break;
                            }
                            TreeMap<Integer, VsqBPPair> treeMap = new TreeMap<Integer, VsqBPPair>();
                            PointD pointD = bezierChain.points.get(0).getBase();
                            treeMap.put((int)pointD.getX(), new VsqBPPair((int)pointD.getY(), vsqBPList.getMaxID() + 1L));
                            cadenciiCommand.vsqCommand = VsqCommand.generateCommandTrackCurveEdit2(n, curveType.getName(), vector, treeMap);
                        }
                    }
                } else if (bezierChain.size() > 1) {
                    int n27;
                    int n28;
                    int n29;
                    int n30;
                    int n31;
                    int n32;
                    int n33 = n32 = (int)bezierChain.points.get(0).getBase().getX();
                    int n34 = bezierChain.points.size();
                    for (n31 = 1; n31 < n34; ++n31) {
                        n30 = (int)bezierChain.points.get(n31).getBase().getX();
                        n32 = Math.min(n32, n30);
                        n33 = Math.max(n33, n30);
                    }
                    n31 = n32;
                    n30 = n33;
                    if (bezierChain2.points.size() > 0) {
                        n30 = n31 = (int)bezierChain2.points.get(0).getBase().getX();
                        int n35 = bezierChain2.points.size();
                        for (n29 = 1; n29 < n35; ++n29) {
                            n28 = (int)bezierChain2.points.get(n29).getBase().getX();
                            n31 = Math.min(n31, n28);
                            n30 = Math.max(n30, n28);
                        }
                    }
                    Vector<Long> vector = new Vector<Long>();
                    n29 = vsqBPList.size();
                    for (n28 = 0; n28 < n29; ++n28) {
                        n27 = vsqBPList.getKeyClock(n28);
                        if (n31 <= n27 && n27 <= n30) {
                            vector.add(vsqBPList.getElementB((int)n28).id);
                        }
                        if (n30 < n27) break;
                    }
                    n28 = curveType.getMaximum();
                    n27 = curveType.getMinimum();
                    TreeMap<Integer, VsqBPPair> treeMap = new TreeMap<Integer, VsqBPPair>();
                    if (n32 < n33) {
                        int n36 = Integer.MAX_VALUE;
                        int n37 = 0;
                        for (int i = n32; i < n33; i += n21) {
                            int n38 = (int)bezierChain.getValue(i);
                            if (n38 < n27) {
                                n38 = n27;
                            } else if (n28 < n38) {
                                n38 = n28;
                            }
                            if (n36 == n38) continue;
                            treeMap.put(i, new VsqBPPair(n38, vsqBPList.getMaxID() + (long)(++n37)));
                        }
                    }
                    cadenciiCommand.vsqCommand = VsqCommand.generateCommandTrackCurveEdit2(n, curveType.getName(), vector, treeMap);
                }
                this.editorStatus.renderRequired[n - 1] = true;
            } else if (cadenciiCommand.type == CadenciiCommandType.REPLACE) {
                int n;
                int n39;
                VsqFileEx vsqFileEx = (VsqFileEx)cadenciiCommand.args[0];
                VsqFileEx vsqFileEx2 = (VsqFileEx)this.clone();
                this.Track.clear();
                int n40 = vsqFileEx.Track.size();
                for (n39 = 0; n39 < n40; ++n39) {
                    this.Track.add((VsqTrack)((VsqTrack)vsqFileEx.Track.get(n39)).clone());
                }
                this.TempoTable.clear();
                n40 = vsqFileEx.TempoTable.size();
                for (n39 = 0; n39 < n40; ++n39) {
                    this.TempoTable.add((TempoTableEntry)((TempoTableEntry)vsqFileEx.TempoTable.get(n39)).clone());
                }
                this.TimesigTable.clear();
                n40 = vsqFileEx.TimesigTable.size();
                for (n39 = 0; n39 < n40; ++n39) {
                    this.TimesigTable.add((TimeSigTableEntry)((TimeSigTableEntry)vsqFileEx.TimesigTable.get(n39)).clone());
                }
                this.TotalClocks = vsqFileEx.TotalClocks;
                this.Master = (VsqMaster)vsqFileEx.Master.clone();
                this.Mixer = (VsqMixer)vsqFileEx.Mixer.clone();
                this.AttachedCurves = (AttachedCurve)vsqFileEx.AttachedCurves.clone();
                this.updateTotalClocks();
                cadenciiCommand2 = VsqFileEx.generateCommandReplace(vsqFileEx2);
                n39 = this.Track.size();
                for (n = 0; n < n39 - 1; ++n) {
                    this.editorStatus.renderRequired[n] = true;
                }
                for (n = n39 - 1; n < 16; ++n) {
                    this.editorStatus.renderRequired[n] = false;
                }
            } else if (cadenciiCommand.type == CadenciiCommandType.ATTACHED_CURVE_REPLACE_RANGE) {
                int n = (Integer)cadenciiCommand.args[0];
                TreeMap treeMap = (TreeMap)cadenciiCommand.args[1];
                TreeMap<CurveType, Vector<BezierChain>> treeMap2 = new TreeMap<CurveType, Vector<BezierChain>>();
                for (CurveType curveType : treeMap.keySet()) {
                    Vector<BezierChain> vector = new Vector<BezierChain>();
                    Vector<BezierChain> vector2 = this.AttachedCurves.get(n - 1).get(curveType);
                    for (int i = 0; i < vector2.size(); ++i) {
                        vector.add((BezierChain)vector2.get(i).clone());
                    }
                    treeMap2.put(curveType, vector);
                    this.AttachedCurves.get(n - 1).get(curveType).clear();
                    for (BezierChain bezierChain : (Vector)treeMap.get(curveType)) {
                        this.AttachedCurves.get(n - 1).get(curveType).add(bezierChain);
                    }
                }
                cadenciiCommand2 = VsqFileEx.generateCommandReplaceAttachedCurveRange(n, treeMap2);
                this.editorStatus.renderRequired[n - 1] = true;
            } else if (cadenciiCommand.type == CadenciiCommandType.TRACK_ADD) {
                VsqTrack vsqTrack = (VsqTrack)cadenciiCommand.args[0];
                VsqMixerEntry vsqMixerEntry = (VsqMixerEntry)cadenciiCommand.args[1];
                int n = (Integer)cadenciiCommand.args[2];
                BezierCurves bezierCurves = (BezierCurves)cadenciiCommand.args[3];
                cadenciiCommand2 = VsqFileEx.generateCommandDeleteTrack(n);
                if (this.Track.size() <= 17) {
                    this.Track.insertElementAt((VsqTrack)vsqTrack.clone(), n);
                    this.AttachedCurves.insertElementAt(n - 1, bezierCurves);
                    this.Mixer.Slave.insertElementAt((VsqMixerEntry)vsqMixerEntry.clone(), n - 1);
                }
                for (int i = 15; i >= n; --i) {
                    this.editorStatus.renderRequired[i] = this.editorStatus.renderRequired[i - 1];
                }
                this.editorStatus.renderRequired[n - 1] = true;
            } else if (cadenciiCommand.type == CadenciiCommandType.TRACK_DELETE) {
                int n = (Integer)cadenciiCommand.args[0];
                cadenciiCommand2 = VsqFileEx.generateCommandAddTrack((VsqTrack)this.Track.get(n), this.Mixer.Slave.get(n - 1), n, this.AttachedCurves.get(n - 1));
                this.Track.removeElementAt(n);
                this.AttachedCurves.removeElementAt(n - 1);
                this.Mixer.Slave.removeElementAt(n - 1);
                this.updateTotalClocks();
                for (int i = n - 1; i < 15; ++i) {
                    this.editorStatus.renderRequired[i] = this.editorStatus.renderRequired[i + 1];
                }
                this.editorStatus.renderRequired[15] = false;
            } else if (cadenciiCommand.type == CadenciiCommandType.TRACK_REPLACE) {
                int n = (Integer)cadenciiCommand.args[0];
                VsqTrack vsqTrack = (VsqTrack)cadenciiCommand.args[1];
                BezierCurves bezierCurves = (BezierCurves)cadenciiCommand.args[2];
                cadenciiCommand2 = VsqFileEx.generateCommandTrackReplace(n, (VsqTrack)this.Track.get(n), this.AttachedCurves.get(n - 1));
                this.Track.set(n, vsqTrack);
                this.AttachedCurves.set(n - 1, bezierCurves);
                this.updateTotalClocks();
                this.editorStatus.renderRequired[n - 1] = true;
            } else if (cadenciiCommand.type == CadenciiCommandType.BGM_UPDATE) {
                Vector vector = (Vector)cadenciiCommand.args[0];
                cadenciiCommand2 = VsqFileEx.generateCommandBgmUpdate(this.BgmFiles);
                this.BgmFiles.clear();
                int n = vector.size();
                for (int i = 0; i < n; ++i) {
                    this.BgmFiles.add((BgmFile)vector.get(i));
                }
            }
            if (cadenciiCommand.vsqCommand != null && cadenciiCommand2 != null) {
                cadenciiCommand2.vsqCommand = super.executeCommand(cadenciiCommand.vsqCommand);
            }
        }
        return cadenciiCommand2;
    }

    public VsqFileEx() {
        this("Miku", 1, 4, 4, 500000);
        this.Track.clear();
        this.TempoTable.clear();
        this.TimesigTable.clear();
    }

    public VsqFileEx(String string, int n, int n2, int n3, int n4) {
        super(string, n, n2, n3, n4);
        this.AttachedCurves = new AttachedCurve();
        int n5 = this.Track.size();
        for (int i = 1; i < n5; ++i) {
            this.AttachedCurves.add(new BezierCurves());
        }
    }

    public VsqFileEx(UstFile ustFile) {
        super(ustFile);
        this.AttachedCurves = new AttachedCurve();
        int n = this.Track.size();
        for (int i = 1; i < n; ++i) {
            this.AttachedCurves.add(new BezierCurves());
        }
    }

    public VsqFileEx(String string, String string2) throws FileNotFoundException {
        super(string, string2);
        int n;
        this.AttachedCurves = new AttachedCurve();
        String string3 = PortUtil.combinePath(PortUtil.getDirectoryName(string), PortUtil.getFileName(string) + ".xml");
        for (n = 1; n < this.Track.size(); ++n) {
            this.AttachedCurves.add(new BezierCurves());
        }
        n = this.Track.size();
        block1: for (int i = 1; i < n; ++i) {
            VsqTrack vsqTrack = (VsqTrack)this.Track.get(i);
            Iterator<VsqEvent> iterator = vsqTrack.getSingerEventIterator();
            while (iterator.hasNext()) {
                VsqEvent vsqEvent = iterator.next();
                if (!vsqEvent.ID.IconHandle.IDS.toLowerCase().equals("utau")) continue;
                VsqFileEx.setTrackRendererKind(vsqTrack, RendererKind.UTAU);
                continue block1;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeAsXml(String string) {
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(string);
            s_vsq_serializer.serialize(fileOutputStream, this);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VsqFileEx#writeAsXml; ex=" + exception);
        }
        finally {
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("VsqFileEx#writeAsXml; ex2=" + exception);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static VsqFileEx readFromXml(String string) {
        int n;
        VsqFileEx vsqFileEx = null;
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(string);
            vsqFileEx = (VsqFileEx)s_vsq_serializer.deserialize(fileInputStream);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VsqFileEx#readFromXml; ex=" + exception);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("VsqFileEx#readFromXml; ex2=" + exception);
                }
            }
        }
        if (vsqFileEx == null) {
            return null;
        }
        if (vsqFileEx.AttachedCurves != null) {
            n = vsqFileEx.Track.size();
            if (vsqFileEx.AttachedCurves.getCurves().size() + 1 != n) {
                vsqFileEx.AttachedCurves.getCurves().clear();
                for (int i = 1; i < n; ++i) {
                    vsqFileEx.AttachedCurves.add(new BezierCurves());
                }
            } else {
                for (BezierCurves cloneable : vsqFileEx.AttachedCurves.getCurves()) {
                    for (int i = 0; i < Utility.CURVE_USAGE.length; ++i) {
                        CurveType curveType = Utility.CURVE_USAGE[i];
                        Vector<BezierChain> vector = cloneable.get(curveType);
                        int n2 = vector.size();
                        for (int vsqBPList = 0; vsqBPList < n2; ++vsqBPList) {
                            BezierChain bezierChain = vector.get(vsqBPList);
                            bezierChain.id = vsqBPList + 1;
                            int n3 = bezierChain.points.size();
                            for (int j = 0; j < n3; ++j) {
                                bezierChain.points.get(j).setID(j + 1);
                            }
                        }
                    }
                }
            }
        } else {
            n = vsqFileEx.Track.size();
            for (int i = 1; i < n; ++i) {
                vsqFileEx.AttachedCurves.add(new BezierCurves());
            }
        }
        n = vsqFileEx.Track.size();
        for (int i = 0; i < n; ++i) {
            VsqTrack vsqTrack = (VsqTrack)vsqFileEx.Track.get(i);
            for (CurveType curveType : Utility.CURVE_USAGE) {
                VsqBPList vsqBPList = vsqTrack.getCurve(curveType.getName());
                if (vsqBPList == null) continue;
                vsqBPList.setName(curveType.getName().toLowerCase());
            }
        }
        return vsqFileEx;
    }

    @Override
    public void write(String string) {
        super.write(string);
    }

    @Override
    public void write(String string, int n, String string2) {
        super.write(string, n, string2);
    }
}

