/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import org.kbinani.BEvent;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.windows.forms.BCheckBox;
import org.kbinani.windows.forms.BKeyEventArgs;
import org.kbinani.windows.forms.BKeyEventHandler;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BSlider;
import org.kbinani.windows.forms.BTextBox;

public class VolumeTracker
extends JPanel {
    private int m_feder = 0;
    private String m_number = "0";
    private String m_title = "";
    private Object m_tag = null;
    public static final int WIDTH = 85;
    public static final int HEIGHT = 284;
    private static final int[][] _KEY = new int[][]{{55, 26}, {51, 27}, {47, 28}, {42, 30}, {38, 31}, {35, 33}, {31, 34}, {28, 36}, {24, 37}, {21, 39}, {18, 40}, {15, 42}, {12, 43}, {10, 45}, {7, 46}, {5, 48}, {2, 49}, {0, 51}, {-2, 52}, {-5, 54}, {-7, 55}, {-10, 57}, {-12, 58}, {-15, 60}, {-18, 61}, {-21, 63}, {-24, 64}, {-28, 66}, {-31, 67}, {-35, 69}, {-38, 70}, {-42, 72}, {-47, 73}, {-51, 75}, {-55, 76}, {-60, 78}, {-65, 79}, {-70, 81}, {-76, 82}, {-81, 84}, {-87, 85}, {-93, 87}, {-100, 88}, {-107, 89}, {-114, 91}, {-121, 92}, {-129, 94}, {-137, 95}, {-145, 97}, {-154, 98}, {-163, 100}, {-173, 101}, {-183, 103}, {-193, 104}, {-204, 106}, {-215, 107}, {-227, 109}, {-240, 110}, {-253, 112}, {-266, 113}, {-280, 115}, {-295, 116}, {-311, 118}, {-327, 119}, {-344, 121}, {-362, 122}, {-380, 124}, {-399, 125}, {-420, 127}, {-441, 128}, {-463, 130}, {-486, 131}, {-510, 133}, {-535, 134}, {-561, 136}, {-589, 137}, {-617, 139}, {-647, 140}, {-678, 142}, {-711, 143}, {-745, 145}, {-781, 146}, {-818, 148}, {-857, 149}, {-898, 151}};
    public BEvent<BEventHandler> federChangedEvent = new BEvent();
    public BEvent<BEventHandler> panpotChangedEvent = new BEvent();
    public BEvent<BEventHandler> muteButtonClick = new BEvent();
    public BEvent<BEventHandler> soloButtonClick = new BEvent();
    private static final long serialVersionUID = 1L;
    private BTextBox txtFeder = null;
    private BSlider trackFeder = null;
    private BSlider trackPanpot = null;
    private BTextBox txtPanpot = null;
    private BLabel lblTitle = null;
    private BCheckBox chkMute = null;
    private BCheckBox chkSolo = null;

    public VolumeTracker() {
        this.initialize();
        this.registerEventHandlers();
        this.setResources();
        this.setMuted(false);
        this.setSolo(false);
    }

    public void setLocation(int n, int n2) {
        super.setLocation(n, n2);
    }

    public void setTag(Object object) {
        this.m_tag = object;
    }

    public Object getTag() {
        return this.m_tag;
    }

    public String getTitle() {
        return this.m_title;
    }

    public void setTitle(String string) {
        this.m_title = string;
        this.updateTitle();
    }

    private void updateTitle() {
        if (this.m_number.equals("")) {
            this.lblTitle.setText(this.m_title);
        } else if (this.m_title.equals("")) {
            this.lblTitle.setText(this.m_number);
        } else {
            this.lblTitle.setText(this.m_number + " " + this.m_title);
        }
    }

    public String getNumber() {
        return this.m_number;
    }

    public void setNumber(String string) {
        this.m_number = string;
        this.updateTitle();
    }

    public boolean isMuted() {
        return this.chkMute.isSelected();
    }

    public void setMuted(boolean bl) {
        boolean bl2 = this.chkMute.isSelected();
        this.chkMute.setSelected(bl);
        this.chkMute.setBackground(bl ? PortUtil.DimGray : Color.white);
    }

    public boolean isSolo() {
        return this.chkSolo.isSelected();
    }

    public void setSolo(boolean bl) {
        boolean bl2 = this.chkSolo.isSelected();
        this.chkSolo.setSelected(bl);
        this.chkSolo.setBackground(bl ? PortUtil.DarkCyan : Color.white);
    }

    public int getPanpot() {
        return this.trackPanpot.getValue();
    }

    public void setPanpot(int n) {
        this.trackPanpot.setValue(n);
    }

    public boolean isSoloButtonVisible() {
        return this.chkSolo.isVisible();
    }

    public void setSoloButtonVisible(boolean bl) {
        this.chkSolo.setVisible(bl);
    }

    public int getFeder() {
        return this.m_feder;
    }

    public void setFeder(int n) {
        int n2 = this.m_feder;
        this.m_feder = n;
        if (n2 != this.m_feder) {
            try {
                this.federChangedEvent.raise(this, new BEventArgs());
            }
            catch (Exception exception) {
                PortUtil.stderr.println("VolumeTracker#setFeder; ex=" + exception);
            }
        }
        int n3 = 177 - VolumeTracker.getYCoordFromFeder(this.m_feder);
        this.trackFeder.setValue(n3);
    }

    private static int getFederFromYCoord(int n) {
        int n2 = _KEY[0][0];
        int n3 = Math.abs(_KEY[0][1] - n);
        int n4 = 0;
        int n5 = _KEY.length;
        for (int i = 1; i < n5; ++i) {
            int n6 = Math.abs(_KEY[i][1] - n);
            if (n6 >= n3) continue;
            n4 = i;
            n3 = n6;
            n2 = _KEY[i][0];
        }
        return n2;
    }

    private static int getYCoordFromFeder(int n) {
        int n2 = _KEY[0][1];
        int n3 = Math.abs(_KEY[0][0] - n);
        int n4 = 0;
        int n5 = _KEY.length;
        for (int i = 1; i < n5; ++i) {
            int n6 = Math.abs(_KEY[i][0] - n);
            if (n6 >= n3) continue;
            n4 = i;
            n3 = n6;
            n2 = _KEY[i][1];
        }
        return n2;
    }

    public void VolumeTracker_Resize(Object object, BEventArgs bEventArgs) {
    }

    public void trackFeder_ValueChanged(Object object, BEventArgs bEventArgs) {
        this.m_feder = VolumeTracker.getFederFromYCoord(151 - (this.trackFeder.getValue() - 26));
        this.txtFeder.setText((double)this.m_feder / 10.0 + "");
        try {
            this.federChangedEvent.raise(this, new BEventArgs());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VolumeTracker#trackFeder_ValueChanged; ex=" + exception);
        }
    }

    public void trackPanpot_ValueChanged(Object object, BEventArgs bEventArgs) {
        this.txtPanpot.setText(this.trackPanpot.getValue() + "");
        try {
            this.panpotChangedEvent.raise(this, new BEventArgs());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VolumeTracker#trackPanpot_ValueChanged; ex=" + exception);
        }
    }

    public void txtFeder_KeyDown(Object object, BKeyEventArgs bKeyEventArgs) {
        if ((bKeyEventArgs.getKeyCode() & 0xA) != 10) {
            return;
        }
        try {
            int n = (int)(PortUtil.parseFloat(this.txtFeder.getText()) * 10.0f);
            if (55 < n) {
                n = 55;
            }
            if (n < -898) {
                n = -898;
            }
            this.setFeder(n);
            this.txtFeder.setText((float)this.getFeder() / 10.0f + "");
            this.txtFeder.requestFocusInWindow();
            this.txtFeder.selectAll();
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VolumeTracker#txtFeder_KeyDown; ex=" + exception);
        }
    }

    public void txtPanpot_KeyDown(Object object, BKeyEventArgs bKeyEventArgs) {
        if ((bKeyEventArgs.getKeyCode() & 0xA) != 10) {
            return;
        }
        try {
            int n = PortUtil.parseInt(this.txtPanpot.getText());
            if (n < -64) {
                n = -64;
            }
            if (64 < n) {
                n = 64;
            }
            this.setPanpot(n);
            this.txtPanpot.setText(this.getPanpot() + "");
            this.txtPanpot.requestFocusInWindow();
            this.txtPanpot.selectAll();
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VolumeTracker#txtPanpot_KeyDown; ex=" + exception);
        }
    }

    public void chkSolo_Click(Object object, BEventArgs bEventArgs) {
        try {
            this.soloButtonClick.raise(this, bEventArgs);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VolumeTracker#chkSolo_Click; ex=" + exception);
        }
    }

    public void chkMute_Click(Object object, BEventArgs bEventArgs) {
        try {
            this.muteButtonClick.raise(this, bEventArgs);
        }
        catch (Exception exception) {
            PortUtil.stderr.println("VolumeTracker#chkMute_Click; ex=" + exception);
        }
    }

    private void registerEventHandlers() {
        this.trackFeder.valueChangedEvent.add(new BEventHandler(this, "trackFeder_ValueChanged"));
        this.trackPanpot.valueChangedEvent.add(new BEventHandler(this, "trackPanpot_ValueChanged"));
        this.txtPanpot.keyDownEvent.add(new BKeyEventHandler(this, "txtPanpot_KeyDown"));
        this.txtFeder.keyDownEvent.add(new BKeyEventHandler(this, "txtFeder_KeyDown"));
        this.chkSolo.clickEvent.add(new BEventHandler(this, "chkSolo_Click"));
        this.chkMute.clickEvent.add(new BEventHandler(this, "chkMute_Click"));
    }

    private void setResources() {
    }

    private void initialize() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.anchor = 17;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.fill = 1;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.gridwidth = 2;
        gridBagConstraints3.gridy = 5;
        this.lblTitle = new BLabel();
        this.lblTitle.setText("TITLE");
        this.lblTitle.setPreferredSize(new Dimension(85, 23));
        this.lblTitle.setBackground(Color.white);
        this.lblTitle.setHorizontalAlignment(0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.gridy = 4;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.insets = new Insets(0, 10, 10, 10);
        gridBagConstraints4.gridwidth = 2;
        gridBagConstraints4.gridx = 0;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 2;
        gridBagConstraints5.gridy = 3;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.0;
        gridBagConstraints5.insets = new Insets(3, 3, 3, 3);
        gridBagConstraints5.gridwidth = 2;
        gridBagConstraints5.gridx = 0;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 3;
        gridBagConstraints6.gridy = 2;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 1.0;
        gridBagConstraints6.insets = new Insets(10, 0, 10, 0);
        gridBagConstraints6.gridwidth = 2;
        gridBagConstraints6.gridx = 0;
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.gridy = 1;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.weighty = 0.0;
        gridBagConstraints7.insets = new Insets(10, 3, 0, 3);
        gridBagConstraints7.gridwidth = 2;
        gridBagConstraints7.gridx = 0;
        this.setSize(86, 284);
        this.setLayout(new GridBagLayout());
        this.setPreferredSize(new Dimension(85, 284));
        this.setBackground(new Color(180, 180, 180));
        this.add((Component)this.getChkMute(), gridBagConstraints2);
        this.add((Component)this.getChkSolo(), gridBagConstraints);
        this.add((Component)this.getTxtFeder(), gridBagConstraints7);
        this.add((Component)this.getTrackFeder(), gridBagConstraints6);
        this.add((Component)this.getTrackPanpot(), gridBagConstraints5);
        this.add((Component)this.getTxtPanpot(), gridBagConstraints4);
        this.add((Component)this.lblTitle, gridBagConstraints3);
    }

    private BTextBox getTxtFeder() {
        if (this.txtFeder == null) {
            this.txtFeder = new BTextBox();
            this.txtFeder.setPreferredSize(new Dimension(79, 19));
            this.txtFeder.setHorizontalAlignment(0);
            this.txtFeder.setText("0");
        }
        return this.txtFeder;
    }

    private BSlider getTrackFeder() {
        if (this.trackFeder == null) {
            this.trackFeder = new BSlider();
            this.trackFeder.setOrientation(1);
            this.trackFeder.setMinimum(26);
            this.trackFeder.setPreferredSize(new Dimension(45, 144));
            this.trackFeder.setValue(100);
            this.trackFeder.setBackground(new Color(180, 180, 180));
            this.trackFeder.setMajorTickSpacing(10);
            this.trackFeder.setMaximum(151);
        }
        return this.trackFeder;
    }

    private BSlider getTrackPanpot() {
        if (this.trackPanpot == null) {
            this.trackPanpot = new BSlider();
            this.trackPanpot.setMaximum(64);
            this.trackPanpot.setValue(0);
            this.trackPanpot.setBackground(new Color(180, 180, 180));
            this.trackPanpot.setMajorTickSpacing(1);
            this.trackPanpot.setMinimum(-64);
        }
        return this.trackPanpot;
    }

    private BTextBox getTxtPanpot() {
        if (this.txtPanpot == null) {
            this.txtPanpot = new BTextBox();
            this.txtPanpot.setHorizontalAlignment(0);
            this.txtPanpot.setText("0");
        }
        return this.txtPanpot;
    }

    private BCheckBox getChkMute() {
        if (this.chkMute == null) {
            this.chkMute = new BCheckBox();
            this.chkMute.setText("M");
        }
        return this.chkMute;
    }

    private BCheckBox getChkSolo() {
        if (this.chkSolo == null) {
            this.chkSolo = new BCheckBox();
            this.chkSolo.setText("S");
        }
        return this.chkSolo;
    }
}

