/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import org.kbinani.PortUtil;

public class UtauFreq {
    public String Header;
    public int SampleInterval;
    public double AverageFrequency;
    public int NumPoints;
    public double[] Frequency;
    public double[] Volume;

    private UtauFreq() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UtauFreq FromFrq(String string) {
        UtauFreq utauFreq = new UtauFreq();
        FileInputStream fileInputStream = null;
        try {
            int n;
            int n2;
            int n3;
            fileInputStream = new FileInputStream(string);
            byte[] byArray = new byte[8];
            fileInputStream.read(byArray, 0, 8);
            char[] cArray = new char[8];
            for (n3 = 0; n3 < 8; ++n3) {
                cArray[n3] = (char)byArray[n3];
            }
            utauFreq.Header = new String(cArray);
            fileInputStream.read(byArray, 0, 4);
            utauFreq.SampleInterval = PortUtil.make_int32_le(byArray);
            fileInputStream.read(byArray, 0, 8);
            utauFreq.AverageFrequency = PortUtil.make_double_le(byArray);
            for (n3 = 0; n3 < 4; ++n3) {
                n2 = fileInputStream.read(byArray, 0, 4);
                n = PortUtil.make_int32_le(byArray);
            }
            fileInputStream.read(byArray, 0, 4);
            utauFreq.NumPoints = PortUtil.make_int32_le(byArray);
            utauFreq.Frequency = new double[utauFreq.NumPoints];
            utauFreq.Volume = new double[utauFreq.NumPoints];
            byte[] byArray2 = new byte[16];
            n2 = fileInputStream.read(byArray2, 0, 16);
            n = 0;
            while (n2 > 0) {
                double d = PortUtil.make_double_le(byArray2);
                for (int i = 0; i < 4; ++i) {
                    byArray2[i] = byArray2[i + 4];
                }
                double d2 = PortUtil.make_double_le(byArray2);
                utauFreq.Frequency[n] = d;
                utauFreq.Volume[n] = d2;
                n2 = fileInputStream.read(byArray2, 0, 16);
                ++n;
            }
        }
        catch (Exception exception) {
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return utauFreq;
    }

    public void Write(FileOutputStream fileOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[8];
        char[] cArray = this.Header.toCharArray();
        for (n = 0; n < 8; ++n) {
            byArray[n] = n >= cArray.length ? (byte)0 : (byte)cArray[n];
        }
        fileOutputStream.write(byArray, 0, 8);
        byArray = PortUtil.getbytes_uint32_le(this.SampleInterval);
        fileOutputStream.write(byArray, 0, 4);
        byArray = PortUtil.getbytes_double_le(this.AverageFrequency);
        fileOutputStream.write(byArray, 0, 8);
        for (n = 0; n < 4; ++n) {
            byArray = PortUtil.getbytes_int32_le(0);
            fileOutputStream.write(byArray, 0, 4);
        }
        byArray = PortUtil.getbytes_int32_le(this.NumPoints);
        fileOutputStream.write(byArray, 0, 4);
        for (n = 0; n < this.NumPoints; ++n) {
            byArray = PortUtil.getbytes_double_le(this.Frequency[n]);
            fileOutputStream.write(byArray, 0, 8);
            byArray = PortUtil.getbytes_double_le(this.Volume[n]);
            fileOutputStream.write(byArray, 0, 8);
        }
    }
}

