/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import org.kbinani.PortUtil;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.CurveType;
import org.kbinani.cadencii.OtoArgs;
import org.kbinani.cadencii.PlaySound;
import org.kbinani.cadencii.RenderingRunner;
import org.kbinani.cadencii.StraightRenderingQueue;
import org.kbinani.cadencii.UtauVoiceDB;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.media.WaveReader;
import org.kbinani.media.WaveWriter;
import org.kbinani.vsq.SingerConfig;
import org.kbinani.vsq.TempoTableEntry;
import org.kbinani.vsq.TempoVector;
import org.kbinani.vsq.VsqBPList;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqHandle;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.vsq.VsqTrack;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StraightRenderingRunner
extends RenderingRunner {
    public static String STRAIGHT_SYNTH = "vConnect.exe";
    private static final int MAX_CACHE = 512;
    private static TreeMap<String, Double> s_cache = new TreeMap();
    static final int TEMPO = 120;
    Vector<StraightRenderingQueue> m_queue;
    Vector<SingerConfig> m_singer_config_sys;
    double m_progress_percent = 0.0;
    boolean m_mode_infinite;
    TreeMap<String, UtauVoiceDB> m_voicedb_configs = new TreeMap();
    long m_vsq_length_samples;
    double m_started_date;
    double m_running_rate;

    public StraightRenderingRunner(VsqFileEx vsqFileEx, int n, Vector<SingerConfig> vector, int n2, int n3, long l, boolean bl, WaveWriter waveWriter, double d, Vector<WaveReader> vector2, boolean bl2, boolean bl3) {
        super(n, bl3, waveWriter, d, vector2, bl2, n3, l, n2);
        this.m_locker = new Object();
        this.m_queue = new Vector();
        this.m_singer_config_sys = vector;
        this.m_mode_infinite = bl;
        int n4 = 500000;
        VsqFileEx vsqFileEx2 = (VsqFileEx)vsqFileEx.clone();
        TempoVector tempoVector = new TempoVector();
        tempoVector.clear();
        tempoVector.add(new TempoTableEntry(0, n4, 0.0));
        tempoVector.updateTempoInfo();
        vsqFileEx2.adjustClockToMatchWith(tempoVector);
        vsqFileEx2.TempoTable.clear();
        vsqFileEx2.TempoTable.add(new TempoTableEntry(0, n4, 0.0));
        vsqFileEx2.updateTempoInfo();
        VsqTrack vsqTrack = (VsqTrack)vsqFileEx2.Track.get(n);
        Vector<VsqEvent> vector3 = new Vector<VsqEvent>();
        int n5 = vsqTrack.getEventCount();
        VsqEvent vsqEvent = null;
        for (int i = 0; i < n5; ++i) {
            VsqEvent vsqEvent2 = vsqTrack.getEvent(i);
            if (vsqEvent2.ID.type == VsqIDType.Singer) {
                if (vector3.size() > 0 && vsqEvent != null) {
                    this.appendQueue(vsqFileEx2, n, vector3, vsqEvent, n2);
                    vector3.clear();
                }
                vsqEvent = vsqEvent2;
                continue;
            }
            if (vsqEvent2.ID.type != VsqIDType.Anote) continue;
            vector3.add(vsqEvent2);
        }
        if (vector3.size() > 0 && vsqEvent != null) {
            this.appendQueue(vsqFileEx2, n, vector3, vsqEvent, n2);
        }
        if (this.m_queue.size() > 0) {
            StraightRenderingQueue straightRenderingQueue = this.m_queue.get(this.m_queue.size() - 1);
            this.m_vsq_length_samples = (long)straightRenderingQueue.startFrame + straightRenderingQueue.abstractFrameLength;
        }
    }

    private void appendQueue(VsqFileEx vsqFileEx, int n, Vector<VsqEvent> vector, VsqEvent vsqEvent, int n2) {
        Object object;
        int n3 = vector.size();
        if (n3 <= 0) {
            return;
        }
        VsqEvent vsqEvent2 = vector.get(0);
        VsqEvent vsqEvent3 = null;
        String string = vsqEvent.ID.IconHandle.IDS;
        int n4 = this.m_singer_config_sys.size();
        String string2 = "";
        for (int i = 0; i < n4; ++i) {
            object = this.m_singer_config_sys.get(i);
            if (!((SingerConfig)object).VOICENAME.equals(string)) continue;
            string2 = ((SingerConfig)object).VOICEIDSTR;
            break;
        }
        if (string2.equals("")) {
            return;
        }
        String string3 = PortUtil.combinePath(PortUtil.combinePath(string2, "analyzed"), "oto.ini");
        if (!PortUtil.isFileExists(string3)) {
            return;
        }
        object = null;
        if (this.m_voicedb_configs.containsKey(string3)) {
            object = this.m_voicedb_configs.get(string3);
        } else {
            object = new UtauVoiceDB(string3);
            this.m_voicedb_configs.put(string3, (UtauVoiceDB)object);
        }
        for (int i = n3 - 1; i >= 0; --i) {
            VsqEvent vsqEvent4 = vector.get(i);
            String string4 = vsqEvent4.ID.LyricHandle.L0.Phrase;
            OtoArgs otoArgs = ((UtauVoiceDB)object).attachFileNameFromLyric(string4);
            if (otoArgs.fileName != null && (otoArgs.fileName == null || !otoArgs.fileName.equals(""))) continue;
            vector.removeElementAt(i);
        }
        Vector<VsqEvent> vector2 = new Vector<VsqEvent>();
        n3 = vector.size();
        for (int i = 1; i < n3 + 1; ++i) {
            vsqEvent3 = i == n3 ? null : vector.get(i);
            double d = vsqFileEx.getSecFromClock(vsqEvent2.Clock) - (double)vsqEvent2.UstEvent.PreUtterance / 1000.0;
            double d2 = vsqFileEx.getSecFromClock(vsqEvent2.Clock + vsqEvent2.ID.getLength());
            double d3 = Double.MAX_VALUE;
            if (vsqEvent3 != null && (d3 = vsqFileEx.getSecFromClock(vsqEvent3.Clock) - (double)vsqEvent2.UstEvent.PreUtterance / 1000.0 + (double)vsqEvent2.UstEvent.VoiceOverlap / 1000.0) < d2) {
                d2 = d3;
            }
            vector2.add(vsqEvent2);
            if (d3 - d2 > 0.1 && vector2.size() > 0) {
                this.appendQueueCor(vsqFileEx, n, vector2, n2, string3);
                vector2.clear();
            }
            vsqEvent2 = vsqEvent3;
        }
        if (vector2.size() > 0) {
            this.appendQueueCor(vsqFileEx, n, vector2, n2, string3);
        }
    }

    private void appendQueueCor(VsqFileEx vsqFileEx, int n, Vector<VsqEvent> vector, int n2, String string) {
        Object object;
        Cloneable cloneable;
        int n3;
        if (vector.size() <= 0) {
            return;
        }
        int n4 = 1920;
        CurveType[] curveTypeArray = new CurveType[]{CurveType.PIT, CurveType.PBS, CurveType.DYN, CurveType.BRE, CurveType.GEN};
        VsqTrack vsqTrack = (VsqTrack)((VsqTrack)vsqFileEx.Track.get(n)).clone();
        VsqEvent vsqEvent = vector.get(0);
        int n5 = vsqEvent.Clock;
        int n6 = vsqEvent.Clock + vsqEvent.ID.getLength();
        if (vector.size() > 1) {
            VsqEvent vsqEvent2 = vector.get(vector.size() - 1);
            n6 = vsqEvent2.Clock + vsqEvent2.ID.getLength();
        }
        double d = vsqFileEx.getSecFromClock(n5);
        int n7 = n4 - n5;
        vsqTrack.MetaText.Events.clear();
        int n8 = vector.size();
        for (n3 = 0; n3 < n8; ++n3) {
            VsqEvent object22 = (VsqEvent)vector.get(n3).clone();
            object22.Clock += n7;
            vsqTrack.MetaText.Events.add(object22);
        }
        for (CurveType curveType : curveTypeArray) {
            cloneable = vsqTrack.getCurve(curveType.getName());
            if (cloneable == null) continue;
            object = (VsqBPList)((VsqBPList)cloneable).clone();
            int n9 = ((VsqBPList)cloneable).getValue(n5);
            ((VsqBPList)cloneable).clear();
            ((VsqBPList)cloneable).add(0, n9);
            int n10 = ((VsqBPList)object).size();
            for (int i = 0; i < n10; ++i) {
                int n11 = ((VsqBPList)object).getKeyClock(i);
                if (0 > n11 + n7 || n11 + n7 > n6 + n7 + 1920) continue;
                int n12 = ((VsqBPList)object).getElementA(i);
                ((VsqBPList)cloneable).add(n11 + n7, n12);
            }
        }
        n3 = 0;
        Iterator<VsqEvent> iterator = vsqTrack.getNoteEventIterator();
        while (iterator.hasNext()) {
            cloneable = iterator.next();
            n3 = ((VsqEvent)cloneable).Clock + ((VsqEvent)cloneable).ID.getLength();
        }
        double d2 = (double)n3 / 960.0;
        object = new StraightRenderingQueue();
        ((StraightRenderingQueue)object).startFrame = (int)((d - (double)n4 / 960.0) * (double)n2);
        ((StraightRenderingQueue)object).oto_ini = string;
        ((StraightRenderingQueue)object).abstractFrameLength = (long)(d2 * (double)n2);
        ((StraightRenderingQueue)object).endClock = n6 + n7 + 1920;
        ((StraightRenderingQueue)object).track = vsqTrack;
        this.m_queue.add((StraightRenderingQueue)object);
    }

    private void prepareMetaText(BufferedWriter bufferedWriter, VsqTrack vsqTrack, String string, int n) throws IOException {
        CurveType[] curveTypeArray = new CurveType[]{CurveType.PIT, CurveType.PBS, CurveType.DYN, CurveType.BRE, CurveType.GEN, CurveType.CLE, CurveType.BRI};
        bufferedWriter.write("[Tempo]");
        bufferedWriter.newLine();
        bufferedWriter.write("120");
        bufferedWriter.newLine();
        bufferedWriter.write("[oto.ini]");
        bufferedWriter.newLine();
        bufferedWriter.write(string);
        bufferedWriter.newLine();
        Vector<VsqHandle> vector = vsqTrack.MetaText.writeEventList(bufferedWriter, n);
        Vector<String> vector2 = new Vector<String>(Arrays.asList("Length", "Note#", "Dynamics", "DEMdecGainRate", "DEMaccent", "PreUtterance", "VoiceOverlap", "PMBendDepth", "PMBendLength", "PMbPortamentoUse"));
        Iterator<VsqEvent> iterator = vsqTrack.getEventIterator();
        while (iterator.hasNext()) {
            VsqEvent vsqEvent = iterator.next();
            vsqEvent.write(bufferedWriter, vector2);
        }
        int n2 = vector.size();
        for (int i = 0; i < n2; ++i) {
            vector.get(i).write(bufferedWriter);
        }
        for (CurveType curveType : curveTypeArray) {
            VsqBPList vsqBPList = vsqTrack.getCurve(curveType.getName());
            if (vsqBPList == null) continue;
            String string2 = "";
            if (curveType.equals(CurveType.PIT)) {
                string2 = "[PitchBendBPList]";
            } else if (curveType.equals(CurveType.PBS)) {
                string2 = "[PitchBendSensBPList]";
            } else if (curveType.equals(CurveType.DYN)) {
                string2 = "[DynamicsBPList]";
            } else if (curveType.equals(CurveType.BRE)) {
                string2 = "[EpRResidualBPList]";
            } else if (curveType.equals(CurveType.GEN)) {
                string2 = "[GenderFactorBPList]";
            } else if (curveType.equals(CurveType.BRI)) {
                string2 = "[EpRESlopeBPList]";
            } else {
                if (!curveType.equals(CurveType.CLE)) continue;
                string2 = "[EpRESlopeDepthBPList]";
            }
            vsqBPList.print(bufferedWriter, 0, string2);
        }
    }

    @Override
    public double getElapsedSeconds() {
        return PortUtil.getCurrentTime() - this.m_started_date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        int n;
        Object object;
        Object object2;
        Object object3;
        int n2;
        double[] dArray;
        Object object4;
        this.m_started_date = PortUtil.getCurrentTime();
        int n3 = 1024;
        this.m_rendering = true;
        this.m_abort_required = false;
        String string = PortUtil.combinePath(PortUtil.getApplicationStartupPath(), STRAIGHT_SYNTH);
        if (!PortUtil.isFileExists(string)) {
            this.m_rendering = false;
            return;
        }
        int n4 = this.m_queue.size();
        double d = 0.0;
        for (int i = 0; i < n4; ++i) {
            d += (double)this.m_queue.get((int)i).abstractFrameLength;
        }
        this.m_trim_remain = (int)((double)this.trimMillisec / 1000.0 * (double)this.sampleRate);
        long l = this.m_vsq_length_samples;
        if (this.m_queue.size() > 0) {
            object4 = this.m_queue.get(0);
            if (((StraightRenderingQueue)object4).startFrame > 0) {
                dArray = new double[n3];
                double[] dArray2 = new double[n3];
                for (int i = ((StraightRenderingQueue)object4).startFrame; i > 0; i -= n2) {
                    int n5 = n2 = i > n3 ? n3 : i;
                    if (n2 == n3) {
                        for (int j = 0; j < n3; ++j) {
                            dArray[j] = 0.0;
                            dArray2[j] = 0.0;
                        }
                        this.waveIncoming(dArray, dArray2);
                        continue;
                    }
                    double[] dArray3 = new double[i];
                    object3 = new double[i];
                    this.waveIncoming(dArray3, (double[])object3);
                }
            }
        }
        object4 = null;
        dArray = null;
        double d2 = 0.0;
        for (n2 = 0; n2 < n4; ++n2) {
            double d3;
            StraightRenderingQueue straightRenderingQueue;
            block107: {
                Object object5;
                Object object6;
                Object object7;
                if (this.m_abort_required) {
                    this.m_rendering = false;
                    this.m_abort_required = false;
                    return;
                }
                straightRenderingQueue = this.m_queue.get(n2);
                object3 = AppManager.getTempWaveDir();
                String string2 = PortUtil.combinePath((String)object3, "tmp.usq");
                object2 = "";
                object = null;
                try {
                    object = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(string2), "Shift_JIS"));
                    this.prepareMetaText((BufferedWriter)object, straightRenderingQueue.track, straightRenderingQueue.oto_ini, straightRenderingQueue.endClock);
                }
                catch (Exception exception) {
                }
                finally {
                    if (object != null) {
                        try {
                            ((BufferedWriter)object).close();
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    object2 = PortUtil.getMD5(string2).replace("_", "");
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    PortUtil.copyFile(string2, PortUtil.combinePath((String)object3, (String)object2 + ".usq"));
                    PortUtil.deleteFile(string2);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                string2 = PortUtil.combinePath((String)object3, (String)object2);
                if (!s_cache.containsKey(object2) || !PortUtil.isFileExists(string2 + ".wav")) {
                    String[] stringArray = new String[]{string, "\"" + string2 + ".usq\"", "\"" + string2 + ".wav\""};
                    ProcessBuilder processBuilder = new ProcessBuilder(stringArray);
                    try {
                        object7 = processBuilder.start();
                        ((Process)object7).waitFor();
                    }
                    catch (Exception exception) {
                        System.err.println("StraightRenderingRunner#run; ex=" + exception);
                    }
                    try {
                        PortUtil.deleteFile(string2 + ".usq");
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (s_cache.size() > 512) {
                        boolean bl = true;
                        d3 = PortUtil.getCurrentTime();
                        Object object8 = "";
                        object6 = s_cache.keySet().iterator();
                        while (object6.hasNext()) {
                            object5 = (String)object6.next();
                            double d4 = s_cache.get(object5);
                            if (bl) {
                                d3 = d4;
                                object8 = object5;
                                continue;
                            }
                            if (!(d3 > d4)) continue;
                            d3 = d4;
                            object8 = object5;
                        }
                        s_cache.remove(object8);
                        try {
                            PortUtil.deleteFile(PortUtil.combinePath((String)object3, (String)object8 + ".wav"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    s_cache.put((String)object2, PortUtil.getCurrentTime());
                }
                long l2 = l;
                if (n2 + 1 < n4) {
                    StraightRenderingQueue straightRenderingQueue2 = this.m_queue.get(n2 + 1);
                    l2 = straightRenderingQueue2.startFrame;
                }
                object7 = null;
                try {
                    if (PortUtil.isFileExists(string2 + ".wav")) {
                        object7 = new WaveReader(string2 + ".wav");
                    }
                }
                catch (Exception exception) {
                    object7 = null;
                }
                try {
                    int n6;
                    int n7;
                    int n8 = 0;
                    if (object7 != null) {
                        n8 = ((WaveReader)object7).getTotalSamples();
                    }
                    int n9 = 0;
                    if (l2 <= (long)(straightRenderingQueue.startFrame + n8)) {
                        n9 = (int)((long)(straightRenderingQueue.startFrame + n8) - l2);
                        n8 = (int)(l2 - (long)straightRenderingQueue.startFrame);
                    }
                    if (object4 == null || dArray == null) {
                        int n10;
                        long l3 = 0L;
                        double[] dArray4 = null;
                        double[] dArray5 = null;
                        for (n7 = n8; n7 > 0; n7 -= n10) {
                            if (this.m_abort_required) {
                                this.m_rendering = false;
                                return;
                            }
                            int n11 = n10 = n7 > n3 ? n3 : n7;
                            if (dArray4 == null || dArray5 == null) {
                                dArray4 = new double[n10];
                                dArray5 = new double[n10];
                            } else if (dArray4.length != n10 || dArray5.length != n10) {
                                dArray4 = null;
                                dArray5 = null;
                                dArray4 = new double[n10];
                                dArray5 = new double[n10];
                            }
                            if (object7 != null) {
                                ((WaveReader)object7).read(l3, n10, dArray4, dArray5);
                            }
                            this.waveIncoming(dArray4, dArray5);
                            l3 += (long)n10;
                        }
                        dArray4 = null;
                        dArray5 = null;
                        int n12 = 0;
                        if (object7 != null) {
                            n12 = ((WaveReader)object7).getTotalSamples();
                        }
                        if (n8 < n12) {
                            if (object7 != null) {
                                if (object4 == null) {
                                    object4 = new double[n9];
                                } else if (((StraightRenderingQueue)object4).length != n9) {
                                    object4 = null;
                                    object4 = new double[n9];
                                }
                                if (dArray == null) {
                                    dArray = new double[n9];
                                } else if (dArray.length != n9) {
                                    dArray = null;
                                    dArray = new double[n9];
                                }
                                ((WaveReader)object7).read(l3, n9, (double[])object4, dArray);
                            }
                        } else if (n2 + 1 < n4) {
                            n6 = (int)(l2 - (long)(straightRenderingQueue.startFrame + n12));
                            double[] dArray6 = new double[n6];
                            this.waveIncoming(dArray6, dArray6);
                        }
                        break block107;
                    }
                    n7 = 0;
                    if (object7 != null) {
                        n7 = ((WaveReader)object7).getTotalSamples();
                    }
                    if (n7 < ((StraightRenderingQueue)object4).length) {
                        if (l2 < (long)(straightRenderingQueue.startFrame + n7)) {
                            try {
                                int n13;
                                object6 = new double[n7];
                                object5 = new double[n7];
                                ((WaveReader)object7).read(0L, n7, (double[])object6, (double[])object5);
                                for (n13 = 0; n13 < ((double[])object6).length; ++n13) {
                                    Object object9 = object4;
                                    int n14 = n13;
                                    object9[n14] = object9[n14] + object6[n13];
                                    int n15 = n13;
                                    dArray[n15] = dArray[n15] + object5[n13];
                                }
                                n13 = (int)(l2 - (long)straightRenderingQueue.startFrame);
                                Object object10 = new double[n13];
                                double[] dArray7 = new double[n13];
                                for (n6 = 0; n6 < n13; ++n6) {
                                    object10[n6] = (double)object4[n6];
                                    dArray7[n6] = dArray[n6];
                                }
                                this.waveIncoming((double[])object10, dArray7);
                                object10 = null;
                                dArray7 = null;
                                object10 = object4;
                                dArray7 = dArray;
                                n6 = (int)((long)(straightRenderingQueue.startFrame + ((double[])object10).length) - l2);
                                object4 = new double[n6];
                                dArray = new double[n6];
                                for (int i = 0; i < n6; ++i) {
                                    object4[i] = object10[i + n13];
                                    dArray[i] = dArray7[i + n13];
                                }
                                break block107;
                            }
                            catch (Exception exception) {
                                AppManager.debugWriteLine("StraightRenderingRunner#run; (A),(B); ex=" + exception);
                                break block107;
                            }
                        }
                        try {
                            int n16;
                            object6 = new double[n7];
                            object5 = new double[n7];
                            ((WaveReader)object7).read(0L, n7, (double[])object6, (double[])object5);
                            for (n16 = 0; n16 < ((double[])object6).length; ++n16) {
                                Object object11 = object4;
                                int n17 = n16;
                                object11[n17] = object11[n17] + object6[n16];
                                int n18 = n16;
                                dArray[n18] = dArray[n18] + object5[n16];
                            }
                            this.waveIncoming((double[])object4, dArray);
                            n16 = (int)(l2 - (long)(straightRenderingQueue.startFrame + ((Object)object4).length));
                            object4 = null;
                            dArray = null;
                            object6 = new double[n16];
                            object5 = new double[n16];
                            this.waveIncoming((double[])object6, (double[])object5);
                        }
                        catch (Exception exception) {
                            AppManager.debugWriteLine("StraightRenderingRunner#run; (C); ex=" + exception);
                        }
                        break block107;
                    }
                    if (l2 < (long)(straightRenderingQueue.startFrame + ((StraightRenderingQueue)object4).length)) {
                        try {
                            int n19;
                            int n20;
                            object6 = new double[((StraightRenderingQueue)object4).length];
                            object5 = new double[((StraightRenderingQueue)object4).length];
                            ((WaveReader)object7).read(0L, ((Object)object4).length, (double[])object6, (double[])object5);
                            for (n20 = 0; n20 < ((Object)object4).length; ++n20) {
                                Object object12 = object4;
                                int n21 = n20;
                                object12[n21] = object12[n21] + object6[n20];
                                int n22 = n20;
                                dArray[n22] = dArray[n22] + object5[n20];
                            }
                            n20 = (int)(l2 - (long)straightRenderingQueue.startFrame);
                            Object object13 = new double[n20];
                            double[] dArray8 = new double[n20];
                            for (n6 = 0; n6 < n20; ++n6) {
                                object13[n6] = (double)object4[n6];
                                dArray8[n6] = dArray[n6];
                            }
                            this.waveIncoming((double[])object13, dArray8);
                            object13 = object4;
                            dArray8 = dArray;
                            n6 = (int)((long)(straightRenderingQueue.startFrame + n7) - l2);
                            object4 = new double[n6];
                            dArray = new double[n6];
                            int n23 = ((double[])object13).length;
                            for (n19 = n20; n19 < n23; ++n19) {
                                object4[n19 - n20] = object13[n19];
                                dArray[n19 - n20] = dArray8[n19];
                            }
                            n19 = n7 - n23;
                            object13 = new double[n19];
                            dArray8 = new double[n19];
                            ((WaveReader)object7).read((long)n23, n7 - n23, (double[])object13, dArray8);
                            for (int i = 0; i < ((double[])object13).length; ++i) {
                                object4[i + (n23 - n20)] = object13[i];
                                dArray[i + (n23 - n20)] = dArray8[i];
                            }
                            break block107;
                        }
                        catch (Exception exception) {
                            AppManager.debugWriteLine("StraightRenderingRunner#run; (D); ex=" + exception);
                            break block107;
                        }
                    }
                    if (l2 < (long)(straightRenderingQueue.startFrame + n7)) {
                        try {
                            int n24;
                            object6 = new double[((Object)object4).length];
                            object5 = new double[((Object)object4).length];
                            ((WaveReader)object7).read(0L, ((Object)object4).length, (double[])object6, (double[])object5);
                            for (n24 = 0; n24 < ((Object)object4).length; ++n24) {
                                Object object14 = object4;
                                int n25 = n24;
                                object14[n25] = object14[n25] + object6[n24];
                                int n26 = n24;
                                dArray[n26] = dArray[n26] + object5[n24];
                            }
                            this.waveIncoming((double[])object4, dArray);
                            n24 = (int)(l2 - (long)(straightRenderingQueue.startFrame + ((Object)object4).length));
                            object6 = null;
                            object5 = null;
                            object6 = new double[n24];
                            object5 = new double[n24];
                            ((WaveReader)object7).read((long)((Object)object4).length, n24, (double[])object6, (double[])object5);
                            this.waveIncoming((double[])object6, (double[])object5);
                            int n27 = (int)((long)(straightRenderingQueue.startFrame + n7) - l2);
                            int n28 = ((Object)object4).length;
                            object4 = null;
                            dArray = null;
                            object4 = new double[n27];
                            dArray = new double[n27];
                            ((WaveReader)object7).read((long)(n28 + n24), n27, (double[])object4, dArray);
                        }
                        catch (Exception exception) {
                            AppManager.debugWriteLine("StraightRenderingRunner#run; (E); ex=" + exception);
                        }
                    } else {
                        try {
                            int n29;
                            object6 = new double[((Object)object4).length];
                            object5 = new double[((Object)object4).length];
                            ((WaveReader)object7).read(0L, ((Object)object4).length, (double[])object6, (double[])object5);
                            for (n29 = 0; n29 < ((Object)object4).length; ++n29) {
                                Object object15 = object4;
                                int n30 = n29;
                                object15[n30] = object15[n30] + object6[n29];
                                int n31 = n29;
                                dArray[n31] = dArray[n31] + object5[n29];
                            }
                            this.waveIncoming((double[])object4, dArray);
                            object6 = null;
                            object5 = null;
                            n29 = n7 - ((Object)object4).length;
                            object6 = new double[n29];
                            object5 = new double[n29];
                            ((WaveReader)object7).read((long)((Object)object4).length, n7 - ((Object)object4).length, (double[])object6, (double[])object5);
                            this.waveIncoming((double[])object6, (double[])object5);
                            object4 = null;
                            dArray = null;
                            int n32 = (int)(l2 - (long)(straightRenderingQueue.startFrame + n7));
                            object6 = new double[n32];
                            object5 = new double[n32];
                            this.waveIncoming((double[])object6, (double[])object5);
                        }
                        catch (Exception exception) {
                            AppManager.debugWriteLine("StraightRenderingRunner#run; (F); ex=" + exception);
                        }
                    }
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("StraightRenderingRunner#run; ex=" + exception);
                }
                finally {
                    if (object7 != null) {
                        try {
                            ((WaveReader)object7).close();
                        }
                        catch (Exception exception) {
                            PortUtil.stderr.println("StraightRenderingRunner#run; ex2=" + exception);
                        }
                        object7 = null;
                    }
                }
            }
            this.m_progress_percent = (d2 += (double)straightRenderingQueue.abstractFrameLength) / d * 100.0;
            d3 = PortUtil.getCurrentTime() - this.m_started_date;
            this.m_running_rate = this.m_progress_percent / d3;
        }
        double[] dArray9 = new double[this.sampleRate];
        double[] dArray10 = new double[this.sampleRate];
        for (int i = (int)(this.totalSamples - this.m_total_append); i > 0; i -= n) {
            n = i > this.sampleRate ? this.sampleRate : i;
            object2 = null;
            object = null;
            if (n != this.sampleRate) {
                object2 = new double[n];
                object = new double[n];
            } else {
                object2 = dArray9;
                object = dArray10;
            }
            this.waveIncoming((double[])object2, (double[])object);
        }
        if (this.m_mode_infinite) {
            while (!this.m_abort_required) {
                this.waveIncoming(dArray9, dArray10);
            }
            dArray9 = null;
            dArray10 = null;
        }
        this.m_abort_required = false;
        this.m_rendering = false;
        if (this.directPlay) {
            PlaySound.waitForExit();
        }
    }

    @Override
    public double computeRemainingSeconds() {
        double d = 100.0 / this.m_running_rate;
        double d2 = PortUtil.getCurrentTime() - this.m_started_date;
        double d3 = d - d2;
        if (d3 < 0.0) {
            d3 = 0.0;
        }
        return d3;
    }

    public static void clearCache() {
        String string = AppManager.getTempWaveDir();
        for (String string2 : s_cache.keySet()) {
            try {
                PortUtil.deleteFile(PortUtil.combinePath(string, string2 + ".wav"));
            }
            catch (Exception exception) {}
        }
        s_cache.clear();
    }

    @Override
    public double getProgress() {
        return this.m_progress_percent;
    }
}

