/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import org.kbinani.PortUtil;
import org.kbinani.cadencii.Utility;
import org.kbinani.media.BSoundPlayer;

public class KeySoundPlayer {
    private static BSoundPlayer[] m_sound_previewer;
    private static BSoundPlayer m_temp_player;
    private static boolean[] m_prepared;

    public static void init() {
        m_sound_previewer = new BSoundPlayer[48];
        m_temp_player = null;
        m_prepared = new boolean[127];
        String string = Utility.getKeySoundPath();
        for (int i = 0; i <= 126; ++i) {
            String string2 = PortUtil.combinePath(string, i + ".wav");
            if (PortUtil.isFileExists(string2)) {
                KeySoundPlayer.m_prepared[i] = true;
                if (36 > i || i > 83) continue;
                try {
                    KeySoundPlayer.m_sound_previewer[i - 36] = new BSoundPlayer(string2);
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("KeySoundPlayer#init; ex=" + exception);
                }
                continue;
            }
            KeySoundPlayer.m_prepared[i] = false;
        }
    }

    public static void play(int n) {
        if (n < 0 || 127 <= n) {
            return;
        }
        if (!m_prepared[n]) {
            return;
        }
        if (36 <= n && n <= 83) {
            if (m_sound_previewer[n - 36] != null) {
                try {
                    m_sound_previewer[n - 36].play();
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("KeySoundPlayer#play; ex=" + exception);
                }
            }
        } else {
            String string;
            if (m_temp_player == null) {
                m_temp_player = new BSoundPlayer();
            }
            if (PortUtil.isFileExists(string = PortUtil.combinePath(Utility.getKeySoundPath(), n + ".wav"))) {
                m_temp_player.setSoundLocation(string);
                m_temp_player.play();
            }
        }
    }
}

