/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.AWTKeyStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.TreeMap;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.ValuePair;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.EditorConfig;
import org.kbinani.cadencii.Utility;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BFormClosingEventArgs;
import org.kbinani.windows.forms.BFormClosingEventHandler;
import org.kbinani.windows.forms.BKeyEventArgs;
import org.kbinani.windows.forms.BKeys;
import org.kbinani.windows.forms.BListView;
import org.kbinani.windows.forms.BListViewItem;
import org.kbinani.windows.forms.BPreviewKeyDownEventArgs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormShortcutKeys
extends BDialog {
    private TreeMap<String, ValuePair<String, BKeys[]>> m_dict;
    private TreeMap<String, ValuePair<String, BKeys[]>> m_first_dict;
    private static int columnWidthCommand = 240;
    private static int columnWidthShortcutKey = 140;
    private static final long serialVersionUID = 2743132471603994391L;
    private JPanel jPanel = null;
    private BListView list = null;
    private JPanel jPanel3 = null;
    private BButton btnLoadDefault = null;
    private BButton btnRevert = null;
    private JPanel jPanel31 = null;
    private BButton btnCancel = null;
    private BButton btnOK = null;

    public FormShortcutKeys(TreeMap<String, ValuePair<String, BKeys[]>> treeMap) {
        try {
            this.initialize();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.list.setColumnHeaders(new String[]{"Command", "Shortcut Key"});
        this.list.setColumnWidth(0, columnWidthCommand);
        this.list.setColumnWidth(1, columnWidthShortcutKey);
        this.registerEventHandlers();
        this.setResources();
        this.applyLanguage();
        this.m_dict = treeMap;
        this.m_first_dict = new TreeMap();
        FormShortcutKeys.CopyDict(this.m_dict, this.m_first_dict);
        this.UpdateList();
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
    }

    public void applyLanguage() {
        this.setTitle(FormShortcutKeys._("Shortcut Config"));
        this.btnOK.setText(FormShortcutKeys._("OK"));
        this.btnCancel.setText(FormShortcutKeys._("Cancel"));
        this.btnRevert.setText(FormShortcutKeys._("Revert"));
        this.btnLoadDefault.setText(FormShortcutKeys._("Load Default"));
        this.list.setColumnHeaders(new String[]{FormShortcutKeys._("Command"), FormShortcutKeys._("Shortcut Key")});
        System.err.println("info; FormShortcutKeys#applyLanguage; \"toolTip.SetToolTip( list, _( \"Select command and hit key(s) you want to set.\\nHit Backspace if you want to remove shortcut key.\" ) )");
        int n = this.list.getGroupCount();
        for (int i = 0; i < n; ++i) {
            String string = this.list.getGroupNameAt(i);
            if (string.equals("listGroupFile")) {
                this.list.setGroupHeader(string, FormShortcutKeys._("File"));
                continue;
            }
            if (string.equals("listGroupEdit")) {
                this.list.setGroupHeader(string, FormShortcutKeys._("Edit"));
                continue;
            }
            if (string.equals("listGroupVisual")) {
                this.list.setGroupHeader(string, FormShortcutKeys._("View"));
                continue;
            }
            if (string.equals("listGroupJob")) {
                this.list.setGroupHeader(string, FormShortcutKeys._("Job"));
                continue;
            }
            if (string.equals("listGroupLyric")) {
                this.list.setGroupHeader(string, FormShortcutKeys._("Lyrics"));
                continue;
            }
            if (string.equals("listGroupSetting")) {
                this.list.setGroupHeader(string, FormShortcutKeys._("Setting"));
                continue;
            }
            if (string.equals("listGroupHelp")) {
                this.list.setGroupHeader(string, FormShortcutKeys._("Help"));
                continue;
            }
            if (string.equals("listGroupTrack")) {
                this.list.setGroupHeader(string, FormShortcutKeys._("Track"));
                continue;
            }
            if (string.equals("listGroupScript")) {
                this.list.setGroupHeader(string, FormShortcutKeys._("Script"));
                continue;
            }
            if (!string.equals("listGroupOther")) continue;
            this.list.setGroupHeader(string, FormShortcutKeys._("Others"));
        }
    }

    public TreeMap<String, ValuePair<String, BKeys[]>> getResult() {
        TreeMap<String, ValuePair<String, BKeys[]>> treeMap = new TreeMap<String, ValuePair<String, BKeys[]>>();
        FormShortcutKeys.CopyDict(this.m_dict, treeMap);
        return treeMap;
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private static void CopyDict(TreeMap<String, ValuePair<String, BKeys[]>> treeMap, TreeMap<String, ValuePair<String, BKeys[]>> treeMap2) {
        treeMap2.clear();
        for (String string : treeMap.keySet()) {
            String string2 = treeMap.get(string).getKey();
            BKeys[] bKeysArray = treeMap.get(string).getValue();
            Vector<BKeys> vector = new Vector<BKeys>();
            for (BKeys bKeys : bKeysArray) {
                vector.add(bKeys);
            }
            treeMap2.put(string, new ValuePair<String, BKeys[]>(string2, vector.toArray(new BKeys[0])));
        }
    }

    private void UpdateList() {
        this.list.clear();
        for (String string : this.m_dict.keySet()) {
            Vector<BKeys> vector = new Vector<BKeys>();
            for (BKeys bKeys : this.m_dict.get(string).getValue()) {
                vector.add(bKeys);
            }
            BListViewItem bListViewItem = new BListViewItem(new String[]{string, Utility.getShortcutDisplayString(vector.toArray(new BKeys[0]))});
            String string2 = this.m_dict.get(string).getKey();
            bListViewItem.setName(string2);
            String string3 = "";
            string3 = string2.startsWith("menuFile") ? "listGroupFile" : (string2.startsWith("menuEdit") ? "listGroupEdit" : (string2.startsWith("menuVisual") ? "listGroupVisual" : (string2.startsWith("menuJob") ? "listGroupJob" : (string2.startsWith("menuLyric") ? "listGroupLyric" : (string2.startsWith("menuTrack") ? "listGroupTrack" : (string2.startsWith("menuScript") ? "listGroupScript" : (string2.startsWith("menuSetting") ? "listGroupSetting" : (string2.startsWith("menuHelp") ? "listGroupHelp" : "listGroupOther"))))))));
            this.list.addItem(string3, bListViewItem);
        }
        this.UpdateColor();
        this.applyLanguage();
    }

    private void UpdateColor() {
        int n = this.list.getGroupCount();
        for (int i = 0; i < n; ++i) {
            String string = this.list.getGroupNameAt(i);
            for (int j = 0; j < this.list.getItemCount(string); ++j) {
                String string2 = this.list.getItemAt(string, j).getSubItemAt(1);
                if (string2.equals("")) {
                    this.list.setItemBackColorAt(string, j, Color.white);
                    continue;
                }
                boolean bl = false;
                for (int k = 0; k < n; ++k) {
                    String string3 = this.list.getGroupNameAt(k);
                    for (int i2 = 0; i2 < this.list.getItemCount(string3); ++i2) {
                        if (k == i && j == i2 || !string2.equals(this.list.getItemAt(string3, i2).getSubItemAt(1))) continue;
                        bl = true;
                        break;
                    }
                    if (bl) break;
                }
                if (bl) {
                    this.list.setItemBackColorAt(string, j, Color.yellow);
                    continue;
                }
                this.list.setItemBackColorAt(string, j, Color.white);
            }
        }
    }

    private void registerEventHandlers() {
        this.btnLoadDefault.clickEvent.add(new BEventHandler(this, "btnLoadDefault_Click"));
        this.btnRevert.clickEvent.add(new BEventHandler(this, "btnRevert_Click"));
        this.formClosingEvent.add(new BFormClosingEventHandler(this, "FormShortcutKeys_FormClosing"));
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
    }

    private void setResources() {
    }

    public void list_PreviewKeyDown(Object object, BPreviewKeyDownEventArgs bPreviewKeyDownEventArgs) {
    }

    public void list_KeyDown(Object object, BKeyEventArgs bKeyEventArgs) {
        Object object22;
        int n;
        Object object3;
        int n2;
        Object object4 = "";
        int n3 = -1;
        int n4 = this.list.getGroupCount();
        for (n2 = 0; n2 < n4; ++n2) {
            object3 = this.list.getGroupNameAt(n2);
            n = this.list.getSelectedIndex((String)object3);
            if (n < 0) continue;
            object4 = object3;
            n3 = n;
            break;
        }
        if (n3 < 0) {
            return;
        }
        n2 = n3;
        object3 = KeyStroke.getKeyStroke(bKeyEventArgs.getKeyCode(), bKeyEventArgs.getModifiers());
        n = ((AWTKeyStroke)object3).getKeyCode();
        int n5 = ((AWTKeyStroke)object3).getModifiers();
        Vector<BKeys> vector = new Vector<BKeys>();
        BKeys bKeys = BKeys.None;
        for (Object object22 : AppManager.SHORTCUT_ACCEPTABLE) {
            if (n != object22.getValue()) continue;
            vector.add((BKeys)((Object)object22));
            if ((n5 & 8) == 8) {
                vector.add(BKeys.Alt);
            }
            if ((n5 & 2) == 2) {
                vector.add(BKeys.Control);
            }
            if ((n5 & 1) == 1) {
                vector.add(BKeys.Shift);
            }
            bKeys = object22;
            break;
        }
        BListViewItem bListViewItem = this.list.getItemAt((String)object4, n2);
        bListViewItem.setSubItemAt(1, Utility.getShortcutDisplayString(vector.toArray(new BKeys[0])));
        this.list.setItemAt((String)object4, n2, bListViewItem);
        object22 = this.list.getItemAt((String)object4, n2).getSubItemAt(0);
        if (this.m_dict.containsKey(object22)) {
            this.m_dict.get(object22).setValue(vector.toArray(new BKeys[0]));
        }
        this.UpdateColor();
    }

    public void btnRevert_Click(Object object, BEventArgs bEventArgs) {
        FormShortcutKeys.CopyDict(this.m_first_dict, this.m_dict);
        this.UpdateList();
    }

    public void btnLoadDefault_Click(Object object, BEventArgs bEventArgs) {
        block0: for (int i = 0; i < EditorConfig.DEFAULT_SHORTCUT_KEYS.size(); ++i) {
            String string = EditorConfig.DEFAULT_SHORTCUT_KEYS.get((int)i).Key;
            BKeys[] bKeysArray = EditorConfig.DEFAULT_SHORTCUT_KEYS.get((int)i).Value;
            for (String string2 : this.m_dict.keySet()) {
                if (!string.equals(this.m_dict.get(string2).getKey())) continue;
                this.m_dict.get(string2).setValue(bKeysArray);
                continue block0;
            }
        }
        this.UpdateList();
    }

    public void FormShortcutKeys_FormClosing(Object object, BFormClosingEventArgs bFormClosingEventArgs) {
        columnWidthCommand = this.list.getColumnWidth(0);
        columnWidthShortcutKey = this.list.getColumnWidth(1);
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.OK);
    }

    private void initialize() {
        this.setSize(new Dimension(396, 468));
        this.setTitle("Shortcut Config");
        this.setContentPane(this.getJPanel());
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            gridBagConstraints.insets = new Insets(0, 0, 16, 12);
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 12, 12, 0);
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.insets = new Insets(12, 12, 6, 12);
            gridBagConstraints3.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getList(), gridBagConstraints3);
            this.jPanel.add((Component)this.getJPanel3(), gridBagConstraints2);
            this.jPanel.add((Component)this.getJPanel31(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private BListView getList() {
        if (this.list == null) {
            this.list = new BListView();
        }
        return this.list;
    }

    private JPanel getJPanel3() {
        if (this.jPanel3 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 2;
            this.jPanel3 = new JPanel();
            this.jPanel3.setLayout(new GridBagLayout());
            this.jPanel3.add((Component)this.getBtnLoadDefault(), gridBagConstraints2);
            this.jPanel3.add((Component)this.getBtnRevert(), gridBagConstraints);
        }
        return this.jPanel3;
    }

    private BButton getBtnLoadDefault() {
        if (this.btnLoadDefault == null) {
            this.btnLoadDefault = new BButton();
            this.btnLoadDefault.setText("Load Default");
        }
        return this.btnLoadDefault;
    }

    private BButton getBtnRevert() {
        if (this.btnRevert == null) {
            this.btnRevert = new BButton();
            this.btnRevert.setText("Revert");
        }
        return this.btnRevert;
    }

    private JPanel getJPanel31() {
        if (this.jPanel31 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridx = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.gridx = 2;
            this.jPanel31 = new JPanel();
            this.jPanel31.setLayout(new GridBagLayout());
            this.jPanel31.add((Component)this.getBtnCancel(), gridBagConstraints2);
            this.jPanel31.add((Component)this.getBtnOK(), gridBagConstraints);
        }
        return this.jPanel31;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }
}

