/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Iterator;
import javax.swing.JPanel;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.vsq.NoteHeadHandle;
import org.kbinani.vsq.SynthesizerType;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BCheckBox;
import org.kbinani.windows.forms.BComboBox;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BGroupBox;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BPanel;
import org.kbinani.windows.forms.BSlider;
import org.kbinani.windows.forms.BTextBox;

public class FormNoteExpressionConfig
extends BDialog {
    boolean m_apply_current_track = false;
    NoteHeadHandle m_note_head_handle = null;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private BPanel panelVocaloid2Template = null;
    private BLabel lblTemplate = null;
    private BComboBox comboTemplate = null;
    private BLabel jLabel1 = null;
    private BGroupBox groupPitchControl = null;
    private BLabel lblBendDepth = null;
    private BSlider trackBendDepth = null;
    private BTextBox txtBendDepth = null;
    private BLabel jLabel3 = null;
    private BLabel lblBendLength = null;
    private BSlider trackBendLength = null;
    private BTextBox txtBendLength = null;
    private BLabel jLabel5 = null;
    private BCheckBox chkUpPortamento = null;
    private BCheckBox chkDownPortamento = null;
    private BLabel jLabel6 = null;
    private BGroupBox groupDynamicsControl = null;
    private BLabel lblDecay = null;
    private BSlider trackDecay = null;
    private BTextBox txtDecay = null;
    private BLabel jLabel31 = null;
    private BLabel lblAccent = null;
    private BSlider trackAccent = null;
    private BTextBox txtAccent = null;
    private BLabel jLabel51 = null;
    private BLabel jLabel61 = null;
    private BGroupBox groupAttack = null;
    private BLabel lblDuration = null;
    private BSlider trackDuration = null;
    private BTextBox txtDuration = null;
    private BLabel jLabel311 = null;
    private BLabel lblDepth = null;
    private BSlider trackDepth = null;
    private BTextBox txtDepth = null;
    private BLabel jLabel511 = null;
    private BLabel jLabel611 = null;
    private BLabel lblAttackTemplate = null;
    private BComboBox comboAttackTemplate = null;
    private BPanel jPanel2 = null;
    private BButton btnOK = null;
    private BButton btnCancel = null;

    public FormNoteExpressionConfig(SynthesizerType synthesizerType, NoteHeadHandle noteHeadHandle) {
        this.initialize();
        this.registerEventHandlers();
        this.setResources();
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
        this.applyLanguage();
        if (noteHeadHandle != null) {
            this.m_note_head_handle = (NoteHeadHandle)noteHeadHandle.clone();
        }
        if (synthesizerType == SynthesizerType.VOCALOID1) {
            this.getContentPane().remove(this.groupDynamicsControl);
            this.getContentPane().remove(this.panelVocaloid2Template);
            this.getContentPane().remove(this.groupPitchControl);
        } else {
            this.getContentPane().remove(this.groupAttack);
        }
        NoteHeadHandle noteHeadHandle2 = new NoteHeadHandle();
        this.comboAttackTemplate.removeAllItems();
        noteHeadHandle2.IconID = "$01010000";
        noteHeadHandle2.setCaption("[Non Attack]");
        this.comboAttackTemplate.addItem(noteHeadHandle2);
        this.comboAttackTemplate.setSelectedItem(noteHeadHandle2);
        String string = "";
        if (this.m_note_head_handle != null) {
            string = this.m_note_head_handle.IconID;
            this.txtDuration.setText(this.m_note_head_handle.getDuration() + "");
            this.txtDepth.setText(this.m_note_head_handle.getDepth() + "");
        } else {
            this.txtDuration.setEnabled(false);
            this.txtDepth.setEnabled(false);
            this.trackDuration.setEnabled(false);
            this.trackDepth.setEnabled(false);
        }
        Iterator<NoteHeadHandle> iterator = VocaloSysUtil.attackConfigIterator(SynthesizerType.VOCALOID1);
        while (iterator.hasNext()) {
            NoteHeadHandle noteHeadHandle3 = iterator.next();
            this.comboAttackTemplate.addItem(noteHeadHandle3);
            if (!noteHeadHandle3.IconID.equals(string)) continue;
            this.comboAttackTemplate.setSelectedItem(this.comboAttackTemplate.getItemAt(this.comboAttackTemplate.getItemCount() - 1));
        }
        this.comboAttackTemplate.selectedIndexChangedEvent.add(new BEventHandler(this, "comboAttackTemplate_SelectedIndexChanged"));
    }

    public NoteHeadHandle getEditedNoteHeadHandle() {
        return this.m_note_head_handle;
    }

    public void applyLanguage() {
        this.lblTemplate.setText(FormNoteExpressionConfig._("Template") + "(&T)");
        this.groupPitchControl.setTitle(FormNoteExpressionConfig._("Pitch Control"));
        this.lblBendDepth.setText(FormNoteExpressionConfig._("Bend Depth") + "(&B)");
        this.lblBendLength.setText(FormNoteExpressionConfig._("Bend Length") + "(&L)");
        this.chkUpPortamento.setText(FormNoteExpressionConfig._("Add portamento in rising movement") + "(&R)");
        this.chkDownPortamento.setText(FormNoteExpressionConfig._("Add portamento in falling movement") + "(&F)");
        this.groupAttack.setTitle(FormNoteExpressionConfig._("Attack Control (VOCALOID1)"));
        this.groupDynamicsControl.setTitle(FormNoteExpressionConfig._("Dynamics Control (VOCALOID2)"));
        this.lblDecay.setText(FormNoteExpressionConfig._("Decay") + "(&D)");
        this.lblAccent.setText(FormNoteExpressionConfig._("Accent") + "(&A)");
        this.btnOK.setText(FormNoteExpressionConfig._("OK"));
        this.btnCancel.setText(FormNoteExpressionConfig._("Cancel"));
        this.setTitle(FormNoteExpressionConfig._("Expression control property"));
    }

    public int getPMBendDepth() {
        return this.trackBendDepth.getValue();
    }

    public void setPMBendDepth(int n) {
        this.trackBendDepth.setValue(n);
        this.txtBendDepth.setText(n + "");
    }

    public int getPMBendLength() {
        return this.trackBendLength.getValue();
    }

    public void setPMBendLength(int n) {
        this.trackBendLength.setValue(n);
        this.txtBendLength.setText(n + "");
    }

    public int getPMbPortamentoUse() {
        int n = 0;
        if (this.chkUpPortamento.isSelected()) {
            ++n;
        }
        if (this.chkDownPortamento.isSelected()) {
            n += 2;
        }
        return n;
    }

    public void setPMbPortamentoUse(int n) {
        if (n % 2 == 1) {
            this.chkUpPortamento.setSelected(true);
        } else {
            this.chkUpPortamento.setSelected(false);
        }
        if (n >= 2) {
            this.chkDownPortamento.setSelected(true);
        } else {
            this.chkDownPortamento.setSelected(false);
        }
    }

    public int getDEMdecGainRate() {
        return this.trackDecay.getValue();
    }

    public void setDEMdecGainRate(int n) {
        this.trackDecay.setValue(n);
        this.txtDecay.setText(n + "");
    }

    public int getDEMaccent() {
        return this.trackAccent.getValue();
    }

    public void setDEMaccent(int n) {
        this.trackAccent.setValue(n);
        this.txtAccent.setText(n + "");
    }

    public boolean getApplyCurrentTrack() {
        return this.m_apply_current_track;
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.txtBendLength.textChangedEvent.add(new BEventHandler(this, "txtBendLength_TextChanged"));
        this.txtBendDepth.textChangedEvent.add(new BEventHandler(this, "txtBendDepth_TextChanged"));
        this.trackBendLength.valueChangedEvent.add(new BEventHandler(this, "trackBendLength_Scroll"));
        this.trackBendDepth.valueChangedEvent.add(new BEventHandler(this, "trackBendDepth_Scroll"));
        this.txtAccent.textChangedEvent.add(new BEventHandler(this, "txtAccent_TextChanged"));
        this.txtDecay.textChangedEvent.add(new BEventHandler(this, "txtDecay_TextChanged"));
        this.trackAccent.valueChangedEvent.add(new BEventHandler(this, "trackAccent_Scroll"));
        this.trackDecay.valueChangedEvent.add(new BEventHandler(this, "trackDecay_Scroll"));
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.comboTemplate.selectedIndexChangedEvent.add(new BEventHandler(this, "comboBox1_SelectedIndexChanged"));
        this.txtDepth.textChangedEvent.add(new BEventHandler(this, "txtDepth_TextChanged"));
        this.txtDuration.textChangedEvent.add(new BEventHandler(this, "txtDuration_TextChanged"));
        this.trackDepth.valueChangedEvent.add(new BEventHandler(this, "trackDepth_Scroll"));
        this.trackDuration.valueChangedEvent.add(new BEventHandler(this, "trackDuration_Scroll"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
    }

    private void setResources() {
    }

    public void comboAttackTemplate_SelectedIndexChanged(Object object, BEventArgs bEventArgs) {
        int n = this.comboAttackTemplate.getSelectedIndex();
        if (n < 0) {
            return;
        }
        if (n == 0) {
            this.m_note_head_handle = null;
            this.txtDuration.setEnabled(false);
            this.trackDuration.setEnabled(false);
            this.txtDepth.setEnabled(false);
            this.trackDepth.setEnabled(false);
            return;
        }
        this.txtDuration.setEnabled(true);
        this.trackDuration.setEnabled(true);
        this.txtDepth.setEnabled(true);
        this.trackDepth.setEnabled(true);
        NoteHeadHandle noteHeadHandle = (NoteHeadHandle)this.comboAttackTemplate.getSelectedItem();
        if (this.m_note_head_handle == null) {
            this.txtDuration.setText(noteHeadHandle.getDuration() + "");
            this.txtDepth.setText(noteHeadHandle.getDepth() + "");
        }
        this.m_note_head_handle = (NoteHeadHandle)noteHeadHandle.clone();
        this.m_note_head_handle.setDuration(this.trackDuration.getValue());
        this.m_note_head_handle.setDepth(this.trackDepth.getValue());
    }

    public void trackBendDepth_Scroll(Object object, BEventArgs bEventArgs) {
        this.txtBendDepth.setText(this.trackBendDepth.getValue() + "");
    }

    public void txtBendDepth_TextChanged(Object object, BEventArgs bEventArgs) {
        try {
            int n = PortUtil.parseInt(this.txtBendDepth.getText());
            if (n != this.trackBendDepth.getValue()) {
                if (n < this.trackBendDepth.getMinimum()) {
                    n = this.trackBendDepth.getMinimum();
                    this.txtBendDepth.setText(n + "");
                } else if (this.trackBendDepth.getMaximum() < n) {
                    n = this.trackBendDepth.getMaximum();
                    this.txtBendDepth.setText(n + "");
                }
                this.trackBendDepth.setValue(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackBendLength_Scroll(Object object, BEventArgs bEventArgs) {
        this.txtBendLength.setText(this.trackBendLength.getValue() + "");
    }

    public void txtBendLength_TextChanged(Object object, BEventArgs bEventArgs) {
        try {
            int n = PortUtil.parseInt(this.txtBendLength.getText());
            if (n != this.trackBendLength.getValue()) {
                if (n < this.trackBendLength.getMinimum()) {
                    n = this.trackBendLength.getMinimum();
                    this.txtBendLength.setText(n + "");
                } else if (this.trackBendLength.getMaximum() < n) {
                    n = this.trackBendLength.getMaximum();
                    this.txtBendLength.setText(n + "");
                }
                this.trackBendLength.setValue(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackDecay_Scroll(Object object, BEventArgs bEventArgs) {
        this.txtDecay.setText(this.trackDecay.getValue() + "");
    }

    public void txtDecay_TextChanged(Object object, BEventArgs bEventArgs) {
        try {
            int n = PortUtil.parseInt(this.txtDecay.getText());
            if (n != this.trackDecay.getValue()) {
                if (n < this.trackDecay.getMinimum()) {
                    n = this.trackDecay.getMinimum();
                    this.txtDecay.setText(n + "");
                } else if (this.trackDecay.getMaximum() < n) {
                    n = this.trackDecay.getMaximum();
                    this.txtDecay.setText(n + "");
                }
                this.trackDecay.setValue(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void trackAccent_Scroll(Object object, BEventArgs bEventArgs) {
        this.txtAccent.setText(this.trackAccent.getValue() + "");
    }

    public void txtAccent_TextChanged(Object object, BEventArgs bEventArgs) {
        try {
            int n = PortUtil.parseInt(this.txtAccent.getText());
            if (n != this.trackAccent.getValue()) {
                if (n < this.trackAccent.getMinimum()) {
                    n = this.trackAccent.getMinimum();
                    this.txtAccent.setText(n + "");
                } else if (this.trackAccent.getMaximum() < n) {
                    n = this.trackAccent.getMaximum();
                    this.txtAccent.setText(n + "");
                }
                this.trackAccent.setValue(n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.OK);
    }

    public void comboBox1_SelectedIndexChanged(Object object, BEventArgs bEventArgs) {
        switch (this.comboTemplate.getSelectedIndex()) {
            case 1: {
                this.setPMBendDepth(8);
                this.setPMBendLength(0);
                this.setPMbPortamentoUse(0);
                this.setDEMdecGainRate(50);
                this.setDEMaccent(50);
                break;
            }
            case 2: {
                this.setPMBendDepth(8);
                this.setPMBendLength(0);
                this.setPMbPortamentoUse(0);
                this.setDEMdecGainRate(50);
                this.setDEMaccent(68);
                break;
            }
            case 3: {
                this.setPMBendDepth(8);
                this.setPMBendLength(0);
                this.setPMbPortamentoUse(0);
                this.setDEMdecGainRate(70);
                this.setDEMaccent(80);
                break;
            }
            case 4: {
                this.setPMBendDepth(20);
                this.setPMBendLength(0);
                this.setPMbPortamentoUse(3);
                this.setDEMdecGainRate(50);
                this.setDEMaccent(42);
                break;
            }
            case 5: {
                this.setPMBendDepth(20);
                this.setPMBendLength(0);
                this.setPMbPortamentoUse(3);
                this.setDEMdecGainRate(50);
                this.setDEMaccent(25);
            }
        }
    }

    public void btnApply_Click(Object object, BEventArgs bEventArgs) {
        if (AppManager.showMessageBox(FormNoteExpressionConfig._("Would you like to change singer style for all events?"), "Cadencii", 0, 2) == BDialogResult.YES) {
            this.m_apply_current_track = true;
            this.setDialogResult(BDialogResult.OK);
        }
    }

    public void trackDuration_Scroll(Object object, BEventArgs bEventArgs) {
        this.txtDuration.setText(this.trackDuration.getValue() + "");
        if (this.m_note_head_handle != null) {
            this.m_note_head_handle.setDuration(this.trackDuration.getValue());
        }
    }

    public void trackDepth_Scroll(Object object, BEventArgs bEventArgs) {
        this.txtDepth.setText(this.trackDepth.getValue() + "");
        if (this.m_note_head_handle != null) {
            this.m_note_head_handle.setDepth(this.trackDepth.getValue());
        }
    }

    public void txtDuration_TextChanged(Object object, BEventArgs bEventArgs) {
        try {
            int n = PortUtil.parseInt(this.txtDuration.getText());
            if (n != this.trackDuration.getValue()) {
                if (n < this.trackDuration.getMinimum()) {
                    n = this.trackDuration.getMinimum();
                } else if (this.trackDuration.getMaximum() < n) {
                    n = this.trackDuration.getMaximum();
                }
                this.txtDuration.setText(n + "");
                this.trackDuration.setValue(n);
                if (this.m_note_head_handle != null) {
                    this.m_note_head_handle.setDuration(n);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void txtDepth_TextChanged(Object object, BEventArgs bEventArgs) {
        try {
            int n = PortUtil.parseInt(this.txtDepth.getText());
            if (n != this.trackDepth.getValue()) {
                if (n < this.trackDepth.getMinimum()) {
                    n = this.trackDepth.getMinimum();
                } else if (this.trackDepth.getMaximum() < n) {
                    n = this.trackDepth.getMaximum();
                }
                this.txtDepth.setText(n + "");
                this.trackDepth.setValue(n);
                if (this.m_note_head_handle != null) {
                    this.m_note_head_handle.setDepth(this.trackDepth.getValue());
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    private void initialize() {
        this.setSize(403, 461);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Default Singer Style");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.insets = new Insets(16, 0, 16, 0);
            gridBagConstraints.anchor = 14;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.fill = 3;
            gridBagConstraints.gridy = 4;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.insets = new Insets(12, 12, 0, 12);
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 2;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.insets = new Insets(12, 12, 0, 12);
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.anchor = 11;
            gridBagConstraints4.insets = new Insets(12, 12, 0, 12);
            gridBagConstraints4.gridy = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.fill = 2;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.anchor = 11;
            gridBagConstraints5.insets = new Insets(12, 12, 0, 12);
            gridBagConstraints5.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPanelVocaloid2Template(), gridBagConstraints5);
            this.jContentPane.add((Component)this.getGroupPitchControl(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getGroupDynamicsControl(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getGroupAttack(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJPanel2(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private BPanel getPanelVocaloid2Template() {
        if (this.panelVocaloid2Template == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridy = 0;
            this.jLabel1 = new BLabel();
            this.jLabel1.setText("");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.fill = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints2.gridx = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 1;
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.gridy = 0;
            this.lblTemplate = new BLabel();
            this.lblTemplate.setText("Template");
            this.panelVocaloid2Template = new BPanel();
            this.panelVocaloid2Template.setLayout(new GridBagLayout());
            this.panelVocaloid2Template.add((Component)this.lblTemplate, gridBagConstraints3);
            this.panelVocaloid2Template.add((Component)this.getComboTemplate(), gridBagConstraints2);
            this.panelVocaloid2Template.add((Component)this.jLabel1, gridBagConstraints);
        }
        return this.panelVocaloid2Template;
    }

    private BComboBox getComboTemplate() {
        if (this.comboTemplate == null) {
            this.comboTemplate = new BComboBox();
            this.comboTemplate.setPreferredSize(new Dimension(121, 22));
        }
        return this.comboTemplate;
    }

    private BGroupBox getGroupPitchControl() {
        if (this.groupPitchControl == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.gridy = 4;
            this.jLabel6 = new BLabel();
            this.jLabel6.setText("");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints2.gridy = 3;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridwidth = 4;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridy = 1;
            this.jLabel5 = new BLabel();
            this.jLabel5.setText("%");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints5.gridx = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.gridy = 1;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridy = 1;
            this.lblBendLength = new BLabel();
            this.lblBendLength.setText("Bend Length");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 3;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.gridy = 0;
            this.jLabel3 = new BLabel();
            this.jLabel3.setText("%");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 0;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.weightx = 1.0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints9.gridx = 2;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 0;
            gridBagConstraints10.gridy = 0;
            gridBagConstraints10.weightx = 0.0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridy = 0;
            this.lblBendDepth = new BLabel();
            this.lblBendDepth.setText("Bend Depth");
            this.groupPitchControl = new BGroupBox();
            this.groupPitchControl.setLayout(new GridBagLayout());
            this.groupPitchControl.setTitle("Pitch Control (VOCALOID2)");
            this.groupPitchControl.add((Component)this.lblBendDepth, gridBagConstraints11);
            this.groupPitchControl.add((Component)this.getTrackBendDepth(), gridBagConstraints10);
            this.groupPitchControl.add((Component)this.getTxtBendDepth(), gridBagConstraints9);
            this.groupPitchControl.add((Component)this.jLabel3, gridBagConstraints8);
            this.groupPitchControl.add((Component)this.lblBendLength, gridBagConstraints7);
            this.groupPitchControl.add((Component)this.getTrackBendLength(), gridBagConstraints6);
            this.groupPitchControl.add((Component)this.getTxtBendLength(), gridBagConstraints5);
            this.groupPitchControl.add((Component)this.jLabel5, gridBagConstraints4);
            this.groupPitchControl.add((Component)this.getChkUpPortamento(), gridBagConstraints3);
            this.groupPitchControl.add((Component)this.getChkDownPortamento(), gridBagConstraints2);
            this.groupPitchControl.add((Component)this.jLabel6, gridBagConstraints);
        }
        return this.groupPitchControl;
    }

    private BSlider getTrackBendDepth() {
        if (this.trackBendDepth == null) {
            this.trackBendDepth = new BSlider();
            this.trackBendDepth.setPreferredSize(new Dimension(156, 18));
            this.trackBendDepth.setValue(8);
        }
        return this.trackBendDepth;
    }

    private BTextBox getTxtBendDepth() {
        if (this.txtBendDepth == null) {
            this.txtBendDepth = new BTextBox();
            this.txtBendDepth.setText("8");
            this.txtBendDepth.setHorizontalAlignment(4);
            this.txtBendDepth.setPreferredSize(new Dimension(39, 19));
        }
        return this.txtBendDepth;
    }

    private BSlider getTrackBendLength() {
        if (this.trackBendLength == null) {
            this.trackBendLength = new BSlider();
            this.trackBendLength.setPreferredSize(new Dimension(156, 18));
            this.trackBendLength.setValue(0);
        }
        return this.trackBendLength;
    }

    private BTextBox getTxtBendLength() {
        if (this.txtBendLength == null) {
            this.txtBendLength = new BTextBox();
            this.txtBendLength.setText("0");
            this.txtBendLength.setPreferredSize(new Dimension(39, 19));
            this.txtBendLength.setHorizontalAlignment(4);
        }
        return this.txtBendLength;
    }

    private BCheckBox getChkUpPortamento() {
        if (this.chkUpPortamento == null) {
            this.chkUpPortamento = new BCheckBox();
            this.chkUpPortamento.setText("Add portamento in rising movement");
        }
        return this.chkUpPortamento;
    }

    private BCheckBox getChkDownPortamento() {
        if (this.chkDownPortamento == null) {
            this.chkDownPortamento = new BCheckBox();
            this.chkDownPortamento.setText("Add portamento in falling movement");
        }
        return this.chkDownPortamento;
    }

    private BGroupBox getGroupDynamicsControl() {
        if (this.groupDynamicsControl == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.gridwidth = 4;
            this.jLabel61 = new BLabel();
            this.jLabel61.setText("");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 3;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.fill = 2;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.gridy = 1;
            this.jLabel51 = new BLabel();
            this.jLabel51.setText("%");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 0;
            gridBagConstraints3.gridy = 1;
            gridBagConstraints3.weightx = 0.0;
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridx = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 0;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 0.0;
            gridBagConstraints4.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.gridx = 1;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.insets = new Insets(0, 12, 0, 0);
            this.lblAccent = new BLabel();
            this.lblAccent.setText("Accent");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 3;
            gridBagConstraints6.weightx = 1.0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridy = 0;
            this.jLabel31 = new BLabel();
            this.jLabel31.setText("%");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 0;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 0.0;
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridx = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.fill = 0;
            gridBagConstraints8.gridy = 0;
            gridBagConstraints8.weightx = 0.0;
            gridBagConstraints8.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridx = 1;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.gridy = 0;
            gridBagConstraints9.insets = new Insets(0, 12, 0, 0);
            this.lblDecay = new BLabel();
            this.lblDecay.setText("Decay");
            this.groupDynamicsControl = new BGroupBox();
            this.groupDynamicsControl.setLayout(new GridBagLayout());
            this.groupDynamicsControl.setTitle("Dynamics Control (VOCALOID2)");
            this.groupDynamicsControl.add((Component)this.lblDecay, gridBagConstraints9);
            this.groupDynamicsControl.add((Component)this.getTrackDecay(), gridBagConstraints8);
            this.groupDynamicsControl.add((Component)this.getTxtDecay(), gridBagConstraints7);
            this.groupDynamicsControl.add((Component)this.jLabel31, gridBagConstraints6);
            this.groupDynamicsControl.add((Component)this.lblAccent, gridBagConstraints5);
            this.groupDynamicsControl.add((Component)this.getTrackAccent(), gridBagConstraints4);
            this.groupDynamicsControl.add((Component)this.getTxtAccent(), gridBagConstraints3);
            this.groupDynamicsControl.add((Component)this.jLabel51, gridBagConstraints2);
            this.groupDynamicsControl.add((Component)this.jLabel61, gridBagConstraints);
        }
        return this.groupDynamicsControl;
    }

    private BSlider getTrackDecay() {
        if (this.trackDecay == null) {
            this.trackDecay = new BSlider();
            this.trackDecay.setPreferredSize(new Dimension(156, 18));
        }
        return this.trackDecay;
    }

    private BTextBox getTxtDecay() {
        if (this.txtDecay == null) {
            this.txtDecay = new BTextBox();
            this.txtDecay.setPreferredSize(new Dimension(39, 19));
            this.txtDecay.setHorizontalAlignment(4);
            this.txtDecay.setText("50");
        }
        return this.txtDecay;
    }

    private BSlider getTrackAccent() {
        if (this.trackAccent == null) {
            this.trackAccent = new BSlider();
            this.trackAccent.setPreferredSize(new Dimension(156, 18));
        }
        return this.trackAccent;
    }

    private BTextBox getTxtAccent() {
        if (this.txtAccent == null) {
            this.txtAccent = new BTextBox();
            this.txtAccent.setPreferredSize(new Dimension(39, 19));
            this.txtAccent.setHorizontalAlignment(4);
            this.txtAccent.setText("50");
        }
        return this.txtAccent;
    }

    private BGroupBox getGroupAttack() {
        if (this.groupAttack == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.fill = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints.gridx = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 12, 0, 0);
            gridBagConstraints2.gridy = 0;
            this.lblAttackTemplate = new BLabel();
            this.lblAttackTemplate.setText("Attack Variation");
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.gridy = 5;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridwidth = 4;
            this.jLabel611 = new BLabel();
            this.jLabel611.setText("");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 3;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridy = 2;
            this.jLabel511 = new BLabel();
            this.jLabel511.setText("%");
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 0;
            gridBagConstraints5.gridy = 2;
            gridBagConstraints5.weightx = 0.0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.gridx = 2;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.fill = 0;
            gridBagConstraints6.gridy = 2;
            gridBagConstraints6.weightx = 0.0;
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints6.gridx = 1;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.anchor = 17;
            gridBagConstraints7.gridx = 0;
            gridBagConstraints7.gridy = 2;
            gridBagConstraints7.insets = new Insets(0, 12, 0, 0);
            this.lblDepth = new BLabel();
            this.lblDepth.setText("Depth");
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 3;
            gridBagConstraints8.weightx = 1.0;
            gridBagConstraints8.fill = 2;
            gridBagConstraints8.anchor = 17;
            gridBagConstraints8.gridy = 1;
            this.jLabel311 = new BLabel();
            this.jLabel311.setText("%");
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.fill = 0;
            gridBagConstraints9.gridy = 1;
            gridBagConstraints9.weightx = 0.0;
            gridBagConstraints9.anchor = 17;
            gridBagConstraints9.gridx = 2;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.fill = 0;
            gridBagConstraints10.gridy = 1;
            gridBagConstraints10.weightx = 0.0;
            gridBagConstraints10.anchor = 17;
            gridBagConstraints10.insets = new Insets(3, 3, 3, 3);
            gridBagConstraints10.gridx = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.anchor = 17;
            gridBagConstraints11.gridx = 0;
            gridBagConstraints11.gridy = 1;
            gridBagConstraints11.insets = new Insets(0, 12, 0, 0);
            this.lblDuration = new BLabel();
            this.lblDuration.setText("Duration");
            this.groupAttack = new BGroupBox();
            this.groupAttack.setLayout(new GridBagLayout());
            this.groupAttack.setTitle("Attack (VOCALOID1)");
            this.groupAttack.add((Component)this.lblDuration, gridBagConstraints11);
            this.groupAttack.add((Component)this.getTrackDuration(), gridBagConstraints10);
            this.groupAttack.add((Component)this.getTxtDuration(), gridBagConstraints9);
            this.groupAttack.add((Component)this.jLabel311, gridBagConstraints8);
            this.groupAttack.add((Component)this.lblDepth, gridBagConstraints7);
            this.groupAttack.add((Component)this.getTrackDepth(), gridBagConstraints6);
            this.groupAttack.add((Component)this.getTxtDepth(), gridBagConstraints5);
            this.groupAttack.add((Component)this.jLabel511, gridBagConstraints4);
            this.groupAttack.add((Component)this.jLabel611, gridBagConstraints3);
            this.groupAttack.add((Component)this.lblAttackTemplate, gridBagConstraints2);
            this.groupAttack.add((Component)this.getComboAttackTemplate(), gridBagConstraints);
        }
        return this.groupAttack;
    }

    private BSlider getTrackDuration() {
        if (this.trackDuration == null) {
            this.trackDuration = new BSlider();
            this.trackDuration.setPreferredSize(new Dimension(156, 18));
            this.trackDuration.setValue(64);
            this.trackDuration.setMaximum(127);
        }
        return this.trackDuration;
    }

    private BTextBox getTxtDuration() {
        if (this.txtDuration == null) {
            this.txtDuration = new BTextBox();
            this.txtDuration.setPreferredSize(new Dimension(39, 19));
            this.txtDuration.setHorizontalAlignment(4);
            this.txtDuration.setText("64");
        }
        return this.txtDuration;
    }

    private BSlider getTrackDepth() {
        if (this.trackDepth == null) {
            this.trackDepth = new BSlider();
            this.trackDepth.setPreferredSize(new Dimension(156, 18));
            this.trackDepth.setMaximum(127);
            this.trackDepth.setValue(64);
        }
        return this.trackDepth;
    }

    private BTextBox getTxtDepth() {
        if (this.txtDepth == null) {
            this.txtDepth = new BTextBox();
            this.txtDepth.setPreferredSize(new Dimension(39, 19));
            this.txtDepth.setHorizontalAlignment(4);
            this.txtDepth.setText("64");
        }
        return this.txtDepth;
    }

    private BComboBox getComboAttackTemplate() {
        if (this.comboAttackTemplate == null) {
            this.comboAttackTemplate = new BComboBox();
            this.comboAttackTemplate.setPreferredSize(new Dimension(143, 20));
        }
        return this.comboAttackTemplate;
    }

    private BPanel getJPanel2() {
        if (this.jPanel2 == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.anchor = 16;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            this.jPanel2 = new BPanel();
            this.jPanel2.setLayout(new GridBagLayout());
            this.jPanel2.add((Component)this.getBtnOK(), gridBagConstraints2);
            this.jPanel2.add((Component)this.getBtnCancel(), gridBagConstraints);
        }
        return this.jPanel2;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }
}

