/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.Window;
import java.io.Serializable;
import java.util.Vector;
import javax.swing.JMenuBar;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.kbinani.BEvent;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.BgmFile;
import org.kbinani.cadencii.FederChangedEventHandler;
import org.kbinani.cadencii.FormMain;
import org.kbinani.cadencii.MuteChangedEventHandler;
import org.kbinani.cadencii.PanpotChangedEventHandler;
import org.kbinani.cadencii.Resources;
import org.kbinani.cadencii.SoloChangedEventHandler;
import org.kbinani.cadencii.TopMostChangedEventHandler;
import org.kbinani.cadencii.VolumeTracker;
import org.kbinani.cadencii.VsqFileEx;
import org.kbinani.vsq.VsqMixerEntry;
import org.kbinani.vsq.VsqTrack;
import org.kbinani.windows.forms.BCheckBox;
import org.kbinani.windows.forms.BForm;
import org.kbinani.windows.forms.BFormClosingEventArgs;
import org.kbinani.windows.forms.BFormClosingEventHandler;
import org.kbinani.windows.forms.BHScrollBar;
import org.kbinani.windows.forms.BMenu;
import org.kbinani.windows.forms.BMenuItem;
import org.kbinani.windows.forms.BPanel;

public class FormMixer
extends BForm {
    private FormMain m_parent;
    private Vector<VolumeTracker> m_tracker = null;
    public BEvent<FederChangedEventHandler> federChangedEvent = new BEvent();
    public BEvent<PanpotChangedEventHandler> panpotChangedEvent = new BEvent();
    public BEvent<SoloChangedEventHandler> soloChangedEvent = new BEvent();
    public BEvent<MuteChangedEventHandler> muteChangedEvent = new BEvent();
    public BEvent<TopMostChangedEventHandler> topMostChangedEvent = new BEvent();
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private BPanel panel1 = null;
    private BHScrollBar hScroll = null;
    private VolumeTracker volumeMaster = null;
    private BCheckBox chkTopmost = null;
    private JMenuBar menuMain = null;
    private BMenu menuVisual = null;
    private BMenuItem menuVisualReturn = null;

    public FormMixer(FormMain formMain) {
        this.initialize();
        this.registerEventHandlers();
        this.setResources();
        this.volumeMaster.setFeder(0);
        this.volumeMaster.setMuted(false);
        this.volumeMaster.setSolo(true);
        this.volumeMaster.setNumber("Master");
        this.volumeMaster.setPanpot(0);
        this.volumeMaster.setSoloButtonVisible(false);
        this.volumeMaster.setTitle("");
        this.applyLanguage();
        this.m_parent = formMain;
    }

    public void updateSoloMute() {
        int n;
        VsqFileEx vsqFileEx = AppManager.getVsqFile();
        if (vsqFileEx == null) {
            return;
        }
        boolean bl = vsqFileEx.getMasterMute();
        this.volumeMaster.setMuted(bl);
        boolean bl2 = false;
        for (n = 1; n < vsqFileEx.Track.size(); ++n) {
            if (!vsqFileEx.getSolo(n)) continue;
            bl2 = true;
            break;
        }
        for (n = 1; n < vsqFileEx.Track.size(); ++n) {
            if (bl2) {
                if (vsqFileEx.getSolo(n)) {
                    this.m_tracker.get(n - 1).setSolo(true);
                    this.m_tracker.get(n - 1).setMuted(bl ? true : vsqFileEx.getMute(n));
                    continue;
                }
                this.m_tracker.get(n - 1).setSolo(false);
                this.m_tracker.get(n - 1).setMuted(true);
                continue;
            }
            this.m_tracker.get(n - 1).setSolo(vsqFileEx.getSolo(n));
            this.m_tracker.get(n - 1).setMuted(bl ? true : vsqFileEx.getMute(n));
        }
        n = vsqFileEx.Track.size() - 1;
        for (int i = 0; i < vsqFileEx.BgmFiles.size(); ++i) {
            this.m_tracker.get(n + i).setMuted(bl ? true : vsqFileEx.BgmFiles.get((int)i).mute == 1);
        }
    }

    public void applyShortcut(KeyStroke keyStroke) {
        this.menuVisualReturn.setAccelerator(keyStroke);
    }

    public void applyLanguage() {
        this.setTitle(FormMixer._("Mixer"));
        this.chkTopmost.setText(FormMixer._("Top Most"));
    }

    public void updateStatus() {
        Serializable serializable;
        Object object;
        int n;
        int n2;
        int n3;
        int n4;
        VsqFileEx vsqFileEx = AppManager.getVsqFile();
        int n5 = vsqFileEx.Mixer.Slave.size() + AppManager.getBgmCount();
        if (this.m_tracker == null) {
            this.m_tracker = new Vector();
        }
        if (this.m_tracker.size() < n5) {
            n4 = n5 - this.m_tracker.size();
            for (n3 = 0; n3 < n4; ++n3) {
                VolumeTracker volumeTracker = new VolumeTracker();
                volumeTracker.muteButtonClick.add(new BEventHandler(this, "FormMixer_MuteButtonClick"));
                volumeTracker.soloButtonClick.add(new BEventHandler(this, "FormMixer_SoloButtonClick"));
                volumeTracker.federChangedEvent.add(new BEventHandler(this, "FormMixer_FederChanged"));
                volumeTracker.panpotChangedEvent.add(new BEventHandler(this, "FormMixer_PanpotChanged"));
                this.m_tracker.add(volumeTracker);
            }
        } else if (this.m_tracker.size() > n5) {
            n4 = this.m_tracker.size() - n5;
            for (n3 = 0; n3 < n4; ++n3) {
                this.m_tracker.removeElementAt(this.m_tracker.size() - 1);
            }
        }
        int n6 = ++n5 <= (n2 = (int)Math.floor((float)(n = (n4 = PortUtil.getWorkingArea((Window)this).width) - 2 * (n3 = 4)) / 86.0f)) ? n5 : n2;
        int n7 = n2 - 1;
        int n8 = vsqFileEx.Mixer.Slave.size() + AppManager.getBgmCount();
        if (n7 >= n8) {
            this.hScroll.setMinimum(0);
            this.hScroll.setValue(0);
            this.hScroll.setMaximum(0);
            this.hScroll.setVisibleAmount(1);
            this.hScroll.setPreferredSize(new Dimension(86 * n8, this.hScroll.getHeight()));
        } else {
            this.hScroll.setMinimum(0);
            this.hScroll.setValue(0);
            this.hScroll.setMaximum(n8 * 85);
            this.hScroll.setVisibleAmount(n7 * 85);
            this.hScroll.setPreferredSize(new Dimension(86 * n7, this.hScroll.getHeight()));
        }
        this.hScroll.setLocation(0, 284);
        int n9 = -1;
        for (VsqMixerEntry vsqMixerEntry : vsqFileEx.Mixer.Slave) {
            object = this.m_tracker.get(++n9);
            ((VolumeTracker)object).setFeder(vsqMixerEntry.Feder);
            ((VolumeTracker)object).setPanpot(vsqMixerEntry.Panpot);
            ((VolumeTracker)object).setTitle(((VsqTrack)vsqFileEx.Track.get(n9 + 1)).getName());
            ((VolumeTracker)object).setNumber(n9 + 1 + "");
            ((VolumeTracker)object).setLocation(n9 * 86, 0);
            ((VolumeTracker)object).setSoloButtonVisible(true);
            ((VolumeTracker)object).setMuted(vsqMixerEntry.Mute == 1);
            ((VolumeTracker)object).setSolo(vsqMixerEntry.Solo == 1);
            ((VolumeTracker)object).setTag(n9 + 1);
            ((VolumeTracker)object).setSoloButtonVisible(true);
            this.addToPanel1((VolumeTracker)object, n9);
        }
        int n10 = AppManager.getBgmCount();
        for (int i = 0; i < n10; ++i) {
            object = AppManager.getBgm(i);
            serializable = this.m_tracker.get(++n9);
            ((VolumeTracker)serializable).setFeder(((BgmFile)object).feder);
            ((VolumeTracker)serializable).setPanpot(((BgmFile)object).panpot);
            ((VolumeTracker)serializable).setTitle(PortUtil.getFileName(((BgmFile)object).file));
            ((VolumeTracker)serializable).setNumber("");
            ((VolumeTracker)serializable).setLocation(n9 * 86, 0);
            ((VolumeTracker)serializable).setSoloButtonVisible(false);
            ((VolumeTracker)serializable).setMuted(((BgmFile)object).mute == 1);
            ((VolumeTracker)serializable).setSolo(false);
            ((VolumeTracker)serializable).setTag(-i - 1);
            ((VolumeTracker)serializable).setSoloButtonVisible(false);
            this.addToPanel1((VolumeTracker)serializable, n9);
        }
        this.volumeMaster.setFeder(vsqFileEx.Mixer.MasterFeder);
        this.volumeMaster.setPanpot(vsqFileEx.Mixer.MasterPanpot);
        this.volumeMaster.setSoloButtonVisible(false);
        this.setResizable(true);
        JPanel jPanel = this.getJContentPane();
        object = jPanel.getSize();
        serializable = new Rectangle();
        serializable = jPanel.getBounds((Rectangle)serializable);
        int n11 = this.getWidth() - ((Rectangle)serializable).width;
        int n12 = this.getHeight() - ((Rectangle)serializable).height;
        PortUtil.println("FormMixer#updateStatus; this.getWidth()=" + this.getWidth() + "; this.getHeight()=" + this.getHeight());
        PortUtil.println("FormMixer#updateStatus; rc.width=" + ((Rectangle)serializable).width + "; rc.height=" + ((Rectangle)serializable).height);
        int n13 = n6 * 86 + 3;
        int n14 = 284 + this.hScroll.getHeight();
        this.setSize(n13, n14 + this.hScroll.getHeight() + this.menuMain.getHeight());
        PortUtil.println("FormMixer#updateStatus; w=" + n13 + "; h=" + n14 + "; xdiff=" + n11 + "; ydiff=" + n12);
        this.setResizable(false);
    }

    public void setShowTopMost(boolean bl) {
        this.setAlwaysOnTop(bl);
        this.chkTopmost.setSelected(bl);
    }

    private void addToPanel1(VolumeTracker volumeTracker, int n) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 3;
        this.panel1.add((Component)volumeTracker, gridBagConstraints);
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.menuVisualReturn.clickEvent.add(new BEventHandler(this, "menuVisualReturn_Click"));
        this.hScroll.valueChangedEvent.add(new BEventHandler(this, "veScrollBar_ValueChanged"));
        this.volumeMaster.panpotChangedEvent.add(new BEventHandler(this, "volumeMaster_PanpotChanged"));
        this.volumeMaster.federChangedEvent.add(new BEventHandler(this, "volumeMaster_FederChanged"));
        this.chkTopmost.checkedChangedEvent.add(new BEventHandler(this, "chkTopmost_CheckedChanged"));
        this.formClosingEvent.add(new BFormClosingEventHandler(this, "FormMixer_FormClosing"));
        this.volumeMaster.muteButtonClick.add(new BEventHandler(this, "volumeMaster_MuteButtonClick"));
    }

    private void setResources() {
        this.setIconImage(Resources.get_icon());
    }

    public void FormMixer_PanpotChanged(Object object, BEventArgs bEventArgs) {
        if (object == null) {
            return;
        }
        if (!(object instanceof VolumeTracker)) {
            return;
        }
        VolumeTracker volumeTracker = (VolumeTracker)object;
        Object object2 = volumeTracker.getTag();
        if (object2 == null) {
            return;
        }
        if (!(object2 instanceof Integer)) {
            return;
        }
        int n = (Integer)object2;
        try {
            this.panpotChangedEvent.raise(n, volumeTracker.getPanpot());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMixer#FormMixer_PanpotChanged; ex=" + exception);
        }
    }

    public void FormMixer_FederChanged(Object object, BEventArgs bEventArgs) {
        if (object == null) {
            return;
        }
        if (!(object instanceof VolumeTracker)) {
            return;
        }
        VolumeTracker volumeTracker = (VolumeTracker)object;
        Object object2 = volumeTracker.getTag();
        if (object2 == null) {
            return;
        }
        if (!(object2 instanceof Integer)) {
            return;
        }
        int n = (Integer)object2;
        try {
            this.federChangedEvent.raise(n, volumeTracker.getFeder());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMixer#FormMixer_FederChanged; ex=" + exception);
        }
    }

    public void FormMixer_SoloButtonClick(Object object, BEventArgs bEventArgs) {
        VolumeTracker volumeTracker = (VolumeTracker)object;
        int n = (Integer)volumeTracker.getTag();
        try {
            this.soloChangedEvent.raise(n, volumeTracker.isSolo());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMixer#FormMixer_IsSoloChanged; ex=" + exception);
        }
        this.updateSoloMute();
    }

    public void FormMixer_MuteButtonClick(Object object, BEventArgs bEventArgs) {
        VolumeTracker volumeTracker = (VolumeTracker)object;
        int n = (Integer)volumeTracker.getTag();
        try {
            this.muteChangedEvent.raise(n, volumeTracker.isMuted());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMixer#FormMixer_IsMutedChanged; ex=" + exception);
        }
        this.updateSoloMute();
    }

    public void menuVisualReturn_Click(Object object, BEventArgs bEventArgs) {
        this.m_parent.flipMixerDialogVisible(false);
    }

    public void FormMixer_FormClosing(Object object, BFormClosingEventArgs bFormClosingEventArgs) {
        this.m_parent.flipMixerDialogVisible(false);
        bFormClosingEventArgs.Cancel = true;
    }

    public void veScrollBar_ValueChanged(Object object, BEventArgs bEventArgs) {
        int n = this.hScroll.getValue();
        for (int i = 0; i < this.m_tracker.size(); ++i) {
            this.m_tracker.get(i).setLocation(-n + 86 * i, 0);
        }
        this.invalidate();
    }

    public void volumeMaster_FederChanged(Object object, BEventArgs bEventArgs) {
        try {
            this.federChangedEvent.raise(0, this.volumeMaster.getFeder());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMixer#volumeMaster_FederChanged; ex=" + exception);
        }
    }

    public void volumeMaster_PanpotChanged(Object object, BEventArgs bEventArgs) {
        try {
            this.panpotChangedEvent.raise(0, this.volumeMaster.getPanpot());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMixer#volumeMaster_PanpotChanged; ex=" + exception);
        }
    }

    public void volumeMaster_MuteButtonClick(Object object, BEventArgs bEventArgs) {
        try {
            this.muteChangedEvent.raise(0, this.volumeMaster.isMuted());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMixer#volumeMaster_IsMutedChanged; ex=" + exception);
        }
    }

    public void chkTopmost_CheckedChanged(Object object, BEventArgs bEventArgs) {
        try {
            this.topMostChangedEvent.raise(this, this.chkTopmost.isSelected());
        }
        catch (Exception exception) {
            PortUtil.stderr.println("FormMixer#chkTopmost_CheckedChanged; ex=" + exception);
        }
        this.setAlwaysOnTop(this.chkTopmost.isSelected());
    }

    public boolean isShowTopMost() {
        return this.isAlwaysOnTop();
    }

    private void initialize() {
        this.setSize(161, 343);
        this.setJMenuBar(this.getMenuMain());
        this.setContentPane(this.getJContentPane());
        this.setTitle("JFrame");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            gridBagConstraints.gridy = 1;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.weightx = 0.0;
            gridBagConstraints2.weighty = 1.0;
            gridBagConstraints2.fill = 1;
            gridBagConstraints2.anchor = 11;
            gridBagConstraints2.gridy = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 1.0;
            gridBagConstraints3.gridy = 0;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weighty = 0.0;
            gridBagConstraints4.anchor = 17;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.weighty = 1.0;
            gridBagConstraints5.fill = 3;
            gridBagConstraints5.anchor = 11;
            gridBagConstraints5.gridy = 0;
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.getPanel1(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getVolumeMaster(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getHScroll(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getChkTopmost(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private BPanel getPanel1() {
        if (this.panel1 == null) {
            this.panel1 = new BPanel();
            this.panel1.setLayout(new GridBagLayout());
        }
        return this.panel1;
    }

    private BHScrollBar getHScroll() {
        if (this.hScroll == null) {
            this.hScroll = new BHScrollBar();
        }
        return this.hScroll;
    }

    private JPanel getVolumeMaster() {
        if (this.volumeMaster == null) {
            this.volumeMaster = new VolumeTracker();
        }
        return this.volumeMaster;
    }

    private BCheckBox getChkTopmost() {
        if (this.chkTopmost == null) {
            this.chkTopmost = new BCheckBox();
            this.chkTopmost.setText("Top most");
            this.chkTopmost.setText("Top most");
        }
        return this.chkTopmost;
    }

    private JMenuBar getMenuMain() {
        if (this.menuMain == null) {
            this.menuMain = new JMenuBar();
            this.menuMain.add(this.getMenuVisual());
        }
        return this.menuMain;
    }

    private BMenu getMenuVisual() {
        if (this.menuVisual == null) {
            this.menuVisual = new BMenu();
            this.menuVisual.add(this.getMenuVisualReturn());
        }
        return this.menuVisual;
    }

    private BMenuItem getMenuVisualReturn() {
        if (this.menuVisualReturn == null) {
            this.menuVisualReturn = new BMenuItem();
        }
        return this.menuVisualReturn;
    }
}

