/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BNumericUpDown;

public class FormInsertBar
extends BDialog {
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private BLabel lblPosition = null;
    private BNumericUpDown numPosition = null;
    private BLabel lblThBar = null;
    private BLabel lblLength = null;
    private BNumericUpDown numLength = null;
    private BLabel lblBar = null;
    private JPanel jPanel = null;
    private BButton btnOK = null;
    private BButton btnCancel = null;
    private JLabel lblPositionPrefix = null;

    public FormInsertBar(int n) {
        this.initialize();
        this.registerEventHandlers();
        this.setResources();
        this.applyLanguage();
        this.numPosition.setMaximum(n);
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
    }

    public void applyLanguage() {
        this.setTitle(FormInsertBar._("Insert Bars"));
        String string = FormInsertBar._("_PREFIX_TH_");
        if (string.equals("_PREFIX_TH_")) {
            this.lblPositionPrefix.setText("");
        } else {
            this.lblPositionPrefix.setText(string);
        }
        this.lblPosition.setText(FormInsertBar._("Position"));
        this.lblLength.setText(FormInsertBar._("Length"));
        this.lblThBar.setText(FormInsertBar._("th bar"));
        this.lblBar.setText(FormInsertBar._("bar"));
        this.btnOK.setText(FormInsertBar._("OK"));
        this.btnCancel.setText(FormInsertBar._("Cancel"));
    }

    public int getLength() {
        return (int)this.numLength.getValue();
    }

    public void setLength(int n) {
        this.numLength.setValue(n);
    }

    public int getPosition() {
        return (int)this.numPosition.getValue();
    }

    public void setPosition(int n) {
        this.numPosition.setValue(n);
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
    }

    private void setResources() {
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.OK);
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    private void initialize() {
        this.setSize(249, 158);
        this.setContentPane(this.getJContentPane());
        this.setTitle("Insert bar");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(8, 0, 0, 0);
            gridBagConstraints.gridy = 0;
            this.lblPositionPrefix = new JLabel();
            this.lblPositionPrefix.setText(" ");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 13;
            gridBagConstraints2.gridwidth = 4;
            gridBagConstraints2.weightx = 1.0;
            gridBagConstraints2.insets = new Insets(16, 0, 8, 0);
            gridBagConstraints2.gridy = 2;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 3;
            gridBagConstraints3.insets = new Insets(4, 8, 0, 16);
            gridBagConstraints3.anchor = 17;
            gridBagConstraints3.gridy = 1;
            this.lblBar = new BLabel();
            this.lblBar.setText("bar");
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 2;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.insets = new Insets(4, 0, 0, 0);
            gridBagConstraints4.gridx = 2;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(4, 16, 0, 8);
            gridBagConstraints5.gridwidth = 2;
            gridBagConstraints5.gridy = 1;
            this.lblLength = new BLabel();
            this.lblLength.setText("Length");
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 3;
            gridBagConstraints6.insets = new Insets(8, 8, 0, 16);
            gridBagConstraints6.anchor = 17;
            gridBagConstraints6.gridy = 0;
            this.lblThBar = new BLabel();
            this.lblThBar.setText("th bar");
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.fill = 2;
            gridBagConstraints7.gridy = 0;
            gridBagConstraints7.weightx = 1.0;
            gridBagConstraints7.insets = new Insets(8, 0, 0, 0);
            gridBagConstraints7.gridx = 2;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.anchor = 13;
            gridBagConstraints8.insets = new Insets(8, 16, 0, 8);
            gridBagConstraints8.gridy = 0;
            this.lblPosition = new BLabel();
            this.lblPosition.setText("Position");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.lblPosition, gridBagConstraints8);
            this.jContentPane.add((Component)this.getNumPosition(), gridBagConstraints7);
            this.jContentPane.add((Component)this.lblThBar, gridBagConstraints6);
            this.jContentPane.add((Component)this.lblLength, gridBagConstraints5);
            this.jContentPane.add((Component)this.getNumLength(), gridBagConstraints4);
            this.jContentPane.add((Component)this.lblBar, gridBagConstraints3);
            this.jContentPane.add((Component)this.getJPanel(), gridBagConstraints2);
            this.jContentPane.add((Component)this.lblPositionPrefix, gridBagConstraints);
        }
        return this.jContentPane;
    }

    private BNumericUpDown getNumPosition() {
        if (this.numPosition == null) {
            this.numPosition = new BNumericUpDown();
        }
        return this.numPosition;
    }

    private BNumericUpDown getNumLength() {
        if (this.numLength == null) {
            this.numLength = new BNumericUpDown();
        }
        return this.numLength;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 17;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints2.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getBtnOK(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnCancel(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }
}

