/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JPanel;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BDialog;
import org.kbinani.windows.forms.BDialogResult;
import org.kbinani.windows.forms.BLabel;
import org.kbinani.windows.forms.BTextArea;

public class FormImportLyric
extends BDialog {
    private int m_max_notes = 1;
    private static final long serialVersionUID = 1L;
    private JPanel jContentPane = null;
    private BLabel lblNotes = null;
    private BTextArea txtLyrics = null;
    private JPanel jPanel = null;
    private BButton btnOK = null;
    private BButton btnCancel = null;
    private JButton jButton = null;
    private JButton jButton1 = null;

    public FormImportLyric(int n) {
        this.initialize();
        this.registerEventHandlers();
        this.setResources();
        this.applyLanguage();
        String string = n > 1 ? " [notes]" : " [note]";
        this.lblNotes.setText("Max : " + n + string);
        this.m_max_notes = n;
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
    }

    public void applyLanguage() {
        this.setTitle(FormImportLyric._("Import lyrics"));
        this.btnCancel.setText(FormImportLyric._("Cancel"));
        this.btnOK.setText(FormImportLyric._("OK"));
    }

    public String[] getLetters() {
        int n;
        Vector<Character> vector = new Vector<Character>(Arrays.asList(Character.valueOf('\u3041'), Character.valueOf('\u3043'), Character.valueOf('\u3045'), Character.valueOf('\u3047'), Character.valueOf('\u3049'), Character.valueOf('\u3083'), Character.valueOf('\u3085'), Character.valueOf('\u3087'), Character.valueOf('\u30a1'), Character.valueOf('\u30a3'), Character.valueOf('\u30a5'), Character.valueOf('\u30a7'), Character.valueOf('\u30a9'), Character.valueOf('\u30e3'), Character.valueOf('\u30e5'), Character.valueOf('\u30e7')));
        String string = "";
        for (int i = 0; i < this.m_max_notes && i < this.txtLyrics.getLineCount(); ++i) {
            try {
                int n2 = this.txtLyrics.getLineStartOffset(i);
                n = this.txtLyrics.getLineEndOffset(i);
                string = string + this.txtLyrics.getText(n2, n - n2) + " ";
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String[] stringArray = PortUtil.splitString(string, new char[]{'\n', '\t', ' ', '\u3000', '\r'}, true);
        Vector<String> vector2 = new Vector<String>();
        for (n = 0; n < stringArray.length; ++n) {
            String string2 = stringArray[n];
            char[] cArray = string2.toCharArray();
            String string3 = "";
            int n3 = -1;
            while (n3 + 1 < cArray.length) {
                if ('A' <= cArray[++n3] && cArray[n3] <= '\u0176') {
                    string3 = string3 + cArray[n3] + "";
                    continue;
                }
                if (PortUtil.getStringLength(string3) > 0) {
                    vector2.add(string3);
                    string3 = "";
                }
                if (n3 + 1 < cArray.length) {
                    if (vector.contains(Character.valueOf(cArray[n3 + 1]))) {
                        vector2.add(cArray[n3] + "" + cArray[n3 + 1] + "");
                        ++n3;
                        continue;
                    }
                    vector2.add(cArray[n3] + "");
                    continue;
                }
                vector2.add(cArray[n3] + "");
            }
            if (PortUtil.getStringLength(string3) <= 0) continue;
            vector2.add(string3);
        }
        return vector2.toArray(new String[0]);
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.btnOK.clickEvent.add(new BEventHandler(this, "btnOK_Click"));
        this.btnCancel.clickEvent.add(new BEventHandler(this, "btnCancel_Click"));
    }

    private void setResources() {
    }

    public void btnOK_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.OK);
    }

    public void btnCancel_Click(Object object, BEventArgs bEventArgs) {
        this.setDialogResult(BDialogResult.CANCEL);
    }

    private void initialize() {
        this.setSize(456, 380);
        this.setContentPane(this.getJContentPane());
        this.setTitle("JFrame");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 2;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 1;
            gridBagConstraints2.gridy = 1;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.gridx = 0;
            gridBagConstraints3.anchor = 13;
            gridBagConstraints3.insets = new Insets(0, 0, 16, 0);
            gridBagConstraints3.gridy = 2;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.fill = 1;
            gridBagConstraints4.gridy = 1;
            gridBagConstraints4.weightx = 1.0;
            gridBagConstraints4.weighty = 1.0;
            gridBagConstraints4.insets = new Insets(0, 16, 16, 16);
            gridBagConstraints4.gridx = 0;
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.gridx = 0;
            gridBagConstraints5.anchor = 17;
            gridBagConstraints5.insets = new Insets(16, 16, 8, 0);
            gridBagConstraints5.gridy = 0;
            this.lblNotes = new BLabel();
            this.lblNotes.setText("Max : *[notes]");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.lblNotes, gridBagConstraints5);
            this.jContentPane.add((Component)this.getTxtLyrics(), gridBagConstraints4);
            this.jContentPane.add((Component)this.getJPanel(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getJButton(), gridBagConstraints2);
            this.jContentPane.add((Component)this.getJButton1(), gridBagConstraints);
        }
        return this.jContentPane;
    }

    private BTextArea getTxtLyrics() {
        if (this.txtLyrics == null) {
            this.txtLyrics = new BTextArea();
        }
        return this.txtLyrics;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 1;
            gridBagConstraints.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints.gridy = 0;
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.insets = new Insets(0, 0, 0, 16);
            gridBagConstraints2.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getBtnOK(), gridBagConstraints2);
            this.jPanel.add((Component)this.getBtnCancel(), gridBagConstraints);
        }
        return this.jPanel;
    }

    private BButton getBtnOK() {
        if (this.btnOK == null) {
            this.btnOK = new BButton();
            this.btnOK.setText("OK");
        }
        return this.btnOK;
    }

    private BButton getBtnCancel() {
        if (this.btnCancel == null) {
            this.btnCancel = new BButton();
            this.btnCancel.setText("Cancel");
        }
        return this.btnCancel;
    }

    private JButton getJButton() {
        if (this.jButton == null) {
            this.jButton = new JButton();
        }
        return this.jButton;
    }

    private JButton getJButton1() {
        if (this.jButton1 == null) {
            this.jButton1 = new JButton();
        }
        return this.jButton1;
    }
}

