/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani.cadencii;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Image;
import java.awt.Point;
import java.io.File;
import java.util.Iterator;
import java.util.TreeMap;
import java.util.Vector;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import org.kbinani.BEventArgs;
import org.kbinani.BEventHandler;
import org.kbinani.PortUtil;
import org.kbinani.apputil.Messaging;
import org.kbinani.apputil.Util;
import org.kbinani.cadencii.AppManager;
import org.kbinani.cadencii.EditMode;
import org.kbinani.cadencii.Resources;
import org.kbinani.vsq.IconDynamicsHandle;
import org.kbinani.vsq.SynthesizerType;
import org.kbinani.vsq.VocaloSysUtil;
import org.kbinani.vsq.VsqEvent;
import org.kbinani.vsq.VsqIDType;
import org.kbinani.windows.forms.BButton;
import org.kbinani.windows.forms.BCheckBox;
import org.kbinani.windows.forms.BForm;
import org.kbinani.windows.forms.BFormClosingEventArgs;
import org.kbinani.windows.forms.BFormClosingEventHandler;
import org.kbinani.windows.forms.BKeys;
import org.kbinani.windows.forms.BMenu;
import org.kbinani.windows.forms.BMenuBar;
import org.kbinani.windows.forms.BMenuItem;
import org.kbinani.windows.forms.BMouseEventArgs;
import org.kbinani.windows.forms.BMouseEventHandler;

public class FormIconPalette
extends BForm {
    private Vector<BButton> dynaffButtons = new Vector();
    private Vector<BButton> crescendButtons = new Vector();
    private Vector<BButton> decrescendButtons = new Vector();
    private int buttonWidth = 40;
    private static final long serialVersionUID = 1L;
    private BMenuBar myMenuBar = null;
    private BMenu menuWindow = null;
    private BMenuItem menuWindowHide = null;
    private BCheckBox chkTopMost = null;
    private JPanel jPanel = null;

    public FormIconPalette() {
        this.initialize();
        this.applyLanguage();
        Util.applyFontRecurse(this, AppManager.editorConfig.getBaseFont());
        this.init();
        this.registerEventHandlers();
        TreeMap<String, BKeys[]> treeMap = AppManager.editorConfig.getShortcutKeysDictionary();
        if (treeMap.containsKey("menuVisualIconPalette")) {
            BKeys[] bKeysArray = treeMap.get("menuVisualIconPalette");
            KeyStroke keyStroke = PortUtil.getKeyStrokeFromBKeys(bKeysArray);
            this.menuWindowHide.setAccelerator(keyStroke);
        }
    }

    public void applyLanguage() {
        this.setTitle(FormIconPalette._("Icon Palette"));
        this.chkTopMost.setText(FormIconPalette._("Top Most"));
    }

    public void applyShortcut(KeyStroke keyStroke) {
        this.menuWindowHide.setAccelerator(keyStroke);
    }

    public void setTopMost(boolean bl) {
        this.chkTopMost.setSelected(bl);
    }

    private static String _(String string) {
        return Messaging.getMessage(string);
    }

    private void registerEventHandlers() {
        this.formClosingEvent.add(new BFormClosingEventHandler(this, "FormIconPalette_FormClosing"));
        this.menuWindowHide.clickEvent.add(new BEventHandler(this, "menuWindowHide_Click"));
        this.chkTopMost.checkedChangedEvent.add(new BEventHandler(this, "chkTopMost_CheckedChanged"));
    }

    private void init() {
        Object object;
        Iterator<IconDynamicsHandle> iterator = VocaloSysUtil.dynamicsConfigIterator(SynthesizerType.VOCALOID1);
        while (iterator.hasNext()) {
            Image image;
            IconDynamicsHandle iconDynamicsHandle = iterator.next();
            object = iconDynamicsHandle.IconID;
            BButton bButton = new BButton();
            bButton.setName((String)object);
            bButton.setTag(iconDynamicsHandle);
            String string = iconDynamicsHandle.getButtonImageFullPath();
            boolean bl = PortUtil.isFileExists(string);
            if (bl) {
                image = null;
                try {
                    image = ImageIO.read(new File(string));
                }
                catch (Exception exception) {
                    PortUtil.stderr.println("FormIconPalette#init; ex=" + exception);
                }
                bButton.setIcon(new ImageIcon(image));
            } else {
                image = null;
                String string2 = "";
                String string3 = iconDynamicsHandle.IDS;
                if (string3.equals("cresc_1")) {
                    image = Resources.get_cresc1();
                } else if (string3.equals("cresc_2")) {
                    image = Resources.get_cresc2();
                } else if (string3.equals("cresc_3")) {
                    image = Resources.get_cresc3();
                } else if (string3.equals("cresc_4")) {
                    image = Resources.get_cresc4();
                } else if (string3.equals("cresc_5")) {
                    image = Resources.get_cresc5();
                } else if (string3.equals("dim_1")) {
                    image = Resources.get_dim1();
                } else if (string3.equals("dim_2")) {
                    image = Resources.get_dim2();
                } else if (string3.equals("dim_3")) {
                    image = Resources.get_dim3();
                } else if (string3.equals("dim_4")) {
                    image = Resources.get_dim4();
                } else if (string3.equals("dim_5")) {
                    image = Resources.get_dim5();
                } else if (string3.equals("Dynaff11")) {
                    string2 = "fff";
                } else if (string3.equals("Dynaff12")) {
                    string2 = "ff";
                } else if (string3.equals("Dynaff13")) {
                    string2 = "f";
                } else if (string3.equals("Dynaff21")) {
                    string2 = "mf";
                } else if (string3.equals("Dynaff22")) {
                    string2 = "mp";
                } else if (string3.equals("Dynaff31")) {
                    string2 = "p";
                } else if (string3.equals("Dynaff32")) {
                    string2 = "pp";
                } else if (string3.equals("Dynaff33")) {
                    string2 = "ppp";
                }
                if (image != null) {
                    bButton.setIcon(new ImageIcon(image));
                } else {
                    bButton.setText(string2);
                }
            }
            bButton.mouseDownEvent.add(new BMouseEventHandler(this, "handleCommonMouseDown"));
            bButton.setPreferredSize(new Dimension(this.buttonWidth, this.buttonWidth));
            int n = 0;
            int n2 = 0;
            if (((String)object).startsWith("$0501")) {
                this.dynaffButtons.add(bButton);
                n2 = 0;
                n = this.dynaffButtons.size() - 1;
                continue;
            }
            if (((String)object).startsWith("$0502")) {
                this.crescendButtons.add(bButton);
                n2 = 1;
                n = this.crescendButtons.size() - 1;
                continue;
            }
            if (!((String)object).startsWith("$0503")) continue;
            this.decrescendButtons.add(bButton);
            n2 = 2;
            n = this.decrescendButtons.size() - 1;
        }
        this.chkTopMost.setLocation(new Point(0, 3 * this.buttonWidth));
        int n = 0;
        int n3 = 0;
        if (this.dynaffButtons.size() > 0) {
            n += this.buttonWidth;
        }
        n += this.chkTopMost.getHeight();
        n3 = Math.max(n3, this.buttonWidth * this.dynaffButtons.size());
        if (this.crescendButtons.size() > 0) {
            n += this.buttonWidth;
        }
        n3 = Math.max(n3, this.buttonWidth * this.crescendButtons.size());
        if (this.decrescendButtons.size() > 0) {
            n += this.buttonWidth;
        }
        n3 = Math.max(n3, this.buttonWidth * this.decrescendButtons.size());
        object = this.getSize();
        this.setMaximumSize((Dimension)object);
        this.setMinimumSize((Dimension)object);
    }

    public void FormIconPalette_FormClosing(Object object, BFormClosingEventArgs bFormClosingEventArgs) {
        bFormClosingEventArgs.Cancel = true;
        this.setVisible(false);
    }

    public void chkTopMost_CheckedChanged(Object object, BEventArgs bEventArgs) {
        this.setAlwaysOnTop(this.chkTopMost.isSelected());
    }

    public void menuWindowHide_Click(Object object, BEventArgs bEventArgs) {
        this.close();
    }

    public void handleCommonMouseDown(Object object, BMouseEventArgs bMouseEventArgs) {
        if (AppManager.getEditMode() != EditMode.NONE) {
            return;
        }
        BButton bButton = (BButton)object;
        if (AppManager.mainWindow != null) {
            AppManager.mainWindow.toFront();
        }
        IconDynamicsHandle iconDynamicsHandle = (IconDynamicsHandle)bButton.getTag();
        VsqEvent vsqEvent = new VsqEvent();
        vsqEvent.Clock = 0;
        vsqEvent.ID.Note = 60;
        vsqEvent.ID.type = VsqIDType.Aicon;
        vsqEvent.ID.IconDynamicsHandle = (IconDynamicsHandle)iconDynamicsHandle.clone();
        int n = iconDynamicsHandle.getLength();
        if (n <= 0) {
            n = 1;
        }
        vsqEvent.ID.setLength(n);
        AppManager.addingEvent = vsqEvent;
    }

    private void initialize() {
        this.setSize(new Dimension(275, 178));
        this.setContentPane(this.getJPanel());
        this.setJMenuBar(this.getMyMenuBar());
    }

    private BMenuBar getMyMenuBar() {
        if (this.myMenuBar == null) {
            this.myMenuBar = new BMenuBar();
            this.myMenuBar.add(this.getMenuWindow());
        }
        return this.myMenuBar;
    }

    private BMenu getMenuWindow() {
        if (this.menuWindow == null) {
            this.menuWindow = new BMenu();
            this.menuWindow.setText("Window");
            this.menuWindow.add(this.getMenuWindowHide());
        }
        return this.menuWindow;
    }

    private BMenuItem getMenuWindowHide() {
        if (this.menuWindowHide == null) {
            this.menuWindowHide = new BMenuItem();
            this.menuWindowHide.setText("Hide");
        }
        return this.menuWindowHide;
    }

    private BCheckBox getChkTopMost() {
        if (this.chkTopMost == null) {
            this.chkTopMost = new BCheckBox();
            this.chkTopMost.setText("TopMost");
        }
        return this.chkTopMost;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.add((Component)this.getChkTopMost(), gridBagConstraints);
        }
        return this.jPanel;
    }
}

