/*
 * Decompiled with CFR 0.152.
 */
package org.kbinani;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BDelegate {
    Method m_method = null;
    Object m_invoker = null;
    String m_name = "";

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof BDelegate)) {
            return false;
        }
        BDelegate bDelegate = (BDelegate)object;
        if (!this.m_method.equals(bDelegate.m_method)) {
            return false;
        }
        return this.m_invoker == bDelegate.m_invoker;
    }

    public BDelegate(Class<?> clazz, String string, Class<?> clazz2, Class<?> ... classArray) throws Exception {
        this.m_name = string;
        this.m_invoker = null;
        for (Method method : clazz.getDeclaredMethods()) {
            Class<?>[] classArray2;
            if (!method.getName().equals(string) || !this.compareType(method.getReturnType(), clazz2) || (classArray2 = method.getParameterTypes()).length != classArray.length) continue;
            boolean bl = true;
            for (int i = 0; i < classArray2.length; ++i) {
                if (this.compareType(classArray2[i], classArray[i])) continue;
                bl = false;
                break;
            }
            if (!bl) continue;
            this.m_method = method;
            break;
        }
        if (this.m_method == null) {
            throw new Exception("don't know such method '" + string + "'");
        }
    }

    public BDelegate(Object object, String string, Class<?> clazz, Class<?> ... classArray) throws Exception {
        this(object.getClass(), string, clazz, classArray);
        this.m_invoker = object;
    }

    public Object invoke(Object ... objectArray) throws IllegalAccessException, InvocationTargetException {
        Object object = null;
        try {
            object = this.m_method.invoke(this.m_invoker, objectArray);
        }
        catch (Exception exception) {
            System.err.println("BDelegate#invoke; name=" + this.m_name + "; class=" + this.m_method.getDeclaringClass().toString() + "; ex=" + exception);
            this.printThrowableRecurse(exception, 1);
        }
        return object;
    }

    private void printThrowableRecurse(Throwable throwable, int n) {
        String string = "    ";
        String string2 = "";
        if (throwable == null) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            string2 = string2 + string;
        }
        System.err.println(string2 + throwable.toString());
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            StackTraceElement stackTraceElement = stackTraceElementArray[i];
            String string3 = stackTraceElement.getFileName();
            if (string3 == null || string3.equals("")) continue;
            System.err.println(string2 + stackTraceElement.getClassName() + "." + stackTraceElement.getMethodName() + "(" + string3 + ":" + stackTraceElement.getLineNumber() + ")");
        }
        this.printThrowableRecurse(throwable.getCause(), n + 1);
    }

    private boolean compareType(Class<?> clazz, Class<?> clazz2) {
        Class<?> clazz3 = this.transform(clazz);
        Class<?> clazz4 = this.transform(clazz2);
        return clazz3.equals(clazz4);
    }

    private Class<?> transform(Class<?> clazz) {
        if (clazz.equals(Integer.class)) {
            return Integer.TYPE;
        }
        if (clazz.equals(Byte.class)) {
            return Byte.TYPE;
        }
        if (clazz.equals(Void.class)) {
            return Void.TYPE;
        }
        if (clazz.equals(Double.class)) {
            return Double.TYPE;
        }
        if (clazz.equals(Float.class)) {
            return Float.TYPE;
        }
        if (clazz.equals(Boolean.class)) {
            return Boolean.TYPE;
        }
        if (clazz.equals(Character.class)) {
            return Character.TYPE;
        }
        if (clazz.equals(Long.class)) {
            return Long.TYPE;
        }
        if (clazz.equals(Short.class)) {
            return Short.TYPE;
        }
        return clazz;
    }
}

