/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.CreationTimeCache;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileEventListener;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.FileManagerEvent;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MetaFileManager
extends FileManager {
    private static final Log LOG;
    private Saver saver;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.xml.MetaFileManager");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public synchronized Response[] query(QueryRequest queryRequest) {
        Response[] responseArray;
        LimeXMLDocument limeXMLDocument;
        Response[] responseArray2 = super.query(queryRequest);
        if (this.shouldIncludeXMLInResponse(queryRequest) && (limeXMLDocument = queryRequest.getRichQuery()) != null && (responseArray = this.query(limeXMLDocument)) != null) {
            responseArray2 = this.union(responseArray2, responseArray, limeXMLDocument);
        }
        return responseArray2;
    }

    protected boolean isValidXMLMatch(Response response, LimeXMLDocument limeXMLDocument) {
        return LimeXMLUtils.match(response.getDocument(), limeXMLDocument, true);
    }

    protected boolean shouldIncludeXMLInResponse(QueryRequest queryRequest) {
        return queryRequest.desiresXMLResponses() || queryRequest.desiresOutOfBandReplies();
    }

    protected void addXMLToResponse(Response response, FileDesc fileDesc) {
        List list = fileDesc.getLimeXMLDocuments();
        if (list.size() == 0) {
            return;
        }
        if (list.size() == 1) {
            response.setDocument((LimeXMLDocument)list.get(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fileChanged(File file) {
        Object object;
        FileDesc fileDesc;
        if (LOG.isTraceEnabled()) {
            LOG.debug((Object)("File Changed: " + file));
        }
        if ((fileDesc = this.getFileDescForFile(file)) == null) {
            return;
        }
        CreationTimeCache creationTimeCache = CreationTimeCache.instance();
        final Long l = creationTimeCache.getCreationTime(fileDesc.getSHA1Urn());
        List list = fileDesc.getLimeXMLDocuments();
        if (LimeXMLUtils.isEditableFormat(file)) {
            try {
                object = MetaDataReader.readDocument(file);
                list = this.resolveWriteableDocs(list, (LimeXMLDocument)object);
            }
            catch (IOException iOException) {
                list = Collections.EMPTY_LIST;
            }
        }
        if (fileDesc != (object = this.removeFileIfShared(file, false))) {
            Assert.that(false, "wanted to remove: " + fileDesc + "\ndid remove: " + object);
        }
        MetaFileManager metaFileManager = this;
        synchronized (metaFileManager) {
            _needRebuild = true;
        }
        this.addFileIfShared(file, list, false, this._revision, new FileEventListener((FileDesc)object){
            private final /* synthetic */ FileDesc val$removed;
            {
                this.val$removed = fileDesc;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void handleFileEvent(FileManagerEvent fileManagerEvent) {
                FileManagerEvent fileManagerEvent2 = null;
                if (fileManagerEvent.isAddEvent()) {
                    CreationTimeCache creationTimeCache;
                    FileDesc fileDesc = fileManagerEvent.getFileDescs()[0];
                    CreationTimeCache creationTimeCache2 = creationTimeCache = CreationTimeCache.instance();
                    synchronized (creationTimeCache2) {
                        creationTimeCache.removeTime(fileDesc.getSHA1Urn());
                        creationTimeCache.addTime(fileDesc.getSHA1Urn(), l);
                        creationTimeCache.commitTime(fileDesc.getSHA1Urn());
                    }
                    fileManagerEvent2 = new FileManagerEvent((FileManager)MetaFileManager.this, 4, new FileDesc[]{this.val$removed, fileDesc});
                } else {
                    fileManagerEvent2 = new FileManagerEvent((FileManager)MetaFileManager.this, 2, this.val$removed);
                }
                MetaFileManager.this.dispatchFileEvent(fileManagerEvent2);
            }
        });
    }

    private List resolveWriteableDocs(List list, LimeXMLDocument limeXMLDocument) {
        Object object;
        LimeXMLDocument limeXMLDocument2 = null;
        LimeXMLSchema limeXMLSchema = LimeXMLSchemaRepository.instance().getSchema(AudioMetaData.schemaURI);
        Object object2 = list.iterator();
        while (object2.hasNext()) {
            object = (LimeXMLDocument)object2.next();
            if (((LimeXMLDocument)object).getSchema() != limeXMLSchema) continue;
            limeXMLDocument2 = object;
            break;
        }
        if (limeXMLDocument.equals(limeXMLDocument2)) {
            return list;
        }
        object2 = new ArrayList();
        object2.addAll(list);
        if (limeXMLDocument2 == null) {
            object2.add(limeXMLDocument);
            return object2;
        }
        object2.remove(limeXMLDocument2);
        object = limeXMLDocument2.getOrderedNameValueList();
        List list2 = limeXMLDocument.getOrderedNameValueList();
        int n = 0;
        while (n < object.size()) {
            NameValue nameValue = (NameValue)object.get(n);
            if (AudioMetaData.isNonLimeAudioField(nameValue.getName())) {
                list2.add(nameValue);
            }
            ++n;
        }
        limeXMLDocument2 = new LimeXMLDocument(list2, AudioMetaData.schemaURI);
        object2.add(limeXMLDocument2);
        return object2;
    }

    protected synchronized FileDesc removeFileIfShared(File file, boolean bl) {
        FileDesc fileDesc = super.removeFileIfShared(file, bl);
        if (fileDesc == null) {
            return null;
        }
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        List list = fileDesc.getLimeXMLDocuments();
        LinkedList<String> linkedList = new LinkedList<String>();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            linkedList.add(((LimeXMLDocument)iterator.next()).getSchemaURI());
        }
        iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string);
            if (limeXMLReplyCollection == null) continue;
            limeXMLReplyCollection.removeDoc(fileDesc);
        }
        _needRebuild = true;
        return fileDesc;
    }

    protected void loadStarted(int n) {
        RouterService.getCallback().setAnnotateEnabled(false);
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        int n2 = 0;
        while (n2 < stringArray.length) {
            schemaReplyCollectionMapper.add(stringArray[n2], new LimeXMLReplyCollection(stringArray[n2]));
            ++n2;
        }
        super.loadStarted(n);
    }

    protected void loadFinished(int n) {
        if (this.saver == null) {
            this.saver = new Saver();
            RouterService.schedule(this.saver, 60000L, 60000L);
        }
        Collection collection = SchemaReplyCollectionMapper.instance().getCollections();
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            ((LimeXMLReplyCollection)iterator.next()).loadFinished();
        }
        RouterService.getCallback().setAnnotateEnabled(true);
        super.loadFinished(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFile(FileDesc fileDesc, File file, List list, Set set) {
        super.loadFile(fileDesc, file, list, set);
        boolean bl = false;
        Collection collection = SchemaReplyCollectionMapper.instance().getCollections();
        Object object = collection.iterator();
        while (object.hasNext()) {
            bl |= ((LimeXMLReplyCollection)object.next()).initialize(fileDesc, list) != null;
        }
        object = collection.iterator();
        while (object.hasNext()) {
            bl |= ((LimeXMLReplyCollection)object.next()).createIfNecessary(fileDesc) != null;
        }
        if (bl) {
            object = this;
            synchronized (object) {
                _needRebuild = true;
            }
        }
    }

    protected void save() {
        if (this.isLoadFinished()) {
            Collection collection = SchemaReplyCollectionMapper.instance().getCollections();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                ((LimeXMLReplyCollection)iterator.next()).writeMapToDisk();
            }
        }
        super.save();
    }

    private Response[] union(Response[] responseArray, Response[] responseArray2, LimeXMLDocument limeXMLDocument) {
        if (responseArray == null || responseArray.length == 0) {
            return responseArray2;
        }
        if (responseArray2 == null || responseArray2.length == 0) {
            return responseArray;
        }
        HashSet<Response> hashSet = new HashSet<Response>();
        int n = 0;
        while (n < responseArray2.length) {
            hashSet.add(responseArray2[n]);
            ++n;
        }
        n = 0;
        while (n < responseArray.length) {
            hashSet.add(responseArray[n]);
            ++n;
        }
        Response[] responseArray3 = new Response[hashSet.size()];
        responseArray3 = hashSet.toArray(responseArray3);
        return responseArray3;
    }

    protected void buildQRT() {
        super.buildQRT();
        Iterator iterator = this.getXMLKeyWords().iterator();
        while (iterator.hasNext()) {
            _queryRouteTable.add((String)iterator.next());
        }
        iterator = this.getXMLIndivisibleKeyWords().iterator();
        while (iterator.hasNext()) {
            _queryRouteTable.addIndivisible((String)iterator.next());
        }
    }

    private List getXMLKeyWords() {
        ArrayList arrayList = new ArrayList();
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(stringArray[n2]);
            if (limeXMLReplyCollection != null) {
                arrayList.addAll(limeXMLReplyCollection.getKeyWords());
            }
            ++n2;
        }
        return arrayList;
    }

    private List getXMLIndivisibleKeyWords() {
        ArrayList<String> arrayList = new ArrayList<String>();
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = 0;
        while (n < stringArray.length) {
            LimeXMLReplyCollection limeXMLReplyCollection;
            if (stringArray[n] != null) {
                arrayList.add(stringArray[n]);
            }
            if ((limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(stringArray[n])) != null) {
                arrayList.addAll(limeXMLReplyCollection.getKeyWordsIndivisible());
            }
            ++n;
        }
        return arrayList;
    }

    private Response[] query(LimeXMLDocument limeXMLDocument) {
        String string = limeXMLDocument.getSchemaURI();
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string);
        if (limeXMLReplyCollection == null) {
            return null;
        }
        List list = limeXMLReplyCollection.getMatchingReplies(limeXMLDocument);
        int n = list.size();
        if (n == 0) {
            return null;
        }
        Response[] responseArray = new Response[n];
        int n2 = 0;
        Response[] responseArray2 = list.iterator();
        while (responseArray2.hasNext()) {
            LimeXMLDocument limeXMLDocument2 = (LimeXMLDocument)responseArray2.next();
            File file = limeXMLDocument2.getIdentifier();
            Response response = null;
            if (file == null) {
                response = new Response(0xFFFFFFFFL, 0L, " ");
            } else {
                FileDesc fileDesc = RouterService.getFileManager().getFileDescForFile(file);
                if (fileDesc == null) continue;
                response = new Response(fileDesc);
                fileDesc.incrementHitCount();
                RouterService.getCallback().handleSharedFileUpdate(fileDesc.getFile());
            }
            response.setDocument(limeXMLDocument2);
            responseArray[n2] = response;
            ++n2;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 < n) {
            responseArray2 = new Response[n2];
            System.arraycopy(responseArray, 0, responseArray2, 0, n2);
            responseArray = responseArray2;
        }
        return responseArray;
    }

    private class Saver
    implements Runnable {
        private Saver() {
        }

        public void run() {
            if (!MetaFileManager.this.shutdown && MetaFileManager.this.isLoadFinished()) {
                MetaFileManager.this.save();
            }
        }
    }
}

