/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.messages.vendor;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Connection;
import com.limegroup.gnutella.Constants;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.ManagedConnection;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.IPPortCombo;
import com.limegroup.gnutella.messages.vendor.UDPCrawlerPing;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ApplicationSettings;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.StringUtils;
import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.GZIPOutputStream;

public class UDPCrawlerPong
extends VendorMessage {
    public static final int VERSION = 1;
    public static final String AGENT_SEP = ";";

    public UDPCrawlerPong(UDPCrawlerPing uDPCrawlerPing) {
        super(F_LIME_VENDOR_ID, 6, 1, UDPCrawlerPong.derivePayload(uDPCrawlerPing));
        this.setGUID(new GUID(uDPCrawlerPing.getGUID()));
    }

    private static byte[] derivePayload(UDPCrawlerPing uDPCrawlerPing) {
        Object object;
        long l;
        Object object2;
        byte by = (byte)(uDPCrawlerPing.getFormat() & 0x3F);
        List list = new LinkedList<Connection>();
        List list2 = new LinkedList<Object>();
        Iterator iterator = RouterService.getConnectionManager().getInitializedConnections().iterator();
        boolean bl = uDPCrawlerPing.hasNewOnly();
        while (iterator.hasNext()) {
            object2 = (Connection)iterator.next();
            if (bl) {
                if (((Connection)object2).remoteHostSupportsUDPCrawling() < 1) continue;
                list.add(object2);
                continue;
            }
            if (!((Connection)object2).isGoodUltrapeer()) continue;
            list.add(object2);
        }
        iterator = RouterService.getConnectionManager().getInitializedClientConnections().iterator();
        while (iterator.hasNext()) {
            object2 = (Connection)iterator.next();
            list2.add(object2);
        }
        if (!uDPCrawlerPing.hasLocaleInfo()) {
            if (uDPCrawlerPing.getNumberUP() != -1 && uDPCrawlerPing.getNumberUP() < list.size()) {
                int n = (int)Math.floor(Math.random() * (double)(list.size() - uDPCrawlerPing.getNumberUP()));
                list = list.subList(n, n + uDPCrawlerPing.getNumberUP());
            }
            if (uDPCrawlerPing.getNumberLeaves() != -1 && uDPCrawlerPing.getNumberLeaves() < list2.size()) {
                int n = (int)Math.floor(Math.random() * (double)(list2.size() - uDPCrawlerPing.getNumberLeaves()));
                list2 = list2.subList(n, n + uDPCrawlerPing.getNumberLeaves());
            }
        } else {
            object2 = ApplicationSettings.LANGUAGE.getValue();
            List list3 = RouterService.getConnectionManager().getInitializedConnectionsMatchLocale((String)object2);
            list.removeAll(list3);
            list3.addAll(list);
            list = list3;
            list3 = RouterService.getConnectionManager().getInitializedClientConnectionsMatchLocale((String)object2);
            list2.removeAll(list3);
            list3.addAll(list2);
            list2 = list3;
            if (uDPCrawlerPing.getNumberUP() != -1 && uDPCrawlerPing.getNumberUP() < list.size()) {
                list = list.subList(0, uDPCrawlerPing.getNumberUP());
            }
            if (uDPCrawlerPing.getNumberLeaves() != -1 && uDPCrawlerPing.getNumberLeaves() < list2.size()) {
                list2 = list2.subList(0, uDPCrawlerPing.getNumberLeaves());
            }
        }
        int n = 6;
        if (uDPCrawlerPing.hasConnectionTime()) {
            n += 2;
        }
        if (uDPCrawlerPing.hasLocaleInfo()) {
            n += 2;
        }
        if (uDPCrawlerPing.hasReplies()) {
            n += 4;
        }
        int n2 = uDPCrawlerPing.hasNodeUptime() ? 7 : 3;
        byte[] byArray = new byte[(list.size() + list2.size()) * n + n2];
        byArray[0] = (byte)list.size();
        byArray[1] = (byte)list2.size();
        byArray[2] = by;
        if (uDPCrawlerPing.hasNodeUptime()) {
            l = RouterService.getConnectionManager().getCurrentAverageUptime() / 1000L;
            if (l > Integer.MAX_VALUE) {
                l = Integer.MAX_VALUE;
            }
            ByteOrder.int2leb((int)l, byArray, 3);
        }
        list.addAll(list2);
        l = System.currentTimeMillis();
        iterator = list.iterator();
        while (iterator.hasNext()) {
            object = (ManagedConnection)iterator.next();
            System.arraycopy(UDPCrawlerPong.packIPAddress(((Connection)object).getInetAddress(), ((Connection)object).getPort()), 0, byArray, n2, 6);
            n2 += 6;
            if (uDPCrawlerPing.hasConnectionTime()) {
                long l2 = l - ((Connection)object).getConnectionTime();
                short s = (short)(l2 / Constants.MINUTE);
                ByteOrder.short2leb(s, byArray, n2);
                n2 += 2;
            }
            if (uDPCrawlerPing.hasLocaleInfo()) {
                System.arraycopy(((Connection)object).getLocalePref().getBytes(), 0, byArray, n2, 2);
                n2 += 2;
            }
            if (!uDPCrawlerPing.hasReplies()) continue;
            ByteOrder.int2leb(ByteOrder.long2int(((ManagedConnection)object).getNumQueryReplies()), byArray, n2);
            n2 += 4;
        }
        if (uDPCrawlerPing.hasUserAgent()) {
            Object object3;
            object = new StringBuffer();
            iterator = list.iterator();
            while (iterator.hasNext()) {
                Connection connection = (Connection)iterator.next();
                object3 = connection.getUserAgent();
                object3 = StringUtils.replace((String)object3, AGENT_SEP, "\\;");
                ((StringBuffer)object).append((String)object3).append(AGENT_SEP);
            }
            ((StringBuffer)object).append(CommonUtils.getHttpServer());
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            try {
                object3 = new GZIPOutputStream(byteArrayOutputStream);
                byte[] byArray2 = new byte[2];
                ByteOrder.short2leb((short)((StringBuffer)object).length(), byArray2, 0);
                ((FilterOutputStream)object3).write(byArray2);
                ((FilterOutputStream)object3).write(((StringBuffer)object).toString().getBytes());
                ((DeflaterOutputStream)object3).flush();
                ((DeflaterOutputStream)object3).close();
            }
            catch (IOException iOException) {
                ErrorService.error(iOException);
            }
            object3 = byteArrayOutputStream.toByteArray();
            byte[] byArray3 = byArray;
            byArray = new byte[byArray.length + ((Object)object3).length + 2];
            System.arraycopy(byArray3, 0, byArray, 0, byArray3.length);
            ByteOrder.short2leb((short)((Object)object3).length, byArray, byArray3.length);
            System.arraycopy(object3, 0, byArray, byArray3.length + 2, ((Object)object3).length);
        }
        return byArray;
    }

    private static byte[] packIPAddress(InetAddress inetAddress, int n) {
        try {
            IPPortCombo iPPortCombo = new IPPortCombo(inetAddress.getHostAddress(), n);
            return iPPortCombo.toBytes();
        }
        catch (UnknownHostException unknownHostException) {
            throw new IllegalArgumentException(unknownHostException.getMessage());
        }
    }
}

