/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ReadState;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class ReadSkipState
extends ReadState {
    private long leftToRead;

    public ReadSkipState(long l) {
        this.leftToRead = l;
    }

    protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        this.leftToRead = BufferUtils.delete(byteBuffer, this.leftToRead);
        int n = 0;
        while (this.leftToRead > 0L && (n = readableByteChannel.read(byteBuffer)) > 0) {
            this.leftToRead = BufferUtils.delete(byteBuffer, this.leftToRead);
        }
        if (this.leftToRead > 0L && n == -1) {
            throw new IOException("EOF");
        }
        return this.leftToRead > 0L;
    }

    public long getAmountProcessed() {
        return -1L;
    }
}

