/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.io;

import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ChannelReadObserver;
import com.limegroup.gnutella.io.InterestReadChannel;
import java.io.IOException;
import java.nio.ByteBuffer;

public abstract class AbstractChannelInterestRead
implements ChannelReadObserver,
InterestReadChannel {
    protected ByteBuffer buffer = ByteBuffer.allocate(this.getBufferSize());
    protected InterestReadChannel source;
    protected boolean shutdown;

    protected abstract int getBufferSize();

    public int read(ByteBuffer byteBuffer) {
        return BufferUtils.transfer(this.buffer, byteBuffer);
    }

    public void shutdown() {
        this.shutdown = true;
    }

    public InterestReadChannel getReadChannel() {
        return this.source;
    }

    public void setReadChannel(InterestReadChannel interestReadChannel) {
        this.source = interestReadChannel;
    }

    public void interest(boolean bl) {
        this.source.interest(bl);
    }

    public void close() throws IOException {
        this.source.close();
    }

    public boolean isOpen() {
        return this.source.isOpen();
    }

    public void handleIOException(IOException iOException) {
    }
}

