/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.http;

import com.limegroup.gnutella.http.HeaderSupport;
import com.limegroup.gnutella.io.BufferUtils;
import com.limegroup.gnutella.io.ReadState;
import com.limegroup.gnutella.statistics.Statistic;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class ReadHeadersIOState
extends ReadState {
    private static final Log LOG;
    protected final HeaderSupport support;
    private final Statistic stat;
    private final int maxHeaderSize;
    private final int maxHeaders;
    protected boolean doneConnect;
    protected StringBuffer currentHeader = new StringBuffer(1024);
    protected String connectLine;
    private long amountRead;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.http.ReadHeadersIOState");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public ReadHeadersIOState(HeaderSupport headerSupport, Statistic statistic, int n, int n2) {
        this.support = headerSupport;
        this.stat = statistic;
        this.maxHeaders = n;
        this.maxHeaderSize = n2;
    }

    protected boolean processRead(ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer) throws IOException {
        boolean bl = false;
        while (!bl) {
            int n = 0;
            while (byteBuffer.hasRemaining() && (n = readableByteChannel.read(byteBuffer)) > 0) {
                if (this.stat != null) {
                    this.stat.addData(n);
                }
                this.amountRead += (long)n;
            }
            if (byteBuffer.position() == 0) {
                if (n != -1) break;
                throw new IOException("EOF");
            }
            byteBuffer.flip();
            if (!this.doneConnect && BufferUtils.readLine(byteBuffer, this.currentHeader)) {
                this.connectLine = this.currentHeader.toString();
                LOG.debug((Object)("Read connect line: " + this.connectLine));
                this.currentHeader.delete(0, this.currentHeader.length());
                this.processConnectLine();
                this.doneConnect = true;
            }
            if (this.doneConnect) {
                while (BufferUtils.readLine(byteBuffer, this.currentHeader)) {
                    LOG.debug((Object)("Read header: " + this.currentHeader));
                    if (!this.support.processReadHeader(this.currentHeader.toString())) {
                        bl = true;
                        break;
                    }
                    this.currentHeader.delete(0, this.currentHeader.length());
                    if (this.support.getHeadersReadSize() <= this.maxHeaders) continue;
                    throw new IOException("too many headers");
                }
            }
            byteBuffer.compact();
            if (this.currentHeader.length() <= this.maxHeaderSize) continue;
            throw new IOException("header too big");
        }
        if (bl) {
            this.processHeaders();
            return false;
        }
        return true;
    }

    public long getAmountProcessed() {
        return this.amountRead;
    }

    protected abstract void processConnectLine() throws IOException;

    protected abstract void processHeaders() throws IOException;
}

