/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.filters;

import com.limegroup.gnutella.ByteOrder;

public class IP {
    private static final String MSG = "Could not parse: ";
    private final int addr;
    private final int mask;

    public IP(byte[] byArray) throws IllegalArgumentException {
        if (byArray.length != 4) {
            throw new IllegalArgumentException(MSG);
        }
        this.addr = IP.bytesToInt(byArray, 0);
        this.mask = -1;
    }

    public IP(String string) throws IllegalArgumentException {
        int n = string.indexOf(47);
        if (n == -1) {
            this.mask = IP.createNetmaskFromWildChars(string);
            this.addr = IP.stringToInt(string);
        } else if (string.lastIndexOf(47) == n) {
            this.mask = IP.parseNetmask(string.substring(n + 1));
            this.addr = IP.stringToInt(string.substring(0, n)) & this.mask;
        } else {
            throw new IllegalArgumentException(MSG + string);
        }
    }

    private static int parseNetmask(String string) throws IllegalArgumentException {
        if (string.indexOf(46) != -1) {
            return IP.stringToInt(string);
        }
        try {
            int n = Integer.parseInt(string);
            if (n >= 0 && n <= 32) {
                return n == 32 ? -1 : ~(-1 >>> n);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        throw new IllegalArgumentException(MSG + string);
    }

    private static int bytesToInt(byte[] byArray, int n) {
        return ByteOrder.beb2int(byArray, n);
    }

    private static int stringToInt(String string) throws IllegalArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 0;
            int n6 = 0;
            while (n4 < n3) {
                block10: {
                    block9: {
                        char c;
                        block8: {
                            c = string.charAt(n4);
                            if (c != '.') break block8;
                            if (n6 != 0 && n2 < 3) {
                                break;
                            }
                            break block9;
                        }
                        if (c == '*' ? n6 == 0 : c >= '0' && c <= '9' && n6 <= 2 && (n5 = n5 * 10 + c - 48) <= 255) break block10;
                    }
                    throw new IllegalArgumentException(MSG + string);
                }
                ++n4;
                ++n6;
            }
            n = n << 8 | n5;
            ++n4;
            ++n2;
        }
        if (n2 < 4) {
            n <<= (4 - n2) * 8;
        }
        return n;
    }

    private static int createNetmaskFromWildChars(String string) throws IllegalArgumentException {
        int n = 0;
        int n2 = 0;
        int n3 = string.length();
        int n4 = 0;
        while (n4 < n3) {
            int n5 = 255;
            int n6 = 0;
            while (n4 < n3) {
                block11: {
                    block9: {
                        char c;
                        block10: {
                            block8: {
                                c = string.charAt(n4);
                                if (c != '.') break block8;
                                if (n6 != 0 && n2 < 3) {
                                    break;
                                }
                                break block9;
                            }
                            if (c != '*') break block10;
                            if (n6 != 0) break block9;
                            n5 = 0;
                            break block11;
                        }
                        if (c >= '0' && c <= '9' && n6 <= 2) break block11;
                    }
                    throw new IllegalArgumentException(MSG + string);
                }
                ++n4;
                ++n6;
            }
            n = n << 8 | n5;
            ++n4;
            ++n2;
        }
        if (n2 < 4) {
            n <<= (4 - n2) * 8;
        }
        return n;
    }

    int getMask() {
        return this.mask;
    }

    public int getDistanceTo(IP iP) {
        return (iP.addr ^ this.addr) & iP.mask & this.mask;
    }

    public boolean contains(IP iP) {
        return (iP.addr & this.mask) == this.addr && (iP.mask & this.mask) == this.mask;
    }

    public boolean equals(Object object) {
        if (object instanceof IP) {
            IP iP = (IP)object;
            return this.mask == iP.mask && (this.addr & this.mask) == (iP.addr & iP.mask);
        }
        return false;
    }

    public int hashCode() {
        return this.addr ^ this.mask;
    }
}

