/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.downloader.HTTPConnectObserver;
import com.limegroup.gnutella.downloader.PushDetails;
import com.limegroup.gnutella.util.NetworkUtils;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PushList {
    private static final Log LOG;
    private final TreeMap pushers = new TreeMap(GUID.GUID_BYTE_COMPARATOR);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.downloader.PushList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPushHost(PushDetails pushDetails, HTTPConnectObserver hTTPConnectObserver) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Adding observer for details: " + pushDetails));
        }
        TreeMap treeMap = this.pushers;
        synchronized (treeMap) {
            byte[] byArray = pushDetails.getClientGUID();
            LinkedList<Push> linkedList = (LinkedList<Push>)this.pushers.get(byArray);
            if (linkedList == null) {
                linkedList = new LinkedList<Push>();
                this.pushers.put(byArray, linkedList);
            }
            linkedList.add(new Push(pushDetails, hTTPConnectObserver));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectObserver getExactHostFor(PushDetails pushDetails) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving exact match for details: " + pushDetails));
        }
        TreeMap treeMap = this.pushers;
        synchronized (treeMap) {
            List list;
            byte[] byArray;
            block7: {
                byArray = pushDetails.getClientGUID();
                list = (List)this.pushers.get(byArray);
                if (list != null) break block7;
                LOG.debug((Object)"No pushes waiting on those exact details.");
                return null;
            }
            Push push = this.getExactHost(list, pushDetails);
            if (list.isEmpty()) {
                this.pushers.remove(byArray);
            }
            if (push != null) {
                return push.observer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HTTPConnectObserver getHostFor(byte[] byArray, String string) {
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieving best match for address: " + string + ", guid: " + new GUID(byArray)));
        }
        TreeMap treeMap = this.pushers;
        synchronized (treeMap) {
            List list;
            block7: {
                list = (List)this.pushers.get(byArray);
                if (list != null) break block7;
                LOG.debug((Object)"No pushes waiting on that GUID.");
                return null;
            }
            Push push = this.getBestHost(list, string);
            if (list.isEmpty()) {
                this.pushers.remove(byArray);
            }
            if (push != null) {
                return push.observer;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getAllAndClear() {
        LinkedList<HTTPConnectObserver> linkedList = new LinkedList<HTTPConnectObserver>();
        TreeMap treeMap = this.pushers;
        synchronized (treeMap) {
            Iterator iterator = this.pushers.values().iterator();
            while (iterator.hasNext()) {
                List list = (List)iterator.next();
                if (list == null) continue;
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    Push push = (Push)iterator2.next();
                    linkedList.add(push.observer);
                }
            }
            this.pushers.clear();
        }
        return linkedList;
    }

    private Push getBestHost(List list, String string) {
        Push push;
        if (list.isEmpty()) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            push = (Push)iterator.next();
            if (!push.details.getAddress().equals(string)) continue;
            LOG.debug((Object)"Found an exact match!");
            iterator.remove();
            return push;
        }
        LOG.debug((Object)"No exact match, using first private|bogus address.");
        iterator = list.iterator();
        while (iterator.hasNext()) {
            push = (Push)iterator.next();
            if (!NetworkUtils.isPrivateAddress(push.details.getAddress()) && !push.details.getAddress().equals("1.1.1.1")) continue;
            iterator.remove();
            return push;
        }
        LOG.debug((Object)"No private address to use!");
        return null;
    }

    private Push getExactHost(List list, PushDetails pushDetails) {
        if (list.isEmpty()) {
            return null;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Push push = (Push)iterator.next();
            if (!push.details.equals(pushDetails)) continue;
            iterator.remove();
            return push;
        }
        LOG.debug((Object)"No exact match!");
        return null;
    }

    private static class Push {
        private final PushDetails details;
        private final HTTPConnectObserver observer;

        Push(PushDetails pushDetails, HTTPConnectObserver hTTPConnectObserver) {
            this.details = pushDetails;
            this.observer = hTTPConnectObserver;
        }
    }
}

