/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.downloader;

import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.ResponseVerifier;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.Vector;
import org.xml.sax.SAXException;

public class AutoDownloadDetails
implements Serializable {
    static final long serialVersionUID = 3400666689236195243L;
    private String query = null;
    private String richQuery = null;
    private transient LimeXMLDocument xmlDoc = null;
    private transient boolean xmlCreated = false;
    private transient MediaType type = null;
    private byte[] guid = null;
    private List dlList = null;
    private String mediaDesc;
    private static final int MATCHER_BUF_SIZE = 120;
    private static ApproximateMatcher matcher = new ApproximateMatcher(120);
    private float MATCH_PRECISION_DL = 0.3f;
    private float WORD_INCIDENCE_RATE = 0.509999f;
    private int LOW_SCORE = 95;
    private Set wordSet = null;
    public static final int MAX_DOWNLOADS = 1;
    private int committedDLs = 0;
    private static final boolean debugOn = false;

    static {
        matcher.setIgnoreCase(true);
        matcher.setIgnoreWhitespace(true);
        matcher.setCompareBackwards(true);
    }

    public AutoDownloadDetails(String string, String string2, byte[] byArray, MediaType mediaType) {
        this.query = string;
        this.richQuery = string2;
        this.type = mediaType;
        this.mediaDesc = this.type != null ? this.type.getMimeType() : null;
        this.guid = byArray;
        this.dlList = new Vector();
        this.wordSet = new HashSet();
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        this.type = this.mediaDesc == null ? MediaType.getAnyTypeMediaType() : MediaType.getMediaTypeForSchema(this.mediaDesc);
        if (this.type == null) {
            this.type = MediaType.getAnyTypeMediaType();
        }
    }

    public String getQuery() {
        return this.query;
    }

    public String getRichQuery() {
        return this.richQuery;
    }

    public MediaType getMediaType() {
        return this.type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean addDownload(RemoteFileDesc remoteFileDesc) {
        AutoDownloadDetails.debug("ADD.addDownload(): *-----------");
        AutoDownloadDetails.debug("ADD.addDownload(): entered.");
        boolean bl = true;
        if (!this.expired()) {
            int n;
            Object object;
            int n2;
            String string = remoteFileDesc.getFileName();
            if (this.type != null && !this.type.matches(string)) {
                bl = false;
                AutoDownloadDetails.debug("ADD.addDownload(): file " + string + " isn't the right type.");
            }
            if (!this.xmlCreated) {
                this.xmlCreated = true;
                if (this.richQuery != null && !this.richQuery.equals("")) {
                    try {
                        this.xmlDoc = new LimeXMLDocument(this.richQuery);
                    }
                    catch (SchemaNotFoundException schemaNotFoundException) {
                    }
                    catch (SAXException sAXException) {
                    }
                    catch (IOException iOException) {}
                }
            }
            if ((n2 = ResponseVerifier.score(this.query, this.xmlDoc, remoteFileDesc)) < this.LOW_SCORE) {
                bl = false;
                AutoDownloadDetails.debug("ADD.addDownload(): file " + string + " has low score of " + n2);
            }
            if (bl && this.wordSet.size() > 0) {
                object = new StringTokenizer(this.ripExtension(string), " -._+/*()\\,");
                n = 0;
                int n3 = ((StringTokenizer)object).countTokens();
                while (((StringTokenizer)object).hasMoreTokens()) {
                    String string2 = ((StringTokenizer)object).nextToken().toLowerCase();
                    AutoDownloadDetails.debug("ADD.addDownload(): currToken = " + string2);
                    if (this.wordSet.contains(string2)) continue;
                    ++n;
                }
                float f = (float)(n3 - n) / (float)this.wordSet.size();
                if (n == 0 || f > this.WORD_INCIDENCE_RATE) {
                    bl = false;
                    AutoDownloadDetails.debug("ADD.addDownload(): file " + string + " has many elements similar to" + " other files. matchRate = " + f + ", additions = " + n);
                }
            }
            if (bl && this.dlList.size() > 0) {
                ApproximateMatcher approximateMatcher = matcher;
                synchronized (approximateMatcher) {
                    object = matcher.process(string);
                }
                n = 0;
                while (n < this.dlList.size()) {
                    String string3;
                    RemoteFileDesc remoteFileDesc2 = (RemoteFileDesc)this.dlList.get(n);
                    String string4 = remoteFileDesc2.getFileName();
                    int n4 = 0;
                    ApproximateMatcher approximateMatcher2 = matcher;
                    synchronized (approximateMatcher2) {
                        string3 = matcher.process(string4);
                        n4 = matcher.match((String)object, string3);
                    }
                    int n5 = Math.min(((String)object).length(), string3.length());
                    if ((float)n4 / (float)n5 < this.MATCH_PRECISION_DL) {
                        bl = false;
                        AutoDownloadDetails.debug("ADD.addDownload(): conflict for file " + string + " and " + string4);
                    }
                    if (!bl) break;
                    ++n;
                }
            }
            if (bl) {
                this.dlList.add(remoteFileDesc);
                object = new StringTokenizer(this.ripExtension(string), " -._+/*()\\,");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    this.wordSet.add(((StringTokenizer)object).nextToken().toLowerCase());
                }
                AutoDownloadDetails.debug("ADD.addDownload(): wordSet = " + this.wordSet);
            }
        } else {
            bl = false;
        }
        AutoDownloadDetails.debug("ADD.addDownload(): returning " + bl);
        AutoDownloadDetails.debug("ADD.addDownload(): -----------*");
        return bl;
    }

    public synchronized void removeDownload(RemoteFileDesc remoteFileDesc) {
        this.dlList.remove(remoteFileDesc);
        StringTokenizer stringTokenizer = new StringTokenizer(this.ripExtension(remoteFileDesc.getFileName()), " -._+/*()\\,");
        while (stringTokenizer.hasMoreTokens()) {
            this.wordSet.remove(stringTokenizer.nextToken().toLowerCase());
        }
    }

    public synchronized void commitDownload(RemoteFileDesc remoteFileDesc) {
        if (this.dlList.contains(remoteFileDesc)) {
            ++this.committedDLs;
        }
    }

    public synchronized boolean expired() {
        boolean bl = false;
        if (this.committedDLs >= 1) {
            bl = true;
        }
        return bl;
    }

    private String ripExtension(String string) {
        String string2 = null;
        int n = string.lastIndexOf(46);
        string2 = n == -1 ? string : string.substring(0, n);
        return string2;
    }

    private static void debug(String string) {
    }

    private static void debug(Exception exception) {
    }
}

