/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import java.io.File;
import java.util.EventObject;

public class FileManagerEvent
extends EventObject {
    public static final int ADD = 1;
    public static final int REMOVE = 2;
    public static final int RENAME = 3;
    public static final int CHANGE = 4;
    public static final int FAILED = 5;
    public static final int ALREADY_SHARED = 6;
    public static final int ADD_FOLDER = 7;
    public static final int REMOVE_FOLDER = 8;
    private final int kind;
    private final FileDesc[] fds;
    private final File[] files;

    public FileManagerEvent(FileManager fileManager, int n, FileDesc fileDesc) {
        this(fileManager, n, new FileDesc[]{fileDesc});
    }

    public FileManagerEvent(FileManager fileManager, int n, FileDesc[] fileDescArray) {
        super(fileManager);
        this.kind = n;
        this.fds = fileDescArray;
        this.files = null;
    }

    public FileManagerEvent(FileManager fileManager, int n, File file) {
        this(fileManager, n, new File[]{file});
    }

    public FileManagerEvent(FileManager fileManager, int n, File file, File file2) {
        this(fileManager, n, new File[]{file, file2});
    }

    public FileManagerEvent(FileManager fileManager, int n, File[] fileArray) {
        super(fileManager);
        this.kind = n;
        this.files = fileArray;
        this.fds = null;
    }

    public int getKind() {
        return this.kind;
    }

    public FileDesc[] getFileDescs() {
        return this.fds;
    }

    public File[] getFiles() {
        return this.files;
    }

    public boolean isAddEvent() {
        return this.kind == 1;
    }

    public boolean isRemoveEvent() {
        return this.kind == 2;
    }

    public boolean isRenameEvent() {
        return this.kind == 3;
    }

    public boolean isChangeEvent() {
        return this.kind == 4;
    }

    public boolean isFailedEvent() {
        return this.kind == 5;
    }

    public boolean isAlreadySharedEvent() {
        return this.kind == 6;
    }

    public boolean isAddFolderEvent() {
        return this.kind == 7;
    }

    public boolean isRemoveFolderEvent() {
        return this.kind == 8;
    }

    public String toString() {
        int n;
        StringBuffer stringBuffer = new StringBuffer("FileManagerEvent: [event=");
        switch (this.kind) {
            case 1: {
                stringBuffer.append("ADD");
                break;
            }
            case 2: {
                stringBuffer.append("REMOVE");
                break;
            }
            case 3: {
                stringBuffer.append("RENAME");
                break;
            }
            case 4: {
                stringBuffer.append("CHANGE");
                break;
            }
            case 5: {
                stringBuffer.append("FAILED");
                break;
            }
            case 6: {
                stringBuffer.append("ALREADY_SHARED");
                break;
            }
            case 7: {
                stringBuffer.append("ADD_FOLDER");
                break;
            }
            case 8: {
                stringBuffer.append("REMOVE_FOLDER");
                break;
            }
            default: {
                stringBuffer.append("UNKNOWN");
            }
        }
        if (this.fds != null) {
            stringBuffer.append(", fds=").append(this.fds.length).append("\n");
            n = 0;
            while (n < this.fds.length) {
                stringBuffer.append(this.fds[n]);
                if (n != this.fds.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
        } else {
            stringBuffer.append(", fds=null");
        }
        if (this.files != null) {
            stringBuffer.append(", files=").append(this.files.length).append("\n");
            n = 0;
            while (n < this.files.length) {
                stringBuffer.append(this.files[n]);
                if (n != this.files.length - 1) {
                    stringBuffer.append(", ");
                }
                ++n;
            }
        } else {
            stringBuffer.append(", files=null");
        }
        return stringBuffer.append("]").toString();
    }
}

