/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.connection.GnetConnectObserver;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.BlockingIncomingHandshaker;
import com.limegroup.gnutella.handshaking.BlockingOutgoingHandshaker;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.Handshaker;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.io.ConnectObserver;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.MessageFactory;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.HeaderUpdateVendorMessage;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.statistics.CompressionStat;
import com.limegroup.gnutella.statistics.ConnectionStat;
import com.limegroup.gnutella.util.CompressingOutputStream;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.ThreadFactory;
import com.limegroup.gnutella.util.UncompressingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Map;
import java.util.Properties;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Connection
implements IpPort {
    private static final Log LOG;
    private final Object PING_LOCK = new Object();
    private final Object PONG_LOCK = new Object();
    private final String _host;
    private int _port;
    protected volatile Socket _socket;
    private InputStream _in;
    private OutputStream _out;
    private final boolean OUTGOING;
    protected Inflater _inflater;
    protected Deflater _deflater;
    private volatile long _bytesSent;
    private volatile long _bytesReceived;
    private volatile long _compressedBytesSent;
    private volatile long _compressedBytesReceived;
    protected MessagesSupportedVendorMessage _messagesSupported = null;
    protected CapabilitiesVM _capabilities = null;
    protected volatile boolean _closed = false;
    private HandshakeResponse _headersRead = HandshakeResponse.createEmptyResponse();
    private HandshakeResponse _headersWritten = HandshakeResponse.createEmptyResponse();
    private long _connectionTime = Long.MAX_VALUE;
    private byte _softMax;
    private volatile long _nextPingTime = Long.MIN_VALUE;
    private volatile long _nextPongTime = Long.MIN_VALUE;
    protected static final IOException CONNECTION_CLOSED;
    private final byte[] HEADER_BUF = new byte[23];
    private final byte[] OUT_HEADER_BUF = new byte[23];
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
        CONNECTION_CLOSED = new IOException("connection closed");
    }

    public Connection(String string, int n) {
        if (string == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("illegal port: " + n);
        }
        this._host = string;
        this._port = n;
        this.OUTGOING = true;
        ConnectionStat.OUTGOING_CONNECTION_ATTEMPTS.incrementStat();
    }

    public Connection(Socket socket) {
        if (socket == null) {
            throw new NullPointerException("null socket");
        }
        this._host = socket.getInetAddress().getHostAddress();
        this._port = socket.getPort();
        this._socket = socket;
        this.OUTGOING = false;
        ConnectionStat.INCOMING_CONNECTION_ATTEMPTS.incrementStat();
    }

    protected void postInit() {
        try {
            if (this._headersRead.supportsVendorMessages() > 0.0f) {
                this.send(MessagesSupportedVendorMessage.instance());
                this.send(CapabilitiesVM.instance());
            }
        }
        catch (IOException iOException) {}
    }

    protected void sendUpdatedCapabilities() {
        try {
            if (this._headersRead.supportsVendorMessages() > 0.0f) {
                this.send(CapabilitiesVM.instance());
            }
        }
        catch (IOException iOException) {}
    }

    protected void handleVendorMessage(VendorMessage vendorMessage) {
        if (vendorMessage instanceof MessagesSupportedVendorMessage) {
            this._messagesSupported = (MessagesSupportedVendorMessage)vendorMessage;
        }
        if (vendorMessage instanceof CapabilitiesVM) {
            this._capabilities = (CapabilitiesVM)vendorMessage;
        }
        if (vendorMessage instanceof HeaderUpdateVendorMessage) {
            HeaderUpdateVendorMessage headerUpdateVendorMessage = (HeaderUpdateVendorMessage)vendorMessage;
            Properties properties = this._headersRead.props();
            properties.putAll((Map<?, ?>)headerUpdateVendorMessage.getProperties());
            this._headersRead = HandshakeResponse.createResponse(properties);
        }
    }

    public void initialize(Properties properties, HandshakeResponder handshakeResponder) throws IOException, NoGnutellaOkException, BadHandshakeException {
        this.initialize(properties, handshakeResponder, 0, null);
    }

    public void initialize(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) throws IOException, NoGnutellaOkException, BadHandshakeException {
        this.initialize(properties, handshakeResponder, 0, gnetConnectObserver);
    }

    protected void initialize(Properties properties, HandshakeResponder handshakeResponder, int n, GnetConnectObserver gnetConnectObserver) throws IOException, NoGnutellaOkException, BadHandshakeException {
        if (this.isOutgoing()) {
            if (gnetConnectObserver != null) {
                this._socket = this.connect(this._host, this._port, n, this.createAsyncConnectObserver(properties, handshakeResponder, gnetConnectObserver));
            } else {
                this._socket = this.connect(this._host, this._port, n);
                this.preHandshakeInitialize(properties, handshakeResponder, gnetConnectObserver);
            }
        } else {
            this.preHandshakeInitialize(properties, handshakeResponder, gnetConnectObserver);
        }
    }

    protected Socket connect(String string, int n, int n2) throws IOException {
        return Sockets.connect(string, n, n2);
    }

    protected Socket connect(String string, int n, int n2, ConnectObserver connectObserver) throws IOException {
        return Sockets.connect(string, n, n2, connectObserver);
    }

    protected ConnectObserver createAsyncConnectObserver(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) {
        return new Connector(properties, handshakeResponder, gnetConnectObserver);
    }

    protected void preHandshakeInitialize(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) throws IOException, NoGnutellaOkException, BadHandshakeException {
        if (this._closed) {
            this._socket.close();
            throw CONNECTION_CLOSED;
        }
        InetAddress inetAddress = this._socket.getLocalAddress();
        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && this._socket.getInetAddress().equals(inetAddress) && this._port == ConnectionSettings.PORT.getValue()) {
            throw new IOException("Connection to self");
        }
        RouterService.getAcceptor().setAddress(inetAddress);
        this.performHandshake(properties, handshakeResponder, gnetConnectObserver);
    }

    protected void performHandshake(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) throws IOException, BadHandshakeException, NoGnutellaOkException {
        Handshaker handshaker = this.createHandshaker(properties, handshakeResponder);
        try {
            handshaker.shake();
        }
        catch (NoGnutellaOkException noGnutellaOkException) {
            this.setHeaders(handshaker);
            this.close();
            throw noGnutellaOkException;
        }
        catch (IOException iOException) {
            this.setHeaders(handshaker);
            this.close();
            throw new BadHandshakeException(iOException);
        }
        this.postHandshakeInitialize(handshaker);
    }

    protected Handshaker createHandshaker(Properties properties, HandshakeResponder handshakeResponder) throws IOException {
        try {
            this._in = this.getInputStream();
            this._out = this.getOutputStream();
            if (this._in == null) {
                throw new IOException("null input stream");
            }
            if (this._out == null) {
                throw new IOException("null output stream");
            }
        }
        catch (Exception exception) {
            this.close();
            throw new IOException("could not establish connection");
        }
        if (this.isOutgoing()) {
            return new BlockingOutgoingHandshaker(properties, handshakeResponder, this._socket, this._in, this._out);
        }
        return new BlockingIncomingHandshaker(handshakeResponder, this._socket, this._in, this._out);
    }

    protected void setHeaders(Handshaker handshaker) {
        this._headersWritten = handshaker.getWrittenHeaders();
        this._headersRead = handshaker.getReadHeaders();
    }

    protected void postHandshakeInitialize(Handshaker handshaker) {
        this.setHeaders(handshaker);
        this._connectionTime = System.currentTimeMillis();
        this._softMax = ConnectionSettings.SOFT_MAX.getValue();
        if (this.isGoodUltrapeer() || this.isGoodLeaf()) {
            this._softMax = (byte)(this._softMax + 1);
        }
        if (this.isWriteDeflated()) {
            this._deflater = new Deflater();
            this._out = this.createDeflatedOutputStream(this._out);
        }
        if (this.isReadDeflated()) {
            this._inflater = new Inflater();
            this._in = this.createInflatedInputStream(this._in);
        }
    }

    protected OutputStream createDeflatedOutputStream(OutputStream outputStream) {
        return new CompressingOutputStream(outputStream, this._deflater);
    }

    protected InputStream createInflatedInputStream(InputStream inputStream) {
        return new UncompressingInputStream(inputStream, this._inflater);
    }

    public boolean isAsynchronous() {
        return this._socket.getChannel() != null;
    }

    public boolean isInitialized() {
        return this._socket != null;
    }

    protected OutputStream getOutputStream() throws IOException {
        if (this.isAsynchronous()) {
            return this._socket.getOutputStream();
        }
        return new BufferedOutputStream(this._socket.getOutputStream());
    }

    protected InputStream getInputStream() throws IOException {
        if (this.isAsynchronous()) {
            return this._socket.getInputStream();
        }
        return new BufferedInputStream(this._socket.getInputStream());
    }

    public boolean isOutgoing() {
        return this.OUTGOING;
    }

    protected Message receive() throws IOException, BadPacketException {
        if (this.isAsynchronous() && this.isReadDeflated() && !(this._in instanceof UncompressingInputStream)) {
            this._in = new UncompressingInputStream(this._in, this._inflater);
        }
        if (this._closed) {
            throw CONNECTION_CLOSED;
        }
        Message message = null;
        while (message == null) {
            message = this.readAndUpdateStatistics();
        }
        return message;
    }

    public Message receive(int n) throws IOException, BadPacketException, InterruptedIOException {
        Message message;
        if (this.isAsynchronous() && this.isReadDeflated() && !(this._in instanceof UncompressingInputStream)) {
            this._in = new UncompressingInputStream(this._in, this._inflater);
        }
        if (this._closed) {
            throw CONNECTION_CLOSED;
        }
        int n2 = this._socket.getSoTimeout();
        this._socket.setSoTimeout(n);
        try {
            Message message2 = this.readAndUpdateStatistics();
            if (message2 == null) {
                throw new InterruptedIOException("null message read");
            }
            message = message2;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            this._socket.setSoTimeout(n2);
            throw throwable;
        }
        this._socket.setSoTimeout(n2);
        return message;
    }

    private Message readAndUpdateStatistics() throws IOException, BadPacketException {
        Message message = MessageFactory.read(this._in, this.HEADER_BUF, 1, this._softMax);
        this.updateReadStatistics(message);
        return message;
    }

    protected void updateReadStatistics(Message message) throws IOException {
        if (this.isReadDeflated()) {
            try {
                long l = this._inflater.getTotalIn();
                long l2 = this._inflater.getTotalOut();
                CompressionStat.GNUTELLA_UNCOMPRESSED_DOWNSTREAM.addData((int)(l2 - this._bytesReceived));
                CompressionStat.GNUTELLA_COMPRESSED_DOWNSTREAM.addData((int)(l - this._compressedBytesReceived));
                this._compressedBytesReceived = l;
                this._bytesReceived = l2;
            }
            catch (NullPointerException nullPointerException) {
                throw CONNECTION_CLOSED;
            }
        } else if (message != null) {
            this._bytesReceived += (long)message.getTotalLength();
        }
    }

    public void send(Message message) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Connection (" + this.toString() + ") is sending message: " + message));
        }
        try {
            message.write(this._out, this.OUT_HEADER_BUF);
            this.updateWriteStatistics(message);
        }
        catch (NullPointerException nullPointerException) {
            throw CONNECTION_CLOSED;
        }
    }

    public void flush() throws IOException {
        try {
            this._out.flush();
            this.updateWriteStatistics(null);
        }
        catch (NullPointerException nullPointerException) {
            throw CONNECTION_CLOSED;
        }
    }

    protected void updateWriteStatistics(Message message) {
        if (this.isWriteDeflated()) {
            long l = this._deflater.getTotalIn();
            long l2 = this._deflater.getTotalOut();
            CompressionStat.GNUTELLA_UNCOMPRESSED_UPSTREAM.addData((int)(l - this._bytesSent));
            CompressionStat.GNUTELLA_COMPRESSED_UPSTREAM.addData((int)(l2 - this._compressedBytesSent));
            this._bytesSent = l;
            this._compressedBytesSent = l2;
        } else if (message != null) {
            this._bytesSent += (long)message.getTotalLength();
        }
    }

    public long getBytesSent() {
        if (this.isWriteDeflated()) {
            return this._compressedBytesSent;
        }
        return this._bytesSent;
    }

    public long getUncompressedBytesSent() {
        return this._bytesSent;
    }

    public long getBytesReceived() {
        if (this.isReadDeflated()) {
            return this._compressedBytesReceived;
        }
        return this._bytesReceived;
    }

    public long getUncompressedBytesReceived() {
        return this._bytesReceived;
    }

    public float getSentSavedFromCompression() {
        if (!this.isWriteDeflated() || this._bytesSent == 0L) {
            return 0.0f;
        }
        return 1.0f - (float)this._compressedBytesSent / (float)this._bytesSent;
    }

    public float getReadSavedFromCompression() {
        if (!this.isReadDeflated() || this._bytesReceived == 0L) {
            return 0.0f;
        }
        return 1.0f - (float)this._compressedBytesReceived / (float)this._bytesReceived;
    }

    public String getAddress() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public int getListeningPort() {
        if (this.isOutgoing()) {
            if (this._socket == null) {
                return -1;
            }
            return this._socket.getPort();
        }
        return this._headersRead.getListeningPort();
    }

    void setListeningPort(int n) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        this._port = n;
    }

    public InetAddress getInetAddress() throws IllegalStateException {
        if (this._socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this._socket.getInetAddress();
    }

    public Socket getSocket() throws IllegalStateException {
        if (this._socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this._socket;
    }

    public long getConnectionTime() {
        return this._connectionTime;
    }

    public byte getSoftMax() {
        return this._softMax;
    }

    public boolean isStable() {
        return this.isStable(System.currentTimeMillis());
    }

    public boolean isStable(long l) {
        return (l - this.getConnectionTime()) / 1000L > 5L;
    }

    public int supportsVendorMessage(byte[] byArray, int n) {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsMessage(byArray, n);
        }
        return -1;
    }

    public boolean supportsVMRouting() {
        if (this._headersRead != null) {
            return (double)this._headersRead.supportsVendorMessages() >= 0.2;
        }
        return false;
    }

    public int remoteHostSupportsUDPConnectBack() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsTCPConnectBack() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsTCPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsUDPRedirect() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPConnectBackRedirect();
        }
        return -1;
    }

    public int remoteHostSupportsTCPRedirect() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsTCPConnectBackRedirect();
        }
        return -1;
    }

    public int remoteHostSupportsUDPCrawling() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPCrawling();
        }
        return -1;
    }

    public int remoteHostSupportsHopsFlow() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsHopsFlow();
        }
        return -1;
    }

    public int remoteHostSupportsPushProxy() {
        if (this._messagesSupported != null && this.isClientSupernodeConnection()) {
            return this._messagesSupported.supportsPushProxy();
        }
        return -1;
    }

    public int remoteHostSupportsLeafGuidance() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsLeafGuidance();
        }
        return -1;
    }

    public int remoteHostSupportsHeaderUpdate() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsHeaderUpdate();
        }
        return -1;
    }

    public boolean getRemoteHostSupportsFeatureQueries() {
        if (this._capabilities != null) {
            return this._capabilities.supportsFeatureQueries() > 0;
        }
        return false;
    }

    public int getRemoteHostFeatureQuerySelector() {
        if (this._capabilities != null) {
            return this._capabilities.supportsFeatureQueries();
        }
        return -1;
    }

    public boolean remoteHostSupportsWhatIsNew() {
        if (this._capabilities != null) {
            return this._capabilities.supportsWhatIsNew();
        }
        return false;
    }

    protected boolean isLocal() {
        return NetworkUtils.isLocalAddress(this._socket.getInetAddress());
    }

    public String getPropertyWritten(String string) {
        return this._headersWritten.props().getProperty(string);
    }

    public boolean isOpen() {
        return !this._closed;
    }

    public void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {}
        }
        if (this._deflater != null) {
            this._deflater.end();
        }
        if (this._inflater != null) {
            this._inflater.end();
        }
        IOUtils.close(this._in);
        IOUtils.close(this._out);
    }

    public String getUserAgent() {
        return this._headersRead.getUserAgent();
    }

    public boolean isLimeWire() {
        return this._headersRead.isLimeWire();
    }

    public boolean isOldLimeWire() {
        return this._headersRead.isOldLimeWire();
    }

    public boolean isWriteDeflated() {
        return this._headersWritten.isDeflateEnabled();
    }

    public boolean isReadDeflated() {
        return this._headersRead.isDeflateEnabled();
    }

    public boolean isGoodUltrapeer() {
        return this._headersRead.isGoodUltrapeer();
    }

    public boolean isGoodLeaf() {
        return this._headersRead.isGoodLeaf();
    }

    public boolean supportsPongCaching() {
        return this._headersRead.supportsPongCaching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPings() {
        Object object = this.PING_LOCK;
        synchronized (object) {
            block6: {
                long l;
                block5: {
                    l = System.currentTimeMillis();
                    if (this.isStable(l)) break block5;
                    return false;
                }
                if (l >= this._nextPingTime) break block6;
                return false;
            }
            this._nextPingTime = System.currentTimeMillis() + 2500L;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPongs() {
        Object object = this.PONG_LOCK;
        synchronized (object) {
            long l;
            block6: {
                block5: {
                    l = System.currentTimeMillis();
                    if (this.isStable(l)) break block5;
                    return false;
                }
                if (l >= this._nextPongTime) break block6;
                return false;
            }
            int n = l - this.getConnectionTime() < 10000L ? 300 : 12000;
            this._nextPongTime = l + (long)n;
            return true;
        }
    }

    public int getNumIntraUltrapeerConnections() {
        return this._headersRead.getNumIntraUltrapeerConnections();
    }

    public boolean isHighDegreeConnection() {
        return this._headersRead.isHighDegreeConnection();
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return this._headersRead.isUltrapeerQueryRoutingConnection();
    }

    public boolean supportsProbeQueries() {
        return this._headersRead.supportsProbeQueries();
    }

    public boolean receivedHeaders() {
        return this._headersRead != HandshakeResponse.createEmptyResponse();
    }

    public HandshakeResponse headers() {
        return this._headersRead;
    }

    public boolean isLeafConnection() {
        return this._headersRead.isLeaf();
    }

    public boolean isSupernodeConnection() {
        return this._headersRead.isUltrapeer();
    }

    public boolean isClientSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string) == false;
    }

    public boolean isSupernodeSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isGUESSCapable() {
        return this._headersRead.isGUESSCapable();
    }

    public boolean isGUESSUltrapeer() {
        return this._headersRead.isGUESSUltrapeer();
    }

    public boolean isTempConnection() {
        return this._headersRead.isTempConnection();
    }

    public boolean isSupernodeClientConnection() {
        if (!this.isLeafConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        if (!Boolean.valueOf(string).booleanValue()) {
            return false;
        }
        return this.isQueryRoutingEnabled();
    }

    public boolean supportsGGEP() {
        return this._headersRead.supportsGGEP();
    }

    public void handleStatisticVM(StatisticVendorMessage statisticVendorMessage) throws IOException {
        this.send(statisticVendorMessage);
    }

    boolean isQueryRoutingEnabled() {
        return this._headersRead.isQueryRoutingEnabled();
    }

    public String toString() {
        return "CONNECTION: host=" + this._host + " port=" + this._port;
    }

    public String getLocalePref() {
        return this._headersRead.getLocalePref();
    }

    private class Connector
    implements ConnectObserver,
    Runnable {
        private final Properties requestHeaders;
        private final HandshakeResponder responder;
        private final GnetConnectObserver observer;

        Connector(Properties properties, HandshakeResponder handshakeResponder, GnetConnectObserver gnetConnectObserver) {
            this.requestHeaders = properties;
            this.responder = handshakeResponder;
            this.observer = gnetConnectObserver;
        }

        public void handleIOException(IOException iOException) {
        }

        public void shutdown() {
            this.observer.shutdown();
        }

        public void handleConnect(Socket socket) {
            Connection.this._socket = socket;
            ThreadFactory.startThread(this, "Handshaking");
        }

        public void run() {
            try {
                Connection.this.preHandshakeInitialize(this.requestHeaders, this.responder, this.observer);
                this.observer.handleConnect();
            }
            catch (NoGnutellaOkException noGnutellaOkException) {
                this.observer.handleNoGnutellaOk(noGnutellaOkException.getCode(), noGnutellaOkException.getMessage());
            }
            catch (BadHandshakeException badHandshakeException) {
                this.observer.handleBadHandshake();
            }
            catch (IOException iOException) {
                this.observer.shutdown();
            }
        }
    }
}

