/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.cabos;

import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.FileUtils;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.Socket;
import jp.sourceforge.cabos.AqDispatcher;
import jp.sourceforge.cabos.AqEvent;
import jp.sourceforge.cabos.AqEventHandler;
import jp.sourceforge.cabos.ConnectionUpdate;
import jp.sourceforge.cabos.TransferUpdate;

public class AqMain {
    private static InputStreamReader reader = null;
    private static OutputStreamWriter writer = null;
    private static Socket socket = null;
    private static boolean isShuttingdown = false;

    public static void main(String[] stringArray) {
        try {
            socket = new Socket("localhost", 1024);
            reader = new InputStreamReader(socket.getInputStream(), "UTF-8");
            writer = new OutputStreamWriter(socket.getOutputStream(), "UTF-8");
        }
        catch (Exception exception) {
            System.exit(0);
        }
        AqEvent.signalEvent(98);
        if (CommonUtils.getUserHomeDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserHomeDir());
        } else {
            CommonUtils.getUserHomeDir().mkdirs();
        }
        if (CommonUtils.getUserSettingsDir().exists()) {
            FileUtils.setWriteable(CommonUtils.getUserSettingsDir());
        } else {
            CommonUtils.getUserSettingsDir().mkdirs();
        }
        AqEvent.signalEvent(99);
        AqMain.readLoop();
        System.exit(0);
    }

    private static void readLoop() {
        LinkedList linkedList = new LinkedList();
        StringBuffer stringBuffer = new StringBuffer();
        try {
            while (!isShuttingdown) {
                char c = (char)reader.read();
                if (c == '|' || c == '\n' || c == '\r') {
                    linkedList.add((Object)stringBuffer.toString());
                    stringBuffer.setLength(0);
                    if (c != '\n' && c != '\r') continue;
                    AqDispatcher.dispatchCommand((List)linkedList);
                    linkedList.clear();
                    continue;
                }
                stringBuffer.append(c);
            }
        }
        catch (IOException iOException) {}
    }

    protected static void start() {
        RouterService routerService = new RouterService(new AqEventHandler());
        routerService.start();
        RouterService.schedule(new ConnectionUpdate(), 60000L, 60000L);
        RouterService.schedule(new TransferUpdate(), 1000L, 1000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void writeEvent(String string) {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                writer.write(string);
                writer.flush();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void shutdown() {
        OutputStreamWriter outputStreamWriter = writer;
        synchronized (outputStreamWriter) {
            try {
                reader.close();
                writer.close();
                socket.close();
            }
            catch (IOException iOException) {}
            isShuttingdown = true;
        }
    }
}

