/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.NoSuchElementException;

public class IntSet {
    public ArrayList list;
    private int size = 0;

    protected void repOk() {
        if (this.list.size() < 2) {
            return;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < this.list.size() - 1) {
            Interval interval = this.get(n2);
            n += interval.high - interval.low + 1;
            Interval interval2 = this.get(n2 + 1);
            Assert.that(interval.low <= interval.high, "Backwards interval: " + this.toString());
            Assert.that(interval.high < interval2.low - 1, "Touching intervals: " + this.toString());
            ++n2;
        }
        Interval interval = this.get(this.list.size() - 1);
        Assert.that(interval.low <= interval.high, "Backwards interval: " + this.toString());
        Assert.that((n += interval.high - interval.low + 1) == this.size, "Bad size.  Should be " + n + " not " + this.size);
    }

    private final Interval get(int n) {
        return (Interval)this.list.get(n);
    }

    private final int search(int n) {
        int n2 = 0;
        int n3 = this.list.size() - 1;
        while (n2 <= n3) {
            int n4 = (n2 + n3) / 2;
            int n5 = this.get((int)n4).low;
            if (n5 < n) {
                n2 = n4 + 1;
                continue;
            }
            if (n < n5) {
                n3 = n4 - 1;
                continue;
            }
            return n4;
        }
        return n3;
    }

    public IntSet() {
        this.list = new ArrayList();
    }

    public IntSet(int n) {
        this.list = new ArrayList(n);
    }

    public int size() {
        return this.size;
    }

    public boolean contains(int n) {
        int n2 = this.search(n);
        if (n2 == -1) {
            return false;
        }
        Interval interval = this.get(n2);
        Assert.that(interval.low <= n, "Bad return value from search.");
        return n <= interval.high;
    }

    public boolean add(int n) {
        boolean bl;
        int n2 = this.search(n);
        ++this.size;
        if (n2 == -1) {
            if (this.list.size() == 0 || n < this.get((int)0).low - 1) {
                this.list.add(0, (Object)new Interval(n));
                return true;
            }
            this.get((int)0).low = n;
            return true;
        }
        Interval interval = this.get(n2);
        Assert.that(interval.low <= n);
        if (n <= interval.high) {
            --this.size;
            return false;
        }
        if (n2 == this.list.size() - 1) {
            if (interval.high < n - 1) {
                this.list.add((Object)new Interval(n));
                return true;
            }
            interval.high = n;
            return true;
        }
        Interval interval2 = this.get(n2 + 1);
        boolean bl2 = interval.high == n - 1;
        boolean bl3 = bl = n == interval2.low - 1;
        if (bl2) {
            if (bl) {
                interval.high = interval2.high;
                this.list.remove(n2 + 1);
                return true;
            }
            interval.high = n;
            return true;
        }
        if (bl) {
            interval2.low = n;
            return true;
        }
        this.list.add(n2 + 1, (Object)new Interval(n));
        return true;
    }

    public boolean remove(int n) {
        boolean bl;
        int n2 = this.search(n);
        if (n2 == -1 || n > this.get((int)n2).high) {
            return false;
        }
        Interval interval = this.get(n2);
        boolean bl2 = interval.low == n;
        boolean bl3 = bl = interval.high == n;
        if (bl2) {
            if (bl) {
                this.list.remove(n2);
            } else {
                ++interval.low;
            }
        } else if (bl) {
            --interval.high;
        } else {
            Interval interval2 = new Interval(n + 1, interval.high);
            interval.high = n - 1;
            this.list.add(n2 + 1, (Object)interval2);
        }
        --this.size;
        return true;
    }

    public boolean addAll(IntSet intSet) {
        boolean bl = false;
        IntSetIterator intSetIterator = intSet.iterator();
        while (intSetIterator.hasNext()) {
            bl |= this.add(intSetIterator.next());
        }
        return bl;
    }

    public boolean retainAll(IntSet intSet) {
        int n;
        ArrayList arrayList = new ArrayList();
        IntSetIterator intSetIterator = this.iterator();
        while (intSetIterator.hasNext()) {
            n = intSetIterator.next();
            if (intSet.contains(n)) continue;
            arrayList.add((Object)new Integer(n));
        }
        int n2 = arrayList.size() - 1;
        while (n2 >= 0) {
            n = (Integer)arrayList.get(n2);
            this.remove(n);
            --n2;
        }
        return arrayList.size() > 0;
    }

    public void trim() {
        this.list.trimToSize();
    }

    public IntSetIterator iterator() {
        return new IntSetIterator();
    }

    public String toString() {
        return this.list.toString();
    }

    private static class Interval {
        int low;
        int high;

        Interval(int n, int n2) {
            this.low = n;
            this.high = n2;
        }

        Interval(int n) {
            this.low = n;
            this.high = n;
        }

        public String toString() {
            if (this.low == this.high) {
                return String.valueOf(this.low);
            }
            return String.valueOf(String.valueOf(this.low)) + "-" + String.valueOf(this.high);
        }
    }

    public class IntSetIterator {
        private int i = 0;
        private int next;

        private IntSetIterator() {
            if (this.i < IntSet.this.list.size()) {
                this.next = ((IntSet)IntSet.this).get((int)this.i).low;
            }
        }

        public boolean hasNext() {
            return this.i < IntSet.this.list.size();
        }

        public int next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            int n = this.next++;
            if (this.next > ((IntSet)IntSet.this).get((int)this.i).high) {
                ++this.i;
                if (this.i < IntSet.this.list.size()) {
                    this.next = ((IntSet)IntSet.this).get((int)this.i).low;
                }
            }
            return n;
        }
    }
}

