/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class CountingOutputStream
extends FilterOutputStream {
    private int _count = 0;
    private boolean _isCounting = true;

    public CountingOutputStream(OutputStream outputStream) {
        super(outputStream);
    }

    public void write(int n) throws IOException {
        this.out.write(n);
        if (this._isCounting) {
            ++this._count;
        }
    }

    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.out.write(byArray, n, n2);
        if (this._isCounting) {
            this._count += n2;
        }
    }

    public void close() throws IOException {
        this.out.close();
    }

    public int getAmountWritten() {
        return this._count;
    }

    public void setIsCounting(boolean bl) {
        this._isCounting = bl;
    }
}

