/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.http.ConstantHTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderName;
import com.limegroup.gnutella.http.HTTPHeaderValue;
import com.limegroup.gnutella.http.HTTPHeaderValueCollection;
import com.limegroup.gnutella.http.HTTPMessage;
import com.limegroup.gnutella.http.HTTPUtils;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Set;
import java.io.IOException;
import java.io.OutputStream;

public class QueuedUploadState
implements HTTPMessage {
    private final FileDesc FILE_DESC;
    private final HTTPUploader UPLOADER;
    private final int POSITION;

    public QueuedUploadState(int n, HTTPUploader hTTPUploader) {
        this.POSITION = n;
        this.UPLOADER = hTTPUploader;
        this.FILE_DESC = hTTPUploader.getFileDesc();
    }

    public void writeMessageHeaders(OutputStream outputStream) throws IOException {
        URN uRN;
        Assert.that(this.POSITION != -1);
        String string = "HTTP/1.1 503 Service Unavailable\r\n";
        outputStream.write(string.getBytes());
        HTTPUtils.writeHeader(HTTPHeaderName.SERVER, ConstantHTTPHeaderValue.SERVER_VALUE, outputStream);
        string = "X-Queue: position=" + (this.POSITION + 1) + ", pollMin=" + 45 + ", pollMax=" + 120 + "\r\n";
        outputStream.write(string.getBytes());
        if (this.FILE_DESC != null && (uRN = this.FILE_DESC.getSHA1Urn()) != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.GNUTELLA_CONTENT_URN, (HTTPHeaderValue)this.FILE_DESC.getSHA1Urn(), outputStream);
            Set set = this.UPLOADER.getNextSetOfAltsToSend();
            if (set.size() > 0) {
                HTTPUtils.writeHeader(HTTPHeaderName.ALT_LOCATION, (HTTPHeaderValue)new HTTPHeaderValueCollection((Collection)set), outputStream);
            }
            if (this.FILE_DESC instanceof IncompleteFileDesc) {
                HTTPUtils.writeHeader(HTTPHeaderName.AVAILABLE_RANGES, (HTTPHeaderValue)((IncompleteFileDesc)this.FILE_DESC), outputStream);
            }
        }
        if (this.UPLOADER.isFirstReply()) {
            HTTPUtils.writeFeatures(outputStream);
        }
        if (this.FILE_DESC.getHashTree() != null) {
            HTTPUtils.writeHeader(HTTPHeaderName.THEX_URI, (HTTPHeaderValue)this.FILE_DESC.getHashTree(), outputStream);
        }
        string = "\r\n";
        outputStream.write(string.getBytes());
    }

    public void writeMessageBody(OutputStream outputStream) throws IOException {
    }

    public boolean getCloseConnection() {
        return false;
    }
}

