/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.QueryReply;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.messages.vendor.QueryStatusResponse;
import com.limegroup.gnutella.search.HostData;
import com.limegroup.gnutella.settings.SearchSettings;
import com.limegroup.gnutella.util.DataUtils;
import com.limegroup.gnutella.util.NetworkUtils;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.Vector;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SearchResultHandler {
    private static final Log LOG;
    private static final int QUERY_EXPIRE_TIME = 30000;
    public static final int REPORT_INTERVAL = 15;
    public static final int MAX_RESULTS = 65535;
    private final List GUID_COUNTS = new Vector();
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.limegroup.gnutella.search.SearchResultHandler");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG = LogFactory.getLog((Class)clazz);
    }

    public void handleQueryReply(QueryReply queryReply) {
        this.handleReply(queryReply);
    }

    public void addQuery(QueryRequest queryRequest) {
        LOG.trace((Object)"entered SearchResultHandler.addQuery(QueryRequest)");
        GuidCount guidCount = new GuidCount(queryRequest);
        this.GUID_COUNTS.add((Object)guidCount);
    }

    public void removeQuery(GUID gUID) {
        LOG.trace((Object)"entered SearchResultHandler.removeQuery(GUID)");
        GuidCount guidCount = this.removeQueryInternal(gUID);
        if (guidCount != null && !guidCount.isFinished()) {
            QueryStatusResponse queryStatusResponse = new QueryStatusResponse(gUID, 65535);
            RouterService.getConnectionManager().updateQueryStatus(queryStatusResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getQueriesToReSend() {
        LOG.trace((Object)"entered SearchResultHandler.getQueriesToSend()");
        LinkedList linkedList = null;
        List list = this.GUID_COUNTS;
        synchronized (list) {
            long l = System.currentTimeMillis();
            Iterator iterator = this.GUID_COUNTS.iterator();
            while (iterator.hasNext()) {
                GuidCount guidCount = (GuidCount)iterator.next();
                if (!this.isQueryStillValid(guidCount, l)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("adding " + guidCount + " to list of queries to resend"));
                }
                if (linkedList == null) {
                    linkedList = new LinkedList();
                }
                linkedList.add((Object)guidCount.getQueryRequest());
            }
        }
        if (linkedList == null) {
            return DataUtils.EMPTY_LIST;
        }
        return linkedList;
    }

    public int getNumResultsForQuery(GUID gUID) {
        GuidCount guidCount = this.retrieveGuidCount(gUID);
        if (guidCount != null) {
            return guidCount.getNumResults();
        }
        return -1;
    }

    private boolean handleReply(QueryReply queryReply) {
        HostData hostData;
        try {
            hostData = queryReply.getHostData();
        }
        catch (BadPacketException badPacketException) {
            LOG.debug((Object)"bad packet reading qr", (Throwable)badPacketException);
            return false;
        }
        if (!hostData.isReplyToMulticastQuery() && !queryReply.isBrowseHostReply()) {
            if (hostData.getQuality() < SearchSettings.MINIMUM_SEARCH_QUALITY.getValue()) {
                LOG.debug((Object)"Ignoring because low quality");
                return false;
            }
            if (hostData.getSpeed() < SearchSettings.MINIMUM_SEARCH_SPEED.getValue()) {
                LOG.debug((Object)"Ignoring because low speed");
                return false;
            }
            if (hostData.isFirewalled() && !NetworkUtils.isVeryCloseIP(queryReply.getIPBytes()) && (!RouterService.acceptedIncomingConnection() || NetworkUtils.isPrivateAddress(RouterService.getAddress()))) {
                LOG.debug((Object)"Ignoring from firewall funkiness");
                return false;
            }
        }
        List list = null;
        try {
            list = queryReply.getResultsAsList();
        }
        catch (BadPacketException badPacketException) {
            LOG.debug((Object)"Error gettig results", (Throwable)badPacketException);
            return false;
        }
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Response response = (Response)iterator.next();
            if (!RouterService.matchesType(hostData.getMessageGUID(), response) || RouterService.isMandragoreWorm(hostData.getMessageGUID(), response)) continue;
            RemoteFileDesc remoteFileDesc = response.toRemoteFileDesc(hostData);
            Set set = response.getLocations();
            RouterService.getCallback().handleQueryResult(remoteFileDesc, hostData, set);
            ++n;
        }
        this.accountAndUpdateDynamicQueriers(queryReply, n);
        return n > 0;
    }

    private void accountAndUpdateDynamicQueriers(QueryReply queryReply, int n) {
        LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): entered.");
        if (n > 0) {
            GuidCount guidCount = this.retrieveGuidCount(new GUID(queryReply.getGUID()));
            if (guidCount == null) {
                return;
            }
            LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): incrementing.");
            guidCount.increment(n);
            if (RouterService.isShieldedLeaf() && !guidCount.isFinished() && guidCount.getNumResults() > guidCount.getNextReportNum()) {
                LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): telling UPs.");
                guidCount.tallyReport();
                if (guidCount.getNumResults() > 250) {
                    guidCount.markAsFinished();
                }
                int n2 = guidCount.isFinished() ? 65535 : guidCount.getNumResults() / 4;
                QueryStatusResponse queryStatusResponse = new QueryStatusResponse(guidCount.getGUID(), n2);
                RouterService.getConnectionManager().updateQueryStatus(queryStatusResponse);
            }
        }
        LOG.trace((Object)"SRH.accountAndUpdateDynamicQueriers(): returning.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount removeQueryInternal(GUID gUID) {
        List list = this.GUID_COUNTS;
        synchronized (list) {
            Iterator iterator = this.GUID_COUNTS.iterator();
            while (iterator.hasNext()) {
                GuidCount guidCount = (GuidCount)iterator.next();
                if (!guidCount.getGUID().equals(gUID)) continue;
                iterator.remove();
                return guidCount;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GuidCount retrieveGuidCount(GUID gUID) {
        List list = this.GUID_COUNTS;
        synchronized (list) {
            Iterator iterator = this.GUID_COUNTS.iterator();
            while (iterator.hasNext()) {
                GuidCount guidCount = (GuidCount)iterator.next();
                if (!guidCount.getGUID().equals(gUID)) continue;
                return guidCount;
            }
        }
        return null;
    }

    private boolean isQueryStillValid(GuidCount guidCount, long l) {
        LOG.trace((Object)"entered SearchResultHandler.isQueryStillValid(GuidCount)");
        return l < guidCount.getTime() + 30000L && guidCount.getNumResults() < 250;
    }

    private static class GuidCount {
        private final long _time;
        private final GUID _guid;
        private final QueryRequest _qr;
        private int _numResults;
        private int _nextReportNum = 15;
        private boolean markAsFinished = false;

        public GuidCount(QueryRequest queryRequest) {
            this._qr = queryRequest;
            this._guid = new GUID(queryRequest.getGUID());
            this._numResults = 0;
            this._time = System.currentTimeMillis();
        }

        public GUID getGUID() {
            return this._guid;
        }

        public int getNumResults() {
            return this._numResults;
        }

        public int getNextReportNum() {
            return this._nextReportNum;
        }

        public long getTime() {
            return this._time;
        }

        public QueryRequest getQueryRequest() {
            return this._qr;
        }

        public boolean isFinished() {
            return this.markAsFinished;
        }

        public void tallyReport() {
            this._nextReportNum = this._numResults + 15;
        }

        public void increment(int n) {
            this._numResults += n;
        }

        public void markAsFinished() {
            this.markAsFinished = true;
        }

        public String toString() {
            return this._guid + ":" + this._numResults + ":" + this._nextReportNum;
        }
    }
}

