/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.util.FileUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Vector;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2DecompressionException;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.NoID3v2TagException;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;

public class ID3Editor {
    private String title_;
    private String artist_;
    private String album_;
    private String year_;
    private String track_;
    private String comment_;
    private String genre_;
    private LimeXMLDocument correctDocument = null;
    private static final String TITLE_STRING = "title=\"";
    private static final String ARTIST_STRING = "artist=\"";
    private static final String ALBUM_STRING = "album=\"";
    private static final String YEAR_STRING = "year=\"";
    private static final String TRACK_STRING = "track=\"";
    private static final String COMMENT_STRING = "comments=\"";
    private static final String GENRE_STRING = "genre=\"";
    private static final String BITRATE_STRING = "bitrate=\"";
    private static final String SECONDS_STRING = "seconds=\"";
    private static final String ISO_LATIN_1 = "8859_1";
    private static final String UNICODE = "Unicode";
    static final String TITLE_ID = "TIT2";
    static final String ARTIST_ID = "TPE1";
    static final String ALBUM_ID = "TALB";
    static final String YEAR_ID = "TYER";
    static final String TRACK_ID = "TRCK";
    static final String COMMENT_ID = "COMM";
    static final String GENRE_ID = "TCON";
    private final boolean debugOn = false;

    private void debug(String string) {
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ID3Editor)) {
            return false;
        }
        ID3Editor iD3Editor = (ID3Editor)object;
        return this.matches(this.title_, iD3Editor.title_) && this.matches(this.artist_, iD3Editor.artist_) && this.matches(this.album_, iD3Editor.album_) && this.matches(this.year_, iD3Editor.year_) && this.matches(this.track_, iD3Editor.track_) && this.matches(this.comment_, iD3Editor.comment_) && this.matches(this.genre_, iD3Editor.genre_);
    }

    private boolean matches(String string, String string2) {
        if (string == null) {
            return string2 == null;
        }
        return string.equals(string2);
    }

    private Object[] ripTag(String string, String string2) throws IOException {
        Object[] objectArray = new Object[3];
        int n = string.indexOf(string2);
        if (n < 0) {
            throw new IOException("tag not found");
        }
        if (n != 0) {
            objectArray[0] = new Integer(n - 1);
        }
        if (n == 0) {
            objectArray[0] = new Integer(n);
        }
        int n2 = n;
        while (string.charAt(n2) != '=') {
            ++n2;
        }
        while (string.charAt(n2) != '\"') {
            ++n2;
        }
        int n3 = ++n2;
        while (string.charAt(n2) != '\"') {
            ++n2;
        }
        int n4 = n2;
        objectArray[1] = new Integer(n2 + 1);
        this.debug("ID3Editor.ripTag(): i = " + n3 + ", j = " + n4);
        objectArray[2] = string.substring(n3, n4);
        return objectArray;
    }

    public String removeID3Tags(String string) {
        int n;
        int n2;
        Object[] objectArray = null;
        try {
            objectArray = this.ripTag(string, TITLE_STRING);
            this.title_ = (String)objectArray[2];
            this.debug("title = " + this.title_);
            n2 = (Integer)objectArray[0];
            n = (Integer)objectArray[1];
            string = String.valueOf(string.substring(0, n2)) + string.substring(n, string.length());
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.ripTag(string, ARTIST_STRING);
            this.artist_ = (String)objectArray[2];
            this.debug("artist = " + this.artist_);
            n2 = (Integer)objectArray[0];
            n = (Integer)objectArray[1];
            string = String.valueOf(string.substring(0, n2)) + string.substring(n, string.length());
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.ripTag(string, ALBUM_STRING);
            this.album_ = (String)objectArray[2];
            n2 = (Integer)objectArray[0];
            n = (Integer)objectArray[1];
            string = String.valueOf(string.substring(0, n2)) + string.substring(n, string.length());
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.ripTag(string, YEAR_STRING);
            this.year_ = (String)objectArray[2];
            n2 = (Integer)objectArray[0];
            n = (Integer)objectArray[1];
            string = String.valueOf(string.substring(0, n2)) + string.substring(n, string.length());
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.ripTag(string, TRACK_STRING);
            this.track_ = (String)objectArray[2];
            n2 = (Integer)objectArray[0];
            n = (Integer)objectArray[1];
            string = String.valueOf(string.substring(0, n2)) + string.substring(n, string.length());
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.ripTag(string, COMMENT_STRING);
            this.comment_ = (String)objectArray[2];
            n2 = (Integer)objectArray[0];
            n = (Integer)objectArray[1];
            string = String.valueOf(string.substring(0, n2)) + string.substring(n, string.length());
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.ripTag(string, GENRE_STRING);
            this.genre_ = (String)objectArray[2];
            n2 = (Integer)objectArray[0];
            n = (Integer)objectArray[1];
            string = String.valueOf(string.substring(0, n2)) + string.substring(n, string.length());
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.ripTag(string, BITRATE_STRING);
            n2 = (Integer)objectArray[0];
            n = (Integer)objectArray[1];
            string = String.valueOf(string.substring(0, n2)) + string.substring(n, string.length());
        }
        catch (IOException iOException) {}
        try {
            objectArray = this.ripTag(string, SECONDS_STRING);
            n2 = (Integer)objectArray[0];
            n = (Integer)objectArray[1];
            string = String.valueOf(string.substring(0, n2)) + string.substring(n, string.length());
        }
        catch (IOException iOException) {}
        return string;
    }

    public boolean betterThan(ID3Editor iD3Editor) {
        return this.firstBetter(this.title_, iD3Editor.title_) && this.firstBetter(this.artist_, iD3Editor.artist_) && this.firstBetter(this.album_, iD3Editor.album_) && this.firstBetter(this.track_, iD3Editor.track_) && this.firstBetter(this.comment_, iD3Editor.comment_) && this.firstBetter(this.genre_, iD3Editor.genre_);
    }

    private boolean firstBetter(String string, String string2) {
        if (string == null && string2 == null) {
            return true;
        }
        if (string != null && string.equals(string2)) {
            return true;
        }
        return string != null && !"".equals(string);
    }

    public void pickBetterFields(ID3Editor iD3Editor) {
        if (this.firstBetter(iD3Editor.title_, this.title_)) {
            this.title_ = iD3Editor.title_;
        }
        if (this.firstBetter(iD3Editor.artist_, this.artist_)) {
            this.artist_ = iD3Editor.artist_;
        }
        if (this.firstBetter(iD3Editor.album_, this.album_)) {
            this.album_ = iD3Editor.album_;
        }
        if (this.firstBetter(iD3Editor.track_, this.track_)) {
            this.track_ = iD3Editor.track_;
        }
        if (this.firstBetter(iD3Editor.comment_, this.comment_)) {
            this.comment_ = iD3Editor.comment_;
        }
        if (this.firstBetter(iD3Editor.genre_, this.genre_)) {
            this.genre_ = iD3Editor.genre_;
        }
    }

    /*
     * Unable to fully structure code
     */
    public int writeID3DataToDisk(String var1_1) {
        block23: {
            if (!LimeXMLUtils.isMP3File(var1_1)) {
                return 12;
            }
            var2_2 = null;
            var3_3 = null;
            try {
                var2_2 = new File(var1_1);
                FileUtils.setWriteable(var2_2);
                var3_3 = new RandomAccessFile(var2_2, "rw");
            }
            catch (IOException v0) {
                while (true) {
                    var7_4 = null;
                    if (var3_3 != null) {
                        try {
                            var3_3.close();
                        }
                        catch (IOException v1) {}
                    }
                    return 1;
                }
            }
            try {
                var4_8 = 0L;
                try {
                    var4_8 = var3_3.length();
                    if (var4_8 < 128L) ** continue;
                    var3_3.seek(var4_8 - 128L);
                }
                catch (IOException v2) {
lbl32:
                    // 2 sources

                    while (true) {
                        var7_5 = null;
                        if (var3_3 != null) {
                            try {
                                var3_3.close();
                            }
                            catch (IOException v3) {}
                        }
                        return 2;
                    }
                }
            }
            catch (Throwable var8_11) {
                block24: {
                    var7_7 = null;
                    if (var3_3 == null) break block24;
                    try {
                        var3_3.close();
                    }
                    catch (IOException v4) {}
                }
                throw var8_11;
            }
            var6_9 = -1;
            try {
                var6_9 = this.writeID3V2DataToDisk(var2_2);
            }
            catch (IOException v5) {
                ** continue;
            }
            catch (ID3v2Exception v6) {
                var6_9 = this.writeID3V1DataToDisk(var3_3);
            }
            var9_10 = var6_9;
            var7_6 = null;
            if (var3_3 == null) break block23;
            try {
                var3_3.close();
            }
            catch (IOException v7) {}
        }
        return var9_10;
    }

    public void setCorrectDocument(LimeXMLDocument limeXMLDocument) {
        this.correctDocument = limeXMLDocument;
    }

    public LimeXMLDocument getCorrectDocument() {
        return this.correctDocument;
    }

    private int writeID3V2DataToDisk(File file) throws IOException, ID3v2Exception {
        ID3v2Frame iD3v2Frame;
        Iterator iterator;
        ID3v2 iD3v2 = new ID3v2(file);
        Vector vector = null;
        try {
            vector = (Vector)iD3v2.getFrames().clone();
        }
        catch (NoID3v2TagException noID3v2TagException) {}
        ArrayList arrayList = new ArrayList();
        this.addAllNeededFrames((List)arrayList);
        if (arrayList.size() == 0) {
            return 0;
        }
        if (vector != null) {
            iterator = vector.iterator();
            while (iterator.hasNext()) {
                iD3v2Frame = (ID3v2Frame)iterator.next();
                int n = arrayList.indexOf((Object)iD3v2Frame);
                ID3v2Frame iD3v2Frame2 = null;
                if (n >= 0) {
                    iD3v2Frame2 = (ID3v2Frame)arrayList.remove(n);
                    if (Arrays.equals((byte[])iD3v2Frame.getContent(), (byte[])iD3v2Frame2.getContent())) continue;
                }
                iD3v2.removeFrame(iD3v2Frame);
                if (iD3v2Frame2 == null) continue;
                iD3v2.addFrame(iD3v2Frame2);
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iD3v2Frame = (ID3v2Frame)iterator.next();
            iD3v2.addFrame(iD3v2Frame);
        }
        iD3v2.update();
        return 0;
    }

    private void addAllNeededFrames(List list) {
        ID3v2Frame iD3v2Frame = null;
        if (this.title_ != null && !this.title_.equals("") && (iD3v2Frame = this.makeFrame(TITLE_ID, this.title_)) != null) {
            list.add((Object)iD3v2Frame);
        }
        if (this.artist_ != null && !this.artist_.equals("")) {
            iD3v2Frame = null;
            iD3v2Frame = this.makeFrame(ARTIST_ID, this.artist_);
            if (iD3v2Frame != null) {
                list.add((Object)iD3v2Frame);
            }
        }
        if (this.album_ != null && !this.album_.equals("")) {
            iD3v2Frame = null;
            iD3v2Frame = this.makeFrame(ALBUM_ID, this.album_);
            if (iD3v2Frame != null) {
                list.add((Object)iD3v2Frame);
            }
        }
        if (this.year_ != null && !this.year_.equals("")) {
            iD3v2Frame = null;
            iD3v2Frame = this.makeFrame(YEAR_ID, this.year_);
            if (iD3v2Frame != null) {
                list.add((Object)iD3v2Frame);
            }
        }
        if (this.track_ != null && !this.track_.equals("")) {
            iD3v2Frame = null;
            iD3v2Frame = this.makeFrame(TRACK_ID, this.track_);
            if (iD3v2Frame != null) {
                list.add((Object)iD3v2Frame);
            }
        }
        if (this.comment_ != null && !this.comment_.equals("")) {
            iD3v2Frame = null;
            iD3v2Frame = this.makeFrame(COMMENT_ID, this.comment_);
            if (iD3v2Frame != null) {
                list.add((Object)iD3v2Frame);
            }
        }
        if (this.genre_ != null && !this.genre_.equals("")) {
            iD3v2Frame = null;
            if (this.getGenreByte() > -1) {
                String string = "(" + this.getGenreByte() + ")" + this.genre_;
                iD3v2Frame = this.makeFrame(GENRE_ID, string);
            } else {
                iD3v2Frame = this.makeFrame(GENRE_ID, this.genre_);
            }
            if (iD3v2Frame != null) {
                list.add((Object)iD3v2Frame);
            }
        }
    }

    private ID3v2Frame makeFrame(String string, String string2) {
        boolean bl = true;
        int n = 0;
        while (n < string2.length()) {
            if (string2.charAt(n) > '\u00ff') {
                bl = false;
                break;
            }
            ++n;
        }
        try {
            return new ID3v2Frame(string, string2.getBytes(bl ? ISO_LATIN_1 : UNICODE), true, true, false, 0, 0, 0, bl);
        }
        catch (ID3v2DecompressionException iD3v2DecompressionException) {
            return null;
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return null;
        }
    }

    private int writeID3V1DataToDisk(RandomAccessFile randomAccessFile) {
        byte[] byArray = new byte[30];
        String string = "";
        try {
            randomAccessFile.readFully(byArray, 0, 3);
            string = new String(byArray, 0, 3);
        }
        catch (EOFException eOFException) {
            return 2;
        }
        catch (IOException iOException) {
            return 2;
        }
        if (!string.equals("TAG")) {
            try {
                byte[] byArray2 = "TAG".getBytes();
                randomAccessFile.seek(randomAccessFile.length() - 128L);
                randomAccessFile.write(byArray2, 0, 3);
            }
            catch (IOException iOException) {
                return 3;
            }
        }
        this.debug("about to start writing to file");
        boolean bl = this.toFile(this.title_, 30, randomAccessFile, byArray);
        if (!bl) {
            return 4;
        }
        bl = this.toFile(this.artist_, 30, randomAccessFile, byArray);
        if (!bl) {
            return 5;
        }
        bl = this.toFile(this.album_, 30, randomAccessFile, byArray);
        if (!bl) {
            return 6;
        }
        bl = this.toFile(this.year_, 4, randomAccessFile, byArray);
        if (!bl) {
            return 7;
        }
        bl = this.toFile(this.comment_, 28, randomAccessFile, byArray);
        if (!bl) {
            return 8;
        }
        int n = -1;
        try {
            n = this.track_ == null || this.track_.equals("") ? 0 : (int)Byte.parseByte(this.track_);
        }
        catch (NumberFormatException numberFormatException) {
            return 9;
        }
        try {
            randomAccessFile.write(0);
            randomAccessFile.write(n);
        }
        catch (IOException iOException) {
            return 9;
        }
        byte by = this.getGenreByte();
        try {
            randomAccessFile.write(by);
        }
        catch (IOException iOException) {
            return 10;
        }
        return 0;
    }

    private boolean toFile(String string, int n, RandomAccessFile randomAccessFile, byte[] byArray) {
        byte[] byArray2;
        this.debug("writing value to file " + string);
        if (string == null || string.equals("")) {
            byArray2 = new byte[n];
            Arrays.fill((byte[])byArray2, (int)0, (int)n, (byte)0);
        } else {
            try {
                byArray2 = string.getBytes(ISO_LATIN_1);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return false;
            }
        }
        int n2 = byArray2.length;
        if (n2 < n) {
            System.arraycopy(byArray2, 0, byArray, 0, n2);
            Arrays.fill((byte[])byArray, (int)n2, (int)n, (byte)0);
        } else {
            System.arraycopy(byArray2, 0, byArray, 0, n);
        }
        try {
            randomAccessFile.write(byArray, 0, n);
        }
        catch (IOException iOException) {
            return false;
        }
        return true;
    }

    private byte getGenreByte() {
        if (this.genre_ == null) {
            return -1;
        }
        if (this.genre_.equals("Blues")) {
            return 0;
        }
        if (this.genre_.equals("Classic Rock")) {
            return 1;
        }
        if (this.genre_.equals("Country")) {
            return 2;
        }
        if (this.genre_.equals("Dance")) {
            return 3;
        }
        if (this.genre_.equals("Disco")) {
            return 4;
        }
        if (this.genre_.equals("Funk")) {
            return 5;
        }
        if (this.genre_.equals("Grunge")) {
            return 6;
        }
        if (this.genre_.equals("Hop")) {
            return 7;
        }
        if (this.genre_.equals("Jazz")) {
            return 8;
        }
        if (this.genre_.equals("Metal")) {
            return 9;
        }
        if (this.genre_.equals("New Age")) {
            return 10;
        }
        if (this.genre_.equals("Oldies")) {
            return 11;
        }
        if (this.genre_.equals("Other")) {
            return 12;
        }
        if (this.genre_.equals("Pop")) {
            return 13;
        }
        if (this.genre_.equals("R &amp; B")) {
            return 14;
        }
        if (this.genre_.equals("Rap")) {
            return 15;
        }
        if (this.genre_.equals("Reggae")) {
            return 16;
        }
        if (this.genre_.equals("Rock")) {
            return 17;
        }
        if (this.genre_.equals("Techno")) {
            return 17;
        }
        if (this.genre_.equals("Industrial")) {
            return 19;
        }
        if (this.genre_.equals("Alternative")) {
            return 20;
        }
        if (this.genre_.equals("Ska")) {
            return 21;
        }
        if (this.genre_.equals("Metal")) {
            return 22;
        }
        if (this.genre_.equals("Pranks")) {
            return 23;
        }
        if (this.genre_.equals("Soundtrack")) {
            return 24;
        }
        if (this.genre_.equals("Euro-Techno")) {
            return 25;
        }
        if (this.genre_.equals("Ambient")) {
            return 26;
        }
        if (this.genre_.equals("Trip-Hop")) {
            return 27;
        }
        if (this.genre_.equals("Vocal")) {
            return 28;
        }
        if (this.genre_.equals("Jazz+Funk")) {
            return 29;
        }
        if (this.genre_.equals("Fusion")) {
            return 30;
        }
        if (this.genre_.equals("Trance")) {
            return 31;
        }
        if (this.genre_.equals("Classical")) {
            return 32;
        }
        if (this.genre_.equals("Instrumental")) {
            return 33;
        }
        if (this.genre_.equals("Acid")) {
            return 34;
        }
        if (this.genre_.equals("House")) {
            return 35;
        }
        if (this.genre_.equals("Game")) {
            return 36;
        }
        if (this.genre_.equals("Sound Clip")) {
            return 37;
        }
        if (this.genre_.equals("Gospel")) {
            return 38;
        }
        if (this.genre_.equals("Noise")) {
            return 39;
        }
        if (this.genre_.equals("AlternRock")) {
            return 40;
        }
        if (this.genre_.equals("Bass")) {
            return 41;
        }
        if (this.genre_.equals("Soul")) {
            return 42;
        }
        if (this.genre_.equals("Punk")) {
            return 43;
        }
        if (this.genre_.equals("Space")) {
            return 44;
        }
        if (this.genre_.equals("Meditative")) {
            return 45;
        }
        if (this.genre_.equals("Instrumental Pop")) {
            return 46;
        }
        if (this.genre_.equals("Instrumental Rock")) {
            return 47;
        }
        if (this.genre_.equals("Ethnic")) {
            return 48;
        }
        if (this.genre_.equals("Gothic")) {
            return 49;
        }
        if (this.genre_.equals("Darkwave")) {
            return 50;
        }
        if (this.genre_.equals("Techno-Industrial")) {
            return 51;
        }
        if (this.genre_.equals("Electronic")) {
            return 52;
        }
        if (this.genre_.equals("Pop-Folk")) {
            return 53;
        }
        if (this.genre_.equals("Eurodance")) {
            return 54;
        }
        if (this.genre_.equals("Dream")) {
            return 55;
        }
        if (this.genre_.equals("Southern Rock")) {
            return 56;
        }
        if (this.genre_.equals("Comedy")) {
            return 57;
        }
        if (this.genre_.equals("Cult")) {
            return 58;
        }
        if (this.genre_.equals("Gangsta")) {
            return 59;
        }
        if (this.genre_.equals("Top 40")) {
            return 60;
        }
        if (this.genre_.equals("Christian Rap")) {
            return 61;
        }
        if (this.genre_.equals("Pop/Funk")) {
            return 62;
        }
        if (this.genre_.equals("Jungle")) {
            return 63;
        }
        if (this.genre_.equals("Native American")) {
            return 64;
        }
        if (this.genre_.equals("Cabaret")) {
            return 65;
        }
        if (this.genre_.equals("New Wave")) {
            return 66;
        }
        if (this.genre_.equals("Psychadelic")) {
            return 67;
        }
        if (this.genre_.equals("Rave")) {
            return 68;
        }
        if (this.genre_.equals("Showtunes")) {
            return 69;
        }
        if (this.genre_.equals("Trailer")) {
            return 70;
        }
        if (this.genre_.equals("Lo-Fi")) {
            return 71;
        }
        if (this.genre_.equals("Tribal")) {
            return 72;
        }
        if (this.genre_.equals("Acid Punk")) {
            return 73;
        }
        if (this.genre_.equals("Acid Jazz")) {
            return 74;
        }
        if (this.genre_.equals("Polka")) {
            return 75;
        }
        if (this.genre_.equals("Retro")) {
            return 76;
        }
        if (this.genre_.equals("Musical")) {
            return 77;
        }
        if (this.genre_.equals("Rock &amp; Roll")) {
            return 78;
        }
        if (this.genre_.equals("Hard Rock")) {
            return 79;
        }
        if (this.genre_.equals("Folk")) {
            return 80;
        }
        if (this.genre_.equals("Folk-Rock")) {
            return 81;
        }
        if (this.genre_.equals("National Folk")) {
            return 82;
        }
        if (this.genre_.equals("Swing")) {
            return 83;
        }
        if (this.genre_.equals("Fast Fusion")) {
            return 84;
        }
        if (this.genre_.equals("Bebob")) {
            return 85;
        }
        if (this.genre_.equals("Latin")) {
            return 86;
        }
        if (this.genre_.equals("Revival")) {
            return 87;
        }
        if (this.genre_.equals("Celtic")) {
            return 88;
        }
        if (this.genre_.equals("Bluegrass")) {
            return 89;
        }
        if (this.genre_.equals("Avantgarde")) {
            return 90;
        }
        if (this.genre_.equals("Gothic Rock")) {
            return 91;
        }
        if (this.genre_.equals("Progressive Rock")) {
            return 92;
        }
        if (this.genre_.equals("Psychedelic Rock")) {
            return 93;
        }
        if (this.genre_.equals("Symphonic Rock")) {
            return 94;
        }
        if (this.genre_.equals("Slow Rock")) {
            return 95;
        }
        if (this.genre_.equals("Big Band")) {
            return 96;
        }
        if (this.genre_.equals("Chorus")) {
            return 97;
        }
        if (this.genre_.equals("Easy Listening")) {
            return 98;
        }
        if (this.genre_.equals("Acoustic")) {
            return 99;
        }
        if (this.genre_.equals("Humour")) {
            return 100;
        }
        if (this.genre_.equals("Speech")) {
            return 101;
        }
        if (this.genre_.equals("Chanson")) {
            return 102;
        }
        if (this.genre_.equals("Opera")) {
            return 103;
        }
        if (this.genre_.equals("Chamber Music")) {
            return 104;
        }
        if (this.genre_.equals("Sonata")) {
            return 105;
        }
        if (this.genre_.equals("Symphony")) {
            return 106;
        }
        if (this.genre_.equals("Booty Bass")) {
            return 107;
        }
        if (this.genre_.equals("Primus")) {
            return 108;
        }
        if (this.genre_.equals("Porn Groove")) {
            return 109;
        }
        if (this.genre_.equals("Satire")) {
            return 110;
        }
        if (this.genre_.equals("Slow Jam")) {
            return 111;
        }
        if (this.genre_.equals("Club")) {
            return 112;
        }
        if (this.genre_.equals("Tango")) {
            return 113;
        }
        if (this.genre_.equals("Samba")) {
            return 114;
        }
        if (this.genre_.equals("Folklore")) {
            return 115;
        }
        if (this.genre_.equals("Ballad")) {
            return 116;
        }
        if (this.genre_.equals("Power Ballad")) {
            return 117;
        }
        if (this.genre_.equals("Rhythmic Soul")) {
            return 118;
        }
        if (this.genre_.equals("Freestyle")) {
            return 119;
        }
        if (this.genre_.equals("Duet")) {
            return 120;
        }
        if (this.genre_.equals("Punk Rock")) {
            return 121;
        }
        if (this.genre_.equals("Drum Solo")) {
            return 122;
        }
        if (this.genre_.equals("A capella")) {
            return 123;
        }
        if (this.genre_.equals("Euro-House")) {
            return 124;
        }
        if (this.genre_.equals("Dance Hall")) {
            return 125;
        }
        return -1;
    }
}

