/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.tools;

import de.kapsi.net.daap.ByteUtil;
import de.kapsi.net.daap.chunks.ChunkImpls;
import de.kapsi.net.daap.chunks.impl.SongCodecType;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class ContentCodesAnalyzer {
    private static HashMap getKnownChunks(ChunkImpls chunkClasses) {
        HashMap<String, ContentCode> map = new HashMap<String, ContentCode>();
        String[] names = ChunkImpls.classes;
        Class[] arg1 = new Class[]{};
        Object[] arg2 = new Object[]{};
        for (int i = 0; i < names.length; ++i) {
            try {
                Class<?> clazz = Class.forName(names[i]);
                Method methodContentCode = clazz.getMethod("getContentCode", arg1);
                Method methodName = clazz.getMethod("getName", arg1);
                Method methodType = clazz.getMethod("getType", arg1);
                Object inst = clazz.newInstance();
                String contentCode = (String)methodContentCode.invoke(inst, arg2);
                String name = (String)methodName.invoke(inst, arg2);
                int type = (Integer)methodType.invoke(inst, arg2);
                map.put(contentCode, new ContentCode(contentCode, name, type));
                continue;
            }
            catch (Exception err) {
                err.printStackTrace();
            }
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HashMap readNewChunks(File file) throws IOException {
        HashMap<String, ContentCode> map = new HashMap<String, ContentCode>();
        FileInputStream in = new FileInputStream(file);
        try {
            in.skip(20L);
            in.skip(4L);
            byte[] lenBuf = new byte[4];
            while (in.read(lenBuf, 0, lenBuf.length) != -1) {
                int len = ByteUtil.toIntBE(lenBuf, 0);
                byte[] buf = new byte[len];
                if (in.read(buf, 0, buf.length) == -1) {
                    break;
                }
                int pos = 0;
                len = ByteUtil.toIntBE(buf, pos += 4);
                String contentCode = new String(buf, pos += 4, len);
                pos += len;
                len = ByteUtil.toIntBE(buf, pos += 4);
                String name = new String(buf, pos += 4, len);
                pos += len;
                len = ByteUtil.toIntBE(buf, pos += 4);
                int type = ByteUtil.toInt16BE(buf, pos += 4);
                pos += len;
                map.put(contentCode, new ContentCode(contentCode, name, type));
                in.skip(4L);
            }
        }
        finally {
            in.close();
        }
        return map;
    }

    public static void main(String[] args) throws IOException {
        Object obj;
        Object key;
        if (args.length == 0) {
            System.out.println("ContentCodesAnalyzer <fileWithContentCodes>");
            System.exit(-1);
        }
        Object chunkClasses = null;
        try {
            chunkClasses = Class.forName("de.kapsi.net.daap.chunks.ChunkClasses").newInstance();
        }
        catch (Exception err) {
            // empty catch block
        }
        HashMap knownChnunks = null;
        knownChnunks = chunkClasses != null ? ContentCodesAnalyzer.getKnownChunks(chunkClasses) : new HashMap();
        HashMap newChunks = ContentCodesAnalyzer.readNewChunks(new File(args[0]));
        Iterator<Object> it = null;
        ArrayList added = new ArrayList();
        ArrayList removed = new ArrayList();
        ArrayList<Object[]> changed = new ArrayList<Object[]>();
        it = newChunks.keySet().iterator();
        while (it.hasNext()) {
            key = it.next();
            obj = newChunks.get(key);
            if (!knownChnunks.containsKey(key)) {
                added.add(obj);
                continue;
            }
            Object obj2 = knownChnunks.get(key);
            if (obj2.equals(obj)) continue;
            changed.add(new Object[]{obj, obj2});
        }
        it = knownChnunks.keySet().iterator();
        while (it.hasNext()) {
            key = it.next();
            obj = knownChnunks.get(key);
            if (newChunks.containsKey(key)) continue;
            removed.add(obj);
        }
        System.out.println("\n+++ NEW CHUNKS +++\n");
        it = added.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        System.out.println("\n+++ REMOVED CHUNKS +++\n");
        it = removed.iterator();
        while (it.hasNext()) {
            System.out.println(it.next());
        }
        System.out.println("\n+++ CHANGED CHUNKS +++\n");
        it = changed.iterator();
        while (it.hasNext()) {
            Object[] obj2 = (Object[])it.next();
            System.out.println("NEW: " + obj2[0]);
            System.out.println("OLD: " + obj2[1]);
        }
        FileOutputStream os = new FileOutputStream(new File("/Users/roger/foobar.txt"));
        byte[] dst = new byte[4];
        ByteUtil.toByteBE(SongCodecType.MPEG, dst, 0);
        os.write(dst, 0, dst.length);
    }

    private static final class ContentCode {
        private String contentCode;
        private String name;
        private int type;

        private ContentCode(String contentCode, String name, int type) {
            this.contentCode = contentCode;
            this.name = name;
            this.type = type;
        }

        public boolean equals(Object o) {
            ContentCode other = (ContentCode)o;
            return this.contentCode.equals(other.contentCode) && this.name.equals(other.name) && this.type == other.type;
        }

        public String toString() {
            StringBuffer buf = new StringBuffer();
            buf.append("dmap.dictionary = {\n");
            buf.append("    dmap.contentcodesnumber = ").append(this.contentCode).append("\n");
            buf.append("    dmap.contentcodesname = ").append(this.name).append("\n");
            buf.append("    dmap.contentcodestype = ").append(this.type).append("\n");
            buf.append("}\n");
            return buf.toString();
        }
    }
}

