/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.bio;

import de.kapsi.net.daap.DaapConnection;
import de.kapsi.net.daap.DaapRequest;
import de.kapsi.net.daap.DaapRequestProcessor;
import de.kapsi.net.daap.DaapResponse;
import de.kapsi.net.daap.DaapResponseFactory;
import de.kapsi.net.daap.DaapSession;
import de.kapsi.net.daap.DaapStreamException;
import de.kapsi.net.daap.DaapUtil;
import de.kapsi.net.daap.bio.DaapResponseFactoryBIO;
import de.kapsi.net.daap.bio.DaapServerBIO;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.SocketException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpParser;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DaapConnectionBIO
extends DaapConnection
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$de$kapsi$net$daap$bio$DaapConnectionBIO == null ? (class$de$kapsi$net$daap$bio$DaapConnectionBIO = DaapConnectionBIO.class$("de.kapsi.net.daap.bio.DaapConnectionBIO")) : class$de$kapsi$net$daap$bio$DaapConnectionBIO));
    private static final DaapResponseFactory FACTORY = new DaapResponseFactoryBIO();
    private static final DaapRequestProcessor PROCESSOR = new DaapRequestProcessor(FACTORY);
    private DaapServerBIO server;
    private Socket socket;
    private InputStream in;
    private OutputStream out;
    private DaapSession session;
    private boolean connected = false;
    static /* synthetic */ Class class$de$kapsi$net$daap$bio$DaapConnectionBIO;

    public DaapConnectionBIO(DaapServerBIO server, Socket socket) throws IOException {
        super(server);
        this.server = server;
        this.socket = socket;
        this.in = new BufferedInputStream(socket.getInputStream());
        this.out = socket.getOutputStream();
        this.connected = true;
    }

    private boolean read() throws IOException {
        DaapRequest request = this.readRequest();
        if (!this.isAudioStream()) {
            DaapResponse response;
            if (this.isUndef()) {
                if (request.isSongRequest()) {
                    this.setConnectionType(2);
                    Integer sid = new Integer(request.getSessionId());
                    if (!this.server.isSessionIdValid(sid)) {
                        throw new IOException("Unknown Session-ID: " + sid);
                    }
                    DaapConnection connection = this.server.getConnection(sid);
                    if (connection == null) {
                        throw new IOException("No connection associated with this Session-ID: " + sid);
                    }
                    this.setProtocolVersion(connection.getProtocolVersion());
                } else if (request.isServerInfoRequest()) {
                    this.setConnectionType(1);
                    this.setProtocolVersion(DaapUtil.getProtocolVersion(request));
                } else {
                    throw new IOException("Illegal first request: " + request);
                }
                if (!DaapUtil.isSupportedProtocolVersion(this.getProtocolVersion())) {
                    throw new IOException("Unsupported Protocol Version: " + this.getProtocolVersion());
                }
                if (!this.server.addConnection(this)) {
                    throw new IOException("Server refused this connection");
                }
            }
            if ((response = PROCESSOR.process(request)) != null) {
                this.writer.add(response);
            }
            return true;
        }
        throw new IOException("Cannot read requests from audio stream");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            do {
                this.read();
            } while (this.connected && this.write());
        }
        catch (DaapStreamException err) {
        }
        catch (SocketException err) {
        }
        catch (IOException err) {
            LOG.error((Object)err);
        }
        finally {
            this.close();
        }
    }

    public synchronized void update() throws IOException {
        DaapSession session;
        if (this.isDaapConnection() && (session = this.getSession(false)) != null && !session.hasAttribute("UPDATE_LOCK")) {
            DaapRequest request;
            DaapResponse response;
            Integer sessionId = session.getSessionId();
            Integer delta = (Integer)session.getAttribute("DELTA");
            Integer revisionNumber = (Integer)session.getAttribute("REVISION-NUMBER");
            if (delta != null && revisionNumber != null && (response = PROCESSOR.process(request = new DaapRequest((DaapConnection)this, sessionId, revisionNumber, delta))) != null) {
                response.write();
            }
        }
    }

    void disconnect() {
        this.connected = false;
        this.close();
    }

    public void close() {
        super.close();
        try {
            if (this.in != null) {
                this.in.close();
            }
        }
        catch (IOException err) {
            LOG.error((Object)"Error while closing connection", (Throwable)err);
        }
        try {
            if (this.out != null) {
                this.out.close();
            }
        }
        catch (IOException err) {
            LOG.error((Object)"Error while closing connection", (Throwable)err);
        }
        try {
            if (this.socket != null) {
                this.socket.close();
            }
        }
        catch (IOException err) {
            LOG.error((Object)"Error while closing connection", (Throwable)err);
        }
        if (this.connected) {
            this.server.removeConnection(this);
        }
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public OutputStream getOutputStream() {
        return this.out;
    }

    private DaapRequest readRequest() throws IOException {
        String line = null;
        while ((line = HttpParser.readLine((InputStream)this.in)) != null && line.length() == 0) {
        }
        if (line == null) {
            throw new IOException("Request is null: " + this);
        }
        DaapRequest request = new DaapRequest(this, line);
        Header[] headers = HttpParser.parseHeaders((InputStream)this.in);
        request.addHeaders(headers);
        return request;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer("DaapConnection [");
        buffer.append("Host: ").append(this.socket.getInetAddress()).append(":").append(this.socket.getPort());
        buffer.append(", audioStream: ").append(this.isAudioStream());
        buffer.append(", hasSession: ").append(this.getSession(false) != null);
        return buffer.append("]").toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

