/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap;

import de.kapsi.net.daap.DaapAuthenticator;
import de.kapsi.net.daap.DaapServer;
import de.kapsi.net.daap.DaapServerFactory;
import de.kapsi.net.daap.DaapStreamSource;
import de.kapsi.net.daap.Database;
import de.kapsi.net.daap.Library;
import de.kapsi.net.daap.Playlist;
import de.kapsi.net.daap.SimpleConfig;
import de.kapsi.net.daap.Song;
import de.kapsi.net.daap.Transaction;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.jmdns.JmDNS;
import javax.jmdns.ServiceInfo;

public class Main
extends TimerTask
implements DaapAuthenticator,
DaapStreamSource {
    private static final File SONG = new File("music/song.mp3");
    private static final String LIBRARY = "My Library123";
    private static final int PORT = 5360;
    private static final String[] NAMES = new String[]{"Hello World!", "This Is A Test!", "W00t!", "Under the Impression", "There Is", "Elvelator", "Daze Gone By", "The Only One"};
    private static final String[] ALBUMS = new String[]{"My Album", "Hypnoised", "The Blue Album", "Another EP", "American Analog Set"};
    private static final String[] ARTISTS = new String[]{"My Artist", "Good Charlotte", "Blink 182", "Sum 41", "Know by Heart"};
    private int index_names = 0;
    private int index_albums = 0;
    private int index_artists = 0;
    private Library library;
    private Database database;
    private Playlist playlist0;
    private Playlist playlist1;
    private Playlist playlist2;
    private Playlist playlist3;
    private Song updateSong;
    private Song remove;
    private DaapServer server;

    public Main() throws Exception {
        System.out.println(SONG);
        JmDNS jmdns = new JmDNS();
        ServiceInfo serviceInfo = new ServiceInfo("_daap._tcp.local.", "My Library123._daap._tcp.local.", 5360, 0, 0, LIBRARY);
        jmdns.registerService(serviceInfo);
        this.library = new Library(LIBRARY);
        this.database = new Database("LimeWireXYZ");
        this.playlist0 = new Playlist("Rock Music");
        this.playlist1 = new Playlist("Rock & Roll");
        this.playlist2 = new Playlist("Punk Music");
        this.playlist3 = new Playlist("All");
        Transaction txn = this.library.open(false);
        this.playlist1.setSmartPlaylist(txn, true);
        this.playlist3.setSmartPlaylist(txn, true);
        this.library.add(txn, this.database);
        this.database.add(txn, this.playlist0);
        this.database.add(txn, this.playlist1);
        this.database.add(txn, this.playlist2);
        this.database.add(txn, this.playlist3);
        txn.commit();
        Playlist masterPlaylist = this.database.getMasterPlaylist();
        txn = this.library.open(false);
        for (int i = 0; i < 100; ++i) {
            Song song = this.createSong(i);
            if (i % 2 == 0) {
                this.playlist0.add(txn, song);
            } else if (i % 3 == 0) {
                this.playlist1.add(txn, song);
            } else {
                this.playlist2.add(txn, song);
            }
            this.playlist3.add(txn, song);
            this.updateSong = song;
        }
        txn.commit();
        SimpleConfig config = new SimpleConfig(5360);
        config.setMaxConnections(10);
        this.server = DaapServerFactory.createNIOServer(this.library, config);
        this.server.setAuthenticator(this);
        this.server.setStreamSource(this);
        this.server.bind();
        Thread serverThread = new Thread((Runnable)this.server, "DaapServerThread");
        serverThread.setDaemon(true);
        serverThread.start();
    }

    public Song createSong(int i) {
        Song song = new Song("The Only One " + i);
        song.setArtist("American Analog Set");
        song.setAlbum("Know by Heart");
        song.setGenre("Rock/Pop");
        song.setTrackNumber(2);
        song.setSize((int)SONG.length());
        song.setBitrate(128);
        song.setTime(135000);
        song.setUserRating(i % 100);
        return song;
    }

    public boolean requiresAuthentication() {
        return false;
    }

    public boolean authenticate(String username, String password) {
        return password.equals("test");
    }

    public FileInputStream getSource(Song song) throws IOException {
        File file = SONG;
        if (file != null && file.isFile()) {
            return new FileInputStream(file);
        }
        return null;
    }

    public void run() {
        this.updateSong.setName("0 " + NAMES[this.index_names]);
        this.updateSong.setArtist("0 " + ARTISTS[this.index_artists]);
        this.updateSong.setAlbum("0 " + ALBUMS[this.index_albums]);
        this.updateSong.setUserRating((this.updateSong.getUserRating() + 20) % 120);
        Transaction txn = this.library.open(false);
        this.database.update(txn, this.updateSong);
        boolean smart = this.playlist0.isSmartPlaylist();
        this.playlist0.setSmartPlaylist(txn, !this.playlist1.isSmartPlaylist());
        this.playlist1.setSmartPlaylist(txn, !this.playlist2.isSmartPlaylist());
        this.playlist2.setSmartPlaylist(txn, !this.playlist3.isSmartPlaylist());
        this.playlist3.setSmartPlaylist(txn, !smart);
        String p0 = this.playlist0.getName();
        this.playlist0.setName(txn, this.playlist1.getName());
        this.playlist1.setName(txn, this.playlist2.getName());
        this.playlist2.setName(txn, this.playlist3.getName());
        this.playlist3.setName(txn, p0);
        txn.commit();
        this.server.update();
        this.index_names = (this.index_names + 1) % NAMES.length;
        this.index_artists = (this.index_artists + 1) % ARTISTS.length;
        this.index_albums = (this.index_albums + 1) % ALBUMS.length;
    }

    public static void main(String[] args) throws Exception {
        Main app = new Main();
        Timer timer = new Timer();
        timer.scheduleAtFixedRate((TimerTask)app, 1000L, 3000L);
    }
}

