/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.MetaDataEditor;
import com.limegroup.gnutella.metadata.MetaDataReader;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.I18NConvert;
import com.limegroup.gnutella.util.Trie;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class LimeXMLReplyCollection {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$xml$LimeXMLReplyCollection == null ? (class$com$limegroup$gnutella$xml$LimeXMLReplyCollection = LimeXMLReplyCollection.class$("com.limegroup.gnutella.xml.LimeXMLReplyCollection")) : class$com$limegroup$gnutella$xml$LimeXMLReplyCollection));
    private final String schemaURI;
    private final HashMap mainMap;
    private final Map trieMap;
    private final boolean audio;
    private File dataFile = null;
    private final Object WRITE_LOCK = new Object();
    public static final int NORMAL = 0;
    public static final int FILE_DEFECTIVE = 1;
    public static final int RW_ERROR = 2;
    public static final int BAD_ID3 = 3;
    public static final int FAILED_TITLE = 4;
    public static final int FAILED_ARTIST = 5;
    public static final int FAILED_ALBUM = 6;
    public static final int FAILED_YEAR = 7;
    public static final int FAILED_COMMENT = 8;
    public static final int FAILED_TRACK = 9;
    public static final int FAILED_GENRE = 10;
    public static final int HASH_FAILED = 11;
    public static final int INCORRECT_FILETYPE = 12;
    static /* synthetic */ Class class$com$limegroup$gnutella$xml$LimeXMLReplyCollection;

    public LimeXMLReplyCollection(FileDesc[] fds, String URI2, boolean audio) {
        this.schemaURI = URI2;
        this.audio = audio;
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("LimeXMLReplyCollection(): entered with audio = " + audio));
        }
        this.mainMap = new HashMap();
        this.trieMap = new HashMap();
        MapSerializer ms = this.initializeMapSerializer(URI2);
        HashMap hashToXML = ms == null ? new HashMap() : ms.getMap();
        boolean requiresConversion = false;
        Iterator iter = hashToXML.keySet().iterator();
        if (iter.hasNext()) {
            requiresConversion = iter.next() instanceof String;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("requiresConversion: " + requiresConversion));
        }
        for (int i = 0; i < fds.length; ++i) {
            FileDesc fd = fds[i];
            if (fd instanceof IncompleteFileDesc) continue;
            File file = fd.getFile();
            URN hash = fd.getSHA1Urn();
            Object xml = null;
            LimeXMLDocument doc = null;
            if (requiresConversion) {
                String miniHash = null;
                try {
                    miniHash = new String(LimeXMLUtils.hashFile(file));
                }
                catch (IOException e) {
                    continue;
                }
                xml = hashToXML.get(miniHash);
                doc = xml != null && xml instanceof LimeXMLDocument ? (LimeXMLDocument)xml : this.constructDocument(file);
            } else {
                xml = hashToXML.get(hash);
                doc = xml == null ? this.constructDocument(file) : (LimeXMLDocument)xml;
            }
            if (doc == null) continue;
            if (!doc.supportsID3v2() && LimeXMLUtils.isMP3File(file)) {
                LimeXMLDocument tempDoc;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("reconstructing document for id3v2: " + file));
                }
                if ((tempDoc = this.constructDocument(file)) != null) {
                    doc = tempDoc;
                }
            }
            if (!doc.isValid() && ((doc = this.constructDocument(file)) == null || !doc.isValid())) continue;
            if (AudioMetaData.isCorrupted(doc)) {
                doc = AudioMetaData.fixCorruption(doc);
                this.addReplyWithCommit(file, fd, doc, false);
                continue;
            }
            this.addReply(fd, doc);
        }
        LOG.trace((Object)"LimeXMLReplyCollection(): returning.");
        this.write();
    }

    private LimeXMLDocument constructDocument(File file) {
        if (LimeXMLUtils.isSupportedFormatForSchema(file, this.schemaURI)) {
            try {
                return MetaDataReader.readDocument(file);
            }
            catch (IOException ignored) {
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List getKeyWords() {
        ArrayList retList = new ArrayList();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator docs = this.mainMap.values().iterator();
            while (docs.hasNext()) {
                LimeXMLDocument d = (LimeXMLDocument)docs.next();
                retList.addAll(d.getKeyWords());
            }
        }
        return retList;
    }

    private MapSerializer initializeMapSerializer(String URI2) {
        String fname = LimeXMLSchema.getDisplayString(URI2) + ".sxml";
        LimeXMLProperties props = LimeXMLProperties.instance();
        String path = props.getXMLDocsDir();
        this.dataFile = new File(path, fname);
        if (this.dataFile.isDirectory()) {
            return null;
        }
        try {
            return new MapSerializer(this.dataFile);
        }
        catch (IOException e) {
            LOG.debug((Object)"exception initializing", (Throwable)e);
            return null;
        }
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addKeywords(LimeXMLDocument doc) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator i = doc.getNameValueSet().iterator();
            while (i.hasNext()) {
                LinkedList<LimeXMLDocument> allDocs;
                Map.Entry entry = (Map.Entry)i.next();
                String name = (String)entry.getKey();
                String value = I18NConvert.instance().getNorm((String)entry.getValue());
                Trie trie = (Trie)this.trieMap.get(name);
                if (trie == null) {
                    trie = new Trie(true);
                    this.trieMap.put(name, trie);
                }
                if ((allDocs = (LinkedList<LimeXMLDocument>)trie.get(value)) == null) {
                    allDocs = new LinkedList<LimeXMLDocument>();
                    trie.add(value, allDocs);
                }
                allDocs.add(doc);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeKeywords(LimeXMLDocument doc) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            Iterator i = doc.getNameValueSet().iterator();
            while (i.hasNext()) {
                String value;
                List allDocs;
                Map.Entry entry = (Map.Entry)i.next();
                String name = (String)entry.getKey();
                Trie trie = (Trie)this.trieMap.get(name);
                if (trie == null || (allDocs = (List)trie.get(value = I18NConvert.instance().getNorm((String)entry.getValue()))) == null) continue;
                allDocs.remove(doc);
                if (allDocs.size() != 0) continue;
                trie.remove(value);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addReply(FileDesc fd, LimeXMLDocument replyDoc) {
        URN hash = fd.getSHA1Urn();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            this.mainMap.put(hash, replyDoc);
            this.addKeywords(replyDoc);
        }
        fd.addLimeXMLDocument(replyDoc);
        try {
            String identifier = fd.getFile().getCanonicalPath();
            replyDoc.setIdentifier(identifier);
        }
        catch (IOException ignored) {
            // empty catch block
        }
    }

    void addReplyWithCommit(File f, FileDesc fd, LimeXMLDocument replyDoc, boolean checkBetter) {
        this.addReply(fd, replyDoc);
        if (this.audio) {
            try {
                this.mediaFileToDisk(fd, f.getCanonicalPath(), replyDoc, checkBetter);
            }
            catch (IOException ignored) {}
        } else {
            this.write();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getCount() {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            return this.mainMap.size();
        }
    }

    public boolean isAudio() {
        return this.audio;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument getDocForHash(URN hash) {
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            return (LimeXMLDocument)this.mainMap.get(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMatchingReplies(LimeXMLDocument query) {
        Iterator i;
        HashSet matching = null;
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            i = query.getNameValueSet().iterator();
            while (i.hasNext()) {
                String value;
                Iterator iter;
                Map.Entry entry = (Map.Entry)i.next();
                String name = (String)entry.getKey();
                Trie trie = (Trie)this.trieMap.get(name);
                if (trie == null || !(iter = trie.getPrefixedBy(value = (String)entry.getValue())).hasNext()) continue;
                if (matching == null) {
                    matching = new HashSet();
                }
                while (iter.hasNext()) {
                    List matchesVal = (List)iter.next();
                    matching.addAll(matchesVal);
                }
            }
        }
        if (matching == null || matching.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        LinkedList<LimeXMLDocument> actualMatches = null;
        i = matching.iterator();
        while (i.hasNext()) {
            LimeXMLDocument currReplyDoc = (LimeXMLDocument)i.next();
            if (!LimeXMLUtils.match(currReplyDoc, query, false)) continue;
            if (actualMatches == null) {
                actualMatches = new LinkedList<LimeXMLDocument>();
            }
            actualMatches.add(currReplyDoc);
        }
        if (actualMatches == null || actualMatches.size() == 0) {
            return Collections.EMPTY_LIST;
        }
        return actualMatches;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LimeXMLDocument replaceDoc(FileDesc fd, LimeXMLDocument newDoc) {
        LimeXMLDocument oldDoc = null;
        URN hash = fd.getSHA1Urn();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            oldDoc = this.mainMap.put(hash, newDoc);
            if (oldDoc == null) {
                Assert.that(false, "attempted to replace doc that did not exist!!");
            }
            this.removeKeywords(oldDoc);
            this.addKeywords(newDoc);
        }
        fd.replaceLimeXMLDocument(oldDoc, newDoc);
        return oldDoc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeDoc(FileDesc fd) {
        boolean found;
        LimeXMLDocument val;
        URN hash = fd.getSHA1Urn();
        HashMap hashMap = this.mainMap;
        synchronized (hashMap) {
            val = (LimeXMLDocument)this.mainMap.remove(hash);
            found = val != null;
        }
        boolean written = false;
        if (found) {
            written = this.write();
            if (written) {
                fd.removeLimeXMLDocument(val);
                this.removeKeywords(val);
            } else {
                HashMap hashMap2 = this.mainMap;
                synchronized (hashMap2) {
                    this.mainMap.put(hash, val);
                }
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("found: " + found + ", written: " + written));
        }
        return found && written;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean write() {
        if (this.dataFile == null) {
            String fname = LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml";
            LimeXMLProperties props = LimeXMLProperties.instance();
            String path = props.getXMLDocsDir();
            this.dataFile = new File(path, fname);
        }
        if (this.dataFile.isDirectory()) {
            return false;
        }
        try {
            MapSerializer ms = new MapSerializer(this.dataFile, this.mainMap);
            Object object = this.WRITE_LOCK;
            synchronized (object) {
                ms.commit();
            }
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    public int mediaFileToDisk(FileDesc fd, String fileName, LimeXMLDocument doc, boolean checkBetter) {
        MetaDataEditor commitWith;
        boolean wrote = false;
        int mp3WriteState = -1;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("writing: " + fileName + " to disk."));
        }
        if ((commitWith = this.getEditorIfNeeded(fileName, doc, checkBetter)) != null) {
            if (commitWith.getCorrectDocument() == null) {
                mp3WriteState = this.commitMetaData(fileName, commitWith);
            } else {
                this.removeDoc(fd);
                this.addReply(fd, commitWith.getCorrectDocument());
                mp3WriteState = 0;
            }
        }
        Assert.that(mp3WriteState != 12, "trying to write id3 to non mp3 file");
        wrote = this.write();
        if (!wrote) {
            return 2;
        }
        return mp3WriteState;
    }

    private MetaDataEditor getEditorIfNeeded(String mp3File, LimeXMLDocument doc, boolean checkBetter) {
        MetaDataEditor newValues = MetaDataEditor.getEditorForFile(mp3File);
        if (newValues == null) {
            return null;
        }
        String newXML = null;
        try {
            newXML = doc.getXMLStringWithIdentifier();
        }
        catch (SchemaNotFoundException snfe) {
            return null;
        }
        newValues.populateFromString(newXML);
        MetaDataEditor existing = MetaDataEditor.getEditorForFile(mp3File);
        LimeXMLDocument existingDoc = null;
        try {
            existingDoc = MetaDataReader.readDocument(new File(mp3File));
        }
        catch (IOException e) {
            return null;
        }
        String existingXML = null;
        try {
            existingXML = existingDoc.getXMLStringWithIdentifier();
        }
        catch (SchemaNotFoundException snfe) {
            return null;
        }
        existing.populateFromString(existingXML);
        if (!checkBetter) {
            if (newValues.equals(existing)) {
                return null;
            }
            return newValues;
        }
        if (newValues.equals(existing)) {
            LOG.debug((Object)"tag read from disk is same as XML doc.");
            return null;
        }
        if (existing.betterThan(newValues)) {
            existing.setCorrectDocument(existingDoc);
            return existing;
        }
        newValues.pickBetterFields(existing);
        return newValues;
    }

    private int commitMetaData(String fileName, MetaDataEditor editor) {
        int retVal = editor.commitMetaData(fileName);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("wrote data: " + retVal));
        }
        if (retVal == 1 || retVal == 2 || retVal == 3 || retVal == 12) {
            return retVal;
        }
        RouterService.getFileManager().fileChanged(new File(fileName));
        return retVal;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class MapSerializer {
        private File _backingStoreFile;
        private Map _hashMap;

        MapSerializer(File whereToStore) throws IOException {
            this._backingStoreFile = whereToStore;
            if (this._backingStoreFile.exists()) {
                this.deserializeFromFile();
            } else {
                this._hashMap = new HashMap();
            }
        }

        MapSerializer(File whereToStore, Map storage) {
            this._backingStoreFile = whereToStore;
            this._hashMap = storage;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void deserializeFromFile() throws IOException {
            ObjectInputStream is = null;
            try {
                try {
                    is = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(this._backingStoreFile)));
                    this._hashMap = (Map)is.readObject();
                    if (LOG.isDebugEnabled()) {
                        Iterator it = this._hashMap.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry ent = it.next();
                            LOG.debug((Object)("read " + ent.getKey() + ", " + ent.getValue()));
                        }
                    }
                    Object var5_5 = null;
                    if (is == null) return;
                }
                catch (Throwable t) {
                    LOG.error((Object)"Unable to read LimeXMLCollection", t);
                    throw new IOException();
                }
            }
            catch (Throwable throwable) {
                Object var5_6 = null;
                if (is == null) throw throwable;
                try {
                    is.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException ignored) {}
            is.close();
            return;
        }

        public void commit() throws IOException {
            this.serializeToFile();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void serializeToFile() throws IOException {
            FileOutputStream ostream = null;
            ObjectOutputStream objStream = null;
            try {
                ostream = new FileOutputStream(this._backingStoreFile);
                objStream = new ObjectOutputStream(new BufferedOutputStream(ostream));
                Map map = this._hashMap;
                synchronized (map) {
                    objStream.writeObject(this._hashMap);
                }
                Object var6_5 = null;
                if (ostream == null) return;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                if (ostream == null) throw throwable;
                try {
                    ostream.close();
                    throw throwable;
                }
                catch (IOException ignored) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                ostream.close();
                return;
            }
            catch (IOException ignored) {}
        }

        public Map getMap() {
            return this._hashMap;
        }
    }
}

