/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.downloader.Interval;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.SortedSet;
import java.util.TreeSet;

public class IntervalSet {
    private final SortedSet intervals = new TreeSet(new IntervalComparator());

    public void add(Interval addInterval) {
        int low = addInterval.low;
        int high = addInterval.high;
        Interval lower = null;
        Interval higher = null;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval interval = (Interval)iter.next();
            if (low <= interval.low && interval.high <= high) {
                iter.remove();
                continue;
            }
            if (low <= interval.high && interval.low < low) {
                lower = interval;
            }
            if (interval.high == low - 1) {
                lower = interval;
            }
            if (interval.low <= high && interval.high > high) {
                higher = interval;
            }
            if (high == interval.low - 1) {
                higher = interval;
            }
            if (higher == null && interval.low <= high) continue;
            break;
        }
        if (lower == null && higher == null) {
            this.intervals.add(new Interval(low, high));
        } else if (lower != null && higher != null) {
            this.intervals.remove(higher);
            this.intervals.remove(lower);
            this.intervals.add(new Interval(lower.low, higher.high));
        } else if (higher != null) {
            this.intervals.remove(higher);
            this.intervals.add(new Interval(low, higher.high));
        } else {
            this.intervals.remove(lower);
            this.intervals.add(new Interval(lower.low, high));
        }
    }

    public void delete(Interval deleteMe) {
        int low = deleteMe.low;
        int high = deleteMe.high;
        Interval lower = null;
        Interval higher = null;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval interval = (Interval)iter.next();
            if (interval.high >= low && interval.low <= high) {
                iter.remove();
                if (interval.high <= high) {
                    if (interval.low >= low) continue;
                    lower = new Interval(interval.low, low - 1);
                    continue;
                }
                if (interval.low >= low) {
                    higher = new Interval(high + 1, interval.high);
                    break;
                }
                lower = new Interval(interval.low, low - 1);
                higher = new Interval(high + 1, interval.high);
                break;
            }
            if (interval.low < high) continue;
            break;
        }
        if (lower != null) {
            this.add(lower);
        }
        if (higher != null) {
            this.add(higher);
        }
    }

    public void delete(IntervalSet set) {
        Iterator iter = set.getAllIntervals();
        while (iter.hasNext()) {
            this.delete((Interval)iter.next());
        }
    }

    public Interval removeFirst() throws NoSuchElementException {
        Interval ret = (Interval)this.intervals.first();
        this.intervals.remove(ret);
        return ret;
    }

    public List getOverlapIntervals(Interval checkInterval) {
        ArrayList<Interval> overlapBlocks = new ArrayList<Interval>();
        long low = checkInterval.low;
        long high = checkInterval.high;
        if (low >= high) {
            return overlapBlocks;
        }
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval interval = (Interval)iter.next();
            if (low <= (long)interval.low && (long)interval.high <= high) {
                overlapBlocks.add(interval);
                continue;
            }
            if (low <= (long)interval.high && (long)interval.low < low) {
                overlapBlocks.add(new Interval((int)low, Math.min((int)high, interval.high)));
            }
            if ((long)interval.low > high || (long)interval.high <= high) continue;
            overlapBlocks.add(new Interval(Math.max(interval.low, (int)low), (int)high));
        }
        return overlapBlocks;
    }

    public Iterator getAllIntervals() {
        return this.intervals.iterator();
    }

    public List getAllIntervalsAsList() {
        return new ArrayList(this.intervals);
    }

    public int getSize() {
        int sum = 0;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval block = (Interval)iter.next();
            sum += block.high - block.low + 1;
        }
        return sum;
    }

    public boolean isEmpty() {
        return this.intervals.isEmpty();
    }

    public void clear() {
        this.intervals.clear();
    }

    public IntervalSet invert(int maxSize) {
        IntervalSet ret = new IntervalSet();
        if (maxSize < 1) {
            return ret;
        }
        if (this.intervals.size() == 0) {
            Interval block = new Interval(0, maxSize - 1);
            ret.add(block);
            return ret;
        }
        int low = -1;
        Interval interval = null;
        boolean fixed = false;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            interval = (Interval)iter.next();
            if (interval.low != 0 && low < interval.low) {
                if (low + 1 > interval.low - 1) {
                    if (!fixed) {
                        fixed = true;
                        this.fix();
                        iter = this.intervals.iterator();
                        low = -1;
                        interval = null;
                        continue;
                    }
                    throw new IllegalArgumentException("constructing invalid interval  while trying to invert \n" + this.toString() + " \n with size " + maxSize + " low:" + low + " interval.low:" + interval.low);
                }
                ret.add(new Interval(low + 1, interval.low - 1));
            }
            low = interval.high;
        }
        Assert.that(interval != null, "Null interval in getFreeBlocks");
        if (interval.high < maxSize - 1) {
            ret.add(new Interval(interval.high + 1, maxSize - 1));
        }
        return ret;
    }

    public Iterator getNeededIntervals(int maxSize) {
        return this.invert(maxSize).getAllIntervals();
    }

    public Object clone() {
        IntervalSet ret = new IntervalSet();
        Iterator iter = this.getAllIntervals();
        while (iter.hasNext()) {
            ret.intervals.add(iter.next());
        }
        return ret;
    }

    public String toString() {
        return this.intervals.toString();
    }

    public byte[] toBytes() {
        byte[] ret = new byte[this.intervals.size() * 8];
        int pos = 0;
        Iterator iter = this.intervals.iterator();
        while (iter.hasNext()) {
            Interval current = (Interval)iter.next();
            System.arraycopy(current.toBytes(), 0, ret, pos, 8);
            pos += 8;
        }
        return ret;
    }

    public static IntervalSet parseBytes(byte[] data) {
        IntervalSet ret = new IntervalSet();
        for (int i = 0; i < data.length / 8; ++i) {
            int low = ByteOrder.beb2int(data, i * 8);
            int high = ByteOrder.beb2int(data, i * 8 + 4);
            ret.add(new Interval(low, high));
        }
        return ret;
    }

    private void fix() {
        String preIntervals = this.intervals.toString();
        ArrayList oldIntervals = new ArrayList(this.intervals);
        this.intervals.clear();
        Iterator i = oldIntervals.iterator();
        while (i.hasNext()) {
            this.add((Interval)i.next());
        }
        String postIntervals = this.intervals.toString();
        Assert.silent(false, "IntervalSet invariants broken.\nPre  Fixing: " + preIntervals + "\n" + "Post Fixing: " + postIntervals);
    }

    private class IntervalComparator
    implements Comparator {
        private IntervalComparator() {
        }

        public int compare(Object a, Object b) {
            Interval ia = (Interval)a;
            Interval ib = (Interval)b;
            return ia.low - ib.low;
        }
    }
}

