/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.SystemUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class FileUtils {
    private static final Set UNWRITEABLE = Collections.synchronizedSet(new HashSet());

    public static void writeMap(String filename, Map map) throws IOException, ClassNotFoundException {
        ObjectOutputStream out = null;
        if (out != null) {
            out.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map readMap(String filename) throws IOException, ClassNotFoundException {
        ObjectInputStream in = null;
        try {
            in = new ObjectInputStream(new FileInputStream(filename));
            Map map = (Map)in.readObject();
            return map;
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    public static File[] listFiles(File f) {
        return f.listFiles();
    }

    public static File[] listFiles(File f, FilenameFilter filter) {
        return f.listFiles(filter);
    }

    public static File getParentFile(File f) {
        return f.getParentFile();
    }

    public static File getCanonicalFile(File f) throws IOException {
        return f.getCanonicalFile();
    }

    public static String getFileExtension(File f) {
        String name = f.getName();
        int index = name.lastIndexOf(".");
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return null;
        }
        if (index == name.length() - 1) {
            return null;
        }
        return name.substring(index + 1);
    }

    public static boolean setWriteable(File f) {
        String fName;
        if (!f.exists()) {
            return true;
        }
        if (f.canWrite()) {
            if (CommonUtils.isWindows()) {
                return true;
            }
            if (!f.isDirectory()) {
                return true;
            }
        }
        try {
            fName = f.getCanonicalPath();
        }
        catch (IOException ioe) {
            fName = f.getPath();
        }
        if (UNWRITEABLE.contains(fName)) {
            return false;
        }
        String[] cmds = null;
        if (CommonUtils.isWindows()) {
            SystemUtils.setWriteable(fName);
        } else {
            cmds = CommonUtils.isOS2() ? null : (f.isDirectory() ? new String[]{"chmod", "u+w+x", fName} : new String[]{"chmod", "u+w", fName});
        }
        if (cmds != null) {
            try {
                Process p = Runtime.getRuntime().exec(cmds);
                p.waitFor();
            }
            catch (SecurityException ignored) {
            }
            catch (IOException ignored) {
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (!f.canWrite()) {
            UNWRITEABLE.add(fName);
            return false;
        }
        return true;
    }

    public static void touch(File f) throws IOException {
        File parent = f.getParentFile();
        if (parent != null) {
            parent.mkdirs();
        }
        f.createNewFile();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean forceRename(File a, File b) {
        FileDesc fd;
        boolean success = a.renameTo(b);
        if (!success && (fd = RouterService.getFileManager().getFileDescForFile(a)) != null) {
            UploadManager upMan;
            UploadManager uploadManager = upMan = RouterService.getUploadManager();
            synchronized (uploadManager) {
                if (upMan.killUploadsForFileDesc(fd)) {
                    success = a.renameTo(b);
                }
            }
        }
        if (!success && (success = CommonUtils.copy(a, b))) {
            a.delete();
        }
        return success;
    }
}

