/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;

public final class ResourceGETUploadState
extends UploadState {
    public final String NOT_FOUND = "HTTP/1.1 404 Not Found";
    public final String INT_ERROR = "HTTP/1.1 500 Internal Error";
    private byte[] _resourceBytes = new byte[0];

    public ResourceGETUploadState(HTTPUploader uploader) {
        super(uploader);
    }

    public void writeMessageHeaders(OutputStream ostream) throws IOException {
        String resource = this.UPLOADER.getFileName();
        boolean noResource = false;
        try {
            File resourceFile = CommonUtils.getResourceFile(resource);
            FileInputStream fr = new FileInputStream(resourceFile);
            this._resourceBytes = new byte[(int)resourceFile.length()];
            for (int read = 0; read < this._resourceBytes.length; read += fr.read(this._resourceBytes, read, this._resourceBytes.length - read)) {
            }
        }
        catch (FileNotFoundException fnfe) {
            String str = "HTTP/1.1 404 Not Found\r\n";
            ostream.write(str.getBytes());
            ostream.flush();
            this._resourceBytes = "HTTP/1.1 404 Not Found".getBytes();
            return;
        }
        catch (IOException ioe) {
            String str = "HTTP/1.1 500 Internal Error\r\n";
            ostream.write(str.getBytes());
            ostream.flush();
            this._resourceBytes = "HTTP/1.1 500 Internal Error".getBytes();
            return;
        }
        String str = "HTTP/1.1 200 OK\r\n";
        ostream.write(str.getBytes());
        str = "Server: " + CommonUtils.getHttpServer() + "\r\n";
        ostream.write(str.getBytes());
        str = "Content-Type: image/gif\r\n";
        ostream.write(str.getBytes());
        str = "Content-Length: " + this._resourceBytes.length + "\r\n";
        ostream.write(str.getBytes());
        str = "\r\n";
        ostream.write(str.getBytes());
    }

    public void writeMessageBody(OutputStream ostream) throws IOException {
        ostream.write(this._resourceBytes);
        this.UPLOADER.setAmountUploaded(this._resourceBytes.length);
    }

    public boolean getCloseConnection() {
        return false;
    }
}

