/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.udpconnect;

import com.limegroup.gnutella.udpconnect.SynMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionMessage;
import com.limegroup.gnutella.udpconnect.UDPConnectionProcessor;
import java.lang.ref.WeakReference;
import java.net.InetAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPMultiplexor {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$udpconnect$UDPMultiplexor == null ? (class$com$limegroup$gnutella$udpconnect$UDPMultiplexor = UDPMultiplexor.class$("com.limegroup.gnutella.udpconnect.UDPMultiplexor")) : class$com$limegroup$gnutella$udpconnect$UDPMultiplexor));
    private static UDPMultiplexor _instance = null;
    public static final byte UNASSIGNED_SLOT = 0;
    private WeakReference[] _connections = new WeakReference[256];
    private int _lastConnectionID = 0;
    static /* synthetic */ Class class$com$limegroup$gnutella$udpconnect$UDPMultiplexor;

    public static synchronized UDPMultiplexor instance() {
        if (_instance == null) {
            _instance = new UDPMultiplexor();
        }
        return _instance;
    }

    private UDPMultiplexor() {
    }

    public synchronized byte register(UDPConnectionProcessor con) {
        for (int i = 1; i <= this._connections.length; ++i) {
            int connID = (this._lastConnectionID + i) % 256;
            if (connID == 0 || this._connections[connID] != null && this._connections[connID].get() != null) continue;
            this._lastConnectionID = connID;
            this._connections[connID] = new WeakReference<UDPConnectionProcessor>(con);
            return (byte)connID;
        }
        return 0;
    }

    public synchronized void unregister(UDPConnectionProcessor con) {
        int connID = con.getConnectionID() & 0xFF;
        if (this._connections[connID] != null && this._connections[connID].get() == con) {
            this._connections[connID].clear();
            this._connections[connID] = null;
        }
    }

    public synchronized void routeMessage(UDPConnectionMessage msg, InetAddress senderIP, int senderPort) {
        int connID = msg.getConnectionID() & 0xFF;
        if (connID == 0 && msg instanceof SynMessage) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Receiving SynMessage :" + msg));
            }
            for (int i = 1; i < this._connections.length; ++i) {
                UDPConnectionProcessor con = this._connections[i] == null ? null : (UDPConnectionProcessor)this._connections[i].get();
                if (con == null || !con.isConnecting() || !con.matchAddress(senderIP, senderPort)) continue;
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("routeMessage to conn:" + i + " Syn:" + msg));
                }
                con.handleMessage(msg);
                break;
            }
        } else {
            UDPConnectionProcessor con = this._connections[connID] == null ? null : (UDPConnectionProcessor)this._connections[connID].get();
            if (con != null && con.matchAddress(senderIP, senderPort)) {
                con.handleMessage(msg);
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

