/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.tigertree;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.tigertree.HashTree;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.ConverterObjectInputStream;
import com.limegroup.gnutella.util.ProcessingQueue;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class TigerTreeCache {
    private static TigerTreeCache instance = null;
    private static final ProcessingQueue QUEUE = new ProcessingQueue("TreeHashTread");
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$tigertree$TigerTreeCache == null ? (class$com$limegroup$gnutella$tigertree$TigerTreeCache = TigerTreeCache.class$("com.limegroup.gnutella.tigertree.TigerTreeCache")) : class$com$limegroup$gnutella$tigertree$TigerTreeCache));
    private static Map TREE_MAP;
    private static final File CACHE_FILE;
    static /* synthetic */ Class class$com$limegroup$gnutella$tigertree$TigerTreeCache;

    public static synchronized TigerTreeCache instance() {
        if (instance == null) {
            instance = new TigerTreeCache();
        }
        return instance;
    }

    public synchronized HashTree getHashTree(FileDesc fd) {
        HashTree tree = (HashTree)TREE_MAP.get(fd.getSHA1Urn());
        if (tree == null) {
            QUEUE.add(new HashRunner(fd));
        }
        return tree;
    }

    public synchronized HashTree getHashTree(URN sha1) {
        HashTree tree = (HashTree)TREE_MAP.get(sha1);
        return tree;
    }

    public synchronized void purgeTree(URN sha1) {
        TREE_MAP.remove(sha1);
    }

    public static synchronized void addHashTree(URN sha1, HashTree tree) {
        if (tree.isGoodDepth()) {
            TREE_MAP.put(sha1, tree);
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("added hashtree for urn " + sha1 + ";" + tree.getRootHash()));
            }
        } else if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("hashtree for urn " + sha1 + " had bad depth"));
        }
    }

    private TigerTreeCache() {
        TREE_MAP = TigerTreeCache.createMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map createMap() {
        Map map;
        ObjectInputStream ois = null;
        try {
            try {
                ois = new ConverterObjectInputStream(new BufferedInputStream(new FileInputStream(CACHE_FILE)));
                map = (Map)ois.readObject();
                Object var4_3 = null;
                if (ois == null) return map;
            }
            catch (Throwable t) {
                LOG.error((Object)"Can't read tiger trees", t);
                HashMap hashMap = new HashMap();
                Object var4_4 = null;
                if (ois == null) return hashMap;
                try {
                    ois.close();
                    return hashMap;
                }
                catch (IOException e) {
                    // empty catch block
                }
                return hashMap;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (ois == null) throw throwable;
            try {}
            catch (IOException e) {
                throw throwable;
            }
            ois.close();
            throw throwable;
        }
        try {}
        catch (IOException e) {
            // empty catch block
            return map;
        }
        ois.close();
        return map;
    }

    private static void removeOldEntries(Map map) {
        Iterator iter = map.keySet().iterator();
        while (iter.hasNext()) {
            URN sha1 = (URN)iter.next();
            if (RouterService.getFileManager().getFileDescForUrn(sha1) != null || RouterService.getDownloadManager().getIncompleteFileManager().getFileForUrn(sha1) != null || Math.random() > (double)(map.size() / 200)) continue;
            map.remove(sha1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void persistCache() {
        TigerTreeCache.removeOldEntries(TREE_MAP);
        ObjectOutputStream oos = null;
        oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(CACHE_FILE)));
        oos.writeObject(TREE_MAP);
        Object var4_2 = null;
        if (oos == null) return;
        try {
            oos.close();
            return;
        }
        catch (IOException ignored) {}
        return;
        {
            catch (IOException e) {
                ErrorService.error(e);
                Object var4_3 = null;
                if (oos == null) return;
                try {
                    oos.close();
                    return;
                }
                catch (IOException ignored) {}
                return;
            }
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (oos == null) throw throwable;
            try {
                oos.close();
                throw throwable;
            }
            catch (IOException ignored) {
                // empty catch block
            }
            throw throwable;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "ttree.cache");
    }

    private static class HashRunner
    implements Runnable {
        private final FileDesc FD;

        HashRunner(FileDesc fd) {
            this.FD = fd;
        }

        public void run() {
            try {
                URN sha1 = this.FD.getSHA1Urn();
                if (TigerTreeCache.instance().getHashTree(sha1) == null) {
                    HashTree tree = HashTree.createHashTree(this.FD);
                    TigerTreeCache.addHashTree(sha1, tree);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

