/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.simpp;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import java.io.IOException;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SimppParser {
    private static DOMParser parser = new DOMParser();
    private static final String VERSION = "version";
    private static final String PROPS = "props";
    private int _version;
    private String _propsData;

    public SimppParser(byte[] dataBytes) throws SAXException, IOException {
        String tmp = null;
        try {
            tmp = new String(dataBytes, "UTF-8");
        }
        catch (UnsupportedEncodingException uex) {
            ErrorService.error(uex);
        }
        this.parseInfo(tmp);
    }

    public int getVersion() {
        return this._version;
    }

    public String getPropsData() {
        return this._propsData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parseInfo(String xmlStr) throws SAXException, IOException {
        if (xmlStr == null || xmlStr.equals("")) {
            throw new SAXException("null xml for version info");
        }
        InputSource inputSource = new InputSource(new StringReader(xmlStr));
        Document d = null;
        DOMParser dOMParser = parser;
        synchronized (dOMParser) {
            parser.parse(inputSource);
            d = parser.getDocument();
        }
        if (d == null) {
            throw new SAXException("parsed documemt is null");
        }
        Element docElement = d.getDocumentElement();
        NodeList children = docElement.getChildNodes();
        int len = children.getLength();
        for (int i = 0; i < len; ++i) {
            Node node = children.item(i);
            String nodeName = node.getNodeName().toLowerCase().trim();
            String value = LimeXMLUtils.getText(node.getChildNodes());
            if (nodeName.equals(VERSION)) {
                String ver = value;
                try {
                    this._version = Integer.parseInt(ver);
                }
                catch (NumberFormatException nfx) {
                    this._version = -1;
                }
                continue;
            }
            if (!nodeName.equals(PROPS)) continue;
            this._propsData = value;
        }
    }
}

