/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.settings;

import com.limegroup.gnutella.settings.AbstractNumberSetting;
import java.util.Properties;

public final class FloatSetting
extends AbstractNumberSetting {
    private float value;

    FloatSetting(Properties defaultProps, Properties props, String key, float defaultFloat) {
        super(defaultProps, props, key, String.valueOf(defaultFloat), null, null, null);
    }

    FloatSetting(Properties defaultProps, Properties props, String key, float defaultFloat, String simppKey, float max, float min) {
        super(defaultProps, props, key, String.valueOf(defaultFloat), simppKey, new Float(max), new Float(min));
    }

    public float getValue() {
        return this.value;
    }

    public void setValue(float value) {
        super.setValue(String.valueOf(value));
    }

    protected void loadValue(String sValue) {
        try {
            this.value = Float.valueOf(sValue.trim()).floatValue();
        }
        catch (NumberFormatException nfe) {
            this.revertToDefault();
        }
    }

    protected boolean isInRange(String value) {
        float max = ((Float)this.MAX_VALUE).floatValue();
        float min = ((Float)this.MIN_VALUE).floatValue();
        float val = Float.parseFloat(value);
        return val <= max && val >= min;
    }
}

