/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.metadata;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.metadata.AudioMetaData;
import com.limegroup.gnutella.metadata.MP3Info;
import de.vdheide.mp3.ID3v2;
import de.vdheide.mp3.ID3v2Exception;
import de.vdheide.mp3.ID3v2Frame;
import de.vdheide.mp3.NoID3v2TagException;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.util.Iterator;
import java.util.Vector;

public class MP3MetaData
extends AudioMetaData {
    public MP3MetaData(File f) throws IOException {
        super(f);
    }

    protected void parseFile(File file) throws IOException {
        this.parseID3v2Data(file);
        MP3Info mp3Info = new MP3Info(file.getCanonicalPath());
        this.setBitrate(mp3Info.getBitRate());
        this.setLength((int)mp3Info.getLengthInSeconds());
        if (!this.isComplete()) {
            this.parseID3v1Data(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void parseID3v1Data(File file) {
        block22: {
            block21: {
                if (file.length() < 128L) {
                    return;
                }
                randomAccessFile = null;
                try {
                    try {
                        randomAccessFile = new RandomAccessFile(file, "r");
                        length = randomAccessFile.length();
                        randomAccessFile.seek(length - 128L);
                        buffer = new byte[30];
                        randomAccessFile.readFully(buffer, 0, 3);
                        tag = new String(buffer, 0, 3);
                        if (!tag.equals("TAG")) {
                            var9_7 = null;
                            if (randomAccessFile == null) return;
                            break block21;
                        }
                        randomAccessFile.readFully(buffer, 0, 30);
                        if (this.getTitle() == null || this.getTitle().equals("")) {
                            this.setTitle(this.getString(buffer, 30));
                        }
                        randomAccessFile.readFully(buffer, 0, 30);
                        if (this.getArtist() == null || this.getArtist().equals("")) {
                            this.setArtist(this.getString(buffer, 30));
                        }
                        randomAccessFile.readFully(buffer, 0, 30);
                        if (this.getAlbum() == null || this.getAlbum().equals("")) {
                            this.setAlbum(this.getString(buffer, 30));
                        }
                        randomAccessFile.readFully(buffer, 0, 4);
                        if (this.getYear() == null || this.getYear().equals("")) {
                            this.setYear(this.getString(buffer, 4));
                        }
                        randomAccessFile.readFully(buffer, 0, 30);
                        if (this.getTrack() == 0 || this.getTrack() == -1) {
                            if (buffer[28] == 0) {
                                this.setTrack((short)ByteOrder.ubyte2int(buffer[29]));
                                commentLength = 28;
                            } else {
                                this.setTrack((short)0);
                                commentLength = 3;
                            }
                            if (this.getComment() == null || this.getComment().equals("")) {
                                this.setComment(this.getString(buffer, commentLength));
                            }
                        }
                        randomAccessFile.readFully(buffer, 0, 1);
                        if (this.getGenre() == null || this.getGenre().equals("")) {
                            this.setGenre(MP3MetaData.getGenreString((short)ByteOrder.ubyte2int(buffer[0])));
                        }
                        break block22;
                    }
                    catch (IOException var3_4) {
                        var9_9 = null;
                        if (randomAccessFile == null) return;
                        try {
                            randomAccessFile.close();
                            return;
                        }
                        catch (IOException ignored) {
                            return;
                        }
                    }
                }
                catch (Throwable var8_16) {
                    var9_10 = null;
                    if (randomAccessFile == null) throw var8_16;
                    ** try [egrp 2[TRYBLOCK] [6 : 398->405)] { 
lbl57:
                    // 1 sources

                    randomAccessFile.close();
                    throw var8_16;
lbl59:
                    // 1 sources

                    catch (IOException ignored) {
                        // empty catch block
                    }
                    throw var8_16;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 398->405)] { 
lbl64:
            // 1 sources

            randomAccessFile.close();
            return;
lbl66:
            // 1 sources

            catch (IOException ignored) {
                // empty catch block
            }
            return;
        }
        var9_8 = null;
        if (randomAccessFile == null) return;
        try {}
        catch (IOException ignored) {}
        randomAccessFile.close();
        return;
    }

    private String getString(byte[] buffer, int length) {
        try {
            return new String(buffer, 0, this.getTrimmedLength(buffer, length), "8859_1");
        }
        catch (UnsupportedEncodingException err) {
            return null;
        }
    }

    private void parseID3v2Data(File file) {
        ID3v2 id3v2Parser = null;
        try {
            id3v2Parser = new ID3v2(file);
        }
        catch (ID3v2Exception idvx) {
            return;
        }
        catch (IOException iox) {
            return;
        }
        Vector frames = null;
        try {
            frames = id3v2Parser.getFrames();
        }
        catch (NoID3v2TagException ntx) {
            return;
        }
        Iterator iter = frames.iterator();
        while (iter.hasNext()) {
            ID3v2Frame frame = (ID3v2Frame)iter.next();
            String frameID = frame.getID();
            byte[] contentBytes = frame.getContent();
            String frameContent = null;
            if (contentBytes.length > 0) {
                try {
                    String enc = frame.isISOLatin1() ? "8859_1" : "Unicode";
                    frameContent = new String(contentBytes, enc).trim();
                }
                catch (UnsupportedEncodingException err) {
                    // empty catch block
                }
            }
            if (frameContent == null || frameContent.trim().equals("")) continue;
            if ("TIT2".equals(frameID)) {
                this.setTitle(frameContent);
                continue;
            }
            if ("TPE1".equals(frameID)) {
                this.setArtist(frameContent);
                continue;
            }
            if ("TALB".equals(frameID)) {
                this.setAlbum(frameContent);
                continue;
            }
            if ("TYER".equals(frameID)) {
                this.setYear(frameContent);
                continue;
            }
            if ("COMM".equals(frameID)) {
                byte[] bytes = frame.getContent();
                int startIndex = 0;
                for (int i = bytes.length - 1; i >= 0; --i) {
                    if (bytes[i] != 0) continue;
                    startIndex = i;
                    break;
                }
                frameContent = new String(bytes, startIndex, bytes.length - startIndex).trim();
                this.setComment(frameContent);
                continue;
            }
            if ("TRCK".equals(frameID)) {
                try {
                    this.setTrack(Short.parseShort(frameContent));
                }
                catch (NumberFormatException ignored) {}
                continue;
            }
            if (!"TCON".equals(frameID)) continue;
            int startIndex = frameContent.indexOf("(");
            int endIndex = frameContent.indexOf(")");
            int genreCode = -1;
            if (startIndex > -1 && endIndex > -1 && startIndex < frameContent.length()) {
                String genreByte = frameContent.substring(startIndex + 1, endIndex);
                try {
                    genreCode = Integer.parseInt(genreByte);
                }
                catch (NumberFormatException nfx) {
                    genreCode = -1;
                }
            }
            if (genreCode >= 0 && genreCode <= 127) {
                this.setGenre(MP3MetaData.getGenreString((short)genreCode));
                continue;
            }
            this.setGenre(frameContent);
        }
    }

    public static String getGenreString(short genre) {
        switch (genre) {
            case 0: {
                return "Blues";
            }
            case 1: {
                return "Classic Rock";
            }
            case 2: {
                return "Country";
            }
            case 3: {
                return "Dance";
            }
            case 4: {
                return "Disco";
            }
            case 5: {
                return "Funk";
            }
            case 6: {
                return "Grunge";
            }
            case 7: {
                return "Hip-Hop";
            }
            case 8: {
                return "Jazz";
            }
            case 9: {
                return "Metal";
            }
            case 10: {
                return "New Age";
            }
            case 11: {
                return "Oldies";
            }
            case 12: {
                return "Other";
            }
            case 13: {
                return "Pop";
            }
            case 14: {
                return "R &amp; B";
            }
            case 15: {
                return "Rap";
            }
            case 16: {
                return "Reggae";
            }
            case 17: {
                return "Rock";
            }
            case 18: {
                return "Techno";
            }
            case 19: {
                return "Industrial";
            }
            case 20: {
                return "Alternative";
            }
            case 21: {
                return "Ska";
            }
            case 22: {
                return "Death Metal";
            }
            case 23: {
                return "Pranks";
            }
            case 24: {
                return "Soundtrack";
            }
            case 25: {
                return "Euro-Techno";
            }
            case 26: {
                return "Ambient";
            }
            case 27: {
                return "Trip-Hop";
            }
            case 28: {
                return "Vocal";
            }
            case 29: {
                return "Jazz+Funk";
            }
            case 30: {
                return "Fusion";
            }
            case 31: {
                return "Trance";
            }
            case 32: {
                return "Classical";
            }
            case 33: {
                return "Instrumental";
            }
            case 34: {
                return "Acid";
            }
            case 35: {
                return "House";
            }
            case 36: {
                return "Game";
            }
            case 37: {
                return "Sound Clip";
            }
            case 38: {
                return "Gospel";
            }
            case 39: {
                return "Noise";
            }
            case 40: {
                return "AlternRock";
            }
            case 41: {
                return "Bass";
            }
            case 42: {
                return "Soul";
            }
            case 43: {
                return "Punk";
            }
            case 44: {
                return "Space";
            }
            case 45: {
                return "Meditative";
            }
            case 46: {
                return "Instrumental Pop";
            }
            case 47: {
                return "Instrumental Rock";
            }
            case 48: {
                return "Ethnic";
            }
            case 49: {
                return "Gothic";
            }
            case 50: {
                return "Darkwave";
            }
            case 51: {
                return "Techno-Industrial";
            }
            case 52: {
                return "Electronic";
            }
            case 53: {
                return "Pop-Folk";
            }
            case 54: {
                return "Eurodance";
            }
            case 55: {
                return "Dream";
            }
            case 56: {
                return "Southern Rock";
            }
            case 57: {
                return "Comedy";
            }
            case 58: {
                return "Cult";
            }
            case 59: {
                return "Gangsta";
            }
            case 60: {
                return "Top 40";
            }
            case 61: {
                return "Christian Rap";
            }
            case 62: {
                return "Pop/Funk";
            }
            case 63: {
                return "Jungle";
            }
            case 64: {
                return "Native American";
            }
            case 65: {
                return "Cabaret";
            }
            case 66: {
                return "New Wave";
            }
            case 67: {
                return "Psychadelic";
            }
            case 68: {
                return "Rave";
            }
            case 69: {
                return "Showtunes";
            }
            case 70: {
                return "Trailer";
            }
            case 71: {
                return "Lo-Fi";
            }
            case 72: {
                return "Tribal";
            }
            case 73: {
                return "Acid Punk";
            }
            case 74: {
                return "Acid Jazz";
            }
            case 75: {
                return "Polka";
            }
            case 76: {
                return "Retro";
            }
            case 77: {
                return "Musical";
            }
            case 78: {
                return "Rock &amp; Roll";
            }
            case 79: {
                return "Hard Rock";
            }
            case 80: {
                return "Folk";
            }
            case 81: {
                return "Folk-Rock";
            }
            case 82: {
                return "National Folk";
            }
            case 83: {
                return "Swing";
            }
            case 84: {
                return "Fast Fusion";
            }
            case 85: {
                return "Bebob";
            }
            case 86: {
                return "Latin";
            }
            case 87: {
                return "Revival";
            }
            case 88: {
                return "Celtic";
            }
            case 89: {
                return "Bluegrass";
            }
            case 90: {
                return "Avantgarde";
            }
            case 91: {
                return "Gothic Rock";
            }
            case 92: {
                return "Progressive Rock";
            }
            case 93: {
                return "Psychedelic Rock";
            }
            case 94: {
                return "Symphonic Rock";
            }
            case 95: {
                return "Slow Rock";
            }
            case 96: {
                return "Big Band";
            }
            case 97: {
                return "Chorus";
            }
            case 98: {
                return "Easy Listening";
            }
            case 99: {
                return "Acoustic";
            }
            case 100: {
                return "Humour";
            }
            case 101: {
                return "Speech";
            }
            case 102: {
                return "Chanson";
            }
            case 103: {
                return "Opera";
            }
            case 104: {
                return "Chamber Music";
            }
            case 105: {
                return "Sonata";
            }
            case 106: {
                return "Symphony";
            }
            case 107: {
                return "Booty Bass";
            }
            case 108: {
                return "Primus";
            }
            case 109: {
                return "Porn Groove";
            }
            case 110: {
                return "Satire";
            }
            case 111: {
                return "Slow Jam";
            }
            case 112: {
                return "Club";
            }
            case 113: {
                return "Tango";
            }
            case 114: {
                return "Samba";
            }
            case 115: {
                return "Folklore";
            }
            case 116: {
                return "Ballad";
            }
            case 117: {
                return "Power Ballad";
            }
            case 118: {
                return "Rhythmic Soul";
            }
            case 119: {
                return "Freestyle";
            }
            case 120: {
                return "Duet";
            }
            case 121: {
                return "Punk Rock";
            }
            case 122: {
                return "Drum Solo";
            }
            case 123: {
                return "A capella";
            }
            case 124: {
                return "Euro-House";
            }
            case 125: {
                return "Dance Hall";
            }
        }
        return "";
    }
}

